/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.data.vehicle.stats;

import com.google.gson.JsonObject;
import com.onewhohears.dscombat.data.graph.AoaLiftKGraph;
import com.onewhohears.dscombat.data.graph.StatGraphs;
import com.onewhohears.dscombat.data.graph.TurnRatesBySpeedGraph;
import com.onewhohears.dscombat.data.vehicle.VehicleType;
import com.onewhohears.dscombat.data.vehicle.stats.VehicleStats;
import com.onewhohears.onewholibs.data.jsonpreset.JsonPresetType;
import com.onewhohears.onewholibs.util.UtilParse;
import net.minecraft.resources.ResourceLocation;

public class PlaneStats
extends VehicleStats {
    public final float wing_area;
    public final float flapsAOABias;
    public final float fuselage_lift_area;
    public final float aoa_drag_factor;
    public final float centripetal_scale;
    public final boolean canAimDown;
    public final String[] wingLiftHitboxNames;
    private final String wing_lift_k_graph_key;
    private final String fuselage_lift_k_graph_key;
    private final String turn_rates_graph_key;
    private AoaLiftKGraph wing_lift_k_graph;
    private AoaLiftKGraph fuselage_lift_k_graph;
    private TurnRatesBySpeedGraph turn_rates_graph;

    public PlaneStats(ResourceLocation key, JsonObject json) {
        super(key, json);
        JsonObject plane = UtilParse.getJsonSafe((JsonObject)UtilParse.getJsonSafe((JsonObject)json, (String)"stats"), (String)"plane");
        this.wing_area = UtilParse.getFloatSafe((JsonObject)plane, (String)"wing_area", (float)10.0f);
        this.flapsAOABias = UtilParse.getFloatSafe((JsonObject)plane, (String)"flapsAOABias", (float)8.0f);
        this.canAimDown = UtilParse.getBooleanSafe((JsonObject)plane, (String)"canAimDown", (boolean)false);
        this.fuselage_lift_area = UtilParse.getFloatSafe((JsonObject)plane, (String)"fuselage_lift_area", (float)0.0f);
        this.wing_lift_k_graph_key = UtilParse.getStringSafe((JsonObject)plane, (String)"wing_lift_k_graph", (String)"fuselage");
        this.fuselage_lift_k_graph_key = UtilParse.getStringSafe((JsonObject)plane, (String)"fuselage_lift_k_graph", (String)"fuselage");
        this.turn_rates_graph_key = UtilParse.getStringSafe((JsonObject)plane, (String)"turn_rates_graph", (String)"wooden_plane_turn_rates");
        this.wingLiftHitboxNames = UtilParse.getStringArraySafe((JsonObject)plane, (String)"wing_lift_hitbox_names");
        this.aoa_drag_factor = UtilParse.getFloatSafe((JsonObject)plane, (String)"aoa_drag_factor", (float)1.0f);
        this.centripetal_scale = UtilParse.getFloatSafe((JsonObject)plane, (String)"centripetal_scale", (float)0.4f);
    }

    public JsonPresetType getType() {
        return VehicleType.PLANE;
    }

    @Override
    public PlaneStats asPlane() {
        return this;
    }

    @Override
    public boolean isAircraft() {
        return true;
    }

    @Override
    public boolean flipPitchThrottle() {
        return false;
    }

    @Override
    public boolean ignoreInvertY() {
        return false;
    }

    @Override
    public boolean isPlane() {
        return true;
    }

    public String getWingLiftKGraphKey() {
        return this.wing_lift_k_graph_key;
    }

    public String getFuselageLiftKGraphKey() {
        return this.fuselage_lift_k_graph_key;
    }

    public AoaLiftKGraph getWingLiftKGraph() {
        if (this.wing_lift_k_graph == null) {
            this.wing_lift_k_graph = StatGraphs.get().getAoaLiftKGraph(this.getWingLiftKGraphKey());
        }
        return this.wing_lift_k_graph;
    }

    public AoaLiftKGraph getFuselageLiftKGraph() {
        if (this.fuselage_lift_k_graph == null) {
            this.fuselage_lift_k_graph = StatGraphs.get().getAoaLiftKGraph(this.getFuselageLiftKGraphKey());
        }
        return this.fuselage_lift_k_graph;
    }

    public String getTurnRatesGraphKey() {
        return this.turn_rates_graph_key;
    }

    public TurnRatesBySpeedGraph getTurnRatesGraph() {
        if (this.turn_rates_graph == null) {
            this.turn_rates_graph = StatGraphs.get().getTurnRateGraph(this.getTurnRatesGraphKey());
        }
        return this.turn_rates_graph;
    }
}

