/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.data.weapon.stats;

import com.google.gson.JsonObject;
import com.onewhohears.dscombat.data.weapon.AbstractWeaponBuilders;
import com.onewhohears.dscombat.data.weapon.WeaponType;
import com.onewhohears.dscombat.data.weapon.instance.BunkerBusterInstance;
import com.onewhohears.dscombat.data.weapon.stats.BombStats;
import com.onewhohears.onewholibs.data.jsonpreset.JsonPresetInstance;
import com.onewhohears.onewholibs.data.jsonpreset.JsonPresetType;
import com.onewhohears.onewholibs.util.UtilMCText;
import com.onewhohears.onewholibs.util.UtilParse;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;

public class BunkerBusterStats
extends BombStats {
    private final int blockStrength;

    public BunkerBusterStats(ResourceLocation key, JsonObject json) {
        super(key, json);
        this.blockStrength = UtilParse.getIntSafe((JsonObject)json, (String)"blockStrength", (int)0);
    }

    @Override
    public JsonPresetInstance<?> createPresetInstance() {
        return new BunkerBusterInstance<BunkerBusterStats>(this);
    }

    public int getBlockStrength() {
        return this.blockStrength;
    }

    @Override
    public void addToolTips(List<Component> tips, boolean advanced) {
        super.addToolTips(tips, advanced);
        if (advanced) {
            tips.add((Component)UtilMCText.translatable((String)"info.dscombat.block_strength").m_130946_(": " + this.getBlockStrength()).m_6270_(Style.f_131099_.m_178520_(6266528)));
        }
    }

    @Override
    public String getWeaponTypeCode() {
        return UtilMCText.transString((String)"weapon_code.dscombat.drill");
    }

    @Override
    public String getDefaultIconLocation() {
        return "dscombat:textures/ui/weapon_icons/bunker_buster.png";
    }

    @Override
    public boolean isBullet() {
        return false;
    }

    @Override
    public boolean isAimAssist() {
        return false;
    }

    @Override
    public JsonPresetType getType() {
        return WeaponType.BUNKER_BUSTER;
    }

    public static class Builder
    extends AbstractWeaponBuilders.BunkerBusterBuilder<Builder> {
        protected Builder(String namespace, String name) {
            super(namespace, name, WeaponType.BUNKER_BUSTER);
        }

        public static Builder bunkerBusterBuilder(String namespace, String name) {
            return new Builder(namespace, name);
        }
    }
}

