/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.data.weapon.stats;

import com.google.gson.JsonObject;
import com.onewhohears.dscombat.data.weapon.WeaponType;
import com.onewhohears.dscombat.data.weapon.instance.TrackMissileInstance;
import com.onewhohears.dscombat.data.weapon.stats.MissileStats;
import com.onewhohears.onewholibs.data.jsonpreset.JsonPresetInstance;
import com.onewhohears.onewholibs.data.jsonpreset.JsonPresetType;
import com.onewhohears.onewholibs.util.UtilMCText;
import com.onewhohears.onewholibs.util.UtilParse;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;

public class TrackMissileStats
extends MissileStats {
    private final TargetType targetType;
    private final boolean active;

    public TrackMissileStats(ResourceLocation key, JsonObject json) {
        super(key, json);
        this.targetType = (TargetType)UtilParse.getEnumSafe((JsonObject)json, (String)"targetType", TargetType.class);
        this.active = UtilParse.getBooleanSafe((JsonObject)json, (String)"activeTrack", (boolean)true);
    }

    @Override
    public JsonPresetType getType() {
        return WeaponType.TRACK_MISSILE;
    }

    @Override
    public JsonPresetInstance<?> createPresetInstance() {
        return new TrackMissileInstance<TrackMissileStats>(this);
    }

    public TargetType getTargetType() {
        return this.targetType;
    }

    public boolean isActiveTrack() {
        return this.active;
    }

    @Override
    public void addToolTips(List<Component> tips, boolean advanced) {
        super.addToolTips(tips, advanced);
        switch (this.getTargetType()) {
            case AIR: {
                tips.add((Component)UtilMCText.translatable((String)"info.dscombat.targets_flying").m_6270_(Style.f_131099_.m_178520_(8388564)));
                break;
            }
            case GROUND: {
                tips.add((Component)UtilMCText.translatable((String)"info.dscombat.targets_grounded").m_6270_(Style.f_131099_.m_178520_(8388564)));
                break;
            }
            case WATER: {
                tips.add((Component)UtilMCText.translatable((String)"info.dscombat.targets_in_water").m_6270_(Style.f_131099_.m_178520_(8388564)));
            }
        }
        if (advanced) {
            if (this.active) {
                tips.add((Component)UtilMCText.translatable((String)"info.dscombat.active_track").m_6270_(Style.f_131099_.m_178520_(8388564)));
            } else {
                tips.add((Component)UtilMCText.translatable((String)"info.dscombat.semi_active").m_6270_(Style.f_131099_.m_178520_(8388564)));
            }
        }
    }

    @Override
    public String getWeaponTypeCode() {
        switch (this.getTargetType()) {
            case AIR: {
                if (this.active) {
                    return UtilMCText.transString((String)"weapon_code.dscombat.fox3");
                }
                return UtilMCText.transString((String)"weapon_code.dscombat.fox1");
            }
            case GROUND: {
                return UtilMCText.transString((String)"weapon_code.dscombat.rifel");
            }
            case WATER: {
                return UtilMCText.transString((String)"weapon_code.dscombat.bruiser");
            }
        }
        return "";
    }

    @Override
    public String getDefaultIconLocation() {
        return "dscombat:textures/ui/weapon_icons/radar_missile.png";
    }

    @Override
    public boolean requiresRadar() {
        return true;
    }

    public static enum TargetType {
        AIR,
        GROUND,
        WATER;

    }
}

