/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.data.weapon.stats;

import com.google.gson.JsonObject;
import com.onewhohears.dscombat.data.parts.PartPresets;
import com.onewhohears.dscombat.data.parts.stats.PartStats;
import com.onewhohears.dscombat.data.weapon.WeaponType;
import com.onewhohears.dscombat.data.weapon.instance.WeaponInstance;
import com.onewhohears.dscombat.init.ModItems;
import com.onewhohears.dscombat.init.ModSounds;
import com.onewhohears.dscombat.util.UtilParticles;
import com.onewhohears.dscombat.util.UtilSound;
import com.onewhohears.onewholibs.data.crafting.IngredientStackBuilder;
import com.onewhohears.onewholibs.data.jsonpreset.JsonPresetStats;
import com.onewhohears.onewholibs.util.UtilEntity;
import com.onewhohears.onewholibs.util.UtilItem;
import com.onewhohears.onewholibs.util.UtilMCText;
import com.onewhohears.onewholibs.util.UtilParse;
import java.util.List;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public abstract class WeaponStats
extends JsonPresetStats {
    public static final int INFO_COLOR = 6266528;
    public static final int COMPAT_COLOR = 11403055;
    public static final int TYPE_COLOR = Short.MAX_VALUE;
    public static final int SPECIAL_COLOR = 8388564;
    protected static final ResourceLocation NONE_ICON = new ResourceLocation("dscombat", "textures/ui/weapon_icons/none.png");
    private final int craftNum;
    private final int maxAge;
    private final int fireRate;
    private final boolean canShootOnGround;
    private final String entityTypeKey;
    private final String shootSoundKey;
    private final String[] compatibleWeaponPart;
    private final String itemKey;
    private final String assetId;
    private final ResourceLocation icon;
    private NonNullList<Ingredient> ingredients;
    private EntityType<?> entityType;
    private SoundEvent shootSound;
    private Item item;
    private ItemStack stack;

    public WeaponStats(ResourceLocation key, JsonObject json) {
        super(key, json);
        this.craftNum = UtilParse.getIntSafe((JsonObject)json, (String)"craftNum", (int)0);
        this.maxAge = UtilParse.getIntSafe((JsonObject)json, (String)"maxAge", (int)0);
        this.fireRate = UtilParse.getIntSafe((JsonObject)json, (String)"fireRate", (int)0);
        this.canShootOnGround = UtilParse.getBooleanSafe((JsonObject)json, (String)"canShootOnGround", (boolean)false);
        this.entityTypeKey = UtilParse.getStringSafe((JsonObject)json, (String)"entityTypeKey", (String)"");
        this.shootSoundKey = UtilParse.getStringSafe((JsonObject)json, (String)"shootSoundKey", (String)"");
        this.compatibleWeaponPart = UtilParse.getStringArraySafe((JsonObject)json, (String)"compatibleWeaponPart");
        this.itemKey = UtilParse.getStringSafe((JsonObject)json, (String)"itemKey", (String)"");
        this.assetId = json.has("assetId") ? json.get("assetId").getAsString() : (json.has("modelId") ? json.get("modelId").getAsString() : this.getId());
        this.icon = new ResourceLocation(UtilParse.getStringSafe((JsonObject)json, (String)"icon", (String)this.getDefaultIconLocation()));
    }

    public WeaponInstance<?> createWeaponInstance() {
        return (WeaponInstance)this.createPresetInstance();
    }

    public NonNullList<Ingredient> getIngredients() {
        if (this.ingredients == null) {
            this.ingredients = IngredientStackBuilder.getIngredients((JsonObject)this.getJsonData());
        }
        return this.ingredients;
    }

    public int getCraftNum() {
        return this.craftNum;
    }

    public boolean canAngleDown() {
        return this.isBullet();
    }

    public int getMaxAge() {
        return this.maxAge;
    }

    public int getFireRate() {
        return this.fireRate;
    }

    public boolean canShootOnGround() {
        return this.canShootOnGround;
    }

    public abstract double getMobTurretRange();

    public String toString() {
        return "[" + this.getType().toString() + ":" + this.getId() + "]";
    }

    public EntityType<?> getEntityType() {
        if (this.entityType == null) {
            this.entityType = UtilEntity.getEntityType((String)this.entityTypeKey, this.getWeaponType().getDefaultEntityType());
        }
        return this.entityType;
    }

    public SoundEvent getShootSound() {
        if (this.shootSound == null) {
            this.shootSound = UtilSound.getSoundById(this.shootSoundKey, ModSounds.BULLET_SHOOT_1);
        }
        return this.shootSound;
    }

    private Item getItem() {
        if (this.item == null) {
            this.item = UtilItem.getItem((String)this.itemKey, (Item)((Item)ModItems.AMMO.get()));
        }
        return this.item;
    }

    public ItemStack getDisplayStack() {
        if (this.stack == null) {
            this.stack = new ItemStack((ItemLike)this.getItem());
            this.stack.m_41764_(this.craftNum);
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("weapon", this.getId());
            this.stack.m_41751_(tag);
        }
        return this.stack;
    }

    public ItemStack getNewItem() {
        return this.getDisplayStack().m_41777_();
    }

    public String getItemKey() {
        return this.itemKey;
    }

    public String[] getCompatibleWeaponParts() {
        return this.compatibleWeaponPart;
    }

    public String getAssetId() {
        return this.assetId;
    }

    public ResourceLocation getWeaponIcon() {
        return this.isNoWeapon() ? NONE_ICON : this.icon;
    }

    public String getDefaultIconLocation() {
        return "dscombat:textures/ui/weapon_icons/default.png";
    }

    public abstract String getWeaponTypeCode();

    public WeaponType getWeaponType() {
        return (WeaponType)this.getType();
    }

    public void addToolTips(List<Component> tips, boolean advanced) {
        tips.add((Component)this.getType().getDisplayNameComponent().m_6270_(Style.f_131099_.m_178520_(Short.MAX_VALUE)));
        if (this.compatibleWeaponPart.length > 0) {
            MutableComponent weapons = UtilMCText.translatable((String)"info.dscombat.compatible").m_130946_(": ").m_6270_(Style.f_131099_.m_178520_(11403055));
            for (int i = 0; i < this.compatibleWeaponPart.length; ++i) {
                PartStats stats = (PartStats)PartPresets.get().get(this.compatibleWeaponPart[i]);
                if (stats == null) continue;
                if (i != 0) {
                    weapons.m_7220_((Component)UtilMCText.literal((String)", "));
                }
                weapons.m_7220_((Component)stats.getDisplayNameComponent());
            }
            tips.add((Component)weapons);
        }
        tips.add((Component)UtilMCText.translatable((String)"info.dscombat.fire_rate").m_130946_(": " + this.getFireRate()).m_6270_(Style.f_131099_.m_178520_(6266528)));
        if (advanced) {
            tips.add((Component)UtilMCText.translatable((String)"info.dscombat.max_age").m_130946_(": " + this.getMaxAge()).m_6270_(Style.f_131099_.m_178520_(6266528)));
            if (!this.canShootOnGround) {
                tips.add((Component)UtilMCText.translatable((String)"info.dscombat.must_fly").m_6270_(Style.f_131099_.m_178520_(8388564)));
            }
        }
    }

    public boolean isBullet() {
        return false;
    }

    public boolean isNoWeapon() {
        return false;
    }

    public boolean isIRMissile() {
        return false;
    }

    public boolean requiresRadar() {
        return false;
    }

    public boolean isAimAssist() {
        return false;
    }

    public boolean isPosGuided() {
        return false;
    }

    public static enum WeaponClientImpactType {
        SMALL_BULLET_IMPACT((level, pos) -> UtilParticles.bulletImpact(level, pos, 5.0)),
        SMALL_BULLET_EXPLODE((level, pos) -> UtilParticles.bulletExplode(level, pos, 2.5, true)),
        MED_BOMB_EXPLODE((level, pos) -> UtilParticles.bombExplode(level, pos, 5.0, true)),
        MED_MISSILE_EXPLODE((level, pos) -> UtilParticles.missileExplode(level, pos, 4.0, true));

        private final BiConsumer<Level, Vec3> clientImpactCallback;

        @Nullable
        public static WeaponClientImpactType getByOrdinal(int ordinal) {
            if (ordinal < 0 || ordinal >= WeaponClientImpactType.values().length) {
                return null;
            }
            return WeaponClientImpactType.values()[ordinal];
        }

        private WeaponClientImpactType(BiConsumer<Level, Vec3> clientImpactCallback) {
            this.clientImpactCallback = clientImpactCallback;
        }

        public void onClientImpact(Level level, Vec3 pos) {
            this.clientImpactCallback.accept(level, pos);
        }
    }
}

