/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.entity.ai.goal;

import com.onewhohears.dscombat.Config;
import com.onewhohears.dscombat.command.DSCGameRules;
import com.onewhohears.dscombat.data.weapon.instance.WeaponInstance;
import com.onewhohears.dscombat.data.weapon.stats.WeaponStats;
import com.onewhohears.dscombat.entity.parts.EntityTurret;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.dscombat.util.UtilVehicleEntity;
import com.onewhohears.onewholibs.util.UtilEntity;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;

public class TurretTargetGoal<T extends LivingEntity>
extends NearestAttackableTargetGoal<T> {
    private final EntityTurret turret;
    private final double range;

    public static TurretTargetGoal<Player> targetPlayers(Mob mob, EntityTurret turret) {
        double range = turret.getAIHorizontalRange();
        return new TurretTargetGoal<Player>(mob, turret, Player.class, range, TurretTargetGoal.checkCanTarget(mob, turret, false, range));
    }

    public static TurretTargetGoal<LivingEntity> targetEnemy(Mob mob, EntityTurret turret) {
        double range = turret.getAIHorizontalRange();
        return new TurretTargetGoal<LivingEntity>(mob, turret, LivingEntity.class, range, TurretTargetGoal.checkCanTarget(mob, turret, true, range));
    }

    public static Predicate<LivingEntity> checkCanTarget(Mob mob, EntityTurret turret, boolean enemyCheck, double range) {
        return entity -> {
            WeaponInstance<?> wd = turret.getWeaponData();
            if (wd == null) {
                return false;
            }
            if (entity == null) {
                return false;
            }
            if (entity.m_213877_()) {
                return false;
            }
            if (entity.m_21224_()) {
                return false;
            }
            if (!entity.m_6097_()) {
                return false;
            }
            if (entity.m_5833_()) {
                return false;
            }
            if (entity.m_20182_().m_82546_(turret.m_20182_()).m_165924_() > range) {
                return false;
            }
            if (entity.m_7307_((Entity)mob)) {
                return false;
            }
            if (mob.m_20365_((Entity)entity)) {
                return false;
            }
            boolean isPlayer = false;
            if (entity instanceof Player) {
                Player player = (Player)entity;
                isPlayer = true;
                if (player.m_7500_()) {
                    return false;
                }
            }
            if (enemyCheck) {
                if (mob.m_5647_() == null && isPlayer) {
                    return false;
                }
                if (!(entity instanceof Enemy)) {
                    return false;
                }
            }
            if (((WeaponStats)wd.getStats()).isIRMissile()) {
                if (UtilVehicleEntity.isOnGroundOrWater((Entity)entity)) {
                    return false;
                }
            } else if (((WeaponStats)wd.getStats()).requiresRadar()) {
                EntityVehicle vehicle = turret.getParentVehicle();
                if (vehicle == null) {
                    return false;
                }
                if (!vehicle.radarSystem.hasTarget((Entity)entity)) {
                    return false;
                }
            }
            return UtilEntity.canEntitySeeEntity((Entity)mob, (Entity)entity, (int)((Integer)Config.COMMON.maxBlockCheckDepth.get()));
        };
    }

    protected void m_26073_() {
        WeaponInstance<?> wd = this.turret.getWeaponData();
        EntityVehicle vehicle = this.turret.getParentVehicle();
        if (wd == null || vehicle == null) {
            return;
        }
        if (((WeaponStats)wd.getStats()).requiresRadar()) {
            this.f_26050_ = this.f_26048_ != Player.class && this.f_26048_ != ServerPlayer.class ? vehicle.radarSystem.getLivingTargetByWeapon(wd) : vehicle.radarSystem.getPlayerTargetByWeapon(wd);
            return;
        }
        this.f_26050_ = this.f_26048_ != Player.class && this.f_26048_ != ServerPlayer.class ? this.f_26135_.f_19853_.m_45982_(this.f_26135_.f_19853_.m_6443_(this.f_26048_, this.m_7255_(this.m_7623_()), entity -> true), this.f_26051_, (LivingEntity)this.f_26135_, this.f_26135_.m_20185_(), this.f_26135_.m_20188_(), this.f_26135_.m_20189_()) : this.f_26135_.f_19853_.m_45949_(this.f_26051_, (LivingEntity)this.f_26135_, this.f_26135_.m_20185_(), this.f_26135_.m_20188_(), this.f_26135_.m_20189_());
    }

    public boolean m_8036_() {
        if (!this.f_26135_.f_19853_.m_46469_().m_46207_(DSCGameRules.MOBS_USE_TURRETS)) {
            return false;
        }
        if (this.f_26135_.m_20202_() == null || !this.f_26135_.m_20202_().equals((Object)this.turret)) {
            return false;
        }
        return super.m_8036_();
    }

    public boolean m_8045_() {
        LivingEntity living = this.f_26135_.m_5448_();
        if (living == null) {
            living = this.f_26050_;
        }
        if (living == null) {
            return false;
        }
        if (this.f_26135_.m_21224_()) {
            return false;
        }
        if (!this.f_26051_.m_26885_((LivingEntity)this.f_26135_, living)) {
            return false;
        }
        this.f_26135_.m_6710_(living);
        return true;
    }

    public void m_8041_() {
        this.f_26135_.m_6710_((LivingEntity)null);
        this.f_26050_ = null;
    }

    private TurretTargetGoal(Mob mob, EntityTurret turret, Class<T> type, double range, Predicate<LivingEntity> check) {
        super(mob, type, 8, false, false, check);
        this.turret = turret;
        this.range = range;
        this.f_26051_.m_148355_();
    }

    protected AABB m_7255_(double targetDistance) {
        return this.f_26135_.m_20191_().m_82377_(this.m_7623_(), this.getVerticalRange(), this.m_7623_());
    }

    public double getVerticalRange() {
        return this.turret.getAIVerticalRange();
    }

    protected double m_7623_() {
        return this.range;
    }

    public void m_8056_() {
        super.m_8056_();
    }
}

