/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.entity.vehicle;

import com.mojang.math.Quaternion;
import com.onewhohears.dscombat.Config;
import com.onewhohears.dscombat.data.vehicle.VehicleType;
import com.onewhohears.dscombat.data.vehicle.stats.VehicleStats;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class EntityGroundVehicle
extends EntityVehicle {
    public EntityGroundVehicle(EntityType<? extends EntityGroundVehicle> entity, Level level, String defaultPreset) {
        super(entity, level, defaultPreset);
    }

    @Override
    public VehicleType getVehicleType() {
        return VehicleType.CAR;
    }

    @Override
    public void directionGround(Quaternion q) {
        if (((VehicleStats)this.getStats()).asCar().isTank && this.isOperational()) {
            this.flatten(q, 4.0f, 4.0f, true);
            this.addMomentY(this.inputs.yaw * this.getYawTorque(), true);
        } else {
            super.directionGround(q);
        }
    }

    @Override
    public boolean isBraking() {
        return this.inputs.special;
    }

    @Override
    public void applyBreaks() {
        this.throttleToZero();
        super.applyBreaks();
    }

    @Override
    public Vec3 getThrustForce(Quaternion q) {
        return Vec3.f_82478_;
    }

    @Override
    public boolean isLandingGear() {
        return true;
    }

    @Override
    public float getStepHeight() {
        return 1.0f;
    }

    @Override
    public String getOpenMenuError() {
        return "error.dscombat.no_menu_moving";
    }

    @Override
    public boolean canBrake() {
        return true;
    }

    @Override
    public boolean canToggleLandingGear() {
        return false;
    }

    @Override
    public double getMaxSpeedFactor() {
        return super.getMaxSpeedFactor() * (Double)Config.SERVER.carSpeedFactor.get();
    }
}

