/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.entity.vehicle;

import com.mojang.math.Quaternion;
import com.onewhohears.dscombat.Config;
import com.onewhohears.dscombat.command.DSCGameRules;
import com.onewhohears.dscombat.data.vehicle.VehicleType;
import com.onewhohears.dscombat.data.vehicle.stats.VehicleStats;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.onewholibs.util.math.UtilAngles;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class EntityHelicopter
extends EntityVehicle {
    private int altitudeWarningTicks;

    public EntityHelicopter(EntityType<? extends EntityHelicopter> entity, Level level, String defaultPreset) {
        super(entity, level, defaultPreset);
    }

    @Override
    public VehicleType getVehicleType() {
        return VehicleType.HELICOPTER;
    }

    @Override
    public void tickGround(Quaternion q) {
        this.addFrictionForce(this.kineticFric);
    }

    @Override
    public double getDriveAcc() {
        return 0.0;
    }

    @Override
    public void tickAir(Quaternion q) {
        if (this.inputs.special && this.isOperational()) {
            float max_th = (float)UtilAngles.getYawAxis((Quaternion)q).f_82480_ * this.getMaxPushThrust();
            float yForceNoLift = (float)(-(this.getWeightForce().f_82480_ + this.addForceBetweenTicks.f_82480_));
            if (max_th != 0.0f) {
                this.throttleTowards(yForceNoLift / max_th);
            }
            this.m_20256_(this.m_20184_().m_82542_(0.95, 0.95, 0.95));
        }
        super.tickAir(q);
    }

    @Override
    public void directionGround(Quaternion q) {
        if (!this.isOperational()) {
            return;
        }
        this.flatten(q, 4.0f, 4.0f, true);
    }

    @Override
    public void directionAir(Quaternion q) {
        super.directionAir(q);
        if (!this.isOperational()) {
            return;
        }
        if (this.canControlYaw()) {
            this.addMomentY(this.inputs.yaw * this.getYawTorque(), true);
        }
        if (this.inputs.special) {
            this.flatten(q, this.getMaxDeltaPitch(), this.getMaxDeltaRoll(), false);
        } else {
            this.addMomentX(this.inputs.pitch * this.getPitchTorque(), true);
            this.addMomentZ(this.inputs.roll * this.getRollTorque(), true);
        }
    }

    @Override
    public Vec3 getThrustForce(Quaternion q) {
        Vec3 direction = UtilAngles.getYawAxis((Quaternion)q);
        Vec3 thrustForce = direction.m_82490_(this.getPushThrustMag());
        return thrustForce;
    }

    @Override
    public float getMaxPushThrust() {
        return this.getMaxSpinThrust() * (float)this.airPressure * ((VehicleStats)this.getStats()).asHeli().heliLiftFactor;
    }

    @Override
    public boolean isLandingGear() {
        if (((VehicleStats)this.getStats()).asHeli().alwaysLandingGear) {
            return true;
        }
        return super.isLandingGear();
    }

    public float getAccForward() {
        return ((VehicleStats)this.getStats()).asHeli().accForward;
    }

    public float getAccSide() {
        return ((VehicleStats)this.getStats()).asHeli().accSide;
    }

    @Override
    public boolean isCustomBoundingBox() {
        return true;
    }

    @Override
    public boolean canBrake() {
        return false;
    }

    @Override
    public boolean canToggleLandingGear() {
        return !((VehicleStats)this.getStats()).asHeli().alwaysLandingGear;
    }

    @Override
    public boolean canHover() {
        return true;
    }

    @Override
    public boolean cutThrottleOnNoPilot() {
        return false;
    }

    @Override
    protected float calcDamageFromBullet(DamageSource source, float amount) {
        return amount * DSCGameRules.getBulletDamageHeliFactor(this.f_19853_);
    }

    @Override
    public double getMaxSpeedFactor() {
        return super.getMaxSpeedFactor() * (Double)Config.SERVER.heliSpeedFactor.get();
    }

    @Override
    public int getAltitudeWarningTicks() {
        return this.altitudeWarningTicks;
    }

    @Override
    protected void calcMoveStatsPre(Quaternion q) {
        super.calcMoveStatsPre(q);
        this.altitudeWarningTicks = this.m_20184_().f_82480_ < 0.0 && this.getAltitude() < 40.0 ? ++this.altitudeWarningTicks : 0;
    }
}

