/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.entity.vehicle;

import com.mojang.math.Quaternion;
import com.onewhohears.dscombat.Config;
import com.onewhohears.dscombat.command.DSCGameRules;
import com.onewhohears.dscombat.data.graph.AoaLiftKGraph;
import com.onewhohears.dscombat.data.graph.TurnRatesBySpeedGraph;
import com.onewhohears.dscombat.data.vehicle.VehicleType;
import com.onewhohears.dscombat.data.vehicle.stats.PlaneStats;
import com.onewhohears.dscombat.data.vehicle.stats.VehicleStats;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.onewholibs.util.math.UtilAngles;
import com.onewhohears.onewholibs.util.math.UtilGeometry;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class EntityPlane
extends EntityVehicle {
    private static final float AOA_CHANGE_RATE = 0.5f;
    private float aoa;
    private float liftK;
    private float airFoilSpeedSqr;
    private float airSpeed;
    private float fuselageAoa;
    private float fuselageLiftK;
    private float centripetalForce;
    private float centrifugalForce;
    private double wingLiftMag;
    private double maxSpeedMod = 1.0;
    private double arcadeIgnoreGravityFactor;
    private Vec3 liftDir = Vec3.f_82478_;
    private Vec3 liftForce = Vec3.f_82478_;
    private boolean isArcadeMode = false;
    private int pullUpWarningTicks;
    private int altitudeWarningTicks;

    public EntityPlane(EntityType<? extends EntityPlane> entity, Level level, String defaultPreset) {
        super(entity, level, defaultPreset);
    }

    @Override
    public VehicleType getVehicleType() {
        return VehicleType.PLANE;
    }

    @Override
    public void directionAir(Quaternion q) {
        super.directionAir(q);
        if (!this.isOperational()) {
            return;
        }
        if (this.canControlPitch()) {
            this.addMomentX(this.inputs.pitch * this.getPitchTorque(), true);
        }
        if (this.canControlYaw()) {
            this.addMomentY(this.inputs.yaw * this.getYawTorque(), true);
        }
        if (this.canControlRoll()) {
            if (this.inputs.bothRoll) {
                this.flatten(q, 0.0f, this.getRollTorque(), false);
            } else {
                this.addMomentZ(this.inputs.roll * this.getRollTorque(), true);
            }
        }
    }

    @Override
    public void m_8119_() {
        if (this.f_19797_ % 10 == 0) {
            this.isArcadeMode = DSCGameRules.isPlaneArcadeMode(this.m_9236_());
        }
        super.m_8119_();
    }

    @Override
    public void tickAlways(Quaternion q) {
        super.tickAlways(q);
        if (this.isArcadeMode) {
            this.setForces(this.getForces().m_82549_(this.getWeightForce().m_82490_(-this.getArcadeIgnoreGravityFactor())));
            if (this.m_20096_() && this.isFlapsDown()) {
                this.setForces(this.getForces().m_82520_(0.0, 200.0, 0.0));
            }
        } else {
            this.setForces(this.getForces().m_82549_(this.getLiftForce(q)));
        }
    }

    protected void calcIgnoreGravityFactor(Quaternion q) {
        Vec3 u = this.m_20184_();
        Vec3 rollAxis = UtilAngles.getRollAxis((Quaternion)q);
        double speed = UtilGeometry.vecCompByNormAxis((Vec3)u, (Vec3)rollAxis).m_82553_();
        double minTakeOffSpeed = (double)((VehicleStats)this.getStats()).max_speed * 0.5;
        this.arcadeIgnoreGravityFactor = Math.min(speed / minTakeOffSpeed, 1.0);
    }

    public double getArcadeIgnoreGravityFactor() {
        return this.arcadeIgnoreGravityFactor;
    }

    @Override
    public void calcAcc() {
        super.calcAcc();
        if (this.isArcadeMode && !this.m_20096_() && this.getArcadeIgnoreGravityFactor() == 1.0) {
            double speed = this.m_20184_().m_82553_();
            Vec3 look = this.m_20154_();
            this.m_20256_(look.m_82490_(speed));
        }
    }

    @Override
    protected void calcMoveStatsPre(Quaternion q) {
        super.calcMoveStatsPre(q);
        this.calcMaxSpeedMod();
        if (this.isArcadeMode) {
            this.aoa = 0.0f;
            this.calcIgnoreGravityFactor(q);
            return;
        }
        this.calculateAOA(q);
        this.calculateLift(q);
        this.calculateCentripetalForce();
        double ym = this.m_20184_().f_82480_;
        this.pullUpWarningTicks = ym <= -0.5 && this.getAltitude() / -ym <= 80.0 ? ++this.pullUpWarningTicks : 0;
        this.altitudeWarningTicks = this.m_20184_().f_82480_ < 0.0 && this.getAltitude() < 40.0 ? ++this.altitudeWarningTicks : 0;
    }

    @Override
    public double getDriveAcc() {
        return 0.0;
    }

    @Override
    public double getMaxSpeedForMotion() {
        return super.getMaxSpeedForMotion() * this.getMaxSpeedFromThrottleMod();
    }

    @Override
    public double getMaxSpeedFactor() {
        return super.getMaxSpeedFactor() * (Double)Config.SERVER.planeSpeedFactor.get();
    }

    public double getMaxSpeedFromThrottleMod() {
        return this.maxSpeedMod;
    }

    protected void calcMaxSpeedMod() {
        float th;
        if (this.m_20096_()) {
            this.maxSpeedMod = 1.0;
        }
        double goal = (double)(th = this.getCurrentThrottle()) < 0.5 ? 0.6 : 0.6 + 0.8 * ((double)th - 0.5);
        this.maxSpeedMod = Mth.m_14139_((double)0.015, (double)this.maxSpeedMod, (double)goal);
    }

    @Override
    public boolean isBraking() {
        return this.inputs.special2 && this.m_20096_();
    }

    @Override
    public boolean isFlapsDown() {
        return this.inputs.special;
    }

    @Override
    public void tickAir(Quaternion q) {
        super.tickAir(q);
    }

    protected void calculateAOA(Quaternion q) {
        float goalFuselageAOA;
        float goalAOA;
        Vec3 u = this.m_20184_();
        Vec3 pitchAxis = UtilAngles.getPitchAxis((Quaternion)q);
        this.liftDir = u.m_82537_(pitchAxis).m_82541_();
        Vec3 airFoilAxes = UtilAngles.getRollAxis((Quaternion)q);
        this.airFoilSpeedSqr = (float)UtilGeometry.vecCompByNormAxis((Vec3)u, (Vec3)airFoilAxes).m_82556_();
        this.airSpeed = Mth.m_14116_((float)this.airFoilSpeedSqr);
        if (this.m_20096_() || UtilGeometry.isZero((Vec3)u)) {
            goalAOA = 0.0f;
            goalFuselageAOA = 0.0f;
        } else {
            Vec3 wingNormal = UtilAngles.getYawAxis((Quaternion)q).m_82490_(-1.0);
            goalAOA = (float)UtilGeometry.angleBetweenVecPlaneDegrees((Vec3)u, (Vec3)wingNormal);
            Vec3 fuselageNormal = UtilAngles.rotationToVector((double)this.m_146908_(), (double)(this.m_146909_() + 90.0f));
            goalFuselageAOA = (float)UtilGeometry.angleBetweenVecPlaneDegrees((Vec3)u, (Vec3)fuselageNormal);
        }
        if (this.isFlapsDown()) {
            goalAOA += this.getPlaneStats().flapsAOABias;
        }
        this.aoa = Mth.m_14179_((float)0.5f, (float)this.aoa, (float)goalAOA);
        this.fuselageAoa = Mth.m_14179_((float)0.5f, (float)this.fuselageAoa, (float)goalFuselageAOA);
        this.liftK = this.getWingLiftKGraph().getLerpFloat(this.aoa);
        this.fuselageLiftK = this.getFuselageLiftKGraph().getLerpFloat(this.fuselageAoa);
    }

    protected void calculateLift(Quaternion q) {
        this.wingLiftMag = (double)this.liftK * this.airPressure * (double)this.airFoilSpeedSqr * (double)this.getWingSurfaceArea() * 70.0 * (double)this.getWingLiftPercent();
        double fuselageLift = (double)this.fuselageLiftK * this.airPressure * (double)this.airFoilSpeedSqr * (double)this.getFuselageLiftArea() * 70.0;
        double cenScale = this.getCentripetalScale();
        this.liftForce = this.liftDir.m_82490_(this.getLiftMag()).m_82542_(cenScale, 1.0, cenScale).m_82520_(0.0, fuselageLift, 0.0);
    }

    protected void calculateCentripetalForce() {
        Vec3 cenAxis = UtilAngles.getRollAxis((double)0.0, (double)((this.m_146908_() + 90.0f) * ((float)Math.PI / 180)));
        this.centripetalForce = (float)UtilGeometry.vecCompMagDirByNormAxis((Vec3)this.liftForce, (Vec3)cenAxis);
        if ((double)Mth.m_14154_((float)this.centripetalForce) < 0.01) {
            this.centripetalForce = 0.0f;
        }
        if ((double)Mth.m_14154_((float)this.centrifugalForce) < 0.01) {
            this.centrifugalForce = 0.0f;
        }
        this.centrifugalForce = this.getTotalMass() * this.xzSpeed * this.getYawRate() * ((float)Math.PI / 180);
    }

    public Vec3 getLiftForce(Quaternion q) {
        return this.liftForce;
    }

    public double getLiftMag() {
        return this.wingLiftMag;
    }

    @Override
    public Vec3 getThrustForce(Quaternion q) {
        return UtilAngles.getRollAxis((Quaternion)q).m_82490_(this.getPushThrustMag());
    }

    @Override
    public double getCrossSectionArea() {
        double area = super.getCrossSectionArea();
        double aoaSin = Math.sin(Math.toRadians(this.aoa));
        area += (double)this.getWingSurfaceArea() * aoaSin * this.getAOADragFactor();
        double aoaCos = Math.cos(Math.toRadians(this.aoa));
        if (this.isLandingGear()) {
            area += 10.0 * aoaCos;
        }
        if (this.isFlapsDown()) {
            area += (double)(this.getWingSurfaceArea() / 4.0f) * aoaCos;
        }
        return area;
    }

    public float getAOA() {
        return this.aoa;
    }

    @Override
    public boolean isCustomBoundingBox() {
        return true;
    }

    public final float getWingSurfaceArea() {
        return this.getPlaneStats().wing_area;
    }

    public float getFuselageLiftArea() {
        return this.getPlaneStats().fuselage_lift_area;
    }

    @Override
    public boolean isWeaponAngledDown() {
        return this.getPlaneStats().canAimDown && !this.f_19861_ && this.inputs.special2;
    }

    @Override
    public boolean canAngleWeaponDown() {
        return this.getPlaneStats().canAimDown;
    }

    public AoaLiftKGraph getWingLiftKGraph() {
        return this.getPlaneStats().getWingLiftKGraph();
    }

    public AoaLiftKGraph getFuselageLiftKGraph() {
        return this.getPlaneStats().getFuselageLiftKGraph();
    }

    @Override
    public boolean canBrake() {
        return this.f_19861_;
    }

    @Override
    public boolean canToggleLandingGear() {
        return true;
    }

    @Override
    public boolean canFlapsDown() {
        return true;
    }

    public float getCentripetalForce() {
        return this.centripetalForce;
    }

    public float getCentrifugalForce() {
        return this.centrifugalForce;
    }

    @Override
    public boolean isStalling() {
        return Math.abs(this.getAOA()) >= this.getWingLiftKGraph().getCriticalAOA() || this.liftLost();
    }

    @Override
    public boolean isAboutToStall() {
        return Math.abs(this.getAOA()) >= this.getWingLiftKGraph().getWarnAOA() && !this.isFlapsDown();
    }

    @Override
    public boolean liftLost() {
        return !this.m_20096_() && this.getForces().f_82480_ < -10.0 && this.m_20184_().f_82480_ < -0.1 && Math.abs(this.zRot) > 15.0f;
    }

    @Override
    protected float calcDamageFromBullet(DamageSource source, float amount) {
        return amount * DSCGameRules.getBulletDamagePlaneFactor(this.f_19853_);
    }

    public float getWingLiftPercent() {
        float total = this.getPlaneStats().wingLiftHitboxNames.length;
        if (total == 0.0f) {
            return 1.0f;
        }
        float num = this.getNumberOfAliveHitboxes(this.getPlaneStats().wingLiftHitboxNames);
        return num / total;
    }

    @Override
    public float getControlMaxDeltaPitch() {
        if (this.isArcadeMode || this.isTestMode()) {
            return super.getControlMaxDeltaPitch();
        }
        return this.getTurnRateGraph().getMaxPitchRate(this.airSpeed);
    }

    @Override
    public float getControlMaxDeltaYaw() {
        if (this.isArcadeMode || this.isTestMode()) {
            return super.getControlMaxDeltaYaw();
        }
        return this.getTurnRateGraph().getMaxYawRate(this.airSpeed);
    }

    @Override
    public float getControlMaxDeltaRoll() {
        if (this.isArcadeMode || this.isTestMode()) {
            return super.getControlMaxDeltaRoll();
        }
        return this.getTurnRateGraph().getMaxRollRate(this.airSpeed);
    }

    public TurnRatesBySpeedGraph getTurnRateGraph() {
        return this.getPlaneStats().getTurnRatesGraph();
    }

    public double getAOADragFactor() {
        return this.getPlaneStats().aoa_drag_factor;
    }

    public PlaneStats getPlaneStats() {
        return ((VehicleStats)this.getStats()).asPlane();
    }

    public double getCentripetalScale() {
        return this.getPlaneStats().centripetal_scale;
    }

    @Override
    public int getPullUpWarningTicks() {
        return this.pullUpWarningTicks;
    }

    @Override
    public int getAltitudeWarningTicks() {
        return this.altitudeWarningTicks;
    }
}

