/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.entity.vehicle;

import com.mojang.math.Quaternion;
import com.onewhohears.dscombat.data.vehicle.VehicleType;
import com.onewhohears.dscombat.entity.vehicle.EntityBoat;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class EntitySubmarine
extends EntityBoat {
    public EntitySubmarine(EntityType<? extends EntitySubmarine> entity, Level level, String defaultPreset) {
        super((EntityType<? extends EntityBoat>)entity, level, defaultPreset);
    }

    @Override
    public VehicleType getVehicleType() {
        return VehicleType.SUBMARINE;
    }

    @Override
    public void directionWater(Quaternion q) {
        if (!this.isOperational()) {
            return;
        }
        if (!this.isDriverCameraLocked()) {
            this.flatten(q, this.getMaxDeltaPitch(), this.getMaxDeltaRoll(), false);
        } else {
            this.addMomentX(this.inputs.pitch * this.getPitchTorque(), true);
            this.addMomentZ(this.inputs.roll * this.getRollTorque(), true);
        }
        if (this.canControlYaw()) {
            this.addMomentY(this.inputs.yaw * this.getYawTorque(), true);
        }
    }

    @Override
    public double getDriveAcc() {
        return 0.0;
    }

    @Override
    public void tickWater(Quaternion q) {
        super.tickWater(q);
        Vec3 move = this.m_20184_();
        if (!this.isDriverCameraLocked() && this.isOperational()) {
            move = this.inputs.pitch == 0.0f ? move.m_82542_(1.0, 0.9, 1.0) : move.m_82520_(0.0, (double)this.inputs.pitch * 0.02, 0.0);
            double max = 0.2;
            if (Math.abs(move.f_82480_) > max) {
                move = new Vec3(move.f_82479_, max * Math.signum(move.f_82480_), move.f_82481_);
            }
        }
        this.m_20256_(move);
    }

    @Override
    protected void tickFloat() {
        if (this.inputFloat()) {
            super.tickFloat();
        } else {
            this.forces = this.forces.m_82549_(this.getWeightForce().m_82490_(-1.0));
        }
    }

    @Override
    public double getFloatSpeed() {
        if (!this.isOperational()) {
            return super.getFloatSpeed();
        }
        if (this.inputFloat()) {
            return 0.04;
        }
        return 0.0;
    }

    @Override
    public boolean couldFloat() {
        if (!this.isOperational()) {
            return false;
        }
        return this.inputFloat();
    }

    @Override
    public float getMaxPushThrust() {
        return this.getMaxSpinThrust();
    }

    public boolean inputFloat() {
        return this.inputs.special2;
    }

    @Override
    public boolean isLandingGear() {
        return false;
    }

    @Override
    public boolean isCustomBoundingBox() {
        return true;
    }

    @Override
    public float getStepHeight() {
        return 0.2f;
    }

    @Override
    public void waterDamage() {
    }

    @Override
    public boolean canBrake() {
        return true;
    }
}

