/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.entity.vehicle;

import com.mojang.logging.LogUtils;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import com.onewhohears.dscombat.Config;
import com.onewhohears.dscombat.client.input.DSCClientInputs;
import com.onewhohears.dscombat.client.model.obj.ObjRadarModel;
import com.onewhohears.dscombat.command.DSCGameRules;
import com.onewhohears.dscombat.common.container.menu.VehiclePartsMenu;
import com.onewhohears.dscombat.common.network.IPacket;
import com.onewhohears.dscombat.common.network.PacketHandler;
import com.onewhohears.dscombat.common.network.toclient.ToClientAddForceMoment;
import com.onewhohears.dscombat.common.network.toclient.ToClientOnShoot;
import com.onewhohears.dscombat.common.network.toclient.ToClientVehicleControl;
import com.onewhohears.dscombat.common.network.toclient.ToClientVehicleExplode;
import com.onewhohears.dscombat.common.network.toserver.ToServerFixHitboxes;
import com.onewhohears.dscombat.common.network.toserver.ToServerSyncRotBoxPassengerPos;
import com.onewhohears.dscombat.common.network.toserver.ToServerVehicleCollide;
import com.onewhohears.dscombat.common.network.toserver.ToServerVehicleMoveRot;
import com.onewhohears.dscombat.data.parts.PartSlot;
import com.onewhohears.dscombat.data.parts.PartsManager;
import com.onewhohears.dscombat.data.parts.instance.StorageInstance;
import com.onewhohears.dscombat.data.parts.instance.TurretInstance;
import com.onewhohears.dscombat.data.radar.RadarStats;
import com.onewhohears.dscombat.data.radar.RadarSystem;
import com.onewhohears.dscombat.data.vehicle.VehicleInputManager;
import com.onewhohears.dscombat.data.vehicle.VehiclePresets;
import com.onewhohears.dscombat.data.vehicle.VehicleSoundManager;
import com.onewhohears.dscombat.data.vehicle.VehicleTextureManager;
import com.onewhohears.dscombat.data.vehicle.VehicleType;
import com.onewhohears.dscombat.data.vehicle.client.VehicleClientPresets;
import com.onewhohears.dscombat.data.vehicle.client.VehicleClientStats;
import com.onewhohears.dscombat.data.vehicle.stats.VehicleStats;
import com.onewhohears.dscombat.data.weapon.WeaponSystem;
import com.onewhohears.dscombat.data.weapon.stats.WeaponStats;
import com.onewhohears.dscombat.entity.IREmitter;
import com.onewhohears.dscombat.entity.damagesource.VehicleDamageSource;
import com.onewhohears.dscombat.entity.parts.EntityChainHook;
import com.onewhohears.dscombat.entity.parts.EntityGimbal;
import com.onewhohears.dscombat.entity.parts.EntityPart;
import com.onewhohears.dscombat.entity.parts.EntityRidablePart;
import com.onewhohears.dscombat.entity.parts.EntityTurret;
import com.onewhohears.dscombat.entity.vehicle.CustomExplosion;
import com.onewhohears.dscombat.entity.vehicle.RotableHitbox;
import com.onewhohears.dscombat.init.DataSerializers;
import com.onewhohears.dscombat.init.ModTags;
import com.onewhohears.dscombat.item.VehicleInteractItem;
import com.onewhohears.dscombat.util.UtilClientPacket;
import com.onewhohears.dscombat.util.UtilParticles;
import com.onewhohears.dscombat.util.UtilServerPacket;
import com.onewhohears.dscombat.util.UtilVehicleEntity;
import com.onewhohears.dscombat.util.math.UtilRandom;
import com.onewhohears.onewholibs.data.jsonpreset.JsonPresetAssetReader;
import com.onewhohears.onewholibs.data.jsonpreset.JsonPresetReloadListener;
import com.onewhohears.onewholibs.entity.CustomAnimEntity;
import com.onewhohears.onewholibs.util.UtilEntity;
import com.onewhohears.onewholibs.util.UtilMCText;
import com.onewhohears.onewholibs.util.math.UtilAngles;
import com.onewhohears.onewholibs.util.math.UtilGeometry;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.NameTagItem;
import net.minecraft.world.item.RecordItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.Team;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public abstract class EntityVehicle
extends CustomAnimEntity<VehicleStats, VehicleClientStats>
implements IREmitter,
CustomExplosion {
    protected static final Logger LOGGER = LogUtils.getLogger();
    public static final EntityDataAccessor<Float> HEALTH = SynchedEntityData.m_135353_(EntityVehicle.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Float> ARMOR = SynchedEntityData.m_135353_(EntityVehicle.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Quaternion> Q = SynchedEntityData.m_135353_(EntityVehicle.class, DataSerializers.QUATERNION);
    public static final EntityDataAccessor<Vec3> AV = SynchedEntityData.m_135353_(EntityVehicle.class, DataSerializers.VEC3);
    public static final EntityDataAccessor<Boolean> TEST_MODE = SynchedEntityData.m_135353_(EntityVehicle.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> NO_CONSUME = SynchedEntityData.m_135353_(EntityVehicle.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<String> RADIO_SONG = SynchedEntityData.m_135353_(EntityVehicle.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<Boolean> PLAY_IR_TONE = SynchedEntityData.m_135353_(EntityVehicle.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<RadarStats.RadarMode> RADAR_MODE = SynchedEntityData.m_135353_(EntityVehicle.class, DataSerializers.RADAR_MODE);
    public static final EntityDataAccessor<Boolean> LANDING_GEAR = SynchedEntityData.m_135353_(EntityVehicle.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<PermMode> PERM_MODE = SynchedEntityData.m_135353_(EntityVehicle.class, DataSerializers.PERM_MODE);
    public static final int HITBOX_PUSH_COOLDOWN = 4;
    public final VehicleInputManager inputs;
    public final VehicleSoundManager soundManager;
    public final VehicleTextureManager textureManager;
    public final PartsManager partsManager;
    public final WeaponSystem weaponSystem;
    public final RadarSystem radarSystem;
    protected final List<RotableHitbox> hitboxes = new ArrayList<RotableHitbox>();
    private final Set<Integer> collidedEntityIds = new HashSet<Integer>();
    private final Map<Integer, Integer> hitboxEntityCoolDown = new HashMap<Integer, Integer>();
    private final Map<Integer, EntityCollideInfo> entityCollideInfo = new HashMap<Integer, EntityCollideInfo>();
    private final Map<Integer, Integer> formerPassengersServer = new HashMap<Integer, Integer>();
    public int lastShootTime = -1;
    public int ingredientDropIndex = -1;
    public Quaternion prevQ = Quaternion.f_80118_.m_80161_();
    public Quaternion clientQ = Quaternion.f_80118_.m_80161_();
    public Vec3 clientAV = Vec3.f_82478_;
    public float zRot;
    public float zRotO;
    public Vec3 prevMotion = Vec3.f_82478_;
    public Vec3 forces = Vec3.f_82478_;
    public Vec3 forcesO = Vec3.f_82478_;
    public Vec3 addForceBetweenTicks = Vec3.f_82478_;
    public Vec3 moment = Vec3.f_82478_;
    public Vec3 momentO = Vec3.f_82478_;
    public Vec3 addMomentBetweenTicks = Vec3.f_82478_;
    public boolean nightVisionHud = false;
    public boolean hasRadio = false;
    protected boolean hasFlares;
    protected int xzSpeedDir;
    protected int hurtByFireTime;
    protected int flareTicks;
    protected float xzSpeed;
    protected float totalMass;
    protected float xzYaw;
    protected float slideAngle;
    protected float slideAngleCos;
    protected float maxPushThrust;
    protected float maxSpinThrust;
    protected float currentFuel;
    protected float maxFuel;
    protected double staticFric;
    protected double kineticFric;
    protected double airPressure;
    protected double currentAltitude;
    private int lerpSteps;
    private int deadTicks;
    private int stallWarnTicks;
    private int stallTicks;
    private int engineFireTicks;
    private int fuelLeakTicks;
    private int bingoTicks;
    private int groundTicks;
    private int hitboxRefreshAttempts;
    private int numFlares;
    private int hydraulicsFailureTicks;
    private int missileTicks;
    private int trackedTicks;
    private double lerpX;
    private double lerpY;
    private double lerpZ;
    private float landingGearPos;
    private float landingGearPosOld;
    private float motorRot;
    private float wheelRot;
    protected boolean isDriverCameraLocked = false;
    protected float throttle;
    @Nullable
    protected EntityGimbal pilotGimbal;
    @Nullable
    protected Player chainHolderPlayer;
    @Nullable
    protected EntityChainHook chainHolderHook;
    @Nullable
    private Entity owner;
    @Nullable
    private UUID owner_uuid;
    private int owner_id = -1;

    public EntityVehicle(EntityType<? extends EntityVehicle> entityType, Level level, String defaultPreset) {
        super(entityType, level, defaultPreset);
        this.f_19850_ = true;
        this.inputs = new VehicleInputManager();
        this.soundManager = new VehicleSoundManager(this);
        this.textureManager = new VehicleTextureManager(this);
        this.partsManager = new PartsManager(this);
        this.weaponSystem = new WeaponSystem(this);
        this.radarSystem = new RadarSystem(this);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(HEALTH, (Object)Float.valueOf(100.0f));
        this.f_19804_.m_135372_(ARMOR, (Object)Float.valueOf(100.0f));
        this.f_19804_.m_135372_(Q, (Object)Quaternion.f_80118_);
        this.f_19804_.m_135372_(AV, (Object)Vec3.f_82478_);
        this.f_19804_.m_135372_(TEST_MODE, (Object)false);
        this.f_19804_.m_135372_(NO_CONSUME, (Object)false);
        this.f_19804_.m_135372_(RADIO_SONG, (Object)"");
        this.f_19804_.m_135372_(PLAY_IR_TONE, (Object)false);
        this.f_19804_.m_135372_(RADAR_MODE, (Object)RadarStats.RadarMode.ALL);
        this.f_19804_.m_135372_(LANDING_GEAR, (Object)true);
        this.f_19804_.m_135372_(PERM_MODE, (Object)PermMode.PUBLIC);
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        super.m_7350_(key);
        if (!this.f_19853_.m_5776_()) {
            return;
        }
        if (Q.equals(key)) {
            if (!this.m_6109_()) {
                this.setPrevQ(this.getClientQ());
                this.setClientQ(this.getQ());
            }
        } else if (AV.equals(key)) {
            if (!this.m_6109_()) {
                this.clientAV = (Vec3)this.f_19804_.m_135370_(AV);
            }
        } else if (RADIO_SONG.equals(key)) {
            this.soundManager.onRadioSongUpdate(this.getRadioSong());
        }
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.setTestMode(nbt.m_128471_("test_mode"));
        this.setNoConsume(nbt.m_128471_("no_consume"));
        CompoundTag presetNbt = ((VehicleStats)this.getStats()).getDataAsNBT();
        if (!nbt.m_128471_("merged_preset")) {
            nbt.m_128391_(presetNbt);
        }
        this.partsManager.read(nbt, presetNbt);
        this.textureManager.read(nbt);
        this.soundManager.read(nbt);
        this.setHealth(nbt.m_128457_("health"));
        this.setArmor(nbt.m_128457_("armor"));
        this.setLandingGear(nbt.m_128471_("landing_gear"));
        this.setCurrentThrottle(nbt.m_128457_("current_throttle"));
        this.setXRotNoQ(nbt.m_128457_("xRot"));
        this.setYRotNoQ(nbt.m_128457_("yRot"));
        this.zRot = nbt.m_128457_("zRot");
        Quaternion q = UtilAngles.toQuaternion((double)this.m_146908_(), (double)this.m_146909_(), (double)this.zRot);
        this.setQ(q);
        this.setPrevQ(q);
        this.setClientQ(q);
        this.setRadarMode(RadarStats.RadarMode.values()[nbt.m_128451_("radar_mode")]);
        this.setRadioSong(nbt.m_128461_("radio_song"));
        this.createRotableHitboxes(nbt);
        if (nbt.m_128441_("ingredientDropIndex")) {
            this.ingredientDropIndex = nbt.m_128451_("ingredientDropIndex");
        }
        if (nbt.m_128441_("owner_id")) {
            this.owner_uuid = nbt.m_128342_("owner_id");
        }
        this.setPermMode(PermMode.values()[nbt.m_128451_("perm_mode")]);
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128379_("test_mode", this.isTestMode());
        nbt.m_128379_("no_consume", this.isNoConsume());
        nbt.m_128379_("merged_preset", true);
        this.partsManager.write(nbt);
        this.textureManager.write(nbt);
        this.soundManager.write(nbt);
        nbt.m_128350_("health", this.getHealth());
        nbt.m_128350_("armor", this.getArmor());
        nbt.m_128379_("landing_gear", this.isLandingGear());
        nbt.m_128350_("current_throttle", this.getCurrentThrottle());
        nbt.m_128350_("xRot", this.m_146909_());
        nbt.m_128350_("yRot", this.m_146908_());
        nbt.m_128350_("zRot", this.zRot);
        nbt.m_128405_("radar_mode", this.getRadarMode().ordinal());
        nbt.m_128359_("radio_song", this.getRadioSong());
        Entity own = this.getOwner();
        if (own != null) {
            nbt.m_128359_("owner_name", own.m_6302_());
            nbt.m_128362_("owner_id", own.m_20148_());
        } else if (this.owner_uuid != null) {
            nbt.m_128362_("owner_id", this.owner_uuid);
        }
        Component name = this.m_7770_();
        if (name != null) {
            nbt.m_128359_("CustomName", Component.Serializer.m_130703_((Component)name));
        }
        if (this.m_20151_()) {
            nbt.m_128379_("CustomNameVisible", this.m_20151_());
        }
        nbt.m_128350_("fuel", this.getCurrentFuel());
        nbt.m_128350_("flares", (float)this.getFlareNum());
        this.saveRotableHitboxes(nbt);
        nbt.m_128405_("ingredientDropIndex", this.ingredientDropIndex);
        nbt.m_128405_("perm_mode", this.getPermMode().ordinal());
    }

    public void readSpawnData(FriendlyByteBuf buffer) {
        super.readSpawnData(buffer);
        int weaponIndex = buffer.readInt();
        boolean gear = buffer.readBoolean();
        boolean freeLook = buffer.readBoolean();
        float throttle = buffer.readFloat();
        List<PartSlot> slots = PartsManager.readSlotsFromBuffer(buffer);
        this.textureManager.read((ByteBuf)buffer);
        this.soundManager.write(buffer);
        this.weaponSystem.setSelected(weaponIndex);
        this.partsManager.setPartSlots(slots);
        this.partsManager.clientPartsSetup();
        this.setLandingGear(gear);
        this.setDriverCameraLocked(freeLook);
        this.setCurrentThrottle(throttle);
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        super.writeSpawnData(buffer);
        buffer.writeInt(this.weaponSystem.getSelectedIndex());
        buffer.writeBoolean(this.isLandingGear());
        buffer.writeBoolean(this.isDriverCameraLocked());
        buffer.writeFloat(this.getCurrentThrottle());
        PartsManager.writeSlotsToBuffer(buffer, this.partsManager.getSlots());
        this.textureManager.write(buffer);
        this.soundManager.write(buffer);
    }

    public void onRemovedFromWorld() {
        super.onRemovedFromWorld();
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
    }

    public abstract VehicleType getVehicleType();

    public void init() {
        this.m_6210_();
        if (!this.f_19853_.f_46443_) {
            this.serverSetup();
        } else {
            this.clientSetup();
        }
        this.soundManager.loadSounds((VehicleStats)this.getStats());
    }

    public void m_8119_() {
        if (UtilGeometry.vec3NAN((Vec3)this.m_20184_())) {
            this.m_20256_(Vec3.f_82478_);
        }
        if (this.f_19803_) {
            this.init();
        }
        super.m_8119_();
        this.prevMotion = this.m_20184_();
        this.forcesO = this.getForces();
        this.momentO = this.getMoment();
        this.setForces(Vec3.f_82478_);
        this.setMoment(Vec3.f_82478_);
        this.zRotO = this.zRot;
        Quaternion q = this.getQBySide();
        this.setPrevQ(q);
        this.controlDirection(q);
        this.setQBySide(q);
        UtilAngles.EulerAngles angles = UtilAngles.toDegrees((Quaternion)q);
        this.setXRotNoQ((float)angles.pitch);
        this.setYRotNoQ((float)angles.yaw);
        this.zRot = (float)angles.roll;
        this.tickThrottle();
        if (!this.isTestMode()) {
            this.calcMoveStatsPre(q);
            this.tickMovement(q);
            this.calcAcc();
            this.motionClamp();
            if (!this.m_9236_().m_5776_() && this.canTrample()) {
                this.tickTrample();
            }
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.calcMoveStatsPost(q);
            this.tickCollisions();
        }
        this.tickLerp();
        this.tickHitboxes();
        this.controlSystem();
        this.tickParts();
        this.tickWarnings();
        this.soundManager.onTick();
        this.textureManager.onTick();
        if (this.f_19853_.f_46443_) {
            this.clientTick();
        } else {
            this.serverTick();
        }
    }

    public void serverTick() {
        this.waterDamage();
        if (!this.isTestMode() && !this.isOperational()) {
            this.tickNoHealth();
        }
        if (!(!this.hasRadioSong() || this.isOperational() && this.hasRadio)) {
            this.turnRadioOff();
        }
    }

    public void syncControlsToClient() {
        if (this.f_19853_.f_46443_) {
            return;
        }
        PacketHandler.INSTANCE.send(PacketDistributor.TRACKING_ENTITY.with(() -> this), (Object)new ToClientVehicleControl(this));
    }

    public void tickCollisions() {
        if (!this.f_19853_.f_46443_) {
            this.knockBack(this.f_19853_.m_6249_((Entity)this, this.m_20191_(), this.getKnockbackPredicate()));
            this.tickDismountSafety();
            if (!this.m_217005_()) {
                this.wallCollisions();
            }
        } else if (this.m_6109_()) {
            this.wallCollisions();
        }
    }

    public boolean canTrample() {
        return (this.m_20096_() || this.m_20069_()) && this.xzSpeed > 0.0f && this.m_9236_().m_46469_().m_46207_(DSCGameRules.VEHICLE_TRAMPLE);
    }

    protected void tickTrample() {
        AABB box = this.m_20191_().m_82383_(this.m_20184_()).m_82400_(0.01);
        Entity controller = this.m_6688_();
        for (double x = box.f_82288_; x < box.f_82291_ + 1.0; x += 1.0) {
            for (double z = box.f_82290_; z < box.f_82293_ + 1.0; z += 1.0) {
                for (double y = box.f_82289_; y < box.f_82292_ + 1.0; y += 1.0) {
                    BlockPos pos = new BlockPos(x, y, z);
                    BlockState state = this.m_9236_().m_8055_(pos);
                    if (!state.m_204336_(ModTags.Blocks.VEHICLE_TRAMPLE) || !UtilVehicleEntity.vehicleHasPermissionToTrample(pos, state, this.m_9236_(), controller)) continue;
                    this.m_9236_().m_46953_(pos, true, (Entity)this);
                }
            }
        }
    }

    protected void wallCollisions() {
        if (this.f_19863_) {
            this.verticalCollision();
        }
        if (this.f_19862_ && !this.f_185931_) {
            this.horizontalCollision();
        }
    }

    protected void horizontalCollision() {
        double th;
        double speed = this.prevMotion.m_165924_();
        if (speed > (th = 0.5)) {
            float amount = (float)((speed - th) * 300.0);
            this.collideHurt(amount, false);
        }
    }

    protected void verticalCollision() {
        double my = Math.abs(this.prevMotion.f_82480_);
        double th = 0.5;
        if (this.isOperational() && this.isLandingGear() && Mth.m_14154_((float)this.m_146909_()) < 15.0f && Mth.m_14154_((float)this.zRot) < 15.0f) {
            th = 1.5;
        }
        if (my > th) {
            float amount = (float)((my - th) * 300.0);
            this.collideHurt(amount, true);
        }
        if (this.isOperational() && this.m_20096_() && !this.isLandingGear() && this.getXZSpeed() > 0.5f) {
            this.collideHurt(1.0f, false);
        }
    }

    public boolean m_142535_(float dist, float mult, DamageSource source) {
        this.verticalCollision();
        return true;
    }

    public void collideHurt(float amount, boolean isFall) {
        if (!this.f_19853_.f_46443_ && this.f_19797_ > 200) {
            if (isFall) {
                this.m_6469_(DamageSource.f_19315_, amount);
            } else {
                this.m_6469_(DamageSource.f_19316_, amount);
            }
        } else if (this.f_19853_.f_46443_ && this.m_6109_()) {
            PacketHandler.INSTANCE.sendToServer((Object)new ToServerVehicleCollide(this.m_19879_(), amount, isFall));
        }
    }

    protected Predicate<? super Entity> getKnockbackPredicate() {
        return entity -> {
            Player p;
            if (entity.f_19794_) {
                return false;
            }
            if (entity.m_5833_()) {
                return false;
            }
            if (this.equals(entity.m_20201_())) {
                return false;
            }
            if (!(entity instanceof LivingEntity)) {
                return false;
            }
            if (entity instanceof Player && (p = (Player)entity).m_7500_()) {
                return false;
            }
            return !this.isFormerPassenger((Entity)entity);
        };
    }

    private void tickDismountSafety() {
        this.formerPassengersServer.forEach((id, time) -> {
            if (time > 0) {
                time = time - 1;
            }
        });
    }

    public boolean isFormerPassenger(Entity passenger) {
        return this.formerPassengersServer.containsKey(passenger.m_19879_()) && this.formerPassengersServer.get(passenger.m_19879_()) > 0;
    }

    public void onSeatDismount(Entity entity) {
        if (!this.f_19853_.f_46443_) {
            this.formerPassengersServer.put(entity.m_19879_(), 100);
        }
    }

    protected void knockBack(List<Entity> entities) {
        double push_factor = 10.0f * this.xzSpeed;
        if (push_factor < 2.0) {
            push_factor = 2.0;
        }
        double d0 = this.m_20191_().m_82399_().f_82479_;
        double d1 = this.m_20191_().m_82399_().f_82481_;
        for (Entity entity : entities) {
            if (entity.f_19794_) continue;
            double d2 = entity.m_20185_() - d0;
            double d3 = entity.m_20189_() - d1;
            double d4 = Math.max(d2 * d2 + d3 * d3, 0.1);
            entity.m_5997_(d2 / d4 * push_factor, 0.2, d3 / d4 * push_factor);
            if (!(push_factor > 2.0)) continue;
            entity.m_6469_(VehicleDamageSource.roadKill(this), (float)push_factor * 2.0f);
        }
    }

    public void waterDamage() {
        if (this.f_19797_ % 20 == 0 && this.m_20069_() && this.isOperational()) {
            this.m_6469_(DamageSource.f_19312_, 5.0f);
        }
    }

    public void tickNoHealth() {
        int removeTicks;
        ++this.deadTicks;
        if (this.isFullyLooted()) {
            this.m_6074_();
        }
        if ((removeTicks = this.m_9236_().m_46469_().m_46215_(DSCGameRules.REMOVE_DEAD_VEHICLES_TIME) * 20) >= 0 && this.deadTicks >= removeTicks) {
            if (this.m_9236_().m_46469_().m_46207_(GameRules.f_46137_)) {
                this.dropAllItems();
            }
            this.m_6074_();
        }
    }

    public boolean isFullyLooted() {
        return !this.isOperational() && this.partsManager.isEmpty() && !this.canDropIngredients();
    }

    public boolean isOperational() {
        return this.getHealth() > 0.0f;
    }

    public int getDeadTicks() {
        return this.deadTicks;
    }

    public void clientTick() {
        UtilParticles.vehicleParticles(this);
        this.tickClientLandingGear();
    }

    public void motionClamp() {
        double maxY;
        double my;
        Vec3 move = this.m_20184_();
        double maxXZ = this.getMaxSpeedForMotion();
        Vec3 motionXZ = new Vec3(move.f_82479_, 0.0, move.f_82481_);
        double velXZ = motionXZ.m_82553_();
        if (velXZ > maxXZ) {
            motionXZ = motionXZ.m_82490_(maxXZ / velXZ);
        }
        if ((my = move.f_82480_) > this.getMaxClimbSpeed()) {
            my = this.getMaxClimbSpeed();
        } else if (my < -this.getMaxFallSpeed()) {
            my = -this.getMaxFallSpeed();
        } else if (Math.abs(my) < 0.001) {
            my = 0.0;
        }
        double decreaseSpeedPos = 100.0;
        double altitude = this.getAltitude();
        double nextY = altitude + my;
        if (nextY > this.getMaxAltitude()) {
            my = this.getMaxAltitude() - altitude;
        } else if (altitude > this.getMaxAltitude() - decreaseSpeedPos && my > (maxY = 1.0 - (altitude - this.getMaxAltitude() + decreaseSpeedPos) / decreaseSpeedPos)) {
            my = maxY;
        }
        if (this.f_19861_ && my < 0.0) {
            my = -0.01;
        }
        this.m_20334_(motionXZ.f_82479_, my, motionXZ.f_82481_);
    }

    public double getMaxClimbSpeed() {
        return 1.0;
    }

    public double getMaxFallSpeed() {
        return 2.5;
    }

    public double getMaxSpeedForMotion() {
        return (double)this.getMaxSpeed() * this.getMaxSpeedFactor();
    }

    public double getMaxSpeedFactor() {
        return (Double)Config.SERVER.vehicleSpeedFactor.get();
    }

    public void tickThrottle() {
        if (!this.isTestMode()) {
            if (!this.isOperational() || this.cutThrottleOnNoPilot() && !this.m_217005_() || this.cutThrottleOnNoPassengers() && !this.isPlayerOrBotRiding()) {
                this.resetControls();
                return;
            }
            if (this.currentFuel <= 0.0f || this.isAllEnginesDamaged()) {
                this.throttleToZero();
                return;
            }
        }
        if (this.inputs.throttle > 0.0f) {
            this.increaseThrottle();
        } else if (this.inputs.throttle < 0.0f) {
            this.decreaseThrottle();
        }
    }

    public boolean cutThrottleOnNoPilot() {
        return true;
    }

    public boolean cutThrottleOnNoPassengers() {
        return true;
    }

    public void controlDirection(Quaternion q) {
        if (this.f_19861_) {
            this.directionGround(q);
        } else if (this.m_20069_()) {
            this.directionWater(q);
        } else {
            this.directionAir(q);
        }
        Vec3 m = this.getMoment().m_82549_(this.addMomentBetweenTicks);
        Vec3 av = this.getAngularVel();
        if (!UtilGeometry.isZero((Vec3)m)) {
            av = av.m_82520_(m.f_82479_ / (double)((VehicleStats)this.getStats()).Ix, m.f_82480_ / (double)((VehicleStats)this.getStats()).Iy, m.f_82481_ / (double)((VehicleStats)this.getStats()).Iz);
            this.setAngularVel(av);
        }
        q.m_80148_(Vector3f.f_122222_.m_122240_((float)av.f_82479_));
        q.m_80148_(Vector3f.f_122224_.m_122240_((float)av.f_82480_));
        q.m_80148_(Vector3f.f_122227_.m_122240_((float)av.f_82481_));
        this.applyAngularDrag();
        this.addMomentBetweenTicks = Vec3.f_82478_;
    }

    public void applyAngularDrag() {
        float d;
        Vec3 av = this.getAngularVel();
        float dx = d = this.getAngularDrag();
        float dy = d;
        float dz = d;
        if (!this.f_19861_) {
            if (this.inputs.pitch != 0.0f && Math.abs(av.f_82479_) <= (double)this.getControlMaxDeltaPitch()) {
                dx = 0.0f;
            }
            if (this.inputs.yaw != 0.0f && Math.abs(av.f_82480_) <= (double)this.getControlMaxDeltaYaw()) {
                dy = 0.0f;
            }
            if (this.inputs.roll != 0.0f && Math.abs(av.f_82481_) <= (double)this.getControlMaxDeltaRoll()) {
                dz = 0.0f;
            }
        }
        this.setAngularVel(new Vec3(this.getADComponent(av.f_82479_, dx, ((VehicleStats)this.getStats()).Ix), this.getADComponent(av.f_82480_, dy, ((VehicleStats)this.getStats()).Iy), this.getADComponent(av.f_82481_, dz, ((VehicleStats)this.getStats()).Iz)));
    }

    private double getADComponent(double v, float d, float I) {
        double a = Math.abs(v) - (double)(d / I);
        if (a < 0.0) {
            return 0.0;
        }
        return a * Math.signum(v);
    }

    protected float getAngularDrag() {
        if (this.f_19861_) {
            return 2.5f;
        }
        if (this.m_20069_()) {
            return 1.5f;
        }
        return 1.0f;
    }

    public void directionGround(Quaternion q) {
        if (!this.isOperational()) {
            return;
        }
        this.flatten(q, 4.0f, 4.0f, true);
        float max_tr = this.getTurnRadius();
        Vec3 av = this.getAngularVel();
        if (this.inputs.yaw == 0.0f || max_tr == 0.0f) {
            if (!this.isSliding()) {
                this.setAngularVel(av.m_82542_(1.0, 0.0, 1.0));
            }
            return;
        }
        float tr = 1.0f / this.inputs.yaw * max_tr;
        float turn = this.xzSpeed / tr * (float)this.xzSpeedDir;
        float turnDeg = turn * 57.295776f;
        if (!this.isSliding()) {
            av = av.m_82542_(1.0, 0.0, 1.0).m_82520_(0.0, (double)turnDeg, 0.0);
        } else {
            this.addMomentY(turnDeg * this.slideAngleCos, false);
        }
        this.setAngularVel(av);
    }

    public void directionAir(Quaternion q) {
    }

    public void directionWater(Quaternion q) {
        this.directionAir(q);
    }

    public void flatten(Quaternion q, float dPitch, float dRoll, boolean forced) {
        Vec3 av = this.getAngularVel();
        float x = (float)av.f_82479_;
        float z = (float)av.f_82481_;
        if (!forced) {
            if (Math.abs(av.f_82479_) <= (double)dPitch) {
                x = 0.0f;
            }
            if (Math.abs(av.f_82481_) <= (double)dRoll) {
                z = 0.0f;
            }
        } else {
            z = 0.0f;
            x = 0.0f;
        }
        UtilAngles.EulerAngles angles = UtilAngles.toDegrees((Quaternion)q);
        if (dRoll != 0.0f) {
            float roll = Math.abs(angles.roll) < (double)dRoll ? (float)(-angles.roll) : -((float)Math.signum(angles.roll)) * dRoll;
            z += roll;
        }
        if (dPitch != 0.0f) {
            float diff;
            float goalPitch = 0.0f;
            if (this.m_20096_()) {
                goalPitch = -((VehicleStats)this.getStats()).groundXTilt;
            }
            float pitch = Math.abs(diff = (float)angles.pitch - goalPitch) < dPitch ? diff : Math.signum(diff) * dPitch;
            x += pitch;
        }
        this.setAngularVel(new Vec3((double)x, av.f_82480_, (double)z));
    }

    public void addMoment(Vec3 moment, boolean control) {
        Vec3 m = this.getMoment();
        double x = moment.f_82479_;
        double y = moment.f_82480_;
        double z = moment.f_82481_;
        if (control) {
            Vec3 av = this.getAngularVel();
            if (moment.f_82479_ != 0.0) {
                x = this.getControlMomentComponent(m.f_82479_, moment.f_82479_, av.f_82479_, this.getControlMaxDeltaPitch(), ((VehicleStats)this.getStats()).Ix);
            }
            if (moment.f_82480_ != 0.0) {
                y = this.getControlMomentComponent(m.f_82480_, moment.f_82480_, av.f_82480_, this.getControlMaxDeltaYaw(), ((VehicleStats)this.getStats()).Iy);
            }
            if (moment.f_82481_ != 0.0) {
                z = this.getControlMomentComponent(m.f_82481_, moment.f_82481_, av.f_82481_, this.getControlMaxDeltaRoll(), ((VehicleStats)this.getStats()).Iz);
            }
        }
        this.setMoment(m.m_82520_(x, y, z));
    }

    private double getControlMomentComponent(double cm, double m, double v, float max, float I) {
        if (Math.abs(v) > (double)max && Math.signum(v) == Math.signum(m)) {
            return 0.0;
        }
        double m2 = cm + m;
        double a2 = m2 / (double)I;
        double v2 = v + a2;
        double vd = Math.abs(v2) - (double)max;
        if (vd > 0.0) {
            m -= vd * Math.signum(v2) * (double)I;
        }
        return m;
    }

    public void addMomentX(float moment, boolean control) {
        this.addMoment(Vec3.f_82478_.m_82520_((double)moment, 0.0, 0.0), control);
    }

    public void addMomentY(float moment, boolean control) {
        this.addMoment(Vec3.f_82478_.m_82520_(0.0, (double)moment, 0.0), control);
    }

    public void addMomentZ(float moment, boolean control) {
        this.addMoment(Vec3.f_82478_.m_82520_(0.0, 0.0, (double)moment), control);
    }

    public float getControlMaxDeltaPitch() {
        return this.getMaxDeltaPitch() * Mth.m_14154_((float)this.inputs.pitch);
    }

    public float getControlMaxDeltaYaw() {
        return this.getMaxDeltaYaw() * Mth.m_14154_((float)this.inputs.yaw);
    }

    public float getControlMaxDeltaRoll() {
        return this.getMaxDeltaRoll() * Mth.m_14154_((float)this.inputs.roll);
    }

    protected void calcMoveStatsPre(Quaternion q) {
        this.totalMass = this.getEmptyVehicleMass() + this.partsManager.getPartsWeight();
        this.staticFric = this.totalMass * 0.08f * 1.0f;
        this.kineticFric = this.totalMass * 0.08f * 0.4f;
        this.maxPushThrust = this.partsManager.getTotalPushThrust();
        this.maxSpinThrust = this.partsManager.getTotalSpinThrust();
        this.currentFuel = this.partsManager.getCurrentFuel();
        this.maxFuel = this.partsManager.getMaxFuel();
        this.hasFlares = !this.partsManager.getFlares().isEmpty();
        this.numFlares = this.partsManager.getNumFlares();
        this.airPressure = UtilVehicleEntity.getAirPressure((Entity)this);
        this.groundTicks = this.m_20096_() ? ++this.groundTicks : 0;
    }

    protected void calcMoveStatsPost(Quaternion q) {
        Vec3 m = this.m_20184_();
        float y = this.m_146908_();
        this.xzSpeed = (float)Math.sqrt(m.f_82479_ * m.f_82479_ + m.f_82481_ * m.f_82481_);
        if (this.xzSpeed == 0.0f) {
            this.xzYaw = y;
            this.slideAngle = 0.0f;
        } else {
            this.xzYaw = UtilAngles.getYaw((Vec3)m);
            this.slideAngle = Mth.m_14118_((float)this.xzYaw, (float)y);
            this.slideAngleCos = (float)Math.abs(Math.cos(Math.toRadians(this.slideAngle)));
        }
        this.xzSpeedDir = 1;
        if (Math.abs(this.slideAngle) > 90.0f) {
            this.xzSpeedDir = -1;
        }
        this.currentAltitude = UtilEntity.getDistFromSeaLevel((Entity)this);
    }

    public float getXZSpeed() {
        return this.xzSpeed;
    }

    public int getXZSpeedDir() {
        return this.xzSpeedDir;
    }

    public void calcAcc() {
        Vec3 f = this.getForces().m_82549_(this.addForceBetweenTicks);
        double s = 1.0f / this.getTotalMass();
        this.m_20256_(this.m_20184_().m_82549_(f.m_82490_(s)));
        this.addForceBetweenTicks = Vec3.f_82478_;
    }

    public void m_6478_(MoverType type, Vec3 move) {
        super.m_6478_(type, move);
        if (!this.f_19794_ && this.m_20096_() && this.m_20184_().f_82480_ == 0.0) {
            this.stepDown(move);
        }
    }

    protected void stepDown(Vec3 move) {
        AABB aabb = this.m_20191_();
        Vec3 down = new Vec3(0.0, (double)(-this.getStepHeight()) - 0.1, 0.0);
        List list = this.f_19853_.m_183134_((Entity)this, aabb.m_82369_(down));
        Vec3 collide = EntityVehicle.m_198894_((Entity)this, (Vec3)down, (AABB)aabb, (Level)this.f_19853_, (List)list);
        if (collide.f_82480_ < 0.0 && collide.f_82480_ >= (double)(-this.getStepHeight())) {
            this.m_6034_(this.m_20185_(), this.m_20186_() + collide.f_82480_, this.m_20189_());
        }
    }

    public void tickMovement(Quaternion q) {
        this.tickAlways(q);
        if (this.f_19861_ && this.m_20069_()) {
            this.tickGroundWater(q);
        } else if (this.f_19861_) {
            this.tickGround(q);
        } else if (this.m_20069_()) {
            this.tickWater(q);
        } else {
            this.tickAir(q);
        }
    }

    public void tickAlways(Quaternion q) {
        Vec3 f = this.getForces();
        f = f.m_82549_(this.getWeightForce());
        f = f.m_82549_(this.getThrustForce(q));
        this.setForces(f);
    }

    public void tickGround(Quaternion q) {
        Vec3 n = UtilAngles.rotationToVector((double)this.m_146908_(), (double)0.0);
        if (this.isSliding() || this.willSlideFromTurn()) {
            this.m_20256_(this.m_20184_().m_82549_(n.m_82490_(this.getDriveAcc() * (double)this.slideAngleCos)));
            this.addFrictionForce(this.kineticFric);
        } else {
            this.m_20256_(n.m_82490_((double)(this.xzSpeed * (float)this.xzSpeedDir) + this.getDriveAcc()));
            if (this.getCurrentThrottle() == 0.0f && this.xzSpeed != 0.0f) {
                this.addFrictionForce(200.0);
            }
        }
        if (this.isBraking() && this.isOperational()) {
            this.applyBreaks();
        }
    }

    public double getDriveAcc() {
        return this.getSpinThrustMag() / (double)this.getTotalMass();
    }

    public boolean isBraking() {
        return false;
    }

    public abstract boolean canBrake();

    public void applyBreaks() {
        this.addFrictionForce(this.kineticFric);
    }

    protected void addFrictionForce(double f) {
        Vec3 m = this.m_20184_();
        if (m.f_82479_ == 0.0 && m.f_82481_ == 0.0) {
            return;
        }
        Vec3 mn = m.m_82541_();
        Vec3 force = mn.m_82490_(-f);
        Vec3 acc = force.m_82490_((double)(1.0f / this.getTotalMass()));
        if (m.f_82479_ != 0.0 && Math.signum(m.f_82479_ + acc.f_82479_) != Math.signum(m.f_82479_)) {
            force = force.m_82542_(0.0, 1.0, 1.0);
            m = m.m_82542_(0.0, 1.0, 1.0);
        }
        if (m.f_82481_ != 0.0 && Math.signum(m.f_82481_ + acc.f_82481_) != Math.signum(m.f_82481_)) {
            force = force.m_82542_(1.0, 1.0, 0.0);
            m = m.m_82542_(1.0, 1.0, 0.0);
        }
        this.m_20256_(m);
        this.setForces(this.getForces().m_82549_(force));
    }

    protected boolean willSlideFromTurn() {
        double tr;
        double cen_acc;
        double cen_force;
        double max_tr = this.getTurnRadius();
        return this.inputs.yaw != 0.0f && max_tr != 0.0 && (cen_force = (cen_acc = (double)(this.xzSpeed * this.xzSpeed) / (tr = max_tr * 1.0 / (double)Math.abs(this.inputs.yaw))) * (double)this.getTotalMass()) >= this.staticFric;
    }

    public boolean isSlideAngleNearZero() {
        if (this.xzSpeedDir == -1) {
            return Mth.m_14154_((float)(Mth.m_14154_((float)this.slideAngle) - 180.0f)) < 2.0f;
        }
        return Mth.m_14154_((float)this.slideAngle) < 2.0f;
    }

    public boolean isSliding() {
        return !this.isLandingGear() || !this.isSlideAngleNearZero();
    }

    public void tickAir(Quaternion q) {
        this.setForces(this.getForces().m_82549_(this.getDragForce(q)));
        this.m_183634_();
    }

    public void tickWater(Quaternion q) {
        this.setForces(this.getForces().m_82549_(this.getDragForce(q)));
    }

    public void tickGroundWater(Quaternion q) {
        this.tickGround(q);
        this.tickWater(q);
    }

    public abstract Vec3 getThrustForce(Quaternion var1);

    public double getPushThrustMag() {
        if (this.getCurrentFuel() <= 0.0f || !this.isOperational()) {
            return 0.0;
        }
        return this.getCurrentThrottle() * this.getMaxPushThrust();
    }

    public float getMaxPushThrust() {
        return this.maxPushThrust;
    }

    public double getSpinThrustMag() {
        if (this.getCurrentFuel() <= 0.0f || !this.isOperational()) {
            return 0.0;
        }
        return this.getCurrentThrottle() * this.getMaxSpinThrust();
    }

    public float getMaxSpinThrust() {
        return this.maxSpinThrust;
    }

    public Vec3 getDragForce(Quaternion q) {
        Vec3 direction = this.m_20184_().m_82541_().m_82490_(-1.0);
        Vec3 dragForce = direction.m_82490_(this.getDragMag());
        return dragForce;
    }

    public double getDragMag() {
        double speedSqr = this.m_20184_().m_82556_();
        double d = this.airPressure * speedSqr * this.getCrossSectionArea();
        d = this.m_20069_() ? (d *= 25.0) : (d *= 10.0);
        return d;
    }

    public double getCrossSectionArea() {
        double a = this.getBaseCrossSecArea();
        if (!this.isOperational()) {
            a += 4.0;
        }
        return a;
    }

    public Vec3 getWeightForce() {
        return new Vec3(0.0, (double)(-this.getTotalMass() * 0.08f), 0.0);
    }

    public float getTotalMass() {
        if (Float.isNaN(this.totalMass)) {
            LOGGER.warn("ERROR: NAN MASS? setting to 10000 | " + this);
            this.totalMass = 10000.0f;
        } else if (this.totalMass == 0.0f) {
            LOGGER.warn("ERROR: 0 MASS? setting to 10000 | " + this);
            this.totalMass = 10000.0f;
        }
        return this.totalMass;
    }

    public final float getEmptyVehicleMass() {
        return ((VehicleStats)this.getStats()).mass;
    }

    public void controlSystem() {
        if (!this.isOperational()) {
            return;
        }
        this.radarSystem.tick();
        Entity controller = this.m_6688_();
        if (!this.f_19853_.f_46443_) {
            ServerPlayer player;
            boolean consume;
            this.weaponSystem.serverTick();
            if (controller == null) {
                return;
            }
            boolean bl = consume = !this.isNoConsume();
            if (controller instanceof ServerPlayer && (player = (ServerPlayer)controller).m_7500_()) {
                consume = false;
            }
            boolean consumeFuel = this.f_19853_.m_46469_().m_46207_(DSCGameRules.CONSUME_FULE);
            if (consume && consumeFuel) {
                this.tickFuel();
            }
            if (this.inputs.flare && this.f_19797_ - this.flareTicks >= 10) {
                boolean consumeFlares = this.f_19853_.m_46469_().m_46207_(DSCGameRules.CONSUME_FLARES);
                this.flare(controller, consume && consumeFlares);
            }
        }
    }

    public void openPartsMenu(ServerPlayer player) {
        NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)new SimpleMenuProvider((windowId, playerInv, p) -> new VehiclePartsMenu(windowId, playerInv), (Component)UtilMCText.translatable((String)"screen.dscombat.vehicle_parts_screen")));
    }

    public void openStorage(ServerPlayer player, int index) {
        StorageInstance<?> box = this.partsManager.getStorageData(index);
        if (box == null) {
            player.m_5661_((Component)UtilMCText.translatable((String)"error.dscombat.no_storage_boxes"), true);
            return;
        }
        NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)new SimpleMenuProvider((windowId, playerInventory, p) -> box.createMenu(windowId, playerInventory), (Component)UtilMCText.translatable((String)"screen.dscombat.vehicle_inventory_screen")), buff -> buff.writeInt(this.partsManager.getStorageIndex()));
    }

    public boolean canOpenPartsMenu() {
        return this.m_20096_() && (double)this.xzSpeed < 0.1 || this.isTestMode();
    }

    public String getOpenMenuError() {
        if (!this.m_20096_()) {
            return "error.dscombat.no_menu_in_air";
        }
        return "error.dscombat.no_menu_moving";
    }

    public void flare(Entity controller, boolean consume) {
        if (this.partsManager.useFlares(consume)) {
            ToClientOnShoot.onShootFlareRack(this);
            this.flareTicks = this.f_19797_;
        }
    }

    public void tickParts() {
        this.findGimbalForPilotCamera();
        if (this.f_19853_.f_46443_) {
            this.partsManager.clientTickParts();
        } else {
            this.partsManager.serverTickParts();
        }
    }

    public void m_6001_(double x, double y, double z) {
        if (!this.m_6109_()) {
            super.m_6001_(x, y, z);
            return;
        }
    }

    public void m_6453_(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        this.lerpX = x;
        this.lerpY = y;
        this.lerpZ = z;
        this.lerpSteps = teleport ? posRotationIncrements : 1;
    }

    private void tickLerp() {
        if (this.m_6109_()) {
            this.m_217006_(this.m_20185_(), this.m_20186_(), this.m_20189_());
            this.syncMoveRot();
            this.lerpSteps = 0;
            return;
        }
        if (this.lerpSteps > 0) {
            double d0 = this.m_20185_() + (this.lerpX - this.m_20185_()) / (double)this.lerpSteps;
            double d1 = this.m_20186_() + (this.lerpY - this.m_20186_()) / (double)this.lerpSteps;
            double d2 = this.m_20189_() + (this.lerpZ - this.m_20189_()) / (double)this.lerpSteps;
            --this.lerpSteps;
            this.m_6034_(d0, d1, d2);
        }
    }

    private void syncMoveRot() {
        if (!this.f_19853_.f_46443_ || this.f_19797_ % 10 != 0 || this.f_19803_) {
            return;
        }
        PacketHandler.INSTANCE.sendToServer((Object)new ToServerVehicleMoveRot(this));
    }

    public void resetControls() {
        this.inputs.reset();
        this.throttleToZero();
    }

    public final boolean isDriverCameraLocked() {
        return this.isDriverCameraLocked;
    }

    public final void setDriverCameraLocked(boolean driverCameraLocked) {
        this.isDriverCameraLocked = driverCameraLocked;
    }

    public RadarStats.RadarMode getRadarMode() {
        return (RadarStats.RadarMode)((Object)this.f_19804_.m_135370_(RADAR_MODE));
    }

    public void setRadarMode(RadarStats.RadarMode mode) {
        this.f_19804_.m_135381_(RADAR_MODE, (Object)mode);
    }

    public void cycleRadarMode() {
        this.setRadarMode(this.getRadarMode().cycle());
    }

    public final String getRadioSong() {
        return (String)this.f_19804_.m_135370_(RADIO_SONG);
    }

    public boolean hasRadioSong() {
        return !this.getRadioSong().isEmpty();
    }

    public final void setRadioSong(String song) {
        this.f_19804_.m_135381_(RADIO_SONG, (Object)song);
    }

    public void turnRadioOff() {
        this.setRadioSong("");
    }

    public void serverSetup() {
        this.partsManager.setupParts();
    }

    public void clientSetup() {
        this.soundManager.onClientInit();
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        InteractionResult result;
        if ((double)this.xzSpeed > 0.2) {
            return InteractionResult.PASS;
        }
        if (player.m_36341_()) {
            return InteractionResult.PASS;
        }
        if (player.m_20201_().equals((Object)this)) {
            return InteractionResult.PASS;
        }
        ItemStack stack = player.m_150109_().m_36056_();
        if (!stack.m_41619_() && (result = this.onItemInteract(player, hand, stack)) != InteractionResult.FAIL) {
            return result;
        }
        if (!this.isOperational()) {
            return this.onDestroyedInteract(player, hand);
        }
        if (!this.f_19853_.f_46443_) {
            return this.rideAvailableSeat((Entity)player) ? InteractionResult.CONSUME : InteractionResult.PASS;
        }
        Minecraft m = Minecraft.m_91087_();
        if (m.f_91074_.equals((Object)player)) {
            DSCClientInputs.centerMousePos();
        }
        return InteractionResult.SUCCESS;
    }

    protected InteractionResult onItemInteract(Player player, InteractionHand hand, ItemStack stack) {
        if (stack.m_204117_(ModTags.Items.SPRAY_CAN)) {
            return this.onSprayCanInteract(player, hand, stack);
        }
        if (!this.f_19853_.f_46443_) {
            Item item = stack.m_41720_();
            if (item instanceof VehicleInteractItem) {
                VehicleInteractItem vii = (VehicleInteractItem)item;
                return vii.onServerInteract(this, stack, player, hand);
            }
            if (!this.isOperational()) {
                return InteractionResult.FAIL;
            }
            if (stack.m_204117_(ModTags.Items.GAS_CAN)) {
                return this.onGasCanInteract(player, hand, stack);
            }
            if (stack.m_204117_(ModTags.Items.FORGE_OIL_BUCKET)) {
                return this.onOilBucketInteract(player, hand, stack);
            }
            if (stack.m_204117_(ModTags.Items.VEHICLE_CHAIN)) {
                return this.onChainInteract(player, hand, stack);
            }
            if (item instanceof RecordItem) {
                RecordItem disk = (RecordItem)item;
                if (!this.hasRadio) {
                    return InteractionResult.PASS;
                }
                this.setRadioSong(disk.m_43051_().m_11660_().toString());
                return InteractionResult.SUCCESS;
            }
            if (item instanceof NameTagItem) {
                NameTagItem name = (NameTagItem)item;
                if (stack.m_41788_()) {
                    this.m_6593_(stack.m_41786_());
                    this.m_20340_(true);
                    stack.m_41774_(1);
                    return InteractionResult.CONSUME;
                }
                return InteractionResult.PASS;
            }
        }
        return InteractionResult.FAIL;
    }

    protected InteractionResult onGasCanInteract(Player player, InteractionHand hand, ItemStack stack) {
        int md = stack.m_41776_();
        int d = stack.m_41773_();
        int r = (int)this.addFuel(md - d);
        stack.m_41721_(md - r);
        return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
    }

    protected InteractionResult onOilBucketInteract(Player player, InteractionHand hand, ItemStack stack) {
        float fuelPerBucket = DSCGameRules.getFuelPerOilBlock(this.f_19853_);
        if (this.addFuel(fuelPerBucket) == fuelPerBucket) {
            return InteractionResult.PASS;
        }
        ItemStack remain = stack.getCraftingRemainingItem();
        player.m_150109_().m_6836_(player.m_150109_().f_35977_, remain);
        return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
    }

    protected InteractionResult onSprayCanInteract(Player player, InteractionHand hand, ItemStack stack) {
        if (this.f_19853_.f_46443_) {
            UtilClientPacket.openVehicleTextureScreen(this.textureManager);
        }
        return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
    }

    protected InteractionResult onChainInteract(Player player, InteractionHand hand, ItemStack stack) {
        List hooks = this.f_19853_.m_6443_(EntityChainHook.class, this.m_20191_().m_82400_(8.0), hook -> hook.isPlayerConnected(player));
        for (EntityChainHook hook2 : hooks) {
            if (!hook2.addVehicleConnection(player, this)) continue;
            this.chainToHook(hook2);
            stack.m_41774_(1);
            break;
        }
        return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
    }

    protected InteractionResult onDestroyedInteract(Player player, InteractionHand hand) {
        if (this.partsManager.dropPartItem()) {
            this.playTheftSound();
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        if (this.dropIngredient()) {
            this.playTheftSound();
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public boolean dropIngredient() {
        if (this.f_19853_.f_46443_) {
            return false;
        }
        while (this.canDropIngredients()) {
            ++this.ingredientDropIndex;
            Ingredient ing = (Ingredient)((VehicleStats)this.getStats()).getIngredients().get(this.ingredientDropIndex);
            for (int i = 0; i < ing.m_43908_().length; ++i) {
                if (!ing.m_43908_()[i].m_204117_(ModTags.Items.RECOVERABLE)) continue;
                ItemStack stack = ing.m_43908_()[i].m_41777_();
                stack.m_41764_(UtilRandom.weightedRandomInt(stack.m_41613_(), (Double)Config.COMMON.recoverPartWeight.get()));
                UtilEntity.dropItemStack((Entity)this, (ItemStack)stack);
                return true;
            }
        }
        return false;
    }

    public boolean canDropIngredients() {
        return this.ingredientDropIndex < ((VehicleStats)this.getStats()).getIngredients().size() - 1;
    }

    public void playTheftSound() {
        this.m_9236_().m_6269_(null, (Entity)this, SoundEvents.f_12600_, this.m_5720_(), 0.5f, 1.0f);
    }

    public void dropAllItems() {
        this.dropAllParts();
        this.dropAllIngredients();
    }

    public void dropAllParts() {
        if (this.m_9236_().f_46443_) {
            return;
        }
        this.partsManager.dropAllItems();
    }

    public void dropAllIngredients() {
        if (this.m_9236_().f_46443_) {
            return;
        }
        while (this.dropIngredient()) {
        }
    }

    @Nullable
    public Player getChainHolderPlayer() {
        return this.chainHolderPlayer;
    }

    @Nullable
    public EntityChainHook getChainHolderHook() {
        return this.chainHolderHook;
    }

    public void chainToHook(EntityChainHook hook) {
        this.chainHolderPlayer = null;
        this.chainHolderHook = hook;
    }

    public boolean chainToPlayer(Player player) {
        this.chainHolderPlayer = player;
        this.chainHolderHook = null;
        if (!this.f_19853_.f_46443_) {
            UtilServerPacket.sendVehicleAddPlayer(this, player);
        }
        return true;
    }

    public void disconnectChain() {
        this.chainHolderPlayer = null;
        this.chainHolderHook = null;
    }

    public boolean isChainConnectedToPlayer(Player player) {
        return this.getChainHolderPlayer() != null && this.getChainHolderPlayer().equals((Object)player);
    }

    public void playRepairSound() {
        SoundEvent sound = this.isMaxHealth() ? SoundEvents.f_11671_ : SoundEvents.f_11669_;
        this.f_19853_.m_6269_(null, (Entity)this, sound, this.m_5720_(), 0.5f, 1.0f);
    }

    private boolean ridePilotSeat(Entity e, List<EntityRidablePart> seats) {
        for (EntityRidablePart seat : seats) {
            if (!seat.isPilotSeat()) continue;
            return e.m_20329_((Entity)seat);
        }
        return false;
    }

    public boolean ridePassengerSeat(Entity e) {
        List<EntityRidablePart> seats = this.getSeats();
        for (EntityRidablePart seat : seats) {
            if (seat.isPilotSeat() || !e.m_20329_((Entity)seat)) continue;
            return true;
        }
        return false;
    }

    public boolean rideAvailableSeat(Entity e) {
        List<EntityRidablePart> seats = this.getSeats();
        if (this.ridePilotSeat(e, seats)) {
            return true;
        }
        for (EntityRidablePart seat : seats) {
            if (!e.m_20329_((Entity)seat)) continue;
            return true;
        }
        return false;
    }

    public boolean switchSeat(Entity e) {
        int i;
        List<EntityRidablePart> seats = this.getSeats();
        int seatIndex = -1;
        for (i = 0; i < seats.size(); ++i) {
            Player p = seats.get(i).getPlayer();
            if (p == null || !p.equals((Object)e)) continue;
            seatIndex = i;
            break;
        }
        if (seatIndex == -1) {
            return false;
        }
        i = 0;
        int j = seatIndex + 1;
        while (i < seats.size() - 1) {
            if (j >= seats.size()) {
                j = 0;
            }
            if (e.m_20329_((Entity)seats.get(j))) {
                return true;
            }
            ++i;
            ++j;
        }
        return false;
    }

    public boolean hasOpenPassengerSeat() {
        List<EntityRidablePart> seats = this.getSeats();
        for (EntityRidablePart seat : seats) {
            if (seat.getPassenger() != null) continue;
            return true;
        }
        return false;
    }

    public void m_7332_(Entity passenger) {
        if (passenger instanceof EntityPart) {
            EntityPart part = (EntityPart)passenger;
            passenger.m_146884_(this.convertRelPos(part.getRelativePos()));
            return;
        }
    }

    public Vec3 convertRelPos(Vec3 rel_pos) {
        return UtilAngles.rotateVector((Vec3)rel_pos, (Quaternion)this.getQBySide()).m_82549_(this.m_20182_());
    }

    @Nullable
    public Entity m_6688_() {
        for (EntityRidablePart seat : this.getSeats()) {
            if (!seat.isPilotSeat()) continue;
            return seat.getPlayer();
        }
        return null;
    }

    @Nullable
    public Entity getControllingPlayerOrBot() {
        Player playerAlt = null;
        Player alt = null;
        for (EntityRidablePart seat : this.getSeats()) {
            LivingEntity mob;
            Player player;
            if (seat.isPilotSeat() && (player = seat.getPlayer()) != null) {
                return player;
            }
            if (playerAlt == null && (player = seat.getPlayer()) != null) {
                playerAlt = player;
            }
            if (alt != null || !seat.hasAIUsingTurret() || (mob = seat.getPassenger()) == null) continue;
            alt = mob;
        }
        return playerAlt != null ? playerAlt : alt;
    }

    public boolean isPlayerRiding() {
        for (EntityRidablePart seat : this.getSeats()) {
            if (seat.getPlayer() == null) continue;
            return true;
        }
        return false;
    }

    public boolean isBotUsingRadar() {
        for (EntityTurret turret : this.getTurrets()) {
            if (!turret.isBotUsingRadar()) continue;
            return true;
        }
        return false;
    }

    public boolean isPlayerOrBotRiding() {
        for (EntityRidablePart seat : this.getSeats()) {
            if (!seat.isPlayerOrBotRiding()) continue;
            return true;
        }
        return false;
    }

    protected void m_20348_(Entity passenger) {
        super.m_20348_(passenger);
    }

    protected boolean m_7310_(Entity passenger) {
        return passenger instanceof EntityPart;
    }

    protected boolean m_7341_(Entity entityIn) {
        return false;
    }

    @Nullable
    public EntityRidablePart getPassengerSeat(Entity p) {
        for (EntityRidablePart seat : this.getSeats()) {
            if (!p.equals((Object)seat.getPassenger())) continue;
            return seat;
        }
        return null;
    }

    public boolean isVehicleOf(Entity e) {
        if (e == null) {
            return false;
        }
        List list = this.m_20197_();
        if (list.contains(e)) {
            return true;
        }
        for (Entity l : list) {
            EntityRidablePart seat;
            List list2;
            if (!(l instanceof EntityRidablePart) || !(list2 = (seat = (EntityRidablePart)l).m_20197_()).contains(e)) continue;
            return true;
        }
        return false;
    }

    public boolean m_146862_(@NotNull Predicate<Entity> pPredicate) {
        for (EntityRidablePart seat : this.getSeats()) {
            if (!pPredicate.test((Entity)seat.getPassenger())) continue;
            return true;
        }
        return false;
    }

    public boolean canBeRiddenUnderFluidType(FluidType type, Entity rider) {
        return true;
    }

    public double m_6048_() {
        return 0.0;
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_6063_() {
        return true;
    }

    public boolean m_6087_() {
        return this.rootHitboxEntityInteract();
    }

    public boolean m_6097_() {
        return this.rootHitboxEntityInteract();
    }

    public boolean m_6084_() {
        return super.m_6084_();
    }

    public boolean m_5829_() {
        return this.rootHitboxEntityInteract();
    }

    public boolean m_7337_(Entity entity) {
        if (!super.m_7337_(entity)) {
            return false;
        }
        if (entity.m_6094_()) {
            return false;
        }
        return !this.isHitboxParent(entity);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        return this.hurtLogic(source, amount, null);
    }

    public boolean hurtHitbox(DamageSource source, float amount, RotableHitbox hitbox) {
        return this.hurtLogic(source, amount, hitbox, hitbox.getHitboxData().isDamageRoot());
    }

    public boolean hurtLogic(DamageSource source, float amount, @Nullable RotableHitbox hitbox, boolean hurtRoot) {
        if (this.m_6673_(source)) {
            return false;
        }
        if (source.m_19384_()) {
            this.hurtByFireTime = this.f_19797_;
        }
        this.soundManager.onHurt(source, amount);
        this.damage(source, amount, hitbox, hurtRoot);
        if (!this.f_19853_.f_46443_) {
            if (!this.isOperational()) {
                this.partsManager.damageAllParts();
                this.checkExplodeWhenKilled(source);
            } else {
                this.damageParts(source, amount, hitbox, hurtRoot);
            }
        }
        return true;
    }

    public boolean hurtLogic(DamageSource source, float amount, @Nullable RotableHitbox hitbox) {
        return this.hurtLogic(source, amount, hitbox, true);
    }

    protected void damage(DamageSource source, float amount, @Nullable RotableHitbox hitbox) {
        this.damage(source, amount, hitbox, true);
    }

    protected void damage(DamageSource source, float amount, @Nullable RotableHitbox hitbox, boolean hurtRoot) {
        float remainingArmor;
        if (!source.m_19372_() && source.m_7640_() != null && source.m_7640_().m_6095_().m_204039_(ModTags.EntityTypes.PROJECTILE)) {
            amount = this.calcDamageFromBullet(source, amount);
        }
        float armorDamage = this.calcDamageToArmor(amount);
        float healthDamageWithArmorPercent = EntityVehicle.getHealthDamageWithArmorPercent(source);
        float healthDamage = armorDamage * healthDamageWithArmorPercent;
        armorDamage *= 1.0f - healthDamageWithArmorPercent;
        if (hurtRoot) {
            if (this.getArmor() > 0.0f) {
                remainingArmor = Math.min(this.getArmor() - armorDamage, 0.0f);
                this.addArmor(-armorDamage);
                this.addHealth(-healthDamage + remainingArmor);
            } else {
                this.addHealth(-amount);
            }
        }
        if (hitbox != null) {
            if (hitbox.getArmor() > 0.0f) {
                remainingArmor = Math.min(hitbox.getArmor() - armorDamage, 0.0f);
                hitbox.addArmor(-armorDamage);
                hitbox.addHealth(-healthDamage + remainingArmor);
            } else {
                hitbox.addHealth(-amount);
            }
        }
    }

    public static float getHealthDamageWithArmorPercent(DamageSource source) {
        if (source.m_19372_()) {
            return 0.2f;
        }
        if (source.m_19376_()) {
            return 0.8f;
        }
        if (source.m_19384_()) {
            return 0.7f;
        }
        return 0.0f;
    }

    public float calcDamageToArmor(float amount) {
        return Math.max(0.0f, EntityVehicle.reduceByPercent(amount, ((VehicleStats)this.getStats()).armor_damage_absorbtion * DSCGameRules.getVehicleArmorStrengthFactor(this.f_19853_)) - ((VehicleStats)this.getStats()).armor_damage_threshold);
    }

    public float calcDamageToInside(DamageSource source, float amount) {
        return this.calcDamageToArmor(amount) * EntityVehicle.getHealthDamageWithArmorPercent(source);
    }

    public float calcDamageToRider(DamageSource source, float amount) {
        if (this.getArmor() > 0.0f) {
            return this.calcDamageToInside(source, amount);
        }
        return amount;
    }

    private boolean shouldDebug(DamageSource source) {
        return !source.m_19384_();
    }

    protected float calcDamageFromBullet(DamageSource source, float amount) {
        return amount * DSCGameRules.getBulletDamageVehicleFactor(this.f_19853_);
    }

    private static float reduceByPercent(float amount, float percent) {
        return Math.max(amount - amount * percent, 0.0f);
    }

    public boolean m_6673_(DamageSource source) {
        if (this.isTestMode()) {
            return true;
        }
        if (super.m_6673_(source)) {
            return true;
        }
        if (source.m_19384_() && this.f_19797_ - this.hurtByFireTime < 10) {
            return true;
        }
        return this.isVehicleOf(source.m_7639_());
    }

    public void damageParts(DamageSource source, float amount, @Nullable RotableHitbox hitbox, boolean hurtRoot) {
        float healthPercent;
        if (hitbox != null && hitbox.getHitboxData().isDamageParts() && hitbox.isDestroyed()) {
            this.partsManager.damageAllHitboxParts(hitbox.getHitboxName());
            return;
        }
        boolean damageRoot = this.shouldDamageRoot(hitbox, hurtRoot);
        if (damageRoot) {
            healthPercent = this.getHealth() / this.getMaxHealth();
        } else {
            if (!hitbox.getHitboxData().isDamageParts()) {
                return;
            }
            healthPercent = hitbox.getHealth() / hitbox.getMaxHealth();
        }
        if (healthPercent > 0.5f) {
            return;
        }
        float damagePercent = (1.0f - healthPercent * 2.0f) * amount * 0.1f;
        if (this.f_19796_.m_188501_() > damagePercent) {
            return;
        }
        if (damageRoot) {
            this.partsManager.damageRootPart();
        } else {
            this.partsManager.damageHitboxPart(hitbox.getHitboxName());
        }
    }

    private boolean shouldDamageRoot(@Nullable RotableHitbox hitbox, boolean hurtRoot) {
        return hurtRoot && (hitbox == null || hitbox.isDestroyed());
    }

    protected boolean checkExplodeWhenKilled(DamageSource source) {
        if (source.m_19385_().equals(DamageSource.f_19315_.m_19385_())) {
            this.explode(VehicleDamageSource.fall(this));
            return true;
        }
        if (source.m_19385_().equals(DamageSource.f_19316_.m_19385_())) {
            this.explode(VehicleDamageSource.collide(this));
            return true;
        }
        return false;
    }

    public void addForceMomentToClient(Vec3 force, Vec3 moment) {
        if (this.f_19853_.f_46443_) {
            return;
        }
        this.addForceBetweenTicks = this.addForceBetweenTicks.m_82549_(force);
        this.addMomentBetweenTicks = this.addMomentBetweenTicks.m_82549_(moment);
        PacketHandler.INSTANCE.send(PacketDistributor.TRACKING_ENTITY.with(() -> this), (Object)new ToClientAddForceMoment(this, force, moment));
    }

    public void explode(DamageSource source) {
        if (this.f_19853_.f_46443_) {
            return;
        }
        this.f_19853_.m_7703_((Entity)this, source, null, this.m_20185_(), this.m_20186_(), this.m_20189_(), ((VehicleStats)this.getStats()).crashExplosionRadius, true, Explosion.BlockInteraction.BREAK);
        PacketHandler.INSTANCE.send(PacketDistributor.TRACKING_ENTITY.with(() -> this), (Object)new ToClientVehicleExplode(this));
    }

    public boolean m_6128_() {
        return true;
    }

    public void customExplosionHandler(Explosion exp, @Nullable RotableHitbox hitbox) {
        CustomExplosion entity = hitbox == null ? this : hitbox;
        Vec3 s = exp.getPosition();
        Vec3 b = this.getClosest(s, hitbox);
        Vec3 r = b.m_82546_(entity.m_20182_());
        float diameter = exp.f_46017_ * 2.0f;
        double dist_check = Math.sqrt(b.m_82557_(s)) / (double)diameter;
        if (dist_check > 1.0) {
            return;
        }
        Entity exp_entity = exp.m_46077_().m_7640_();
        double dx = b.f_82479_ - s.f_82479_;
        double dy = b.f_82480_ - s.f_82480_;
        double dz = b.f_82481_ - s.f_82481_;
        double d = Math.sqrt(dx * dx + dy * dy + dz * dz);
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            return;
        }
        if (d == 0.0) {
            if (exp_entity != null) {
                Vec3 dir = exp_entity.m_20154_();
                dx = dir.f_82479_;
                dy = dir.f_82480_;
                dz = dir.f_82481_;
            } else {
                dx = 0.0;
                dy = 1.0;
                dz = 0.0;
            }
        } else {
            dx /= d;
            dy /= d;
            dz /= d;
        }
        double seen_percent = Explosion.m_46064_((Vec3)s, (Entity)entity);
        double exp_factor = (1.0 - dist_check) * seen_percent;
        float amount = (int)((exp_factor * exp_factor + exp_factor) * 3.5 * (double)diameter + 1.0);
        amount *= DSCGameRules.getExplodeDamagerVehicleFactor(this.f_19853_);
        if (hitbox != null) {
            this.hurtLogic(exp.m_46077_(), amount, hitbox, false);
        } else {
            this.hurtLogic(exp.m_46077_(), amount, null);
        }
        System.out.println("explode damage = " + amount + " health " + this.getHealth() + " armor " + this.getArmor());
        Vec3 force = new Vec3(dx * exp_factor, dy * exp_factor, dz * exp_factor).m_82490_(100.0);
        Vec3 f = s.equals((Object)b) && exp_entity != null ? exp_entity.m_20184_().m_82541_().m_82490_(exp_factor * 100.0) : s.m_82546_(b).m_82541_().m_82490_(exp_factor * 100.0);
        Vec3 moment = r.m_82537_(f);
        this.addForceMomentToClient(force, moment);
    }

    @Override
    public void customExplosionHandler(Explosion exp) {
        this.customExplosionHandler(exp, null);
    }

    private Vec3 getClosest(Vec3 pos, @Nullable RotableHitbox hitbox) {
        if (hitbox == null) {
            return UtilGeometry.getClosestPointOnAABB((Vec3)pos, (AABB)this.m_20191_());
        }
        Optional<Vec3> clip = hitbox.getHitbox().clip(pos, hitbox.m_20182_());
        return clip.orElseGet(() -> hitbox.m_20182_());
    }

    public final float getMaxSpeed() {
        return ((VehicleStats)this.getStats()).max_speed;
    }

    public final float getCurrentThrottle() {
        return this.throttle;
    }

    public final void setCurrentThrottle(float throttle) {
        if (throttle > 1.0f) {
            throttle = 1.0f;
        } else if (((VehicleStats)this.getStats()).negativeThrottle && throttle < -1.0f) {
            throttle = -1.0f;
        } else if (!((VehicleStats)this.getStats()).negativeThrottle && throttle < 0.0f) {
            throttle = 0.0f;
        }
        this.throttle = throttle;
    }

    public void throttleToZero() {
        float th = this.getCurrentThrottle();
        if (th == 0.0f) {
            return;
        }
        float r = this.getThrottleDecreaseRate();
        if (Math.abs(th -= r * Math.signum(th)) < r) {
            th = 0.0f;
        }
        this.setCurrentThrottle(th);
    }

    public void throttleTowards(float throttle) {
        this.setCurrentThrottle(Mth.m_14121_((float)this.getCurrentThrottle(), (float)throttle, (float)this.getThrottleIncreaseRate()));
    }

    public final float getThrottleIncreaseRate() {
        return ((VehicleStats)this.getStats()).throttleup;
    }

    public final float getThrottleDecreaseRate() {
        return ((VehicleStats)this.getStats()).throttledown;
    }

    public final float getMaxDeltaPitch() {
        return ((VehicleStats)this.getStats()).maxpitch;
    }

    public final float getMaxDeltaYaw() {
        return ((VehicleStats)this.getStats()).maxyaw;
    }

    public final float getMaxDeltaRoll() {
        return ((VehicleStats)this.getStats()).maxroll;
    }

    public final float getPitchTorque() {
        return ((VehicleStats)this.getStats()).torquepitch;
    }

    public final float getYawTorque() {
        return ((VehicleStats)this.getStats()).torqueyaw;
    }

    public final float getRollTorque() {
        return ((VehicleStats)this.getStats()).torqueroll;
    }

    public void increaseThrottle() {
        this.setCurrentThrottle(this.getCurrentThrottle() + this.getThrottleIncreaseRate());
    }

    public void decreaseThrottle() {
        this.setCurrentThrottle(this.getCurrentThrottle() - this.getThrottleDecreaseRate());
    }

    public final Quaternion getQBySide() {
        if (this.f_19853_.f_46443_) {
            return this.getClientQ();
        }
        return this.getQ();
    }

    public final void setQBySide(Quaternion q) {
        if (this.f_19853_.f_46443_) {
            this.setClientQ(q);
        } else {
            this.setQ(q);
        }
    }

    public final Quaternion getQ() {
        return ((Quaternion)this.f_19804_.m_135370_(Q)).m_80161_();
    }

    public final void setQ(Quaternion q) {
        this.f_19804_.m_135381_(Q, (Object)q.m_80161_());
    }

    public final Quaternion getClientQ() {
        return this.clientQ.m_80161_();
    }

    public final void setClientQ(Quaternion q) {
        this.clientQ = q.m_80161_();
    }

    public final Quaternion getPrevQ() {
        return this.prevQ.m_80161_();
    }

    public final void setPrevQ(Quaternion q) {
        this.prevQ = q.m_80161_();
    }

    public Quaternion getClientQ(float partialTicks) {
        return UtilAngles.lerpQ((float)partialTicks, (Quaternion)this.getPrevQ(), (Quaternion)this.getClientQ());
    }

    public final float getBaseCrossSecArea() {
        return ((VehicleStats)this.getStats()).cross_sec_area;
    }

    public final Vec3 getMoment() {
        return this.moment;
    }

    public final Vec3 getForces() {
        return this.forces;
    }

    public final Vec3 getAngularVel() {
        if (this.f_19853_.f_46443_) {
            return this.clientAV;
        }
        return (Vec3)this.f_19804_.m_135370_(AV);
    }

    public final void setMoment(Vec3 m) {
        this.moment = m;
    }

    public final void setForces(Vec3 f) {
        this.forces = f;
    }

    public final void setAngularVel(Vec3 av) {
        if (this.f_19853_.f_46443_) {
            this.clientAV = av;
        } else {
            this.f_19804_.m_135381_(AV, (Object)av);
        }
    }

    public final float getStealth() {
        return ((VehicleStats)this.getStats()).stealth;
    }

    public ItemStack getItem() {
        ItemStack stack = ((VehicleStats)this.getStats()).getItem();
        CompoundTag tag = new CompoundTag();
        this.m_7380_(tag);
        CompoundTag eTag = new CompoundTag();
        eTag.m_128365_("EntityTag", (Tag)tag);
        eTag.m_128359_("preset", this.getStatsId());
        stack.m_41751_(eTag);
        return stack;
    }

    public boolean canBecomeItem() {
        int fresh = this.f_19853_.m_46469_().m_46215_(DSCGameRules.ITEM_COOLDOWN_VEHICLE_FRESH);
        int shoot = this.f_19853_.m_46469_().m_46215_(DSCGameRules.ITEM_COOLDOWN_VEHICLE_SHOOT);
        return this.f_19797_ / 20 > fresh && (this.lastShootTime == -1 || (this.f_19797_ - this.lastShootTime) / 20 > shoot);
    }

    @Nullable
    public Component getCantBecomeItemReason(Player player) {
        boolean canItemWhileMoving = this.m_9236_().m_46469_().m_46207_(DSCGameRules.CAN_ITEM_WHILE_MOVING);
        if (!canItemWhileMoving && !this.m_20096_()) {
            return UtilMCText.translatable((String)"error.dscombat.cant_item_while_flying");
        }
        if (!canItemWhileMoving && this.m_20184_().m_82556_() > 0.01) {
            return UtilMCText.translatable((String)"error.dscombat.cant_item_while_moving");
        }
        EntityRidablePart seat = this.getPassengerSeat((Entity)player);
        if (seat == null) {
            return UtilMCText.translatable((String)"error.dscombat.not_a_passenger");
        }
        if (!seat.isPilotSeat()) {
            return UtilMCText.translatable((String)"error.dscombat.not_a_pilot");
        }
        int fresh = this.f_19853_.m_46469_().m_46215_(DSCGameRules.ITEM_COOLDOWN_VEHICLE_FRESH);
        int fresh_diff = fresh - this.f_19797_ / 20;
        if (fresh_diff > 0) {
            return UtilMCText.translatable((String)"error.dscombat.cant_item_yet_fresh", (Object[])new Object[]{fresh_diff});
        }
        if (this.lastShootTime == -1) {
            return null;
        }
        int shoot = this.f_19853_.m_46469_().m_46215_(DSCGameRules.ITEM_COOLDOWN_VEHICLE_SHOOT);
        int shoot_diff = shoot - (this.f_19797_ - this.lastShootTime) / 20;
        if (shoot_diff > 0) {
            return UtilMCText.translatable((String)"error.dscombat.cant_item_yet_shoot", (Object[])new Object[]{shoot_diff});
        }
        return null;
    }

    public void becomeItem(Vec3 pos) {
        if (this.f_19853_.f_46443_) {
            return;
        }
        ItemStack stack = this.getItem();
        ItemEntity e = new ItemEntity(this.f_19853_, pos.f_82479_, pos.f_82480_, pos.f_82481_, stack);
        this.f_19853_.m_7967_((Entity)e);
        this.m_146870_();
    }

    public void becomeItem() {
        if (this.f_19853_.f_46443_) {
            return;
        }
        this.becomeItem(this.m_20182_());
    }

    public void becomeItem(@NotNull ServerPlayer player) {
        ItemStack item = this.getItem();
        if (player.m_150109_().m_36062_() != -1 && player.m_36356_(item)) {
            this.m_146870_();
            return;
        }
        this.becomeItem(player.m_20182_());
    }

    public ItemStack m_142340_() {
        return this.getItem();
    }

    public boolean m_6783_(double dist) {
        return dist < 102400.0;
    }

    public final float getArmor() {
        return ((Float)this.f_19804_.m_135370_(ARMOR)).floatValue();
    }

    public final void setArmor(float armor) {
        float max = this.getMaxTotalArmor();
        if (armor > max) {
            armor = max;
        } else if (armor < 0.0f) {
            armor = 0.0f;
        }
        this.f_19804_.m_135381_(ARMOR, (Object)Float.valueOf(armor));
    }

    public final void addArmor(float armor) {
        this.setArmor(this.getArmor() + armor);
    }

    public final float getMaxHealth() {
        return ((VehicleStats)this.getStats()).max_health;
    }

    public final void addHealth(float h) {
        this.setHealth(this.getHealth() + h);
    }

    public final void setHealth(float h) {
        float max = this.getMaxHealth();
        if (h > max) {
            h = max;
        } else if (h < 0.0f) {
            h = 0.0f;
        }
        if (h > 0.0f) {
            this.deadTicks = 0;
            this.ingredientDropIndex = -1;
        }
        this.f_19804_.m_135381_(HEALTH, (Object)Float.valueOf(h));
    }

    public final float getHealth() {
        return ((Float)this.f_19804_.m_135370_(HEALTH)).floatValue();
    }

    public boolean isMaxHealth() {
        return this.getHealth() >= this.getMaxHealth();
    }

    public void repairAll() {
        if (this.f_19853_.f_46443_) {
            return;
        }
        this.addHealth(100000.0f);
        this.addArmor(100000.0f);
        this.repairAllHitboxes();
        this.repairAllParts();
        this.playRepairSound();
    }

    public int onRepairTool(float repair) {
        if (this.f_19853_.f_46443_) {
            return 0;
        }
        int damage = 0;
        if (this.getHealth() < this.getMaxHealth()) {
            this.addHealth(repair);
            damage = 1;
        } else if (this.repairOneHitbox(repair)) {
            damage = 1;
        } else if (this.getArmor() < this.getMaxTotalArmor()) {
            this.addArmor(repair);
            damage = 1;
        } else {
            return 0;
        }
        this.playRepairSound();
        return damage;
    }

    public void repairAllParts() {
        if (this.f_19853_.f_46443_) {
            return;
        }
        this.partsManager.repairAllParts();
    }

    public void repairAllHitboxes() {
        if (this.f_19853_.f_46443_) {
            return;
        }
        for (RotableHitbox h : this.hitboxes) {
            h.fullyRepair();
        }
    }

    public boolean repairOneHitbox(float repair) {
        for (RotableHitbox h : this.hitboxes) {
            if (!h.isDamaged()) continue;
            h.repair(repair);
            return true;
        }
        return false;
    }

    @Override
    public float getIRHeat() {
        return this.getIdleHeat() + Math.abs(this.getCurrentThrottle()) * this.getEngineHeat();
    }

    public final float getIdleHeat() {
        return ((VehicleStats)this.getStats()).idleheat;
    }

    public float getEngineHeat() {
        return this.partsManager.getTotalEngineHeat();
    }

    public final float getBaseArmor() {
        return ((VehicleStats)this.getStats()).base_armor;
    }

    public float getMaxTotalArmor() {
        return this.getBaseArmor() + this.partsManager.getTotalExtraArmor();
    }

    public List<Player> getRidingPlayers() {
        ArrayList<Player> players = new ArrayList<Player>();
        for (EntityRidablePart seat : this.getSeats()) {
            Player p = seat.getPlayer();
            if (p == null) continue;
            players.add(p);
        }
        return players;
    }

    public EntityPart getPilotSeat() {
        return this.getPartBySlotId("pilot_seat");
    }

    public List<EntityRidablePart> getSeats() {
        ArrayList<EntityRidablePart> seats = new ArrayList<EntityRidablePart>();
        for (Entity e : this.m_20197_()) {
            if (!(e instanceof EntityRidablePart)) continue;
            EntityRidablePart seat = (EntityRidablePart)e;
            seats.add(seat);
        }
        return seats;
    }

    public List<EntityTurret> getTurrets() {
        ArrayList<EntityTurret> turrets = new ArrayList<EntityTurret>();
        for (Entity e : this.m_20197_()) {
            if (!(e instanceof EntityTurret)) continue;
            EntityTurret turret = (EntityTurret)e;
            turrets.add(turret);
        }
        return turrets;
    }

    public List<EntityPart> getPartEntities() {
        ArrayList<EntityPart> parts = new ArrayList<EntityPart>();
        for (Entity e : this.m_20197_()) {
            if (!(e instanceof EntityPart)) continue;
            EntityPart part = (EntityPart)e;
            parts.add(part);
        }
        return parts;
    }

    public List<EntityGimbal> getGimbals() {
        ArrayList<EntityGimbal> gimbals = new ArrayList<EntityGimbal>();
        for (Entity e : this.m_20197_()) {
            if (!(e instanceof EntityGimbal)) continue;
            EntityGimbal gimbal = (EntityGimbal)e;
            gimbals.add(gimbal);
        }
        return gimbals;
    }

    protected void findGimbalForPilotCamera() {
        List<EntityGimbal> gimbals = this.getGimbals();
        this.pilotGimbal = gimbals.size() == 0 ? null : gimbals.get(0);
    }

    @Nullable
    public EntityGimbal getGimbalForPilotCamera() {
        return this.pilotGimbal;
    }

    @Nullable
    public EntityPart getPartBySlotId(String slotId) {
        for (Entity e : this.m_20197_()) {
            EntityPart part;
            if (!(e instanceof EntityPart) || !(part = (EntityPart)e).getSlotId().equals(slotId)) continue;
            return part;
        }
        return null;
    }

    public void trackedByMissile(Entity missile) {
        if (this.m_217005_()) {
            this.radarSystem.addRWRWarning(missile.m_19879_(), missile.m_20182_(), true, false);
        }
    }

    public void lockedOnto(Entity radar) {
        if (this.m_217005_()) {
            this.radarSystem.addRWRWarning(radar.m_19879_(), radar.m_20182_(), false, UtilVehicleEntity.isOnGroundOrWater(radar));
        }
    }

    public void playIRTone() {
        this.f_19804_.m_135381_(PLAY_IR_TONE, (Object)true);
    }

    public void stopIRTone() {
        this.f_19804_.m_135381_(PLAY_IR_TONE, (Object)false);
    }

    public boolean shouldPlayLowIRTone() {
        return ((WeaponStats)this.weaponSystem.getSelected().getStats()).isIRMissile();
    }

    public boolean shouldPlayHighIRTone() {
        return (Boolean)this.f_19804_.m_135370_(PLAY_IR_TONE);
    }

    public EntityDimensions m_6972_(Pose pose) {
        if (!this.isStatsHolderLoaded()) {
            return super.m_6972_(pose);
        }
        return ((VehicleStats)this.getStats()).dimensions;
    }

    protected AABB m_142242_() {
        if (this.isCustomBoundingBox()) {
            return this.makeCustomBoundingBox();
        }
        return this.m_6972_(this.m_20089_()).m_20393_(this.m_20182_());
    }

    protected AABB makeCustomBoundingBox() {
        double pX = this.m_20185_();
        double pY = this.m_20186_();
        double pZ = this.m_20189_();
        EntityDimensions d = this.m_6972_(this.m_20089_());
        float f = d.f_20377_ / 2.0f;
        float f1 = d.f_20378_ / 2.0f;
        return new AABB(pX - (double)f, pY - (double)f1, pZ - (double)f, pX + (double)f, pY + (double)f1, pZ + (double)f);
    }

    public boolean isCustomBoundingBox() {
        return false;
    }

    protected AABB m_20217_(Pose pose) {
        return this.m_142242_();
    }

    public AABB m_6921_() {
        return this.m_20191_().m_82400_(((VehicleStats)this.getStats()).cameraDistance);
    }

    public double m_20188_() {
        return this.m_20191_().m_82399_().f_82480_;
    }

    public float getMaxFuel() {
        return this.maxFuel;
    }

    public void tickFuel() {
        this.partsManager.tickFuel();
    }

    public float getCurrentFuel() {
        return this.currentFuel;
    }

    public float addFuel(float fuel) {
        return this.partsManager.addFuel(fuel);
    }

    public void refillAll() {
        if (this.f_19853_.f_46443_) {
            return;
        }
        this.refillFuel();
        this.refillAllWeapons();
    }

    public void refillFlares() {
        if (this.f_19853_.f_46443_) {
            return;
        }
        this.partsManager.addFlares(100000);
    }

    public void refillFuel() {
        if (this.f_19853_.f_46443_) {
            return;
        }
        this.addFuel(100000.0f);
        this.f_19853_.m_6269_(null, (Entity)this, SoundEvents.f_11772_, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    public void refillAllWeapons() {
        if (this.f_19853_.f_46443_) {
            return;
        }
        this.refillFlares();
        this.weaponSystem.refillAll();
        for (EntityTurret t : this.getTurrets()) {
            TurretInstance ti = (TurretInstance)t.getPartInstance();
            if (ti == null) continue;
            ti.setWeaponAmmo(100000);
        }
        this.f_19853_.m_6269_(null, (Entity)this, SoundEvents.f_12574_, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    public abstract boolean canToggleLandingGear();

    public boolean isLandingGear() {
        return (Boolean)this.f_19804_.m_135370_(LANDING_GEAR);
    }

    public void setLandingGear(boolean gear) {
        this.f_19804_.m_135381_(LANDING_GEAR, (Object)gear);
    }

    public boolean isTestMode() {
        return (Boolean)this.f_19804_.m_135370_(TEST_MODE);
    }

    public void setTestMode(boolean testMode) {
        this.f_19804_.m_135381_(TEST_MODE, (Object)testMode);
    }

    public boolean toggleLandingGear() {
        if (!this.canToggleLandingGear()) {
            return this.isLandingGear();
        }
        this.setLandingGear(!this.isLandingGear());
        return this.isLandingGear();
    }

    public void tickClientLandingGear() {
        this.landingGearPosOld = this.landingGearPos;
        if (this.isLandingGear()) {
            if (this.landingGearPos > 0.0f) {
                this.landingGearPos -= 0.02f;
            } else if (this.landingGearPos < 0.0f) {
                this.landingGearPos = 0.0f;
            }
        } else if (this.landingGearPos < 1.0f) {
            this.landingGearPos += 0.02f;
        } else if (this.landingGearPos > 1.0f) {
            this.landingGearPos = 1.0f;
        }
    }

    public float getLandingGearPos(float partialTicks) {
        return Mth.m_14179_((float)partialTicks, (float)this.landingGearPosOld, (float)this.landingGearPos);
    }

    public void m_6074_() {
        super.m_6074_();
    }

    public final float getTurnRadius() {
        return ((VehicleStats)this.getStats()).turn_radius;
    }

    public float getStepHeight() {
        return 0.6f;
    }

    public boolean isNoConsume() {
        return (Boolean)this.f_19804_.m_135370_(NO_CONSUME);
    }

    public void setNoConsume(boolean noConsume) {
        this.f_19804_.m_135381_(NO_CONSUME, (Object)noConsume);
    }

    public Vec3 m_7688_(LivingEntity livingEntity) {
        return super.m_7688_(livingEntity);
    }

    public int getFlareNum() {
        return this.numFlares;
    }

    public boolean hasFlares() {
        return this.hasFlares;
    }

    public void debug(String debug) {
        this.debug(debug, true);
    }

    public void debug(String debug, boolean passengerCheck) {
        if (!passengerCheck || passengerCheck && this.m_217005_()) {
            System.out.println(debug);
        }
    }

    protected void debugTick() {
        String side = "SERVER";
        if (this.f_19853_.f_46443_) {
            side = "CLIENT";
        }
        System.out.println(side + " TICK " + this.f_19797_ + " " + this);
    }

    public void toClientPassengers(IPacket packet) {
        if (this.f_19853_.m_5776_()) {
            return;
        }
        for (Player p : this.getRidingPlayers()) {
            if (p.f_19853_.m_5776_()) continue;
            PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)p), (Object)packet);
        }
    }

    public void toTrackers(IPacket packet) {
        if (this.f_19853_.m_5776_()) {
            return;
        }
        PacketHandler.INSTANCE.send(PacketDistributor.TRACKING_ENTITY.with(() -> this), (Object)packet);
    }

    public boolean isWeaponAngledDown() {
        return false;
    }

    public boolean canAngleWeaponDown() {
        return false;
    }

    public boolean canFlapsDown() {
        return false;
    }

    public boolean isFlapsDown() {
        return false;
    }

    public boolean canHover() {
        return false;
    }

    public boolean m_6072_() {
        return this.isOperational();
    }

    public boolean canRiderInteract() {
        return false;
    }

    public boolean canTrample(BlockState state, BlockPos pos, float fallDistance) {
        return true;
    }

    public boolean m_7307_(Entity entity) {
        if (entity == null) {
            return false;
        }
        Entity c = entity.m_6688_();
        if (c != null) {
            return this.m_20031_(c.m_5647_());
        }
        return super.m_7307_(entity);
    }

    public boolean m_20031_(Team team) {
        if (team == null) {
            return false;
        }
        Entity c = this.getControllingPlayerOrBot();
        if (c != null) {
            return team.m_83536_(c.m_5647_());
        }
        return super.m_20031_(team);
    }

    public List<RotableHitbox> getHitboxes() {
        return this.hitboxes;
    }

    @Nullable
    public RotableHitbox getHitboxByName(String name) {
        for (int i = 0; i < this.hitboxes.size(); ++i) {
            if (!this.hitboxes.get(i).getHitboxName().equals(name)) continue;
            return this.hitboxes.get(i);
        }
        return null;
    }

    @Nullable
    public RotableHitbox getHitboxById(int id) {
        for (int i = 0; i < this.hitboxes.size(); ++i) {
            if (this.hitboxes.get(i).m_19879_() != id) continue;
            return this.hitboxes.get(i);
        }
        return null;
    }

    public boolean isHitboxParent(Entity hitbox) {
        for (int i = 0; i < this.hitboxes.size(); ++i) {
            if (!this.hitboxes.get(i).equals(hitbox)) continue;
            return true;
        }
        return false;
    }

    protected void createRotableHitboxes(CompoundTag nbt) {
        CompoundTag hitbox_data = nbt.m_128469_("hitbox_data");
        this.hitboxes.clear();
        this.hitboxes.addAll(((VehicleStats)this.getStats()).createRotableHitboxes(this));
        for (int i = 0; i < this.hitboxes.size(); ++i) {
            RotableHitbox hitbox = this.hitboxes.get(i);
            hitbox.m_146884_(this.m_20182_());
            hitbox.readNbt(hitbox_data);
            hitbox.m_20234_(f_19843_.incrementAndGet());
            this.f_19853_.m_7967_((Entity)hitbox);
        }
    }

    protected void saveRotableHitboxes(CompoundTag nbt) {
        CompoundTag hitbox_data = new CompoundTag();
        for (int i = 0; i < this.hitboxes.size(); ++i) {
            this.hitboxes.get(i).writeNbt(hitbox_data);
        }
        nbt.m_128365_("hitbox_data", (Tag)hitbox_data);
    }

    public void refreshHitboxes() {
        if (this.f_19853_.f_46443_) {
            return;
        }
        CompoundTag nbt = new CompoundTag();
        this.saveRotableHitboxes(nbt);
        for (int i = 0; i < this.hitboxes.size(); ++i) {
            this.hitboxes.get(i).m_146870_();
        }
        this.createRotableHitboxes(nbt);
    }

    public void addRotableHitboxForClient(RotableHitbox hitbox) {
        if (!this.f_19853_.f_46443_) {
            return;
        }
        String name = hitbox.getHitboxName();
        for (int i = 0; i < this.hitboxes.size(); ++i) {
            if (!this.hitboxes.get(i).getHitboxName().equals(name)) continue;
            this.hitboxes.remove(i);
            break;
        }
        this.hitboxes.add(hitbox);
    }

    public void tickHitboxes() {
        if (this.f_19853_.f_46443_ && this.hitboxes.size() < ((VehicleStats)this.getStats()).getHitboxNum() && this.f_19797_ % 200 == 20) {
            LOGGER.debug("Vehicle {} on client side has {}/{} hitboxes. Sending hitbox refresh packet. Attempt {}", new Object[]{this.m_19879_(), this.hitboxes.size(), ((VehicleStats)this.getStats()).getHitboxNum(), ++this.hitboxRefreshAttempts});
            PacketHandler.INSTANCE.sendToServer((Object)new ToServerFixHitboxes(this));
        }
        for (RotableHitbox box : this.hitboxes) {
            box.m_8119_();
        }
        this.collidedEntityIds.clear();
        this.hitboxEntityCoolDown.forEach((id, time) -> {
            if (time > 0) {
                time = time - 1;
                this.hitboxEntityCoolDown.put((Integer)id, (Integer)time);
            }
        });
    }

    public boolean isEntityHitboxCooldown(Entity entity) {
        return this.hitboxEntityCoolDown.containsKey(entity.m_19879_()) && this.hitboxEntityCoolDown.get(entity.m_19879_()) > 0;
    }

    public void addEntityToHitboxCooldown(Entity entity) {
        this.hitboxEntityCoolDown.put(entity.m_19879_(), 4);
    }

    public void addEntityCollideInfo(Entity entity, RotableHitbox hitbox, Vec3 pos) {
        EntityCollideInfo info = this.entityCollideInfo.get(entity.m_19879_());
        if (info == null) {
            info = new EntityCollideInfo();
            this.entityCollideInfo.put(entity.m_19879_(), info);
        }
        info.addPush(hitbox.m_19879_(), this.f_19797_, pos);
    }

    public boolean isStuckInHitbox(Entity entity) {
        EntityCollideInfo info = this.entityCollideInfo.get(entity.m_19879_());
        if (info == null || info.collides.isEmpty()) {
            return false;
        }
        CollideInfo currentPush = info.collides.get(0);
        if (currentPush.time != this.f_19797_) {
            return false;
        }
        int prevTime = this.f_19797_ - 1;
        boolean multiCollideSameTick = false;
        for (int i = 1; i < info.collides.size(); ++i) {
            CollideInfo push = info.collides.get(i);
            if (!multiCollideSameTick) {
                if (push.time == this.f_19797_ && push.hitboxId != currentPush.hitboxId) {
                    multiCollideSameTick = true;
                } else {
                    return false;
                }
            }
            if (!multiCollideSameTick || push.time != prevTime || push.hitboxId != currentPush.hitboxId) continue;
            return UtilGeometry.isEqual((Vec3)push.pos, (Vec3)currentPush.pos, (double)0.001);
        }
        return false;
    }

    public double getMaxHitboxY() {
        double max = this.m_20186_();
        for (int i = 0; i < this.hitboxes.size(); ++i) {
            double y = this.hitboxes.get(i).getMaxY();
            if (!(y > max)) continue;
            max = y;
        }
        return max;
    }

    private void syncHitboxCollidePositions() {
        if (!this.f_19853_.f_46443_ || this.collidedEntityIds.isEmpty() || !this.m_6109_()) {
            return;
        }
        int[] ids = new int[this.collidedEntityIds.size()];
        Vec3[] pos = new Vec3[this.collidedEntityIds.size()];
        int i = 0;
        for (Integer id : this.collidedEntityIds) {
            ids[i] = id;
            Entity entity = this.f_19853_.m_6815_(id.intValue());
            pos[i] = entity != null ? entity.m_20182_() : new Vec3(0.0, -1000.0, 0.0);
            ++i;
        }
        PacketHandler.INSTANCE.sendToServer((Object)new ToServerSyncRotBoxPassengerPos(ids, pos));
    }

    public void addEntityCollidedHitbox(Entity entity) {
        this.collidedEntityIds.add(entity.m_19879_());
    }

    public boolean didEntityAlreadyCollide(Entity entity) {
        return this.collidedEntityIds.contains(entity.m_19879_());
    }

    public boolean areAllHitboxesDead(String ... hitbox_names) {
        return hitbox_names.length > 0 && this.getNumberOfAliveHitboxes(hitbox_names) == 0;
    }

    public int getNumberOfAliveHitboxes(String ... hitbox_names) {
        int num = 0;
        for (String hitboxName : hitbox_names) {
            RotableHitbox box = this.getHitboxByName(hitboxName);
            if (box == null || box.isDestroyed()) continue;
            ++num;
        }
        return num;
    }

    public ObjRadarModel.MastType getMastType() {
        return ((VehicleStats)this.getStats()).mastType;
    }

    public boolean isFuelLeak() {
        return this.partsManager.isFuelTankDamaged();
    }

    public boolean isEngineFire() {
        return this.partsManager.isEngineDamaged();
    }

    public boolean isAllEnginesDamaged() {
        return this.partsManager.isAllEnginesDamaged();
    }

    public boolean showAfterBurnerParticles() {
        return (double)this.getCurrentThrottle() > 0.5;
    }

    public boolean showMoreAfterBurnerParticles() {
        return (double)this.getCurrentThrottle() > 0.85;
    }

    public boolean showContrailParticles() {
        return this.showAfterBurnerParticles() && this.m_20182_().f_82480_ > 128.0;
    }

    public float getMotorRotation(float partialTicks, float spinRate) {
        this.motorRot += spinRate * this.getCurrentThrottle() * partialTicks;
        return this.motorRot;
    }

    public float getWheelRotation(float partialTicks, float spinRate) {
        this.wheelRot += spinRate * this.xzSpeed * (float)this.xzSpeedDir * partialTicks * 0.05f;
        return this.wheelRot;
    }

    public Vec3[] getAfterBurnerSmokePos() {
        return ((VehicleStats)this.getStats()).afterBurnerSmokePos;
    }

    public List<Vec3> getEngineFirePos() {
        Set<String> hitboxNames = this.partsManager.getEngineFireHitboxNames();
        ArrayList<Vec3> pos = new ArrayList<Vec3>();
        for (String name : hitboxNames) {
            if (name.isEmpty()) {
                pos.add(this.m_20182_());
                continue;
            }
            RotableHitbox hitbox = this.getHitboxByName(name);
            if (hitbox == null) continue;
            pos.add(hitbox.m_20182_());
        }
        return pos;
    }

    public boolean liftLost() {
        return false;
    }

    public boolean isStalling() {
        return false;
    }

    public int getStallTicks() {
        return this.stallTicks;
    }

    public boolean isAboutToStall() {
        return false;
    }

    public int getAboutToStallTicks() {
        return this.stallWarnTicks;
    }

    public boolean isBingoFuelWarning() {
        if (this.getMaxFuel() <= 0.0f) {
            return true;
        }
        return (double)(this.getCurrentFuel() / this.getMaxFuel()) < 0.1;
    }

    public int getEngineFireTicks() {
        return this.engineFireTicks;
    }

    public int getFuelLeakTicks() {
        return this.fuelLeakTicks;
    }

    public int getBingoTicks() {
        return this.bingoTicks;
    }

    public void tickWarnings() {
        this.stallTicks = this.isStalling() ? ++this.stallTicks : 0;
        this.stallWarnTicks = this.isAboutToStall() ? ++this.stallWarnTicks : 0;
        this.engineFireTicks = this.isEngineFire() ? ++this.engineFireTicks : 0;
        this.fuelLeakTicks = this.isFuelLeak() ? ++this.fuelLeakTicks : 0;
        this.bingoTicks = this.isBingoFuelWarning() ? ++this.bingoTicks : 0;
        this.hydraulicsFailureTicks = this.isHydraulicsFailure() ? ++this.hydraulicsFailureTicks : 0;
        this.missileTicks = this.isTrackedByMissile() ? ++this.missileTicks : 0;
        this.trackedTicks = this.isTrackedByRadar() ? ++this.trackedTicks : 0;
    }

    public void m_146922_(float yRot) {
        super.m_146922_(yRot);
        Quaternion q = UtilAngles.toQuaternion((double)this.m_146908_(), (double)this.m_146909_(), (double)this.zRot);
        this.setQBySide(q);
    }

    public void m_146926_(float xRot) {
        super.m_146926_(xRot);
        Quaternion q = UtilAngles.toQuaternion((double)this.m_146908_(), (double)this.m_146909_(), (double)this.zRot);
        this.setQBySide(q);
    }

    public void m_19890_(double pX, double pY, double pZ, float pYRot, float pXRot) {
        this.m_20248_(pX, pY, pZ);
    }

    public void setYRotNoQ(float yRot) {
        super.m_146922_(yRot);
    }

    public void setXRotNoQ(float xRot) {
        super.m_146926_(xRot);
    }

    public boolean isAircraft() {
        return ((VehicleStats)this.getStats()).isAircraft();
    }

    public int getGroundTicks() {
        return this.groundTicks;
    }

    public boolean rootHitboxEntityInteract() {
        return !((VehicleStats)this.getStats()).rootHitboxNoCollide;
    }

    public boolean canControlPitch() {
        return !this.areAllHitboxesDead(((VehicleStats)this.getStats()).controllPitchHitboxNames);
    }

    public boolean canControlYaw() {
        return !this.areAllHitboxesDead(((VehicleStats)this.getStats()).controllYawHitboxNames);
    }

    public boolean canControlRoll() {
        return !this.areAllHitboxesDead(((VehicleStats)this.getStats()).controllRollHitboxNames);
    }

    public float getYawRate() {
        return this.m_146908_() - this.f_19859_;
    }

    public float getActualTurnRadius() {
        return this.xzSpeed / (this.getYawRate() * ((float)Math.PI / 180));
    }

    public double getMaxAltitude() {
        return ((VehicleStats)this.getStats()).max_altitude;
    }

    public double getAltitude() {
        return this.currentAltitude;
    }

    public boolean canReload(Player player) {
        if (!this.isPilotOrCopilot((Entity)player)) {
            player.m_5661_((Component)UtilMCText.translatable((String)"error.dscombat.not_a_pilot"), true);
            return false;
        }
        if ((double)this.xzSpeed > 0.1) {
            player.m_5661_((Component)UtilMCText.translatable((String)"error.dscombat.cant_load_while_moving"), true);
            return false;
        }
        if (!this.m_20096_()) {
            player.m_5661_((Component)UtilMCText.translatable((String)"error.dscombat.cant_load_while_flying"), true);
            return false;
        }
        return true;
    }

    public boolean isPilotOrCopilot(Entity entity) {
        EntityRidablePart seat = this.getPassengerSeat(entity);
        if (seat == null) {
            return false;
        }
        return seat.canPassengerShootParentWeapon();
    }

    public boolean jetesinPart(String slotId) {
        return this.partsManager.dropPartInSlot(slotId);
    }

    public void setOwner(Entity owner) {
        this.owner = owner;
        this.owner_uuid = owner.m_20148_();
    }

    @Nullable
    public Entity getOwner() {
        if (this.owner_uuid == null) {
            return null;
        }
        if (this.owner == null || this.m_9236_().m_6815_(this.owner_id) == null) {
            this.owner = this.m_9236_().m_46003_(this.owner_uuid);
            this.owner_id = this.owner != null ? this.owner.m_19879_() : -1;
        }
        return this.owner;
    }

    public PermMode getPermMode() {
        return (PermMode)((Object)this.f_19804_.m_135370_(PERM_MODE));
    }

    public void setPermMode(PermMode mode) {
        this.f_19804_.m_135381_(PERM_MODE, (Object)mode);
    }

    public boolean hasPermission(@Nonnull Entity entity) {
        if (this.m_9236_().m_5776_()) {
            return false;
        }
        if (DSCGameRules.isForcePublicPerm(this.m_9236_())) {
            return true;
        }
        if (this.getPermMode() == PermMode.PUBLIC) {
            return true;
        }
        Entity owner = this.getOwner();
        if (this.getPermMode() == PermMode.ALLIES) {
            if (entity.equals((Object)owner)) {
                return true;
            }
            if (owner != null) {
                return UtilEntity.areEntitiesAllied((Entity)owner, (Entity)entity);
            }
            return false;
        }
        return entity.equals((Object)owner);
    }

    public boolean isOwner(Entity entity) {
        return entity.equals((Object)this.getOwner());
    }

    public boolean hasOwner() {
        return this.owner_uuid != null;
    }

    public boolean isStationaryRadar() {
        return ((VehicleStats)this.getStats()).isStationaryRadar();
    }

    @Nullable
    public String getAssetId() {
        return ((VehicleStats)this.getStats()).getAssetId();
    }

    @NotNull
    public JsonPresetReloadListener<VehicleStats> getPresets() {
        return VehiclePresets.get();
    }

    @Nullable
    public JsonPresetAssetReader<VehicleClientStats> getClientPresets() {
        return VehicleClientPresets.get();
    }

    @NotNull
    public Component m_7755_() {
        Component name = this.m_7770_();
        if (name != null) {
            return name;
        }
        Entity owner = this.getOwner();
        if (owner != null) {
            return UtilMCText.empty().m_7220_(owner.m_5446_()).m_130946_("'s ").m_7220_((Component)((VehicleStats)this.getStats()).getBaseDisplayName());
        }
        return ((VehicleStats)this.getStats()).getBaseDisplayName();
    }

    public int getPullUpWarningTicks() {
        return 0;
    }

    public int getAltitudeWarningTicks() {
        return 0;
    }

    public boolean isHydraulicsFailure() {
        return !this.canControlPitch() || !this.canControlRoll() || !this.canControlYaw();
    }

    public int getHydraulicsFailureTicks() {
        return this.hydraulicsFailureTicks;
    }

    public boolean isTrackedByMissile() {
        return this.radarSystem.isTrackedByMissile();
    }

    public int getMissileTicks() {
        return this.missileTicks;
    }

    public boolean isTrackedByRadar() {
        return this.radarSystem.isTrackedByRadar();
    }

    public int getTrackedTicks() {
        return this.trackedTicks;
    }

    public static enum PermMode {
        PUBLIC,
        ALLIES,
        PRIVATE;


        public String getTranslatable() {
            return "permmode.dscombat." + this.name().toLowerCase();
        }
    }

    private static class EntityCollideInfo {
        private final List<CollideInfo> collides = new ArrayList<CollideInfo>();

        EntityCollideInfo() {
        }

        private void addPush(int hitboxId, int time, Vec3 pos) {
            this.collides.add(0, new CollideInfo(hitboxId, time, pos));
            while (this.collides.size() > 10) {
                this.collides.remove(this.collides.size() - 1);
            }
        }

        public String toString() {
            return this.collides.toString();
        }
    }

    private static class CollideInfo {
        private final int hitboxId;
        private final int time;
        private final Vec3 pos;

        CollideInfo(int hitboxId, int time, Vec3 pos) {
            this.hitboxId = hitboxId;
            this.time = time;
            this.pos = pos;
        }

        public String toString() {
            return this.hitboxId + "," + this.time + "," + this.pos;
        }
    }
}

