/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.entity.weapon;

import com.onewhohears.dscombat.data.weapon.WeaponType;
import com.onewhohears.dscombat.data.weapon.stats.AntiRadarMissileStats;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.dscombat.entity.weapon.EntityMissile;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class AntiRadarMissile<T extends AntiRadarMissileStats>
extends EntityMissile<T> {
    protected List<ARTarget> targets = new ArrayList<ARTarget>();

    public AntiRadarMissile(EntityType<? extends AntiRadarMissile<?>> type, Level level, String defaultWeaponId) {
        super((EntityType<? extends EntityMissile<?>>)type, level, defaultWeaponId);
    }

    @Override
    public WeaponType getWeaponType() {
        return WeaponType.ANTI_RADAR_MISSILE;
    }

    @Override
    public void tickGuide() {
        if (this.f_19797_ % 10 == 0) {
            this.findARTarget();
        }
        if (this.target != null) {
            this.guideToTarget();
        }
    }

    @Override
    public boolean dieIfNoTargetOutsideTickRange() {
        return false;
    }

    protected void findARTarget() {
        this.targets.clear();
        List vehicles = this.f_19853_.m_45976_(EntityVehicle.class, this.getARBoundingBox());
        for (int i = 0; i < vehicles.size(); ++i) {
            EntityVehicle vehicle = (EntityVehicle)vehicles.get(i);
            if (!vehicle.radarSystem.hasRadar() || vehicle.getRadarMode().isOff() || !vehicle.radarSystem.canServerTick() || !this.basicCheck((Entity)vehicle)) continue;
            float distSqr = (float)this.m_20280_((Entity)vehicle);
            this.targets.add(new ARTarget((Entity)vehicle, (float)vehicle.radarSystem.getMaxAirRange() / distSqr));
        }
        if (this.targets.size() == 0) {
            this.target = null;
            this.targetPos = null;
            return;
        }
        ARTarget max = this.targets.get(0);
        for (int i = 1; i < this.targets.size(); ++i) {
            if (!(this.targets.get((int)i).radiation > max.radiation)) continue;
            max = this.targets.get(i);
        }
        this.target = max.entity;
        this.targetPos = max.entity.m_20182_();
    }

    protected boolean basicCheck(Entity ping) {
        if (!ping.m_20096_()) {
            return false;
        }
        if (this.m_7307_(ping)) {
            return false;
        }
        if (!this.checkTargetRange(ping, ((AntiRadarMissileStats)((Object)this.getWeaponStats())).getScanRange())) {
            return false;
        }
        return this.checkCanSee(ping);
    }

    protected AABB getARBoundingBox() {
        double x = this.m_20185_();
        double y = this.m_20186_();
        double z = this.m_20189_();
        double w = ((AntiRadarMissileStats)((Object)this.getWeaponStats())).getScanRange();
        return new AABB(x + w, y + w, z + w, x - w, y - w, z - w);
    }

    public static class ARTarget {
        public final Entity entity;
        public final float radiation;

        public ARTarget(Entity entity, float radiation) {
            this.entity = entity;
            this.radiation = radiation;
        }
    }
}

