/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.entity.weapon;

import com.onewhohears.dscombat.data.weapon.WeaponType;
import com.onewhohears.dscombat.data.weapon.stats.BulletStats;
import com.onewhohears.dscombat.data.weapon.stats.WeaponStats;
import com.onewhohears.dscombat.entity.damagesource.WeaponDamageSource;
import com.onewhohears.dscombat.entity.weapon.EntityWeapon;
import com.onewhohears.onewholibs.util.math.UtilAngles;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class EntityBullet<T extends BulletStats>
extends EntityWeapon<T> {
    public EntityBullet(EntityType<? extends EntityBullet<?>> type, Level level, String defaultWeaponId) {
        super(type, level, defaultWeaponId);
    }

    @Override
    public WeaponType getWeaponType() {
        return WeaponType.BULLET;
    }

    @Override
    public void init() {
        super.init();
        Vec3 dir = UtilAngles.rotationToVector((double)this.m_146908_(), (double)this.m_146909_());
        this.m_20256_(dir.m_82490_(this.getSpeed()));
    }

    @Override
    protected void tickSetMove() {
        this.m_20256_(this.m_20184_().m_82520_(0.0, (double)-0.08f, 0.0));
    }

    protected void checkExplode() {
        if (this.getAge() < this.minExplodeAge()) {
            return;
        }
        if (!this.f_19853_.m_7232_(this.m_146902_().f_45578_, this.m_146902_().f_45579_)) {
            return;
        }
        if (!this.f_19853_.f_46443_ && this.getExplosive()) {
            Explosion.BlockInteraction interact = Explosion.BlockInteraction.NONE;
            if (this.getTerrain()) {
                interact = Explosion.BlockInteraction.BREAK;
            }
            for (int i = 0; i < this.getExplodeNum(); ++i) {
                this.f_19853_.m_7703_((Entity)this, (DamageSource)this.getExplosionDamageSource(), null, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.getRadius(), this.getFire(), interact);
            }
        }
    }

    public int minExplodeAge() {
        return 1;
    }

    @Override
    public float getDamage() {
        return ((BulletStats)((Object)this.getWeaponStats())).getDamage();
    }

    public boolean getExplosive() {
        return ((BulletStats)((Object)this.getWeaponStats())).isExplosive();
    }

    public boolean getTerrain() {
        return ((BulletStats)((Object)this.getWeaponStats())).isDestroyTerrain();
    }

    public boolean getFire() {
        return ((BulletStats)((Object)this.getWeaponStats())).isCausesFire();
    }

    public float getRadius() {
        return ((BulletStats)((Object)this.getWeaponStats())).getExplosionRadius();
    }

    public double getSpeed() {
        return ((BulletStats)((Object)this.getWeaponStats())).getSpeed();
    }

    public int getExplodeNum() {
        return ((BulletStats)((Object)this.getWeaponStats())).getExplodeNum();
    }

    @Override
    public void m_6074_() {
        super.m_6074_();
        this.checkExplode();
    }

    @Override
    protected WeaponDamageSource getImpactDamageSource() {
        return WeaponDamageSource.WeaponDamageType.BULLET.getSource(this.m_37282_(), this);
    }

    @Override
    protected WeaponDamageSource getExplosionDamageSource() {
        return WeaponDamageSource.WeaponDamageType.BULLET_EXPLODE.getSource(this.m_37282_(), this);
    }

    @Override
    public WeaponStats.WeaponClientImpactType getClientImpactType() {
        if (this.getExplosive()) {
            return WeaponStats.WeaponClientImpactType.SMALL_BULLET_EXPLODE;
        }
        return WeaponStats.WeaponClientImpactType.SMALL_BULLET_IMPACT;
    }
}

