/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.entity.weapon;

import com.onewhohears.dscombat.Config;
import com.onewhohears.dscombat.data.weapon.WeaponType;
import com.onewhohears.dscombat.data.weapon.stats.IRMissileStats;
import com.onewhohears.dscombat.entity.IREmitter;
import com.onewhohears.dscombat.entity.damagesource.WeaponDamageSource;
import com.onewhohears.dscombat.entity.weapon.EntityMissile;
import com.onewhohears.dscombat.init.ModTags;
import com.onewhohears.onewholibs.util.UtilEntity;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class IRMissile<T extends IRMissileStats>
extends EntityMissile<T> {
    protected List<IrTarget> targets = new ArrayList<IrTarget>();
    public static final double IR_RANGE = 300.0;

    public IRMissile(EntityType<? extends IRMissile<?>> type, Level level, String defaultWeaponId) {
        super((EntityType<? extends EntityMissile<?>>)type, level, defaultWeaponId);
    }

    @Override
    public WeaponType getWeaponType() {
        return WeaponType.IR_MISSILE;
    }

    @Override
    public void tickGuide() {
        if (this.f_19797_ % 10 == 0) {
            this.findIrTarget();
        }
        if (this.target != null) {
            this.guideToTarget();
        }
    }

    public static void updateIRTargetsList(Entity weapon, List<IrTarget> targets, float flareResistance, float fov) {
        targets.clear();
        List irEmitters = weapon.f_19853_.m_6249_(weapon, IRMissile.getIrBoundingBox(weapon), entity -> entity.m_6095_().m_204039_(ModTags.EntityTypes.IR_EMITTER));
        for (int i = 0; i < irEmitters.size(); ++i) {
            Entity emitter = (Entity)irEmitters.get(i);
            if (emitter.m_20159_() || !IRMissile.basicCheck(weapon, emitter, true, fov)) continue;
            float distSqr = (float)weapon.m_20280_(emitter);
            float heat = IRMissile.getEntityHeat(emitter, flareResistance);
            targets.add(new IrTarget(emitter, heat / distSqr));
        }
    }

    public static float getEntityHeat(Entity entity, float flareResistance) {
        float heat = 0.0f;
        if (entity instanceof IREmitter) {
            IREmitter ir = (IREmitter)entity;
            heat = ir.getIRHeat();
        } else if (entity.m_6095_().m_204039_(ModTags.EntityTypes.IR_EMITTER_EXTREME)) {
            heat = 100.0f;
        } else if (entity.m_6095_().m_204039_(ModTags.EntityTypes.IR_EMITTER_HIGH)) {
            heat = 20.0f;
        } else if (entity.m_6095_().m_204039_(ModTags.EntityTypes.IR_EMITTER_MED)) {
            heat = 5.0f;
        } else if (entity.m_6095_().m_204039_(ModTags.EntityTypes.IR_EMITTER_LOW)) {
            heat = 1.0f;
        }
        if (entity.m_6095_().m_204039_(ModTags.EntityTypes.FLARE)) {
            heat *= flareResistance;
        }
        return heat;
    }

    protected void findIrTarget() {
        IRMissile.updateIRTargetsList((Entity)this, this.targets, ((IRMissileStats)((Object)this.getWeaponStats())).getFlareResistance(), ((IRMissileStats)((Object)this.getWeaponStats())).getFov());
        if (this.targets.size() == 0) {
            this.target = null;
            this.targetPos = null;
            return;
        }
        IrTarget max = this.targets.get(0);
        for (int i = 1; i < this.targets.size(); ++i) {
            if (!(this.targets.get((int)i).heat > max.heat)) continue;
            max = this.targets.get(i);
        }
        this.target = max.entity;
        this.targetPos = max.entity.m_20182_();
    }

    protected static boolean basicCheck(Entity weapon, Entity ping, boolean checkGround, float fov) {
        if (weapon.equals((Object)ping)) {
            return false;
        }
        if (checkGround && ping.m_20096_()) {
            return false;
        }
        if (ping.m_20069_()) {
            return false;
        }
        if (weapon.m_7307_(ping)) {
            return false;
        }
        if (!IRMissile.checkTargetRange(weapon, ping, fov, 300.0)) {
            return false;
        }
        return UtilEntity.canEntitySeeEntity((Entity)weapon, (Entity)ping, (int)((Integer)Config.COMMON.maxBlockCheckDepth.get()), (double)0.0, (double)0.0);
    }

    public static AABB getIrBoundingBox(Entity e) {
        double x = e.m_20185_();
        double y = e.m_20186_();
        double z = e.m_20189_();
        double w = 300.0;
        return new AABB(x + w, y + w, z + w, x - w, y - w, z - w);
    }

    @Override
    protected WeaponDamageSource getImpactDamageSource() {
        return WeaponDamageSource.WeaponDamageType.MISSILE_CONTACT.getSource(this.m_37282_(), this);
    }

    @Override
    protected WeaponDamageSource getExplosionDamageSource() {
        return WeaponDamageSource.WeaponDamageType.IR_MISSILE.getSource(this.m_37282_(), this);
    }

    public static class IrTarget {
        public final Entity entity;
        public final float heat;

        public IrTarget(Entity entity, float heat) {
            this.entity = entity;
            this.heat = heat;
        }
    }
}

