/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.init;

import com.mojang.math.Quaternion;
import com.onewhohears.dscombat.data.parts.PartPresets;
import com.onewhohears.dscombat.data.parts.instance.PartInstance;
import com.onewhohears.dscombat.data.parts.stats.PartStats;
import com.onewhohears.dscombat.data.radar.RadarStats;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class DataSerializers {
    public static final DeferredRegister<EntityDataSerializer<?>> DATA_SERIALIZERS = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.ENTITY_DATA_SERIALIZERS, (String)"dscombat");
    public static final EntityDataSerializer<Quaternion> QUATERNION = new EntityDataSerializer<Quaternion>(){

        public void write(FriendlyByteBuf buffer, Quaternion q) {
            buffer.writeFloat(q.m_80140_());
            buffer.writeFloat(q.m_80150_());
            buffer.writeFloat(q.m_80153_());
            buffer.writeFloat(q.m_80156_());
        }

        public Quaternion read(FriendlyByteBuf buffer) {
            return new Quaternion(buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat());
        }

        public Quaternion copy(Quaternion q) {
            return new Quaternion(q);
        }
    };
    public static final EntityDataSerializer<Vec3> VEC3 = new EntityDataSerializer<Vec3>(){

        public void write(FriendlyByteBuf buffer, Vec3 v) {
            buffer.writeFloat((float)v.f_82479_);
            buffer.writeFloat((float)v.f_82480_);
            buffer.writeFloat((float)v.f_82481_);
        }

        public Vec3 read(FriendlyByteBuf buffer) {
            return new Vec3((double)buffer.readFloat(), (double)buffer.readFloat(), (double)buffer.readFloat());
        }

        public Vec3 copy(Vec3 v) {
            return new Vec3(v.f_82479_, v.f_82480_, v.f_82481_);
        }
    };
    public static final EntityDataSerializer<PartInstance<?>> PART_DATA = new EntityDataSerializer<PartInstance<?>>(){

        public void write(FriendlyByteBuf buffer, PartInstance<?> p) {
            p.writeBuffer(buffer);
        }

        public PartInstance<?> read(FriendlyByteBuf buffer) {
            String presetId = buffer.m_130277_();
            PartStats stats = (PartStats)PartPresets.get().get(presetId);
            PartInstance<?> data = stats.createPartInstance();
            data.readBuffer(buffer);
            return data;
        }

        public PartInstance<?> copy(PartInstance<?> p) {
            return p;
        }
    };
    public static final EntityDataSerializer<RadarStats.RadarMode> RADAR_MODE = DataSerializers.getEnumSerializer(RadarStats.RadarMode.class);
    public static final EntityDataSerializer<EntityVehicle.PermMode> PERM_MODE = DataSerializers.getEnumSerializer(EntityVehicle.PermMode.class);
    public static final RegistryObject<EntityDataSerializer<?>> SERIALIZER_ENTRY_QUATERNION = DATA_SERIALIZERS.register("quaternion", () -> QUATERNION);
    public static final RegistryObject<EntityDataSerializer<?>> SERIALIZER_ENTRY_VEC3 = DATA_SERIALIZERS.register("vec3", () -> VEC3);
    public static final RegistryObject<EntityDataSerializer<?>> SERIALIZER_ENTRY_PARTDATA = DATA_SERIALIZERS.register("partdata", () -> PART_DATA);
    public static final RegistryObject<EntityDataSerializer<?>> SERIALIZER_ENTRY_RADARMODE = DATA_SERIALIZERS.register("radarmode", () -> RADAR_MODE);
    public static final RegistryObject<EntityDataSerializer<?>> SERIALIZER_ENTRY_PERMMODE = DATA_SERIALIZERS.register("permmode", () -> PERM_MODE);

    public static void register(IEventBus eventBus) {
        DATA_SERIALIZERS.register(eventBus);
    }

    private static <E extends Enum<E>> EntityDataSerializer<E> getEnumSerializer(final Class<E> enumClass) {
        return new EntityDataSerializer<E>(){

            public void write(FriendlyByteBuf buffer, E e) {
                buffer.m_130068_(e);
            }

            public E read(FriendlyByteBuf buffer) {
                return buffer.m_130066_(enumClass);
            }

            public E copy(E e) {
                return e;
            }
        };
    }
}

