/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.init;

import com.google.common.collect.ImmutableSet;
import com.onewhohears.dscombat.data.vehicle.presets.BoatPresets;
import com.onewhohears.dscombat.data.vehicle.presets.CarPresets;
import com.onewhohears.dscombat.data.vehicle.presets.NoahChopperPresets;
import com.onewhohears.dscombat.data.vehicle.presets.PlanePresets;
import com.onewhohears.dscombat.data.vehicle.presets.StationaryPresets;
import com.onewhohears.dscombat.data.vehicle.presets.SubPresets;
import com.onewhohears.dscombat.entity.EntityParachute;
import com.onewhohears.dscombat.entity.parts.EntityChainHook;
import com.onewhohears.dscombat.entity.parts.EntityEngine;
import com.onewhohears.dscombat.entity.parts.EntityGimbal;
import com.onewhohears.dscombat.entity.parts.EntityRadar;
import com.onewhohears.dscombat.entity.parts.EntitySeat;
import com.onewhohears.dscombat.entity.parts.EntityTurret;
import com.onewhohears.dscombat.entity.parts.EntityWeaponRack;
import com.onewhohears.dscombat.entity.vehicle.EntityBoat;
import com.onewhohears.dscombat.entity.vehicle.EntityGroundVehicle;
import com.onewhohears.dscombat.entity.vehicle.EntityHelicopter;
import com.onewhohears.dscombat.entity.vehicle.EntityPlane;
import com.onewhohears.dscombat.entity.vehicle.EntityStationaryVehicle;
import com.onewhohears.dscombat.entity.vehicle.EntitySubmarine;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.dscombat.entity.vehicle.RotableHitbox;
import com.onewhohears.dscombat.entity.weapon.AntiRadarMissile;
import com.onewhohears.dscombat.entity.weapon.EntityBomb;
import com.onewhohears.dscombat.entity.weapon.EntityBullet;
import com.onewhohears.dscombat.entity.weapon.EntityBunkerBuster;
import com.onewhohears.dscombat.entity.weapon.EntityDumbTorpedo;
import com.onewhohears.dscombat.entity.weapon.EntityFlare;
import com.onewhohears.dscombat.entity.weapon.EntityMissile;
import com.onewhohears.dscombat.entity.weapon.IRMissile;
import com.onewhohears.dscombat.entity.weapon.PositionMissile;
import com.onewhohears.dscombat.entity.weapon.TorpedoMissile;
import com.onewhohears.dscombat.entity.weapon.TrackEntityMissile;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ModEntities {
    public static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"dscombat");
    public static final RegistryObject<EntityType<EntityPlane>> PLANE = ENTITIES.register("plane", () -> ModEntities.createVehicleType((type, level) -> new EntityPlane((EntityType<? extends EntityPlane>)type, level, PlanePresets.DEFAULT_WOODEN_PLANE.getId())));
    public static final RegistryObject<EntityType<EntityHelicopter>> HELICOPTER = ENTITIES.register("helicopter", () -> ModEntities.createVehicleType((type, level) -> new EntityHelicopter((EntityType<? extends EntityHelicopter>)type, level, NoahChopperPresets.DEFAULT_NOAH_CHOPPER.getId())));
    public static final RegistryObject<EntityType<EntityGroundVehicle>> CAR = ENTITIES.register("car", () -> ModEntities.createVehicleType((type, level) -> new EntityGroundVehicle((EntityType<? extends EntityGroundVehicle>)type, level, CarPresets.DEFAULT_AXCEL_TRUCK.getId())));
    public static final RegistryObject<EntityType<EntityBoat>> BOAT = ENTITIES.register("boat", () -> ModEntities.createVehicleType((type, level) -> new EntityBoat((EntityType<? extends EntityBoat>)type, level, BoatPresets.DEFAULT_NATHAN_BOAT.getId())));
    public static final RegistryObject<EntityType<EntitySubmarine>> SUBMARINE = ENTITIES.register("submarine", () -> ModEntities.createVehicleType((type, level) -> new EntitySubmarine((EntityType<? extends EntitySubmarine>)type, level, SubPresets.DEFAULT_ANDOLF_SUB.getId())));
    public static final RegistryObject<EntityType<EntityStationaryVehicle>> STATIONARY = ENTITIES.register("stationary_vehicle", () -> ModEntities.createVehicleType((type, level) -> new EntityStationaryVehicle((EntityType<? extends EntityVehicle>)type, level, StationaryPresets.EWR4000.getId())));
    public static final RegistryObject<EntityType<RotableHitbox>> ROTABLE_HITBOX = ENTITIES.register("rotable_hitbox", () -> ModEntities.createEntityTypeFar(RotableHitbox::new, EntityDimensions.m_20395_((float)0.1f, (float)0.1f)));
    public static final EntityDimensions SEAT_SIZE = EntityDimensions.m_20395_((float)0.8f, (float)0.8f);
    public static final RegistryObject<EntityType<EntitySeat>> SEAT = ENTITIES.register("seat", () -> ModEntities.createEntityType(EntitySeat::new, SEAT_SIZE));
    public static final RegistryObject<EntityType<EntityTurret>> TURRET = ENTITIES.register("turret", () -> ModEntities.createEntityTypeFar((type, level) -> new EntityTurret(type, level, "aa_turret"), SEAT_SIZE));
    public static final RegistryObject<EntityType<EntityChainHook>> CHAIN_HOOK = ENTITIES.register("chain_hook", () -> ModEntities.createEntityType(EntityChainHook::new, EntityDimensions.m_20395_((float)1.0f, (float)1.0f)));
    public static final EntityDimensions TINY = EntityDimensions.m_20395_((float)0.1f, (float)0.1f);
    public static final RegistryObject<EntityType<EntityGimbal>> GIMBAL_CAMERA = ENTITIES.register("gimbal_camera", () -> ModEntities.createEntityType(EntityGimbal::new, TINY));
    public static final RegistryObject<EntityType<EntityWeaponRack>> EXTERNAL_WEAPON_PART = ENTITIES.register("external_weapon_part", () -> ModEntities.createEntityType(EntityWeaponRack::new, TINY));
    public static final RegistryObject<EntityType<EntityEngine>> EXTERNAL_ENGINE = ENTITIES.register("external_engine", () -> ModEntities.createEntityType(EntityEngine::new, EntityDimensions.m_20395_((float)0.8f, (float)0.8f)));
    public static final RegistryObject<EntityType<EntityRadar>> EXTERNAL_RADAR = ENTITIES.register("external_radar", () -> ModEntities.createEntityType(EntityRadar::new, EntityDimensions.m_20395_((float)1.0f, (float)1.0f)));
    public static final RegistryObject<EntityType<EntityBullet<?>>> BULLET = ENTITIES.register("bullet", () -> ModEntities.createEntityType((type, level) -> new EntityBullet((EntityType<? extends EntityBullet<?>>)((EntityType<EntityBullet<?>>)type), level, "20mm"), EntityDimensions.m_20395_((float)0.15f, (float)0.15f)));
    public static final RegistryObject<EntityType<EntityBomb<?>>> BOMB = ENTITIES.register("bomb", () -> ModEntities.createEntityType((type, level) -> new EntityBomb((EntityType<? extends EntityBomb<?>>)((EntityType<EntityBomb<?>>)type), level, "anm30"), EntityDimensions.m_20395_((float)0.6f, (float)0.6f)));
    public static final RegistryObject<EntityType<EntityBunkerBuster<?>>> BUNKER_BUSTER = ENTITIES.register("bunker_buster", () -> ModEntities.createEntityType((type, level) -> new EntityBunkerBuster((EntityType<? extends EntityBunkerBuster<?>>)((EntityType<EntityBunkerBuster<?>>)type), level, "gruetz_bunker_buster"), EntityDimensions.m_20395_((float)0.8f, (float)0.8f)));
    public static final RegistryObject<EntityType<PositionMissile<?>>> POS_MISSILE = ENTITIES.register("pos_missile", () -> ModEntities.createEntityTypeFar((type, level) -> new PositionMissile((EntityType<? extends PositionMissile<?>>)((EntityType<PositionMissile<?>>)type), level, "agm114k"), EntityDimensions.m_20395_((float)0.5f, (float)0.5f)));
    public static final RegistryObject<EntityType<IRMissile<?>>> IR_MISSILE = ENTITIES.register("ir_missile", () -> ModEntities.createEntityTypeFar((type, level) -> new IRMissile((EntityType<? extends IRMissile<?>>)((EntityType<IRMissile<?>>)type), level, "aim9l"), EntityDimensions.m_20395_((float)0.5f, (float)0.5f)));
    public static final RegistryObject<EntityType<TrackEntityMissile<?>>> TRACK_MISSILE = ENTITIES.register("track_missile", () -> ModEntities.createEntityTypeFar((type, level) -> new TrackEntityMissile((EntityType<? extends TrackEntityMissile<?>>)((EntityType<TrackEntityMissile<?>>)type), level, "aim120b"), EntityDimensions.m_20395_((float)0.5f, (float)0.5f)));
    public static final RegistryObject<EntityType<AntiRadarMissile<?>>> ANTI_RADAR_MISSILE = ENTITIES.register("anti_radar_missile", () -> ModEntities.createEntityTypeFar((type, level) -> new AntiRadarMissile((EntityType<? extends AntiRadarMissile<?>>)((EntityType<AntiRadarMissile<?>>)type), level, "agm88g"), EntityDimensions.m_20395_((float)0.5f, (float)0.5f)));
    public static final RegistryObject<EntityType<TorpedoMissile<?>>> TORPEDO_MISSILE = ENTITIES.register("torpedo_missile", () -> ModEntities.createEntityTypeFar((type, level) -> new TorpedoMissile((EntityType<? extends TorpedoMissile<?>>)((EntityType<TorpedoMissile<?>>)type), level, "mk13"), EntityDimensions.m_20395_((float)0.5f, (float)0.5f)));
    public static final RegistryObject<EntityType<EntityDumbTorpedo<?>>> DUMB_TORPEDO_MISSILE = ENTITIES.register("dumb_torpedo_missile", () -> ModEntities.createEntityTypeFar((type, level) -> new EntityDumbTorpedo((EntityType<? extends EntityMissile<?>>)((EntityType<EntityMissile<?>>)type), level, "type91"), EntityDimensions.m_20395_((float)1.0f, (float)1.0f)));
    public static final RegistryObject<EntityType<EntityFlare>> FLARE = ENTITIES.register("flare", () -> ModEntities.createEntityType(EntityFlare::new, EntityDimensions.m_20395_((float)0.0f, (float)0.0f)));
    public static final RegistryObject<EntityType<EntityParachute>> PARACHUTE = ENTITIES.register("parachute", () -> ModEntities.createEntityType(EntityParachute::new, EntityDimensions.m_20395_((float)0.625f, (float)0.125f)));

    public static void register(IEventBus eventBus) {
        ENTITIES.register(eventBus);
    }

    private static <T extends Entity> EntityType<T> createEntityType(EntityType.EntityFactory<T> factory, EntityDimensions size) {
        return new EntityType(factory, MobCategory.MISC, true, true, false, true, ImmutableSet.of(), size, 5, 3);
    }

    private static <T extends Entity> EntityType<T> createEntityTypeFar(EntityType.EntityFactory<T> factory, EntityDimensions size) {
        return new EntityType(factory, MobCategory.MISC, true, true, false, true, ImmutableSet.of(), size, 16, 3);
    }

    private static <T extends Entity> EntityType<T> createVehicleType(EntityType.EntityFactory<T> factory) {
        return ModEntities.createEntityTypeFar(factory, EntityDimensions.m_20398_((float)4.0f, (float)4.0f));
    }
}

