/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.init;

import com.google.common.collect.ImmutableSet;
import com.onewhohears.dscombat.init.ModBlocks;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Set;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ModVillagers {
    public static final DeferredRegister<PoiType> POI_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.POI_TYPES, (String)"dscombat");
    public static final DeferredRegister<VillagerProfession> VILLAGER_PROS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.VILLAGER_PROFESSIONS, (String)"dscombat");
    public static final RegistryObject<PoiType> WEAPON_POI = POI_TYPES.register("weapon_workbench_poi", () -> new PoiType(ModVillagers.getBlockStates((Block)ModBlocks.WEAPONS_BLOCK.get()), 1, 1));
    public static final RegistryObject<PoiType> AIRCRAFT_POI = POI_TYPES.register("aircraft_workbench_poi", () -> new PoiType(ModVillagers.getBlockStates((Block)ModBlocks.AIRCRAFT_BLOCK.get()), 1, 1));
    public static final RegistryObject<VillagerProfession> WEAPONS_ENGINEER = VILLAGER_PROS.register("weapons_engineer", () -> new VillagerProfession("weapons_engineer", site -> site.m_203373_(WEAPON_POI.getId()), site -> site.m_203373_(WEAPON_POI.getId()), ImmutableSet.of(), ImmutableSet.of(), SoundEvents.f_12575_));
    public static final RegistryObject<VillagerProfession> AIRCRAFT_ENGINEER = VILLAGER_PROS.register("aircraft_engineer", () -> new VillagerProfession("aircraft_engineer", site -> site.m_203373_(AIRCRAFT_POI.getId()), site -> site.m_203373_(AIRCRAFT_POI.getId()), ImmutableSet.of(), ImmutableSet.of(), SoundEvents.f_12575_));

    public static void registerPOIs() {
        try {
            Method registerBlockStates = ObfuscationReflectionHelper.findMethod(PoiType.class, (String)"registerBlockStates", (Class[])new Class[]{PoiType.class});
            registerBlockStates.invoke(null, WEAPON_POI.get());
            registerBlockStates.invoke(null, WEAPON_POI.get());
        }
        catch (IllegalAccessException | InvocationTargetException exception) {
            exception.printStackTrace();
        }
    }

    public static void register(IEventBus eventBus) {
        POI_TYPES.register(eventBus);
        VILLAGER_PROS.register(eventBus);
    }

    private static Set<BlockState> getBlockStates(Block block) {
        return ImmutableSet.copyOf((Collection)block.m_49965_().m_61056_());
    }
}

