/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.util;

import com.mojang.logging.LogUtils;
import com.onewhohears.dscombat.client.sounds.AfterBurnerSoundInstance;
import com.onewhohears.dscombat.client.sounds.DopplerSoundInstance;
import com.onewhohears.dscombat.client.sounds.PlaneMusicSoundInstance;
import com.onewhohears.dscombat.client.sounds.VehicleEngineSoundInstance;
import com.onewhohears.dscombat.client.sounds.VehicleWindSoundInstance;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.dscombat.util.UtilSound;
import java.util.NoSuchElementException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.registries.RegistryObject;
import org.slf4j.Logger;

public class UtilClientSafeSounds {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static long prevQueueTime = 0L;
    private static int waitTime = 0;

    public static void dopplerSound(Entity entity, SoundEvent sound, float initVolume, float initPitch, float velSound, boolean delayed) {
        Minecraft m = Minecraft.m_91087_();
        LocalPlayer p = m.f_91074_;
        if (p == null) {
            return;
        }
        int delay = 0;
        if (delayed) {
            delay = (int)(p.m_20270_(entity) / 10.0f);
        }
        m.m_91106_().m_120369_((SoundInstance)new DopplerSoundInstance(sound, p, entity, initVolume, initPitch, velSound), delay);
    }

    public static void nonPassengerVehicleEngineSound(EntityVehicle plane, SoundEvent sound, double range) {
        Minecraft m = Minecraft.m_91087_();
        LocalPlayer p = m.f_91074_;
        if (p == null) {
            return;
        }
        m.m_91106_().m_120367_((SoundInstance)new VehicleEngineSoundInstance(sound, p, plane, 10.0f, false, range, 0.0f));
    }

    public static void nonPassengerVehicleEngineSound(EntityVehicle plane, SoundEvent sound) {
        Minecraft m = Minecraft.m_91087_();
        LocalPlayer p = m.f_91074_;
        if (p == null) {
            return;
        }
        m.m_91106_().m_120367_((SoundInstance)new VehicleEngineSoundInstance(sound, p, plane, 10.0f, false));
    }

    public static void passengerVehicleEngineSound(EntityVehicle plane, SoundEvent sound) {
        Minecraft m = Minecraft.m_91087_();
        LocalPlayer p = m.f_91074_;
        if (p == null) {
            return;
        }
        m.m_91106_().m_120367_((SoundInstance)new VehicleEngineSoundInstance(sound, p, plane, 10.0f, true));
    }

    public static void nonPassengerAfterBurnerSound(EntityVehicle plane, SoundEvent sound, double range, float minDist) {
        Minecraft m = Minecraft.m_91087_();
        LocalPlayer p = m.f_91074_;
        if (p == null) {
            return;
        }
        m.m_91106_().m_120367_((SoundInstance)new AfterBurnerSoundInstance(sound, p, plane, 10.0f, false, range, minDist));
    }

    public static void passengerAfterBurnerSound(EntityVehicle plane, SoundEvent sound) {
        Minecraft m = Minecraft.m_91087_();
        LocalPlayer p = m.f_91074_;
        if (p == null) {
            return;
        }
        m.m_91106_().m_120367_((SoundInstance)new AfterBurnerSoundInstance(sound, p, plane, 10.0f, true));
    }

    public static void nonPassengerWindSound(EntityVehicle plane, SoundEvent sound, double range, float minDist) {
        Minecraft m = Minecraft.m_91087_();
        LocalPlayer p = m.f_91074_;
        if (p == null) {
            return;
        }
        m.m_91106_().m_120367_((SoundInstance)new VehicleWindSoundInstance(sound, p, plane, 10.0f, false, range, minDist, 0.0));
    }

    public static void passengerWindSound(EntityVehicle plane, SoundEvent sound, double minSpeed) {
        Minecraft m = Minecraft.m_91087_();
        LocalPlayer p = m.f_91074_;
        if (p == null) {
            return;
        }
        m.m_91106_().m_120367_((SoundInstance)new VehicleWindSoundInstance(sound, p, plane, 10.0f, true, minSpeed));
    }

    public static void aircraftRadio(EntityVehicle plane, SoundEvent sound) {
        Minecraft m = Minecraft.m_91087_();
        LocalPlayer p = m.f_91074_;
        if (p == null) {
            return;
        }
        m.m_91106_().m_120367_((SoundInstance)new PlaneMusicSoundInstance(sound, p, plane, 10.0f));
    }

    public static void aircraftRadio(EntityVehicle plane, String sound) {
        try {
            SoundEvent se = UtilSound.getSoundById(sound, SoundEvents.f_12086_);
            UtilClientSafeSounds.aircraftRadio(plane, se);
        }
        catch (NoSuchElementException e) {
            LOGGER.error("ERROR: " + sound + " does not exist!");
        }
    }

    public static void playCockpitSound(RegistryObject<SoundEvent> sound, float pitch, float volume) {
        if (sound == null) {
            return;
        }
        UtilClientSafeSounds.playCockpitSound((SoundEvent)sound.get(), pitch, volume);
    }

    public static void playCockpitSound(SoundEvent sound, float pitch, float volume) {
        if (sound == null) {
            return;
        }
        Minecraft m = Minecraft.m_91087_();
        m.m_91106_().m_120367_((SoundInstance)UtilClientSafeSounds.forCockpit(sound, pitch, volume));
    }

    public static void queueCockpitSound(SoundEvent sound, float pitch, float volume, int length) {
        if (sound == null) {
            return;
        }
        Minecraft m = Minecraft.m_91087_();
        long currentTime = m.f_91073_.m_46467_();
        long timeDiff = currentTime - prevQueueTime;
        if ((waitTime = (int)((long)waitTime - timeDiff)) < 0) {
            waitTime = 0;
        }
        m.m_91106_().m_120369_((SoundInstance)UtilClientSafeSounds.forCockpit(sound, pitch, volume), waitTime);
        waitTime += length;
        prevQueueTime = currentTime;
    }

    public static SimpleSoundInstance forCockpit(SoundEvent sound, float pitch, float volume) {
        if (sound == null) {
            sound = SoundEvents.f_12509_;
        }
        final Minecraft m = Minecraft.m_91087_();
        final int vehicleId = m.f_91074_.m_20201_().m_19879_();
        return new SimpleSoundInstance(sound.m_11660_(), SoundSource.PLAYERS, volume, pitch, SoundInstance.m_235150_(), false, 0, SoundInstance.Attenuation.NONE, 0.0, 0.0, 0.0, true){

            public float m_7769_() {
                if (m.f_91074_ != null && m.f_91074_.m_20159_() && m.f_91074_.m_20201_().m_19879_() == vehicleId) {
                    return super.m_7769_();
                }
                return 0.0f;
            }
        };
    }

    public static boolean isClientRidingVehicle(EntityVehicle vehicle) {
        Minecraft m = Minecraft.m_91087_();
        if (m.f_91074_ == null) {
            return false;
        }
        return m.f_91074_.m_20201_().equals((Object)vehicle);
    }
}

