/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.util;

import com.onewhohears.dscombat.data.vehicle.SeaLevels;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.dscombat.init.ModTags;
import com.onewhohears.dscombat.util.DSCFakePlayer;
import com.onewhohears.onewholibs.util.UtilEntity;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;

public class UtilVehicleEntity {
    public static double getCrossSectionalArea(Entity entity) {
        if (entity instanceof EntityVehicle) {
            EntityVehicle plane = (EntityVehicle)entity;
            return plane.getCrossSectionArea();
        }
        double area = entity.m_20206_() * entity.m_20205_();
        if (entity.m_6095_().m_204039_(ModTags.EntityTypes.VEHICLE)) {
            return Math.max(area, 1.0);
        }
        return area;
    }

    public static boolean isOnGroundOrWater(Entity entity) {
        Player p;
        if (entity.m_6095_().m_204039_(ModTags.EntityTypes.ALWAYS_GROUNDED)) {
            return true;
        }
        if (entity.m_20159_()) {
            Entity rv = entity.m_20201_();
            if (rv.m_6095_().m_204039_(ModTags.EntityTypes.ALWAYS_GROUNDED)) {
                return true;
            }
            if (rv.m_20096_() || UtilEntity.isHeadAboveWater((Entity)rv)) {
                return true;
            }
        }
        if (entity instanceof Player && (p = (Player)entity).m_21255_()) {
            return false;
        }
        if (!entity.m_20069_() && entity.m_20142_() && (double)entity.f_19789_ < 1.15) {
            return true;
        }
        return entity.m_20096_() || UtilEntity.isHeadAboveWater((Entity)entity);
    }

    public static double getAirPressure(Entity entity) {
        return SeaLevels.getAirPressure((ResourceKey<Level>)entity.m_9236_().m_46472_(), entity.m_20186_());
    }

    public static boolean hasPermissionToBreakBlock(BlockPos pos, BlockState state, Level level, @Nullable Entity entity, DSCFakePlayer type) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(level, pos, state, player);
            MinecraftForge.EVENT_BUS.post((Event)event);
            return !event.isCanceled();
        }
        if (entity instanceof Enemy) {
            return level.m_46469_().m_46207_(GameRules.f_46132_);
        }
        if (!level.m_5776_()) {
            BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(level, pos, state, (Player)type.getPlayer((ServerLevel)level));
            MinecraftForge.EVENT_BUS.post((Event)event);
            return !event.isCanceled();
        }
        return false;
    }

    public static boolean vehicleHasPermissionToTrample(BlockPos pos, BlockState state, Level level, @Nullable Entity entity) {
        return UtilVehicleEntity.hasPermissionToBreakBlock(pos, state, level, entity, DSCFakePlayer.VEHICLE_TRAMPLE);
    }

    public static boolean weaponHasPermissionToBreak(BlockPos pos, BlockState state, Level level, @Nullable Entity entity) {
        return UtilVehicleEntity.hasPermissionToBreakBlock(pos, state, level, entity, DSCFakePlayer.WEAPON_BREAK);
    }
}

