/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.util.math;

import com.mojang.math.Quaternion;
import com.onewhohears.dscombat.util.math.DisguisedAABB;
import com.onewhohears.onewholibs.util.math.UtilAngles;
import com.onewhohears.onewholibs.util.math.UtilGeometry;
import java.util.Optional;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class RotableAABB {
    public static final double SUBSIZE = 0.5;
    public static final double SUBSIZEHALF = 0.25;
    public static final double SUB_COL_SKIN = 0.0;
    public static final double COLLIDE_CHECK_SKIN = 0.0;
    public static final double PUSH_OUT_SKIN = 0.0;
    public static final double INSIDE_PUSH_OUT_SKIN = 0.0;
    public static final double IS_INSIDE_CHECK_SKIN = -0.01;
    public static final double PROBLEM_Y_ADJUST = 0.0;
    private Vec3 center;
    private Vec3 extents;
    private double maxRadius;
    private Quaternion rot = Quaternion.f_80118_.m_80161_();
    private Quaternion roti = Quaternion.f_80118_.m_80161_();

    public RotableAABB(AABB bb) {
        this(bb.m_82399_(), RotableAABB.extentsFromBB(bb));
    }

    public RotableAABB() {
        this(Vec3.f_82478_, Vec3.f_82478_);
    }

    public RotableAABB(double width, double height, double length) {
        this(Vec3.f_82478_, new Vec3(width / 2.0, height / 2.0, length / 2.0));
    }

    public RotableAABB(Vec3 center, Vec3 extents) {
        this.center = center;
        this.extents = extents;
        this.maxRadius = extents.m_82553_();
    }

    public RotableAABB copy() {
        return new RotableAABB(this.getCenter(), this.getExtents());
    }

    public void setCenterAndRot(Vec3 center, Quaternion q) {
        this.setCenter(center);
        this.setRot(q);
    }

    public Vec3 collide(Vec3 pos, AABB aabb, Vec3 move) {
        Vec3 clip = this.getPushOutPos(pos, aabb, 0.0);
        if (move.f_82480_ > 0.0 && clip.f_82480_ < this.getCenter().f_82480_ && pos.f_82480_ + move.f_82480_ > clip.f_82480_) {
            move = new Vec3(move.f_82479_, clip.f_82480_ - pos.f_82480_, move.f_82481_);
        } else if (move.f_82480_ < 0.0 && clip.f_82480_ > this.getCenter().f_82480_ && pos.f_82480_ + move.f_82480_ < clip.f_82480_) {
            move = new Vec3(move.f_82479_, clip.f_82480_ - pos.f_82480_, move.f_82481_);
        }
        if (move.f_82480_ > -0.08 && move.f_82480_ < 0.0) {
            move = move.m_82542_(1.0, 0.0, 1.0);
        }
        return move;
    }

    public boolean contains(AABB aabb) {
        return this.contains(UtilGeometry.getClosestPointOnAABB((Vec3)this.center, (AABB)aabb));
    }

    public boolean contains(Vec3 pos) {
        return this.containsRelRot(this.toRelRotPos(pos));
    }

    public boolean containsRelRot(Vec3 relRotPos) {
        boolean insideX = relRotPos.m_7096_() <= this.extents.m_7096_() && relRotPos.m_7096_() >= -this.extents.m_7096_();
        boolean insideY = relRotPos.m_7098_() <= this.extents.m_7098_() && relRotPos.m_7098_() >= -this.extents.m_7098_();
        boolean insideZ = relRotPos.m_7094_() <= this.extents.m_7094_() && relRotPos.m_7094_() >= -this.extents.m_7094_();
        return insideX && insideY && insideZ;
    }

    public boolean isInside(AABB aabb, double skin) {
        return this.isInside(UtilGeometry.getClosestPointOnAABB((Vec3)this.center, (AABB)aabb), skin);
    }

    public boolean isInside(AABB aabb) {
        boolean inside = this.isInside(aabb, 0.0);
        return inside;
    }

    public boolean isInside(Vec3 pos, double skin) {
        return this.isInsideRelPos(this.toRelRotPos(pos), skin);
    }

    public boolean isInside(Vec3 pos) {
        return this.isInside(pos, 0.0);
    }

    public boolean isInsideRelPos(Vec3 relRotPos, double skin) {
        boolean insideX = relRotPos.m_7096_() < this.extents.m_7096_() + skin && relRotPos.m_7096_() > -this.extents.m_7096_() - skin;
        boolean insideY = relRotPos.m_7098_() < this.extents.m_7098_() + skin && relRotPos.m_7098_() > -this.extents.m_7098_() - skin;
        boolean insideZ = relRotPos.m_7094_() < this.extents.m_7094_() + skin && relRotPos.m_7094_() > -this.extents.m_7094_() - skin;
        return insideX && insideY && insideZ;
    }

    public boolean isInsideRelPos(Vec3 relRotPos) {
        return this.isInsideRelPos(relRotPos, 0.0);
    }

    public Vec3 toRelRotPos(Vec3 pos) {
        return UtilAngles.rotateVector((Vec3)pos.m_82546_(this.center), (Quaternion)this.roti);
    }

    public Vec3 toWorldPos(Vec3 relRotPos) {
        return UtilAngles.rotateVector((Vec3)relRotPos, (Quaternion)this.rot).m_82549_(this.center);
    }

    public Vec3 toWorldVel(Vec3 relRotVel) {
        return UtilAngles.rotateVector((Vec3)relRotVel, (Quaternion)this.rot);
    }

    public Optional<Vec3> clip(Vec3 from, Vec3 to) {
        return this.clip(from, to, true);
    }

    public Optional<Vec3> clip(Vec3 from, Vec3 to, boolean push) {
        Double clipZ;
        Double clipX;
        Vec3 fromRelRot = this.toRelRotPos(from);
        if (this.isInsideRelPos(fromRelRot)) {
            if (push) {
                return Optional.of(this.getPushOutPos(from, 0.0));
            }
            return Optional.of(from);
        }
        Vec3 toRelRot = this.toRelRotPos(to);
        Vec3 diff = toRelRot.m_82546_(fromRelRot);
        double tMin = Double.MAX_VALUE;
        Vec3 clipRelRot = Vec3.f_82478_;
        Double clipY = this.clipAxis(fromRelRot.f_82480_, toRelRot.f_82480_, this.extents.f_82480_);
        if (clipY != null) {
            double t = (clipY - fromRelRot.f_82480_) / diff.f_82480_;
            clipRelRot = fromRelRot.m_82549_(diff.m_82490_(t));
            clipRelRot = new Vec3(clipRelRot.f_82479_, clipY.doubleValue(), clipRelRot.f_82481_);
            if (t < tMin && this.containsRelRot(clipRelRot)) {
                tMin = t;
            }
        }
        if ((clipX = this.clipAxis(fromRelRot.f_82479_, toRelRot.f_82479_, this.extents.f_82479_)) != null) {
            double t = (clipX - fromRelRot.f_82479_) / diff.f_82479_;
            clipRelRot = fromRelRot.m_82549_(diff.m_82490_(t));
            clipRelRot = new Vec3(clipX.doubleValue(), clipRelRot.f_82480_, clipRelRot.f_82481_);
            if (t < tMin && this.containsRelRot(clipRelRot)) {
                tMin = t;
            }
        }
        if ((clipZ = this.clipAxis(fromRelRot.f_82481_, toRelRot.f_82481_, this.extents.f_82481_)) != null) {
            double t = (clipZ - fromRelRot.f_82481_) / diff.f_82481_;
            clipRelRot = fromRelRot.m_82549_(diff.m_82490_(t));
            clipRelRot = new Vec3(clipRelRot.f_82479_, clipRelRot.f_82480_, clipZ.doubleValue());
            if (t < tMin && this.containsRelRot(clipRelRot)) {
                tMin = t;
            }
        }
        if (tMin == Double.MAX_VALUE) {
            return Optional.empty();
        }
        Vec3 clip = this.toWorldPos(clipRelRot);
        return Optional.of(clip);
    }

    private Double clipAxis(double from, double to, double ext) {
        double diff = to - from;
        if (diff > 0.0 && from <= -ext && from + diff >= -ext) {
            return -ext;
        }
        if (diff < 0.0 && from >= ext && from + diff <= ext) {
            return ext;
        }
        return null;
    }

    public Vec3 getPushOutPos(Vec3 pos, AABB aabb, double skin) {
        Vec3[] relRotCorners = new Vec3[8];
        relRotCorners[0] = this.toRelRotPos(new Vec3(aabb.f_82288_, aabb.f_82289_, aabb.f_82290_));
        Vec3 zaxis = UtilAngles.getRollAxis((Quaternion)this.roti);
        Vec3 yaxis = UtilAngles.getYawAxis((Quaternion)this.roti);
        Vec3 xaxis = UtilAngles.getPitchAxis((Quaternion)this.roti);
        relRotCorners[1] = relRotCorners[0].m_82549_(zaxis.m_82490_(aabb.m_82385_()));
        relRotCorners[2] = relRotCorners[0].m_82549_(yaxis.m_82490_(aabb.m_82376_()));
        relRotCorners[3] = relRotCorners[0].m_82549_(zaxis.m_82490_(aabb.m_82385_())).m_82549_(yaxis.m_82490_(aabb.m_82376_()));
        relRotCorners[4] = relRotCorners[0].m_82549_(xaxis.m_82490_(aabb.m_82362_()));
        relRotCorners[5] = relRotCorners[0].m_82549_(zaxis.m_82490_(aabb.m_82385_())).m_82549_(xaxis.m_82490_(aabb.m_82362_()));
        relRotCorners[6] = relRotCorners[0].m_82549_(yaxis.m_82490_(aabb.m_82376_())).m_82549_(xaxis.m_82490_(aabb.m_82362_()));
        relRotCorners[7] = relRotCorners[0].m_82549_(zaxis.m_82490_(aabb.m_82385_())).m_82549_(yaxis.m_82490_(aabb.m_82376_())).m_82549_(xaxis.m_82490_(aabb.m_82362_()));
        int[] absIndex = new int[]{UtilGeometry.getMaxYIndex((Vec3[])relRotCorners), UtilGeometry.getMinYIndex((Vec3[])relRotCorners), UtilGeometry.getMaxXIndex((Vec3[])relRotCorners), UtilGeometry.getMinXIndex((Vec3[])relRotCorners), UtilGeometry.getMaxZIndex((Vec3[])relRotCorners), UtilGeometry.getMinZIndex((Vec3[])relRotCorners)};
        double[] dists = new double[]{Math.abs(this.extents.f_82480_ - relRotCorners[absIndex[0]].f_82480_), Math.abs(-this.extents.f_82480_ - relRotCorners[absIndex[0]].f_82480_), Math.abs(this.extents.f_82480_ - relRotCorners[absIndex[1]].f_82480_), Math.abs(-this.extents.f_82480_ - relRotCorners[absIndex[1]].f_82480_), Math.abs(this.extents.f_82479_ - relRotCorners[absIndex[2]].f_82479_), Math.abs(-this.extents.f_82479_ - relRotCorners[absIndex[2]].f_82479_), Math.abs(this.extents.f_82479_ - relRotCorners[absIndex[3]].f_82479_), Math.abs(-this.extents.f_82479_ - relRotCorners[absIndex[3]].f_82479_), Math.abs(this.extents.f_82481_ - relRotCorners[absIndex[4]].f_82481_), Math.abs(-this.extents.f_82481_ - relRotCorners[absIndex[4]].f_82481_), Math.abs(this.extents.f_82481_ - relRotCorners[absIndex[5]].f_82481_), Math.abs(-this.extents.f_82481_ - relRotCorners[absIndex[5]].f_82481_)};
        int minIndex = UtilGeometry.getMinIndex((double[])dists);
        Vec3 relRotPos = this.toRelRotPos(pos);
        Vec3 relRotPush = Vec3.f_82478_;
        int extDir = minIndex % 2 == 0 ? 1 : -1;
        int absIndexIndex = minIndex / 2;
        if (minIndex % 4 == 0) {
            ++absIndexIndex;
        } else if (minIndex % 4 == 3) {
            --absIndexIndex;
        }
        Vec3 relRotCorner = relRotCorners[absIndex[absIndexIndex]];
        if (minIndex >= 0 && minIndex <= 3) {
            ext = (this.extents.f_82480_ + skin) * (double)extDir;
            relRotPush = new Vec3(relRotPos.f_82479_, ext += relRotPos.f_82480_ - relRotCorner.f_82480_, relRotPos.f_82481_);
        } else if (minIndex >= 4 && minIndex <= 7) {
            ext = (this.extents.f_82479_ + skin) * (double)extDir;
            relRotPush = new Vec3(ext += relRotPos.f_82479_ - relRotCorner.f_82479_, relRotPos.f_82480_, relRotPos.f_82481_);
        } else if (minIndex >= 8 && minIndex <= 11) {
            ext = (this.extents.f_82481_ + skin) * (double)extDir;
            relRotPush = new Vec3(relRotPos.f_82479_, relRotPos.f_82480_, ext += relRotPos.f_82481_ - relRotCorner.f_82481_);
        }
        Vec3 push = this.toWorldPos(relRotPush);
        return push;
    }

    public Vec3 getPushOutPosOld(Vec3 pos, AABB aabb, double skin) {
        Vec3 close = UtilGeometry.getClosestPointOnAABB((Vec3)this.center, (AABB)aabb);
        Vec3 aabbDiff = pos.m_82546_(close);
        Vec3 push = this.getPushOutPos(close, skin).m_82549_(aabbDiff);
        return push;
    }

    public Vec3 getPushOutPos(Vec3 pos, double skin) {
        Vec3 test;
        double distSqr;
        Double pushZ;
        Vec3 test2;
        double distSqr2;
        Double pushX;
        Vec3 test3;
        double distSqr3;
        Vec3 posRelRot = this.toRelRotPos(pos);
        if (!this.isInsideRelPos(posRelRot)) {
            return pos;
        }
        double distSqrMin = Double.MAX_VALUE;
        Vec3 pushRelRot = Vec3.f_82478_;
        Double pushY = this.pushAxis(posRelRot.f_82480_, this.extents.f_82480_, skin);
        if (pushY != null && (distSqr3 = posRelRot.m_82557_(test3 = new Vec3(posRelRot.f_82479_, pushY.doubleValue(), posRelRot.f_82481_))) < distSqrMin) {
            distSqrMin = distSqr3;
            pushRelRot = test3;
        }
        if ((pushX = this.pushAxis(posRelRot.f_82479_, this.extents.f_82479_, skin)) != null && (distSqr2 = posRelRot.m_82557_(test2 = new Vec3(pushX.doubleValue(), posRelRot.f_82480_, posRelRot.f_82481_))) < distSqrMin) {
            distSqrMin = distSqr2;
            pushRelRot = test2;
        }
        if ((pushZ = this.pushAxis(posRelRot.f_82481_, this.extents.f_82481_, skin)) != null && (distSqr = posRelRot.m_82557_(test = new Vec3(posRelRot.f_82479_, posRelRot.f_82480_, pushZ.doubleValue()))) < distSqrMin) {
            distSqrMin = distSqr;
            pushRelRot = test;
        }
        if (distSqrMin == Double.MAX_VALUE) {
            return pos;
        }
        Vec3 push = this.toWorldPos(pushRelRot);
        return push;
    }

    private Double pushAxis(double pos, double ext, double skin) {
        if (pos < 0.0) {
            return -ext - skin;
        }
        return ext + skin;
    }

    public static Vec3 extentsFromBB(AABB bb) {
        return new Vec3(bb.m_82362_() / 2.0, bb.m_82376_() / 2.0, bb.m_82385_() / 2.0);
    }

    public Vec3 getCenter() {
        return this.center;
    }

    public void setCenter(Vec3 center) {
        this.center = center;
    }

    public Vec3 getExtents() {
        return this.extents;
    }

    public void setExtents(Vec3 extents) {
        this.extents = extents;
    }

    public Quaternion getRot() {
        return this.rot.m_80161_();
    }

    public Quaternion getIRot() {
        return this.roti.m_80161_();
    }

    public void setRot(Quaternion rot) {
        this.rot = rot;
        this.roti = rot.m_80161_();
        this.roti.m_80157_();
    }

    public double getMaxRadius() {
        return this.maxRadius;
    }

    public EntityDimensions getMaxDimensions() {
        float max = (float)this.getMaxRadius();
        return EntityDimensions.m_20395_((float)(max * 2.0f), (float)(max * 2.0f));
    }

    public DisguisedAABB getDisguisedAABB(Vec3 pos) {
        return new DisguisedAABB(this, pos, 0.5);
    }

    public AABB makeMaxDimBox() {
        EntityDimensions d = this.getMaxDimensions();
        double pX = this.center.f_82479_;
        double pY = this.center.f_82480_;
        double pZ = this.center.f_82481_;
        double f = d.f_20377_ / 2.0f;
        double f1 = d.f_20378_ / 2.0f;
        return new AABB(pX - f, pY - f1, pZ - f, pX + f, pY + f1, pZ + f);
    }

    public String toString() {
        return "RotableAABB:" + this.getCenter() + ":" + this.getExtents();
    }

    public double getMaxY() {
        return UtilAngles.rotateVector((Vec3)this.getExtents(), (Quaternion)this.rot).f_82480_ + this.getCenter().f_82480_;
    }
}

