/*
 * Decompiled with CFR 0.152.
 */
package com.spyxar.tiptapshow.components;

import com.spyxar.tiptapshow.ClickCounter;
import com.spyxar.tiptapshow.TipTapShowMod;
import com.spyxar.tiptapshow.config.TipTapShowConfig;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_332;

public class RenderableButton {
    private final int x;
    public int y;
    private final int width;
    private final int height;
    private final class_304 key;
    private final String displayText;
    private static final Map<String, Integer> cachedRainbowColors = new HashMap<String, Integer>();
    private static long lastUsedRainbowMillis = 0L;
    private static int rainbowFramesSkipped = 0;

    public RenderableButton(int x, int y, int width, int height, class_304 key) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.key = key;
        this.displayText = RenderableButton.getDisplayText(key);
    }

    public void render(class_332 context) {
        int textColor;
        int fillColor;
        boolean isPressed = this.key.method_1434();
        int n = fillColor = isPressed ? TipTapShowMod.config.pressedBackgroundColor : TipTapShowMod.config.backgroundColor;
        if (TipTapShowMod.config.rainbowMode) {
            this.maybeClearRainbowCache();
            textColor = this.getRainbowColor(this.x);
        } else {
            textColor = isPressed ? TipTapShowMod.config.pressedKeyColor : TipTapShowMod.config.keyColor;
        }
        context.method_25294(this.x, this.y, this.x + this.width, this.y + this.height, fillColor);
        if (this.displayText.equals("{jumpKey}")) {
            RenderableButton.renderJump(context, this, textColor);
            return;
        }
        class_310 client = class_310.method_1551();
        if (this.displayText.contains("\n")) {
            String[] splitText = this.displayText.split("\n", 2);
            String firstLine = splitText[0];
            String secondLine = splitText[1];
            float firstLineX = (float)this.width / 2.0f + (float)this.x - (float)client.field_1772.method_1727(firstLine) / 2.0f;
            float secondLineX = (float)this.width / 2.0f + (float)this.x - (float)client.field_1772.method_1727(secondLine) / 2.0f;
            float f = (float)this.height / 2.0f + (float)this.y;
            Objects.requireNonNull(client.field_1772);
            float lineY = f - (float)(9 * 2) / 2.0f;
            RenderableButton.renderText(context, firstLine, firstLineX, lineY, textColor);
            Objects.requireNonNull(client.field_1772);
            RenderableButton.renderText(context, secondLine, secondLineX, lineY + 9.0f, textColor);
            return;
        }
        int letterWidth = client.field_1772.method_1727(this.displayText);
        float lineX = (float)this.width / 2.0f + (float)this.x - (float)letterWidth / 2.0f;
        float f = (float)this.height / 2.0f + (float)this.y;
        Objects.requireNonNull(client.field_1772);
        float lineY = f - 9.0f / 2.0f;
        RenderableButton.renderText(context, this.displayText, lineX, lineY, textColor);
    }

    private static void renderJump(class_332 context, RenderableButton button, int textColor) {
        int letterWidth = (int)((double)button.width * 0.6);
        float lineX = (float)button.width / 2.0f + (float)button.x;
        float lineY = (float)button.height / 2.0f + (float)button.y;
        context.method_25294(Math.round(lineX - (float)letterWidth / 2.0f), (int)lineY - 1, Math.round(lineX + (float)letterWidth / 2.0f), (int)lineY, textColor);
    }

    private static void renderText(class_332 context, String text, float lineX, float lineY, int textColor) {
        if (TipTapShowMod.config.keyShadow) {
            context.method_27535(class_310.method_1551().field_1772, class_2561.method_30163((String)text), (int)lineX, (int)lineY, textColor);
            return;
        }
        context.method_51433(class_310.method_1551().field_1772, text, (int)lineX, (int)lineY, textColor, false);
    }

    private static String getDisplayText(class_304 key) {
        if (key.method_1435(class_310.method_1551().field_1690.field_1886)) {
            return RenderableButton.getDisplayTextForUseOrAttackKey(key, ClickCounter.getLeftCps(), "text.tiptapshow.lmb");
        }
        if (key.method_1435(class_310.method_1551().field_1690.field_1904)) {
            return RenderableButton.getDisplayTextForUseOrAttackKey(key, ClickCounter.getRightCps(), "text.tiptapshow.rmb");
        }
        if (key.method_1435(class_310.method_1551().field_1690.field_1903)) {
            return "{jumpKey}";
        }
        return key.method_16007().getString().toUpperCase();
    }

    private static String getDisplayTextForUseOrAttackKey(class_304 key, int clicks, String label) {
        String lmbString = class_2561.method_43471((String)"text.tiptapshow.lmb").getString();
        String rmbString = class_2561.method_43471((String)"text.tiptapshow.rmb").getString();
        if (!RenderableButton.shouldRenderCps(clicks)) {
            if (key.method_1427()) {
                return class_2561.method_43471((String)label).getString();
            }
            if (key.method_1433(0)) {
                return lmbString;
            }
            if (key.method_1433(1)) {
                return rmbString;
            }
            return key.method_16007().getString().toUpperCase();
        }
        if (key.method_1427()) {
            return class_2561.method_43471((String)label).getString() + "\n" + clicks + " " + class_2561.method_43471((String)"text.tiptapshow.cps").getString();
        }
        if (key.method_1433(0)) {
            return lmbString + "\n" + clicks + " " + class_2561.method_43471((String)"text.tiptapshow.cps").getString();
        }
        if (key.method_1433(1)) {
            return rmbString + "\n" + clicks + " " + class_2561.method_43471((String)"text.tiptapshow.cps").getString();
        }
        return key.method_16007().getString().toUpperCase() + "\n" + clicks + " " + class_2561.method_43471((String)"text.tiptapshow.cps").getString();
    }

    private static boolean shouldRenderCps(int clicks) {
        return TipTapShowMod.config.cpsType == TipTapShowConfig.CpsType.ALWAYS || TipTapShowMod.config.cpsType == TipTapShowConfig.CpsType.ON_CLICK && clicks != 0;
    }

    public int getRainbowColor(double offset) {
        if (cachedRainbowColors.containsKey(this.displayText)) {
            return cachedRainbowColors.get(this.displayText);
        }
        float hue = (float)((double)(lastUsedRainbowMillis % 1000L) / 1000.0) + (float)((double)this.width + offset / (double)this.width * ((double)TipTapShowMod.config.rainbowOffset / 10.0));
        int newColor = Color.HSBtoRGB(hue, 1.0f, 1.0f);
        cachedRainbowColors.put(this.displayText, newColor);
        return newColor;
    }

    public void maybeClearRainbowCache() {
        int framesToSkip = (6 - TipTapShowMod.config.rainbowSpeed) * 7;
        if (framesToSkip <= rainbowFramesSkipped) {
            cachedRainbowColors.clear();
            lastUsedRainbowMillis += (long)(1000 / Math.max(class_310.method_1551().method_47599(), 60));
            rainbowFramesSkipped = 0;
        }
        ++rainbowFramesSkipped;
    }
}

