/*
 * Decompiled with CFR 0.152.
 */
package com.spyxar.tiptapshow.config;

import com.moandjiezana.toml.Toml;
import com.moandjiezana.toml.TomlWriter;
import com.spyxar.tiptapshow.TipTapShowMod;
import java.io.File;
import java.io.IOException;
import net.fabricmc.loader.api.FabricLoader;

public final class TipTapShowConfig {
    private transient File file;
    public boolean isEnabled = true;
    public int backgroundColor = 926762943;
    public int pressedBackgroundColor = 926762823;
    public int keyColor = -1;
    public int pressedKeyColor = -16777216;
    public boolean rainbowMode = false;
    public int rainbowOffset = 9;
    public int rainbowSpeed = 4;
    public boolean roundedBackground = false;
    public boolean renderInGui = true;
    public boolean renderWhenPlayerListOpen = true;
    public boolean keyShadow = false;
    public CpsType cpsType = CpsType.ALWAYS;
    public double displayFactor = 1.0;
    public int horizontalSlider = 20;
    public int verticalSlider = 20;
    public boolean showMovement = true;
    public boolean showJump = true;
    public boolean showClick = true;

    private TipTapShowConfig() {
    }

    public static TipTapShowConfig loadConfig() {
        TipTapShowConfig config;
        File file = new File(FabricLoader.getInstance().getConfigDir().toString(), "tiptapshow.toml");
        if (file.exists()) {
            Toml configToml = new Toml().read(file);
            config = (TipTapShowConfig)configToml.to(TipTapShowConfig.class);
            config.file = file;
        } else {
            config = new TipTapShowConfig();
            config.file = file;
            config.saveConfig();
        }
        return config;
    }

    public void saveConfig() {
        TomlWriter writer = new TomlWriter();
        try {
            writer.write((Object)this, this.file);
        }
        catch (IOException e) {
            TipTapShowMod.LOGGER.error("An error occured while trying to save the config", (Throwable)e);
        }
    }

    public static enum CpsType {
        ALWAYS,
        ON_CLICK,
        NEVER;

    }
}

