package com.expecticament.helpfulcommands;

import com.expecticament.helpfulcommands.command.ModCommandManager;
import com.expecticament.helpfulcommands.event.ModEventManager;
import net.fabricmc.api.ModInitializer;

import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_2583;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HelpfulCommands implements ModInitializer {
	// This logger is used to write text to the console and the log file.
	// It is considered best practice to use your mod id as the logger's name.
	// That way, it's clear which mod wrote info, warnings, and errors.
	public static final String modID = "helpfulcommands";
	public static final Logger LOGGER = LoggerFactory.getLogger(modID);

	public static final String modName = FabricLoader.getInstance().getModContainer(HelpfulCommands.modID).get().getMetadata().getName();
	public static final String modVersion = FabricLoader.getInstance().getModContainer(HelpfulCommands.modID).get().getMetadata().getVersion().toString();

	public static class style {
		public static final class_2583 simpleText = class_2583.field_24360.method_10977(class_124.field_1068);
		public static final class_2583 error = simpleText.method_10977(class_124.field_1061);
		public static final class_2583 critical = simpleText.method_10977(class_124.field_1079);
		public static final class_2583 warning = simpleText.method_10977(class_124.field_1054);
		public static final class_2583 success = simpleText.method_10977(class_124.field_1060);
		public static final class_2583 primary = simpleText.method_10977(class_124.field_1065);
		public static final class_2583 secondary = simpleText.method_10977(class_124.field_1075);
		public static final class_2583 tertiary = simpleText.method_10977(class_124.field_1054);
		public static final class_2583 inactive = simpleText.method_10977(class_124.field_1080);
		public static final class_2583 enabled = simpleText.method_10977(class_124.field_1060);
		public static final class_2583 disabled = simpleText.method_10977(class_124.field_1061);
	}

	public static final int defaultCommandLevel = 2;
	public static final int defaultConfigEditLevel = 4;

	@Override
	public void onInitialize() {
		// This code runs as soon as Minecraft is in a mod-load-ready state.
		// However, some things (like resources) may still be uninitialized.
		// Proceed with mild caution.
		ModCommandManager.registerCommands();
		ModEventManager.registerEvents();
	}
}