package com.expecticament.helpfulcommands.command.entities;

import com.expecticament.helpfulcommands.command.IHelpfulCommandsCommand;
import com.expecticament.helpfulcommands.command.ModCommandManager;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.expecticament.helpfulcommands.HelpfulCommands;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.class_1297;
import net.minecraft.class_1928;
import net.minecraft.class_1934;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_7157;

public class CMD_gm implements IHelpfulCommandsCommand {

    public static ModCommandManager.ModCommand cmd;

    public static void init(ModCommandManager.ModCommand newData){
        cmd = newData;
    }

    public static void registerCommand(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 environment){
        dispatcher.register(class_2170.method_9247(cmd.name)
                .then(class_2170.method_9247("a")
                        .then(class_2170.method_9244("player(s)", class_2186.method_9308())
                                .executes(ctx -> execute(ctx, class_1934.field_9216, class_2186.method_9312(ctx,"player(s)")))
                        )
                        .executes(ctx -> execute(ctx, class_1934.field_9216, null))
                )
                .then(class_2170.method_9247("c")
                        .then(class_2170.method_9244("player(s)", class_2186.method_9308())
                                .executes(ctx -> execute(ctx, class_1934.field_9220, class_2186.method_9312(ctx,"player(s)")))
                        )
                        .executes(ctx -> execute(ctx, class_1934.field_9220, null))
                )
                .then(class_2170.method_9247("s")
                        .then(class_2170.method_9244("player(s)", class_2186.method_9308())
                                .executes(ctx -> execute(ctx, class_1934.field_9215, class_2186.method_9312(ctx,"player(s)")))
                        )
                        .executes(ctx -> execute(ctx, class_1934.field_9215, null))
                )
                .then(class_2170.method_9247("sp")
                        .then(class_2170.method_9244("player(s)", class_2186.method_9308())
                                .executes(ctx -> execute(ctx, class_1934.field_9219, class_2186.method_9312(ctx,"player(s)")))
                        )
                        .executes(ctx -> execute(ctx, class_1934.field_9219, null))
                )
                .requires(src -> ModCommandManager.canUseCommand(src, cmd))
        );
    }

    private static int execute(CommandContext<class_2168> ctx, class_1934 gameMode, Collection<? extends class_3222> targets) throws CommandSyntaxException {
        class_2168 src = ctx.getSource();

        if(!src.method_43737() && targets == null) {
            src.method_9213(class_2561.method_43471("error.specifyTargets"));
            return 0;
        }

        class_3222 player = src.method_44023();
        class_5250 gameModeNameText = class_2561.method_43471("gameMode." + gameMode.method_8381()).method_10862(HelpfulCommands.style.primary);

        if(targets == null || (targets.size() == 1 && targets.contains(player))) {
            if(changeGameMode(player, gameMode)) {
                src.method_9226(() -> class_2561.method_43469("commands.gm.success.self", gameModeNameText).method_10862(HelpfulCommands.style.success), true);
                return Command.SINGLE_SUCCESS;
            } else {
                src.method_9213(class_2561.method_43471("error.nothingChanged"));
                return 0;
            }
        }

        boolean commandFeedback = src.method_9225().method_64395().method_8355(class_1928.field_19400);
        ArrayList<class_1297> list = new ArrayList<>();
        for(class_3222 i : targets) {
            if(changeGameMode(i, gameMode)) {
                list.add(i);
                if(commandFeedback && i != player) {
                    i.method_64398(class_2561.method_43469("commands.gm.success.self", gameModeNameText).method_10862(HelpfulCommands.style.tertiary));
                }
            }
        }

        int affectedCount = list.size();

        if(affectedCount < 1) {
            src.method_9213(class_2561.method_43471("error.didntFindTargets"));
            return 0;
        }

        if(commandFeedback) {
            class_5250 finalCount = class_2561.method_43470(String.valueOf(affectedCount)).method_10862(HelpfulCommands.style.primary
                    .method_10949(ModCommandManager.targetListToHoverEvent(list))
            );
            src.method_9226(() -> class_2561.method_43469("commands.gm.success.other", gameModeNameText, finalCount).method_10862(HelpfulCommands.style.success), true);
        }

        return affectedCount;
    }

    private static boolean changeGameMode(class_3222 player, class_1934 gameMode) {
        return player.method_7336(gameMode);
    }
}