package com.expecticament.helpfulcommands.command.entities;

import com.expecticament.helpfulcommands.command.IHelpfulCommandsCommand;
import com.expecticament.helpfulcommands.command.ModCommandManager;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.expecticament.helpfulcommands.HelpfulCommands;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.class_1297;
import net.minecraft.class_1928;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_7157;

public class CMD_ignite implements IHelpfulCommandsCommand {

    public static ModCommandManager.ModCommand cmd;

    public static void init(ModCommandManager.ModCommand newData){
        cmd = newData;
    }

    public static void registerCommand(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 environment){
        dispatcher.register(class_2170.method_9247(cmd.name)
                .then(class_2170.method_9244("target(s)", class_2186.method_9306())
                        .then(class_2170.method_9244("duration", IntegerArgumentType.integer(0))
                                .executes(ctx -> execute(ctx, class_2186.method_9317(ctx, "target(s)"), IntegerArgumentType.getInteger(ctx, "duration")))
                        )
                )
                .requires(src -> ModCommandManager.canUseCommand(src, cmd))
        );
    }

    private static int execute(CommandContext<class_2168> ctx, Collection<? extends class_1297> targets, int duration) throws CommandSyntaxException {
        class_2168 src = ctx.getSource();

        if(!src.method_43737() && targets == null){
            src.method_9213(class_2561.method_43471("error.specifyTargets"));
            return 0;
        }

        class_3222 player = src.method_44023();

        if(targets == null || (targets.size() == 1 && targets.contains(player))) {
            if(ignite(player, duration)) {
                src.method_9226(() -> class_2561.method_43469("commands.ignite.success.self", class_2561.method_43470(String.valueOf(duration)).method_10862(HelpfulCommands.style.primary)).method_10862(HelpfulCommands.style.success), true);
                return Command.SINGLE_SUCCESS;
            } else {
                src.method_9213(class_2561.method_43471("error.nothingChanged"));
                return 0;
            }
        }

        boolean commandFeedback = src.method_9225().method_64395().method_8355(class_1928.field_19400);
        ArrayList<class_1297> list = new ArrayList<>();
        for(class_1297 i : targets) {
            if(ignite(i, duration)) {
                list.add(i);
                if(commandFeedback && i.method_31747() && i != player) {
                    ((class_3222) i).method_64398(class_2561.method_43469("commands.ignite.success.self", class_2561.method_43470(String.valueOf(duration)).method_10862(HelpfulCommands.style.primary)).method_10862(HelpfulCommands.style.tertiary));
                }
            }
        }

        int affectedCount = list.size();

        if(affectedCount < 1) {
            src.method_9213(class_2561.method_43471("error.didntFindTargets"));
            return 0;
        }

        if(commandFeedback) {
            class_5250 finalCount = class_2561.method_43470(String.valueOf(affectedCount)).method_10862(HelpfulCommands.style.primary
                    .method_10949(ModCommandManager.targetListToHoverEvent(list))
            );
            src.method_9226(() -> class_2561.method_43469("commands.ignite.success.other", finalCount, class_2561.method_43470(String.valueOf(duration)).method_10862(HelpfulCommands.style.primary)).method_10862(HelpfulCommands.style.success), true);
        }

        return affectedCount;
    }

    private static boolean ignite(class_1297 entity, int duration) {
        if(entity.method_31747()) {
            if(((class_3222) entity).method_56992()) {
                return false;
            }
        }

        if(entity.method_5753()) {
            return false;
        }

        entity.method_5639(duration);

        return true;
    }
}