package com.expecticament.helpfulcommands.command.entities;

import com.expecticament.helpfulcommands.HelpfulCommands;
import com.expecticament.helpfulcommands.command.IHelpfulCommandsCommand;
import com.expecticament.helpfulcommands.command.ModCommandManager;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3917;
import net.minecraft.class_7157;
import net.minecraft.class_747;
import net.minecraft.class_9334;


public class CMD_invsee implements IHelpfulCommandsCommand {

    public static ModCommandManager.ModCommand cmd;

    public static void init(ModCommandManager.ModCommand newData){
        cmd = newData;
    }

    public static void registerCommand(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 environment){
        dispatcher.register(class_2170.method_9247(cmd.name)
                .then(class_2170.method_9244("target", class_2186.method_9305())
                        .executes(ctx -> openInventory(ctx, class_2186.method_9315(ctx, "target")))
                )
                .requires(src-> ModCommandManager.canUseCommand(src, cmd))
        );
    }

    private static int openInventory(CommandContext<class_2168> ctx, class_3222 target) {
        class_2168 src = ctx.getSource();

        if(!src.method_43737()){
            src.method_9213(class_2561.method_43471("error.inGameOnly"));
            return -1;
        }

        class_3222 plr = src.method_44023();

        if(plr == target) {
            src.method_9213(class_2561.method_43471("error.cantUseOnYourself"));
            return -1;
        }

        plr.method_17355(new class_747((syncId, inv, player) -> new InvseeScreenHandler(syncId, inv, target), class_2561.method_43469("commands.invsee.screenTitle", class_2561.method_43470(target.method_5477().getString()))));

        return Command.SINGLE_SUCCESS;
    }

    private static class InvseeScreenHandler extends class_1703 {

        public InvseeScreenHandler(int syncId, class_1661 sourceInventory, class_1657 target) {
            super(class_3917.field_18667, syncId);

            class_1661 targetInventory = target.method_31548();
            this.method_61624(targetInventory, 0, 0);
            for(int i = 0; i < 2; i++) {
                this.method_7621(new EmptySlot(new class_1661(target, null), 0, 0, 0));
            }
            for(int i = 0; i < 5; i++) {
                this.method_7621(new class_1735(targetInventory, 36 + i, 0, 0));
            }
            for(int i = 0; i < 2; i++) {
                this.method_7621(new EmptySlot(new class_1661(target, null), 0, 0, 0));
            }
            this.method_61624(sourceInventory, 0, 0);
        }

        @Override
        public class_1799 method_7601(class_1657 player, int slotIndex) {
            class_1799 itemStack = class_1799.field_8037;
            class_1735 slot = this.field_7761.get(slotIndex);

            if (slot.method_7681()) {
                class_1799 stackInSlot = slot.method_7677();
                itemStack = stackInSlot.method_7972();

                int targetInventoryStart = 0;
                int targetInventoryEnd = 36;
                int sourceInventoryStart = 36;
                int sourceInventoryEnd = this.field_7761.size();

                if (slotIndex >= targetInventoryStart && slotIndex < targetInventoryEnd) {
                    // Shift-click from target's inventory to source's inventory
                    if (!this.method_7616(stackInSlot, sourceInventoryStart, sourceInventoryEnd, false)) {
                        return class_1799.field_8037;
                    }
                } else if (slotIndex >= sourceInventoryStart && slotIndex < sourceInventoryEnd) {
                    // Shift-click from source's inventory to target's inventory
                    if (!this.method_7616(stackInSlot, targetInventoryStart, targetInventoryEnd, false)) {
                        return class_1799.field_8037;
                    }
                }

                if (stackInSlot.method_7960()) {
                    slot.method_53512(class_1799.field_8037);
                } else {
                    slot.method_7668();
                }
            }

            return itemStack;
        }

        @Override
        public boolean method_7597(class_1657 player) {
            return true;
        }
    }

    public static class EmptySlot extends class_1735 {

        public EmptySlot(class_1263 inventory, int index, int x, int y) {
            super(inventory, index, x, y);

            class_1799 itemStack = new class_1799(class_1802.field_8077);
            itemStack.method_57379(class_9334.field_49631, class_2561.method_43471("commands.invsee.emptySlotName").method_10862(HelpfulCommands.style.disabled));

            method_53512(itemStack);
        }

        @Override
        public boolean method_7680(class_1799 stack) {
            return false;
        }
        @Override
        public boolean method_7674(class_1657 playerEntity) {
            return false;
        }
    }
}