package com.expecticament.helpfulcommands.command.teleportation;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;

import com.expecticament.helpfulcommands.HelpfulCommands;
import com.expecticament.helpfulcommands.command.IHelpfulCommandsCommand;
import com.expecticament.helpfulcommands.command.ModCommandManager;
import net.minecraft.class_124;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_7157;
import net.minecraft.text.*;

import com.expecticament.helpfulcommands.util.IEntityDataSaver;
import java.util.HashSet;

public class CMD_back implements IHelpfulCommandsCommand {
    public static ModCommandManager.ModCommand cmd;

    public static void init(ModCommandManager.ModCommand newData){
        cmd=newData;
    }

    public static void registerCommand(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 environment){
        dispatcher.register(class_2170.method_9247(cmd.name)
                        .then(class_2170.method_9247("get")
                                .executes(CMD_back::get)
                        )
                        .then(class_2170.method_9247("tp")
                                .executes(CMD_back::teleport)
                        )
                .executes(CMD_back::teleport)
                .requires(src->ModCommandManager.canUseCommand(src,cmd))
        );
    }

    private static int teleport(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_2168 src=ctx.getSource();
        if(!src.method_43737()){
            src.method_9213(class_2561.method_43471("error.inGameOnly"));
            return -1;
        }

        class_3222 plr=src.method_44023();
        IEntityDataSaver playerData=(IEntityDataSaver) plr;

        int[] deathPos = (playerData.getPersistentData().method_10561("deathPosition")).orElse(new int[0]);
        String dimensionName = (playerData.getPersistentData().method_10558("deathDimension")).orElse("");
        if(deathPos.length!=0){
            class_3218 dimension=null;
            for(class_5321<class_1937> i : src.method_29310()){
                if(i.method_29177().toString().equals(dimensionName)){
                    dimension=src.method_9211().method_3847(i);
                    break;
                }
            }
            if(dimension==null){
                plr.method_64398(class_2561.method_43471("error.unknownDimension").method_10862(HelpfulCommands.style.error));
                return -1;
            }
            plr.method_48105(dimension, deathPos[0], deathPos[1], deathPos[2], new HashSet<>(), plr.method_36454(), plr.method_36455(), false);
            src.method_9226(()-> class_2561.method_43471("commands.back.success").method_10862(HelpfulCommands.style.secondary
                    .method_10958(new class_2558.class_10610("/tp "+deathPos[0]+" "+deathPos[1]+" "+deathPos[2]))
                    .method_10949(new class_2568.class_10613(class_2561.method_43470("x: "+deathPos[0]+"\ny: "+deathPos[1]+"\nz: "+deathPos[2])))
            ),true);
        } else{
            src.method_9213(class_2561.method_43471("commands.back.error.noDeathPos").method_10862(HelpfulCommands.style.error));
            return -1;
        }

        return Command.SINGLE_SUCCESS;
    }

    private static int get(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_2168 src=ctx.getSource();
        if(!src.method_43737()){
            src.method_9213(class_2561.method_43471("error.inGameOnly"));
            return -1;
        }

        class_3222 plr=src.method_44023();
        IEntityDataSaver playerData=(IEntityDataSaver) plr;

        int[] deathPos = (playerData.getPersistentData().method_10561("deathPosition")).orElse(new int[0]);
        if(deathPos.length==0){
            src.method_9213(class_2561.method_43471("commands.back.error.noDeathPos").method_10862(HelpfulCommands.style.error));
            return -1;
        }
        String dimensionName = (playerData.getPersistentData().method_10558("deathDimension")).orElse("");
        class_2583 valueStyle=HelpfulCommands.style.tertiary;

        class_5250 msg=class_2561.method_43473().method_10862(HelpfulCommands.style.primary);
        msg.method_10852(class_2561.method_43470("« ").method_27692(class_124.field_1067));
        msg
                .method_10852(class_2561.method_43470(src.method_9214()).method_27692(class_124.field_1067))
                .method_10852(class_2561.method_43470(" || ").method_10862(HelpfulCommands.style.secondary))
                .method_10852(class_2561.method_43471("deathPosition.title").method_10862(HelpfulCommands.style.secondary))
                .method_10852(class_2561.method_43470(" »").method_27692(class_124.field_1067))
                .method_27693("\n")
                .method_10852(class_2561.method_43470("x: ").method_10862(HelpfulCommands.style.simpleText))
                .method_10852(class_2561.method_43470(String.valueOf(deathPos[0])).method_10862(valueStyle))
                .method_27693("\n")
                .method_10852(class_2561.method_43470("y: ").method_10862(HelpfulCommands.style.simpleText))
                .method_10852(class_2561.method_43470(String.valueOf(deathPos[1])).method_10862(valueStyle))
                .method_27693("\n")
                .method_10852(class_2561.method_43470("z: ").method_10862(HelpfulCommands.style.simpleText))
                .method_10852(class_2561.method_43470(String.valueOf(deathPos[2])).method_10862(valueStyle))
                .method_27693("\n")
                .method_10852(class_2561.method_43471("phrase.dimension").method_10852(class_2561.method_43470(": ")).method_10862(HelpfulCommands.style.simpleText))
                .method_10852(class_2561.method_43470(dimensionName).method_10862(valueStyle))
                .method_27693("\n")
                .method_27693("\n")
                .method_10852(class_2561.method_43470("〚").method_10862(HelpfulCommands.style.secondary))
                .method_10852(class_2561.method_43471("phrase.teleport").method_10862(HelpfulCommands.style.secondary
                        .method_10958(new class_2558.class_10609("/back"))
                        .method_10949(new class_2568.class_10613(class_2561.method_43471("tooltips.clickToTeleport")))
                ))
                .method_10852(class_2561.method_43470("〛").method_10862(HelpfulCommands.style.secondary))
        ;

        src.method_45068(msg);

        return Command.SINGLE_SUCCESS;
    }
}