package com.expecticament.helpfulcommands.command.teleportation;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.expecticament.helpfulcommands.HelpfulCommands;
import com.expecticament.helpfulcommands.command.IHelpfulCommandsCommand;
import com.expecticament.helpfulcommands.command.ModCommandManager;
import net.minecraft.class_1297;
import net.minecraft.class_1928;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2181;
import net.minecraft.class_2186;
import net.minecraft.class_2338;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_7157;
import net.minecraft.text.*;
import java.util.*;

public class CMD_dimension implements IHelpfulCommandsCommand {

    public static ModCommandManager.ModCommand cmd;

    public static void init(ModCommandManager.ModCommand newData){
        cmd = newData;
    }

    public static void registerCommand(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 environment) {
        dispatcher.register(class_2170.method_9247(cmd.name)
                .then(class_2170.method_9247("switch")
                        .then(class_2170.method_9244("dimension", class_2181.method_9288())
                                .then(class_2170.method_9244("target(s)", class_2186.method_9306())
                                        .executes(ctx -> switchDimension(ctx, class_2181.method_9289(ctx, "dimension"), class_2186.method_9317(ctx, "target(s)")))
                                )
                                .executes(ctx -> switchDimension(ctx, class_2181.method_9289(ctx, "dimension"), null))
                        )
                )
                .then(class_2170.method_9247("get")
                        .then(class_2170.method_9244("target", class_2186.method_9305())
                                .executes(ctx -> getDimension(ctx, class_2186.method_9315(ctx, "target")))
                        )
                        .executes(ctx -> getDimension(ctx, null))
                )
                .requires(src->ModCommandManager.canUseCommand(src,cmd))
        );
    }

    private static int getDimension(CommandContext<class_2168> ctx, class_3222 target) throws CommandSyntaxException {
        class_2168 src = ctx.getSource();

        if(!src.method_43737() && target == null){
            src.method_9213(class_2561.method_43471("error.specifyTargets"));
            return 0;
        }

        class_3222 player = src.method_44023();

        if(target == null) {
            target = player;
        }

        String dimensionName = target.method_51469().method_27983().method_29177().toString();

        if(target == player) {
            src.method_45068(class_2561.method_43469("commands.dimension.get.success.self", class_2561.method_43470(dimensionName).method_10862(HelpfulCommands.style.primary
                    .method_10949(new class_2568.class_10613(class_2561.method_43471("tooltips.clickToTeleportToDimension")))
                    .method_10958(new class_2558.class_10609("/dimension switch " + dimensionName))
            )).method_10862(HelpfulCommands.style.secondary));
        } else {
            src.method_45068(class_2561.method_43469("commands.dimension.get.success.other", class_2561.method_43470(target.method_5477().getString()).method_10862(HelpfulCommands.style.primary), class_2561.method_43470(dimensionName).method_10862(HelpfulCommands.style.primary
                    .method_10949(new class_2568.class_10613(class_2561.method_43471("tooltips.clickToTeleportToDimension")))
                    .method_10958(new class_2558.class_10609("/dimension switch " + dimensionName))
            )).method_10862(HelpfulCommands.style.secondary));
        }

        return Command.SINGLE_SUCCESS;
    }

    private static int switchDimension(CommandContext<class_2168> ctx, class_3218 dimension, Collection<? extends class_1297> targets) throws CommandSyntaxException {
        class_2168 src = ctx.getSource();

        if(!src.method_43737() && targets == null) {
            src.method_9213(class_2561.method_43471("error.specifyTargets"));
            return 0;
        }

        class_3222 player = src.method_44023();
        String dimensionName = dimension.method_27983().method_29177().toString();

        if(targets == null || (targets.size() == 1 && targets.contains(player))) {
            if(switchDimensionForTarget(player, dimension)) {
                class_2583 style = HelpfulCommands.style.success;
                src.method_9226(()-> class_2561.method_43469("commands.dimension.success.self", class_2561.method_43470(dimensionName).method_10862(HelpfulCommands.style.primary)).method_10862(style),true);

                return Command.SINGLE_SUCCESS;
            } else {
                src.method_9213(class_2561.method_43471("commands.dimension.error.alreadyInDimension"));
                return 0;
            }
        }

        boolean commandFeedback = src.method_9225().method_64395().method_8355(class_1928.field_19400);
        ArrayList<class_1297> list = new ArrayList<>();
        for(class_1297 i : targets) {
            if(switchDimensionForTarget(i, dimension)) {
                list.add(i);

                if(commandFeedback && i.method_31747() && i != ((class_1297) player)) {
                    class_2583 style = HelpfulCommands.style.tertiary;
                    ((class_3222) i).method_64398(class_2561.method_43469("commands.dimension.success.self", class_2561.method_43470(dimensionName).method_10862(HelpfulCommands.style.primary)).method_10862(style));
                }
            }
        }

        int affectedCount = list.size();

        if(affectedCount < 1) {
            src.method_9213(class_2561.method_43471("error.didntFindTargets"));
            return 0;
        }

        if(commandFeedback) {
            class_5250 finalCount = class_2561.method_43470(String.valueOf(affectedCount)).method_10862(HelpfulCommands.style.primary
                    .method_10949(ModCommandManager.targetListToHoverEvent(list))
            );
            src.method_9226(() -> class_2561.method_43469("commands.dimension.success.other", class_2561.method_43470(dimensionName).method_10862(HelpfulCommands.style.primary), finalCount).method_10862(HelpfulCommands.style.success), true);
        }

        return affectedCount;
    }

    private static boolean switchDimensionForTarget(class_1297 target, class_3218 dimension) {
        if(target.method_73183() == dimension) {
            return false;
        }

        class_2338 blockPos = target.method_24515();
        return target.method_48105(dimension, blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260(), new HashSet<>(), target.method_36454(), target.method_36455(), false);
    }
}