package com.expecticament.helpfulcommands.command.teleportation;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.expecticament.helpfulcommands.HelpfulCommands;
import com.expecticament.helpfulcommands.command.IHelpfulCommandsCommand;
import com.expecticament.helpfulcommands.command.ModCommandManager;
import com.expecticament.helpfulcommands.util.IEntityDataSaver;
import net.minecraft.class_124;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2338;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_7157;
import net.minecraft.text.*;
import java.util.HashSet;

public class CMD_home implements IHelpfulCommandsCommand {

    public static ModCommandManager.ModCommand cmd;

    public static void init(ModCommandManager.ModCommand newData){
        cmd = newData;
    }

    public static void registerCommand(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 environment){
        dispatcher.register(class_2170.method_9247(cmd.name)
            .then(class_2170.method_9247("set")
                    .executes(CMD_home::set)
            )
            .then(class_2170.method_9247("get")
                    .executes(CMD_home::get)
            )
            .then(class_2170.method_9247("tp")
                    .executes(CMD_home::teleport)
            )
            .executes(CMD_home::teleport)
            .requires(src->ModCommandManager.canUseCommand(src,cmd))
        );
    }

    private static int teleport(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_2168 src = ctx.getSource();
        if(!src.method_43737()){
            src.method_9213(class_2561.method_43471("error.inGameOnly"));
            return 0;
        }

        class_3222 player = src.method_44023();
        TeleportationCommands.TeleportationPosition tpos = getTeleportationPosition(src, player);

        if(tpos.pos() != null) {
            if(tpos.world() == null){
                src.method_9213(class_2561.method_43471("error.unknownDimension"));
                return 0;
            }

            player.method_48105(tpos.world(), tpos.pos().method_10263(), tpos.pos().method_10264(), tpos.pos().method_10260(), new HashSet<>(), player.method_36454(), player.method_36455(), false);
            src.method_9226(()-> class_2561.method_43471("commands.home.teleport.success").method_10862(HelpfulCommands.style.secondary
                    .method_10958(new class_2558.class_10610("/tp " + tpos.pos().method_10263() + " " + tpos.pos().method_10264() + " " + tpos.pos().method_10260()))
                    .method_10949(new class_2568.class_10613(class_2561.method_43470("x: " + tpos.pos().method_10263() + "\ny: " + tpos.pos().method_10264() + "\nz: " + tpos.pos().method_10260())))
            ),true);
        } else{
            src.method_9213(class_2561.method_43469("commands.home.error.noHomePos", class_2561.method_43470("/home set").method_10862(HelpfulCommands.style.primary
                    .method_10958(new class_2558.class_10610("/home set"))
                    .method_10949(new class_2568.class_10613(class_2561.method_43471("tooltips.clickToSuggestThisCommand")))
            )));

            return 0;
        }

        return Command.SINGLE_SUCCESS;
    }

    private static int set(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_2168 src = ctx.getSource();
        if(!src.method_43737()){
            src.method_9213(class_2561.method_43471("error.inGameOnly"));
            return 0;
        }

        class_3222 plr = ctx.getSource().method_44023();
        IEntityDataSaver iEntityDataSaver = ((IEntityDataSaver) plr);

        class_2338 pos = plr.method_24515();
        class_5321<class_1937> dimensionKey = plr.method_51469().method_27983();
        String dimensionName = dimensionKey.method_29177().toString();
        iEntityDataSaver.getPersistentData().method_10539("homePosition", new int[]{ pos.method_10263(), pos.method_10264(), pos.method_10260() });
        iEntityDataSaver.getPersistentData().method_10582("homeDimension", dimensionName);

        src.method_9226(()-> class_2561.method_43471("commands.home.set.success").method_10862(HelpfulCommands.style.success),true);

        return Command.SINGLE_SUCCESS;
    }

    private static int get(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_2168 src = ctx.getSource();
        if(!src.method_43737()){
            src.method_9213(class_2561.method_43471("error.inGameOnly"));
            return 0;
        }

        class_3222 player = src.method_44023();
        TeleportationCommands.TeleportationPosition tpos = getTeleportationPosition(src, player);

        if(tpos.pos() != null) {
            if(tpos.world() == null){
                src.method_9213(class_2561.method_43471("error.unknownDimension"));
                return 0;
            }
        } else{
            src.method_9213(class_2561.method_43469("commands.home.error.noHomePos", class_2561.method_43470("/home set").method_10862(HelpfulCommands.style.primary
                    .method_10958(new class_2558.class_10610("/home set"))
                    .method_10949(new class_2568.class_10613(class_2561.method_43471("tooltips.clickToSuggestThisCommand")))
            )));

            return 0;
        }

        String dimensionName = tpos.world().method_27983().method_29177().toString();
        class_2583 valueStyle = HelpfulCommands.style.tertiary;

        class_5250 msg = class_2561.method_43473().method_10862(HelpfulCommands.style.primary);
        msg
                .method_10852(class_2561.method_43470("« ").method_27692(class_124.field_1067))
                .method_10852(class_2561.method_43470(src.method_9214()).method_27692(class_124.field_1067))
                .method_10852(class_2561.method_43470(" || ").method_10862(HelpfulCommands.style.secondary))
                .method_10852(class_2561.method_43471("homePosition.title").method_10862(HelpfulCommands.style.secondary))
                .method_10852(class_2561.method_43470(" »").method_27692(class_124.field_1067))
                .method_27693("\n")
                .method_10852(class_2561.method_43470("x: ").method_10862(HelpfulCommands.style.simpleText))
                .method_10852(class_2561.method_43470(String.valueOf(tpos.pos().method_10263())).method_10862(valueStyle))
                .method_27693("\n")
                .method_10852(class_2561.method_43470("y: ").method_10862(HelpfulCommands.style.simpleText))
                .method_10852(class_2561.method_43470(String.valueOf(tpos.pos().method_10264())).method_10862(valueStyle))
                .method_27693("\n")
                .method_10852(class_2561.method_43470("z: ").method_10862(HelpfulCommands.style.simpleText))
                .method_10852(class_2561.method_43470(String.valueOf(tpos.pos().method_10260())).method_10862(valueStyle))
                .method_27693("\n")
                .method_10852(class_2561.method_43471("phrase.dimension").method_10852(class_2561.method_43470(": ")).method_10862(HelpfulCommands.style.simpleText))
                .method_10852(class_2561.method_43470(dimensionName).method_10862(valueStyle))
                .method_27693("\n")
                .method_27693("\n")
                .method_10852(class_2561.method_43470("〚").method_10862(HelpfulCommands.style.secondary))
                .method_10852(class_2561.method_43471("phrase.teleport").method_10862(HelpfulCommands.style.secondary
                        .method_10958(new class_2558.class_10609("/home"))
                        .method_10949(new class_2568.class_10613(class_2561.method_43471("tooltips.clickToTeleport")))
                ))
                .method_10852(class_2561.method_43470("〛").method_10862(HelpfulCommands.style.secondary))
        ;

        src.method_45068(msg);

        return Command.SINGLE_SUCCESS;
    }

    private static TeleportationCommands.TeleportationPosition getTeleportationPosition(class_2168 src, class_3222 player) {
        IEntityDataSaver playerData = (IEntityDataSaver) player;

        int[] pos = (playerData.getPersistentData().method_10561("homePosition")).orElse(null);
        String dimensionName = (playerData.getPersistentData().method_10558("homeDimension")).orElse("");

        class_3218 dimension = null;
        class_2338 blockPos = null;

        if(pos != null && pos.length >= 3) {
            blockPos = new class_2338(pos[0], pos[1], pos[2]);
        }

        for(class_5321<class_1937> i : src.method_29310()){
            if(i.method_29177().toString().equals(dimensionName)){
                dimension = src.method_9211().method_3847(i);
                break;
            }
        }

        return new TeleportationCommands.TeleportationPosition(dimension, blockPos);
    }
}