package com.expecticament.helpfulcommands.command.teleportation;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.expecticament.helpfulcommands.HelpfulCommands;
import com.expecticament.helpfulcommands.command.IHelpfulCommandsCommand;
import com.expecticament.helpfulcommands.command.ModCommandManager;
import net.minecraft.class_124;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2338;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5217;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_7157;
import net.minecraft.server.MinecraftServer;
import net.minecraft.text.*;
import org.jetbrains.annotations.Nullable;

import java.awt.*;
import java.util.HashSet;

public class CMD_spawn implements IHelpfulCommandsCommand {

    public static ModCommandManager.ModCommand cmd;

    public static void init(ModCommandManager.ModCommand newData){
        cmd = newData;
    }

    private enum SpawnType { Player, World };

    public static void registerCommand(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 environment){
        dispatcher.register(class_2170.method_9247(cmd.name)
                        .then(class_2170.method_9247("player")
                                .then(class_2170.method_9244("target", class_2186.method_9305())
                                        .then(class_2170.method_9247("get")
                                                .executes(ctx-> get(ctx,SpawnType.Player, class_2186.method_9315(ctx, "target")))
                                        )
                                        .then(class_2170.method_9247("tp")
                                                .executes(ctx -> teleport(ctx, SpawnType.Player, class_2186.method_9315(ctx, "target")))
                                        )
                                        .executes(ctx -> teleport(ctx, SpawnType.Player, class_2186.method_9315(ctx, "target")))
                                )
                                .executes(ctx -> teleport(ctx, SpawnType.Player, null))
                        )
                        .then(class_2170.method_9247("world")
                                .then(class_2170.method_9247("get")
                                        .executes(ctx-> get(ctx,SpawnType.World, null))
                                )
                                .then(class_2170.method_9247("tp")
                                        .executes(ctx -> teleport(ctx, SpawnType.World, null))
                                )
                                .executes(ctx -> teleport(ctx, SpawnType.World, null))
                        )
                .requires(src-> ModCommandManager.canUseCommand(src, cmd))
        );
    }

    private static int teleport(CommandContext<class_2168> ctx, SpawnType spawnType, @Nullable class_3222 targetPlayer) throws CommandSyntaxException {
        class_2168 src = ctx.getSource();
        if(!src.method_43737()) {
            src.method_9213(class_2561.method_43471("error.inGameOnly"));
            return 0;
        }

        class_3222 player = src.method_44023();
        if(targetPlayer == null) {
            targetPlayer = player;
        }

        String plrTrKey = ".";
        if(spawnType == SpawnType.Player) {
            plrTrKey = (targetPlayer == player) ? ".self." : ".other.";
        }

        TeleportationCommands.TeleportationPosition tpos = getTeleportationPosition(targetPlayer, spawnType);

        if(tpos.pos() == null) {
            src.method_9213(class_2561.method_43469(String.format("commands.spawn.%s%serror.notSet", spawnType.name().toLowerCase(), plrTrKey), class_2561.method_43470(targetPlayer.method_5477().getString()).method_10862(HelpfulCommands.style.primary)).method_10862(HelpfulCommands.style.error));
            return 0;
        }

        if(tpos.world() == null){
            src.method_9213(class_2561.method_43471("error.unknownDimension"));
            return 0;
        }

        player.method_48105(tpos.world(), tpos.pos().method_10263(), tpos.pos().method_10264(), tpos.pos().method_10260(), new HashSet<>(), player.method_36454(), player.method_36455(), false);
        final class_3222 finalTarget = targetPlayer;
        final String finalPlrTrKey = plrTrKey;
        src.method_9226(()-> class_2561.method_43469(String.format("commands.spawn.%s%ssuccess", spawnType.name().toLowerCase(), finalPlrTrKey), class_2561.method_43470(finalTarget.method_5477().getString()).method_10862(HelpfulCommands.style.primary)).method_10862(HelpfulCommands.style.secondary
                .method_10958(new class_2558.class_10610("/tp " + tpos.pos().method_10263() + " " + tpos.pos().method_10264() + " " + tpos.pos().method_10260()))
                .method_10949(new class_2568.class_10613(class_2561.method_43470("x: " + tpos.pos().method_10263() + "\ny: " + tpos.pos().method_10264() + "\nz: " + tpos.pos().method_10260())))
        ),true);

        return Command.SINGLE_SUCCESS;
    }

    private static int get(CommandContext<class_2168> ctx, SpawnType spawnType, @Nullable class_3222 targetPlayer) throws CommandSyntaxException {
        class_2168 src = ctx.getSource();
        class_3222 player = src.method_44023();

        if(targetPlayer == null) {
            targetPlayer = player;
        }

        String plrTrKey = ".";
        if(spawnType == SpawnType.Player) {
            plrTrKey = (targetPlayer == player) ? ".self." : ".other.";
        }

        TeleportationCommands.TeleportationPosition tpos = getTeleportationPosition(targetPlayer, spawnType);

        if(tpos.pos() == null) {
            src.method_9213(class_2561.method_43469(String.format("commands.spawn.%s%serror.notSet", spawnType.name().toLowerCase(), plrTrKey), class_2561.method_43470(targetPlayer.method_5477().getString()).method_10862(HelpfulCommands.style.primary)).method_10862(HelpfulCommands.style.error));
            return 0;
        }

        if(tpos.world() == null){
            src.method_9213(class_2561.method_43471("error.unknownDimension"));
            return 0;
        }

        class_2583 valueStyle = HelpfulCommands.style.tertiary;
        class_5250 targetName = switch (spawnType) {
            case Player -> class_2561.method_43470(targetPlayer.method_5477().getString());
            case World -> class_2561.method_43471("phrase.world");
        };
        String runCmd = "/spawn " + spawnType.name().toLowerCase();
        if(spawnType == SpawnType.Player) {
            if(targetPlayer != player) {
                runCmd += " " + targetPlayer.method_5477().getString();
            }
        }

        class_5250 msg = class_2561.method_43473().method_10862(HelpfulCommands.style.primary);
        msg
                .method_10852(class_2561.method_43470("« ").method_27692(class_124.field_1067))
                .method_10852(targetName.method_27692(class_124.field_1067))
                .method_10852(class_2561.method_43470(" || ").method_10862(HelpfulCommands.style.secondary))
                .method_10852(class_2561.method_43471("spawnPoint.title").method_10862(HelpfulCommands.style.secondary))
                .method_10852(class_2561.method_43470(" »").method_27692(class_124.field_1067))
                .method_27693("\n")
                .method_10852(class_2561.method_43470("x: ").method_10862(HelpfulCommands.style.simpleText))
                .method_10852(class_2561.method_43470(String.valueOf(tpos.pos().method_10263())).method_10862(valueStyle))
                .method_27693("\n")
                .method_10852(class_2561.method_43470("y: ").method_10862(HelpfulCommands.style.simpleText))
                .method_10852(class_2561.method_43470(String.valueOf(tpos.pos().method_10264())).method_10862(valueStyle))
                .method_27693("\n")
                .method_10852(class_2561.method_43470("z: ").method_10862(HelpfulCommands.style.simpleText))
                .method_10852(class_2561.method_43470(String.valueOf(tpos.pos().method_10260())).method_10862(valueStyle))
                .method_27693("\n")
                .method_10852(class_2561.method_43471("phrase.dimension").method_10852(class_2561.method_43470(": ")).method_10862(HelpfulCommands.style.simpleText))
                .method_10852(class_2561.method_43470(tpos.world().method_27983().method_29177().toString()).method_10862(valueStyle))
                .method_27693("\n")
                .method_27693("\n")
                .method_10852(class_2561.method_43470("〚").method_10862(HelpfulCommands.style.secondary))
                .method_10852(class_2561.method_43471("phrase.teleport").method_10862(HelpfulCommands.style.secondary
                        .method_10958(new class_2558.class_10609(runCmd))
                        .method_10949(new class_2568.class_10613(class_2561.method_43471("tooltips.clickToTeleport")))
                ))
                .method_10852(class_2561.method_43470("〛").method_10862(HelpfulCommands.style.secondary))
        ;

        src.method_45068(msg);

        return Command.SINGLE_SUCCESS;
    }

    private static TeleportationCommands.TeleportationPosition getTeleportationPosition(class_3222 player, SpawnType spawnType) {
        class_2338 pos = null;
        class_3218 world = null;

        MinecraftServer server = player.method_51469().method_8503();

        switch(spawnType) {
            case Player:
                class_3222.class_10766 respawn = player.method_67564();
                if(respawn != null) {
                    world = regKeyToWorld(server, respawn.comp_4913().method_74894());
                    pos = respawn.comp_4913().method_74897();
                }
                break;
            case World:
                class_5217.class_12064 spawnPoint = player.method_51469().method_8410().method_74854();
                pos = spawnPoint.method_74897();
                world = regKeyToWorld(server, spawnPoint.method_74894());
                break;
        }

        return new TeleportationCommands.TeleportationPosition(world, pos);
    }

    private static class_3218 regKeyToWorld(MinecraftServer server, class_5321<class_1937> registryKey) {
        String worldKey = registryKey.method_29177().toString();

        for (class_3218 world : server.method_3738()) {
            if (worldKey.equals(world.method_27983().method_29177().toString())) {
                return world;
            }
        }

        return null;
    }
}