package com.expecticament.helpfulcommands.command.utility;

import com.expecticament.helpfulcommands.command.IHelpfulCommandsCommand;
import com.expecticament.helpfulcommands.command.ModCommandManager;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_7157;
import net.minecraft.class_9334;
import com.expecticament.helpfulcommands.HelpfulCommands;

public class CMD_rename implements IHelpfulCommandsCommand {

    public static ModCommandManager.ModCommand cmd;

    public static void init(ModCommandManager.ModCommand newData){
        cmd=newData;
    }

    public static void registerCommand(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 environment){
        dispatcher.register(class_2170.method_9247(cmd.name)
                .then(class_2170.method_9244("newName", StringArgumentType.string())
                        .executes(ctx->execute(ctx,StringArgumentType.getString(ctx,"newName")))
                )
                .executes(CMD_rename::execute)
                .requires(src->ModCommandManager.canUseCommand(src,cmd))
        );
    }

    private static int execute(CommandContext<class_2168> ctx, String newName) throws CommandSyntaxException{
        if(newName.isEmpty()) return execute(ctx);

        class_2168 source=ctx.getSource();
        if(!source.method_43737()){
            source.method_9213(class_2561.method_43471("error.inGameOnly"));
            return -1;
        } else{
            class_3222 player=source.method_44023();
            if(player==null) return -1;

            class_1799 itemStack=player.method_6047();
            if(itemStack==null || itemStack.method_7960()){
                source.method_9213(class_2561.method_43471("error.nothingInMainHand"));
                return -1;
            }

            String oldName = itemStack.method_7964().getString();
            if(oldName.equals(newName)){
                source.method_9213(class_2561.method_43471("commands.rename.error.sameName"));
                return -1;
            }
            itemStack.method_57379(class_9334.field_49631, class_2561.method_43470(newName));
            source.method_9226(()-> class_2561.method_43469("commands.rename.success", (class_2561.method_43470(oldName)).method_10862(HelpfulCommands.style.primary), class_2561.method_43470(newName).method_10862(HelpfulCommands.style.primary)).method_10862(HelpfulCommands.style.success),true);
        }
        return Command.SINGLE_SUCCESS;
    }

    private static int execute(CommandContext<class_2168> ctx) throws CommandSyntaxException{
        class_2168 source=ctx.getSource();
        if(!source.method_43737()){
            source.method_9213(class_2561.method_43471("error.inGameOnly"));
            return -1;
        } else{
            class_3222 player=source.method_44023();
            if(player==null) return -1;

            class_1799 itemStack=player.method_6047();
            if(itemStack==null || itemStack.method_7960()){
                source.method_9213(class_2561.method_43471("error.nothingInMainHand"));
                return -1;
            }

            if(itemStack.method_58694(class_9334.field_49631)==null){
                source.method_9213(class_2561.method_43471("commands.rename.error.customNameNotSet"));
                return -1;
            }

            itemStack.method_57381(class_9334.field_49631);
            source.method_9226(()-> class_2561.method_43471("commands.rename.success.customNameRemoved").method_10862(HelpfulCommands.style.success),true);
        }
        return Command.SINGLE_SUCCESS;
    }
}
