package com.expecticament.helpfulcommands.command.world;

import com.expecticament.helpfulcommands.command.IHelpfulCommandsCommand;
import com.expecticament.helpfulcommands.command.ModCommandManager;
import com.expecticament.helpfulcommands.util.ConfigManager;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.expecticament.helpfulcommands.HelpfulCommands;
import org.jetbrains.annotations.Nullable;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1299;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2287;
import net.minecraft.class_238;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_7157;

public class CMD_killitems implements IHelpfulCommandsCommand {

    public static ModCommandManager.ModCommand cmd;

    public static void init(ModCommandManager.ModCommand newData){
        cmd = newData;
    }

    public static void registerCommand(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 environment) {
        dispatcher.register(class_2170.method_9247(cmd.name)
                .then(class_2170.method_9244("range", IntegerArgumentType.integer(0))
                        .executes(ctx -> execute(ctx, IntegerArgumentType.getInteger(ctx, "range")))
                        .then(class_2170.method_9244("filter", class_2287.method_9776(registryAccess))
                                .executes(ctx -> execute(ctx, IntegerArgumentType.getInteger(ctx, "range"), class_2287.method_9777(ctx, "filter").method_9785().method_7854()))
                        )
                )
                .executes(CMD_killitems::execute)
                .requires(src->ModCommandManager.canUseCommand(src, cmd))
        );
    }

    private static int execute(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        return execute(ctx, 0, null);
    }
    private static int execute(CommandContext<class_2168> ctx, int range) throws CommandSyntaxException {
        return execute(ctx, range, null);
    }
    private static int execute(CommandContext<class_2168> ctx, int range, @Nullable class_1799 filter) throws CommandSyntaxException {
        class_2168 src = ctx.getSource();

        int rangeConfigValue = (int) Double.parseDouble(ConfigManager.loadConfig(src.method_9211()).fields.get("killitemsRangeLimit").toString());
        if(range > rangeConfigValue){
            src.method_9213(class_2561.method_43469("commands.killitems.error.rangeLimitExceeded", class_2561.method_43470(String.valueOf(range)).method_10862(HelpfulCommands.style.primary), class_2561.method_43470(String.valueOf(rangeConfigValue)).method_10862(HelpfulCommands.style.primary)));
            return -1;
        }
        if(range <= 0){
            range = Math.max((rangeConfigValue / 2), 1);
        }

        Map<String, Integer> entries = new HashMap<>();
        if(src.method_9211().method_3760().method_14574() > 0) {
            for (class_3222 i : src.method_9211().method_3760().method_14571()){
                entries.putAll(killItems(src, i.method_5829().method_1014(range), filter));
            }
        } else{
            entries.putAll(killItems(src, new class_238(src.method_9225().method_74854().method_74897()).method_1014(range), filter));
        }

        int count = 0;

        String entryList = "";
        for(Map.Entry<String, Integer> i : entries.entrySet()){
            entryList += i.getValue() + "x " + i.getKey() + "\n";
            count += i.getValue();
        }
        if(!entryList.isEmpty()){
            entryList = entryList.substring(0, entryList.length() - 1);
        }

        if(count > 0) {
            class_5250 finalCount = class_2561.method_43470(String.valueOf(count)).method_10862(HelpfulCommands.style.primary
                    .method_10949(new class_2568.class_10613(class_2561.method_43470(entryList)))
            );
            int finalRange = range;
            src.method_9226(() -> class_2561.method_43469("commands.killitems.success", finalCount, class_2561.method_43470(String.valueOf(finalRange)).method_10862(HelpfulCommands.style.primary)).method_10862(HelpfulCommands.style.success), true);
        } else{
            src.method_9213(class_2561.method_43469("commands.killitems.error.nothingFound", class_2561.method_43470(String.valueOf(range)).method_10862(HelpfulCommands.style.primary)).method_10862(HelpfulCommands.style.error));
        }

        return Command.SINGLE_SUCCESS;
    }

    private static Map<String, Integer> killItems(class_2168 src, class_238 b, @Nullable class_1799 filter) {
        Map<String, Integer> entries = new HashMap<>();

        class_3218 world = src.method_9225();

        for(class_1542 i : world.method_18023(class_1299.field_6052, b, entity -> (filter == null || entity.method_6983().method_31574(filter.method_7909())))) {
            i.method_5768(world);
            String name = i.method_5477().getString();
            entries.put(name, entries.getOrDefault(name,0) + 1);
        }

        return entries;
    }
}