/*
 * Decompiled with CFR 0.152.
 */
package com.expecticament.helpfulcommands.command;

import com.expecticament.helpfulcommands.helper.PermissionHelper;
import com.expecticament.helpfulcommands.manager.ConfigManager;
import com.expecticament.helpfulcommands.manager.ModCommandManager;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;

public abstract class HelpfulCommandsCommand {
    protected static final SimpleCommandExceptionType SELECTOR_REQUIRED = new SimpleCommandExceptionType((Message)Component.translatable((String)"error.helpful_commands.selectorRequired"));
    protected static final SimpleCommandExceptionType NO_ITEMS_FOUND = new SimpleCommandExceptionType((Message)Component.translatable((String)"error.helpful_commands.noItemsFound"));
    protected static final SimpleCommandExceptionType UNKNOWN_DIMENSION = new SimpleCommandExceptionType((Message)Component.translatable((String)"error.helpful_commands.unknownDimension"));
    protected static final SimpleCommandExceptionType EMPTY_ITEMSTACK_MAINHAND = new SimpleCommandExceptionType((Message)Component.translatable((String)"error.helpful_commands.emptyItemStack.mainHand"));
    private final ModCommandManager.CommandData data;

    public HelpfulCommandsCommand(ModCommandManager.CommandData commandData) {
        this.data = commandData;
    }

    public ModCommandManager.CommandData getCommandData() {
        return this.data;
    }

    public abstract void register(CommandDispatcher<CommandSourceStack> var1, CommandBuildContext var2, Commands.CommandSelection var3);

    public abstract boolean canExecuteBaseCommand(CommandSourceStack var1);

    public boolean canExecute(CommandSourceStack source) {
        return this.canExecute(source, "", this.data.getDefaultOpLevel());
    }

    public boolean canExecute(CommandSourceStack source, String permCheckAppend) {
        return this.canExecute(source, permCheckAppend, this.data.getDefaultOpLevel());
    }

    public boolean canExecute(CommandSourceStack source, String permCheckAppend, int permLevelOverride) {
        if (this.data.getCategory() == ModCommandManager.CommandCategory.MAIN) {
            return true;
        }
        ConfigManager.HelpfulCommandsConfig config = ConfigManager.readConfig();
        if (!config.getCommandState(this.data.getName())) {
            return false;
        }
        if (!((String)permCheckAppend).isEmpty()) {
            permCheckAppend = "." + (String)permCheckAppend;
        }
        return PermissionHelper.hasPermission(source, "helpful_commands.command." + this.data.getCategory().toString().toLowerCase() + "." + this.data.getName() + (String)permCheckAppend, permLevelOverride);
    }

    protected ServerPlayer validatePlayerOnly(CommandSourceStack source) throws CommandSyntaxException {
        return source.getPlayerOrException();
    }

    protected ServerPlayer validateAnySource(CommandSourceStack source) {
        return source.getPlayer();
    }
}

