/*
 * Decompiled with CFR 0.152.
 */
package com.expecticament.helpfulcommands.command.abilities;

import com.expecticament.helpfulcommands.command.HelpfulCommandsCommand;
import com.expecticament.helpfulcommands.helper.StylingHelper;
import com.expecticament.helpfulcommands.manager.ModCommandManager;
import com.expecticament.helpfulcommands.manager.StylingManager;
import com.expecticament.helpfulcommands.manager.TranslationManager;
import com.expecticament.helpfulcommands.style.HelpfulCommandsStyle;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandExceptionType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Abilities;
import net.minecraft.world.level.GameRules;

public class CMD_god
extends HelpfulCommandsCommand {
    public CMD_god(ModCommandManager.CommandData commandData) {
        super(commandData);
    }

    @Override
    public void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext buildContext, Commands.CommandSelection commandSelection) {
        ModCommandManager.CommandData commandData = this.getCommandData();
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)commandData.getName()).requires(this::canExecuteBaseCommand)).then(((RequiredArgumentBuilder)Commands.argument((String)"state", (ArgumentType)BoolArgumentType.bool()).then(((RequiredArgumentBuilder)Commands.argument((String)"players", (ArgumentType)EntityArgument.players()).requires(src -> this.canExecute((CommandSourceStack)src, "other"))).executes(ctx -> this.execute((CommandContext<CommandSourceStack>)ctx, BoolArgumentType.getBool((CommandContext)ctx, (String)"state"), EntityArgument.getPlayers((CommandContext)ctx, (String)"players"))))).executes(ctx -> this.execute((CommandContext<CommandSourceStack>)ctx, BoolArgumentType.getBool((CommandContext)ctx, (String)"state"))))).executes(this::execute));
    }

    @Override
    public boolean canExecuteBaseCommand(CommandSourceStack source) {
        return this.canExecute(source) || this.canExecute(source, "other");
    }

    private int execute(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        return this.execute(ctx, null, null);
    }

    private int execute(CommandContext<CommandSourceStack> ctx, Boolean state) throws CommandSyntaxException {
        return this.execute(ctx, state, null);
    }

    private int execute(CommandContext<CommandSourceStack> ctx, Boolean state, Collection<ServerPlayer> players) throws CommandSyntaxException {
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        ServerPlayer sourcePlayer = this.validateAnySource(src);
        ArrayList targets = new ArrayList(Objects.requireNonNullElse(players, List.of()));
        HelpfulCommandsStyle.TextStyles textStyles = StylingManager.getCurrentStyle().getTextStyles();
        boolean commandFeedback = src.getLevel().getGameRules().getBoolean(GameRules.RULE_SENDCOMMANDFEEDBACK);
        if (targets.isEmpty() || targets.size() == 1 && sourcePlayer != null && targets.contains(sourcePlayer)) {
            if (sourcePlayer == null) {
                throw new CommandSyntaxException((CommandExceptionType)SELECTOR_REQUIRED, (Message)Component.literal((String)TranslationManager.translate(src, "error.helpful_commands.selectorRequired")));
            }
            this.toggleInvulnerabilityAndSendMessage(sourcePlayer, src, state, textStyles, commandFeedback, true, true);
            return 1;
        }
        List<ServerPlayer> affected = targets.stream().filter(p -> this.toggleInvulnerabilityAndSendMessage((ServerPlayer)p, src, state, textStyles, commandFeedback, p == sourcePlayer, false)).toList();
        if (affected.isEmpty()) {
            throw EntityArgument.NO_PLAYERS_FOUND.create();
        }
        MutableComponent stateText = Component.literal((String)TranslationManager.translate(src, "commands.helpful_commands.god.output.success." + String.valueOf(state).toLowerCase()));
        MutableComponent affectedText = Component.empty();
        if (affected.size() == 1) {
            affectedText.append(StylingHelper.getAffectedEntityNameText((Entity)affected.getFirst()));
        } else {
            affectedText.append(StylingHelper.getAffectedEntitiesNumberText(affected)).append(" ").append(TranslationManager.translate(src, "commands.helpful_commands.god.output.success.multiple"));
        }
        TranslationManager.TextBuilder textBuilder = new TranslationManager.TextBuilder(src);
        textBuilder.appendTranslatable("commands.helpful_commands.god.output.success.other", new Component[]{stateText, affectedText});
        textBuilder.setStyle(textStyles.getSuccess());
        src.sendSuccess(textBuilder::getComponent, true);
        return affected.size();
    }

    private boolean toggleInvulnerabilityAndSendMessage(ServerPlayer player, CommandSourceStack commandSourceStack, Boolean state, HelpfulCommandsStyle.TextStyles textStyles, boolean commandFeedback, boolean isSource, boolean feedbackSource) {
        boolean finalState;
        Abilities abilities = player.getAbilities();
        boolean bl = state != null ? state : (finalState = !abilities.invulnerable);
        if (finalState != abilities.invulnerable) {
            abilities.invulnerable = finalState;
            player.onUpdateAbilities();
            if (commandFeedback) {
                TranslationManager.TextBuilder textBuilder = new TranslationManager.TextBuilder(player);
                textBuilder.setStyle(isSource ? (finalState ? textStyles.getAffectedPositive() : textStyles.getAffectedNeutral()) : textStyles.getAffectedNeutral());
                textBuilder.appendTranslatable("commands.helpful_commands.god.output.success.affected", new Component[]{Component.literal((String)TranslationManager.translate(player, "commands.helpful_commands.god.output.success." + String.valueOf(finalState).toLowerCase()))});
                if (isSource) {
                    if (feedbackSource) {
                        commandSourceStack.sendSuccess(textBuilder::getComponent, true);
                    }
                } else {
                    player.sendSystemMessage((Component)textBuilder.getComponent());
                }
            }
            return true;
        }
        return false;
    }
}

