/*
 * Decompiled with CFR 0.152.
 */
package com.expecticament.helpfulcommands.command.itemsAndInventory;

import com.expecticament.helpfulcommands.command.HelpfulCommandsCommand;
import com.expecticament.helpfulcommands.helper.StylingHelper;
import com.expecticament.helpfulcommands.manager.ModCommandManager;
import com.expecticament.helpfulcommands.manager.StylingManager;
import com.expecticament.helpfulcommands.manager.TranslationManager;
import com.expecticament.helpfulcommands.style.HelpfulCommandsStyle;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandExceptionType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class CMD_invsee
extends HelpfulCommandsCommand {
    protected static final SimpleCommandExceptionType OTHER_PLAYER_ONLY = new SimpleCommandExceptionType((Message)Component.empty());

    public CMD_invsee(ModCommandManager.CommandData commandData) {
        super(commandData);
    }

    @Override
    public void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext buildContext, Commands.CommandSelection commandSelection) {
        ModCommandManager.CommandData commandData = this.getCommandData();
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)commandData.getName()).requires(this::canExecuteBaseCommand)).then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(ctx -> this.execute((CommandContext<CommandSourceStack>)ctx, EntityArgument.getPlayer((CommandContext)ctx, (String)"player")))));
    }

    @Override
    public boolean canExecuteBaseCommand(CommandSourceStack source) {
        return this.canExecute(source);
    }

    private int execute(CommandContext<CommandSourceStack> ctx, ServerPlayer player) throws CommandSyntaxException {
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        ServerPlayer sourcePlayer = this.validatePlayerOnly(src);
        if (sourcePlayer == player) {
            throw new CommandSyntaxException((CommandExceptionType)OTHER_PLAYER_ONLY, (Message)Component.literal((String)TranslationManager.translate(src, "commands.helpful_commands.invsee.error.otherPlayerOnly")));
        }
        TranslationManager.TextBuilder screenTitleTexbuilder = new TranslationManager.TextBuilder(src);
        screenTitleTexbuilder.appendTranslatable("commands.helpful_commands.invsee.screenTitle", new Component[]{Component.literal((String)player.getName().getString())});
        sourcePlayer.openMenu((MenuProvider)new SimpleMenuProvider((syncId, inv, playerEntity) -> new InvseeAbstractContainerMenu(syncId, inv, (Player)player), (Component)screenTitleTexbuilder.getComponent()));
        HelpfulCommandsStyle.TextStyles textStyles = StylingManager.getCurrentStyle().getTextStyles();
        TranslationManager.TextBuilder textBuilder = new TranslationManager.TextBuilder(src);
        textBuilder.appendTranslatable("commands.helpful_commands.invsee", StylingHelper.getAffectedEntityNameText((Entity)player)).setStyle(textStyles.getSuccess());
        src.sendSuccess(textBuilder::getComponent, true);
        return 1;
    }

    private static class InvseeAbstractContainerMenu
    extends AbstractContainerMenu {
        public InvseeAbstractContainerMenu(int syncId, Inventory sourceInventory, Player target) {
            super(MenuType.GENERIC_9x5, syncId);
            int i;
            Inventory targetInventory = target.getInventory();
            Inventory emptySlotInventory = new Inventory(target, null);
            this.addStandardInventorySlots((Container)targetInventory, 0, 0);
            for (i = 0; i < 2; ++i) {
                this.addSlot(new EmptySlot(emptySlotInventory, 0, 0, 0));
            }
            for (i = 0; i < 5; ++i) {
                this.addSlot(new Slot((Container)targetInventory, 36 + i, 0, 0));
            }
            for (i = 0; i < 2; ++i) {
                this.addSlot(new EmptySlot(emptySlotInventory, 0, 0, 0));
            }
            this.addStandardInventorySlots((Container)sourceInventory, 0, 0);
        }

        public ItemStack quickMoveStack(Player player, int slotIndex) {
            ItemStack newStack = ItemStack.EMPTY;
            Slot slot = (Slot)this.slots.get(slotIndex);
            if (slot.hasItem()) {
                ItemStack originalStack = slot.getItem();
                newStack = originalStack.copy();
                int targetSlotCount = 45;
                int totalSlots = this.slots.size();
                if (slotIndex < targetSlotCount ? !this.moveItemStackTo(originalStack, targetSlotCount, totalSlots, true) : !this.moveItemStackTo(originalStack, 0, targetSlotCount, false)) {
                    return ItemStack.EMPTY;
                }
                if (originalStack.isEmpty()) {
                    slot.set(ItemStack.EMPTY);
                } else {
                    slot.setChanged();
                }
            }
            return newStack;
        }

        public boolean stillValid(Player player) {
            return true;
        }
    }

    public static class EmptySlot
    extends Slot {
        public EmptySlot(Inventory inventory, int index, int x, int y) {
            super((Container)inventory, index, x, y);
            ItemStack itemStack = new ItemStack((ItemLike)Items.BARRIER);
            itemStack.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)TranslationManager.translate((ServerPlayer)inventory.player, "commands.helpful_commands.invsee.emptySlot")).setStyle(Style.EMPTY.withColor(ChatFormatting.RED)));
            this.set(itemStack);
        }

        public boolean mayPlace(ItemStack stack) {
            return false;
        }

        public boolean mayPickup(Player playerEntity) {
            return false;
        }
    }
}

