/*
 * Decompiled with CFR 0.152.
 */
package com.expecticament.helpfulcommands.command.itemsAndInventory;

import com.expecticament.helpfulcommands.command.HelpfulCommandsCommand;
import com.expecticament.helpfulcommands.helper.StylingHelper;
import com.expecticament.helpfulcommands.manager.ModCommandManager;
import com.expecticament.helpfulcommands.manager.StylingManager;
import com.expecticament.helpfulcommands.manager.TranslationManager;
import com.expecticament.helpfulcommands.style.HelpfulCommandsStyle;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandExceptionType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;

public class CMD_rename
extends HelpfulCommandsCommand {
    public CMD_rename(ModCommandManager.CommandData commandData) {
        super(commandData);
    }

    @Override
    public void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext buildContext, Commands.CommandSelection commandSelection) {
        ModCommandManager.CommandData commandData = this.getCommandData();
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)commandData.getName()).requires(this::canExecuteBaseCommand)).then(((RequiredArgumentBuilder)Commands.argument((String)"new_name", (ArgumentType)StringArgumentType.string()).executes(ctx -> this.execute((CommandContext<CommandSourceStack>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"new_name")))).then(((RequiredArgumentBuilder)Commands.argument((String)"players", (ArgumentType)EntityArgument.players()).requires(src -> this.canExecute((CommandSourceStack)src, "other"))).executes(ctx -> this.execute((CommandContext<CommandSourceStack>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"new_name"), EntityArgument.getPlayers((CommandContext)ctx, (String)"players"))))));
    }

    @Override
    public boolean canExecuteBaseCommand(CommandSourceStack source) {
        return this.canExecute(source) || this.canExecute(source, "other");
    }

    private int execute(CommandContext<CommandSourceStack> ctx, String newName) throws CommandSyntaxException {
        return this.execute(ctx, newName, null);
    }

    private int execute(CommandContext<CommandSourceStack> ctx, String newName, Collection<ServerPlayer> players) throws CommandSyntaxException {
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        ServerPlayer sourcePlayer = this.validateAnySource(src);
        ArrayList targets = new ArrayList(Objects.requireNonNullElse(players, List.of()));
        HelpfulCommandsStyle.TextStyles textStyles = StylingManager.getCurrentStyle().getTextStyles();
        boolean commandFeedback = src.getLevel().getGameRules().getBoolean(GameRules.RULE_SENDCOMMANDFEEDBACK);
        if (targets.isEmpty() || targets.size() == 1 && sourcePlayer != null && targets.contains(sourcePlayer)) {
            if (sourcePlayer == null) {
                throw new CommandSyntaxException((CommandExceptionType)SELECTOR_REQUIRED, (Message)Component.literal((String)TranslationManager.translate(src, "error.helpful_commands.selectorRequired")));
            }
            this.renameAndSendMessage(sourcePlayer, src, newName, textStyles, commandFeedback, true, true);
            return 1;
        }
        HashMap<ServerPlayer, String> affected = new HashMap<ServerPlayer, String>();
        Iterator iterator = targets.iterator();
        while (iterator.hasNext()) {
            ServerPlayer player;
            ItemStack itemStack = this.renameAndSendMessage(player, src, newName, textStyles, commandFeedback, (player = (ServerPlayer)iterator.next()) == sourcePlayer, false);
            if (itemStack.isEmpty()) continue;
            affected.put(player, itemStack.getItemName().getString());
        }
        if (affected.isEmpty()) {
            throw EntityArgument.NO_PLAYERS_FOUND.create();
        }
        MutableComponent newItemNameComponent = Component.literal((String)newName).setStyle(textStyles.getPrimary());
        TranslationManager.DeprecatedTextBuilder textBuilder = new TranslationManager.DeprecatedTextBuilder(src);
        textBuilder.setStyle(textStyles.getSuccess());
        if (newName.isEmpty()) {
            textBuilder.appendTranslatable("commands.helpful_commands.rename.remove.output.success.other.part1").appendWhitespace();
            if (affected.size() == 1) {
                affectedPlayerNameText = StylingHelper.getAffectedEntityNameText((Entity)affected.keySet().iterator().next());
                MutableComponent itemNameText = Component.literal((String)((String)affected.values().iterator().next())).setStyle(textStyles.getPrimary());
                textBuilder.appendComponent(affectedPlayerNameText).appendTranslatable("commands.helpful_commands.rename.remove.output.success.other.part2.single").appendWhitespace().appendComponent((Component)itemNameText);
            } else {
                textBuilder.appendComponent(StylingHelper.getAffectedEntitiesNumberText(affected)).appendWhitespace().appendTranslatable("commands.helpful_commands.rename.remove.output.success.other.part2.multiple");
            }
        } else {
            textBuilder.appendTranslatable("commands.helpful_commands.rename.output.success.other.part1").appendWhitespace();
            if (affected.size() == 1) {
                affectedPlayerNameText = StylingHelper.getAffectedEntityNameText((Entity)affected.keySet().iterator().next());
                MutableComponent itemNameText = Component.literal((String)((String)affected.values().iterator().next())).setStyle(textStyles.getPrimary());
                textBuilder.appendComponent(affectedPlayerNameText).appendTranslatable("commands.helpful_commands.rename.output.success.other.part2.single").appendWhitespace().appendComponent((Component)itemNameText).appendWhitespace().appendTranslatable("commands.helpful_commands.rename.output.success.self.part2").appendWhitespace().appendComponent((Component)newItemNameComponent);
            } else {
                textBuilder.appendComponent(StylingHelper.getAffectedEntitiesNumberText(affected)).appendWhitespace().appendTranslatable("commands.helpful_commands.rename.output.success.other.part2.multiple").appendWhitespace().appendTranslatable("commands.helpful_commands.rename.output.success.self.part2").appendWhitespace().appendComponent((Component)newItemNameComponent);
            }
        }
        src.sendSuccess(textBuilder::getComponent, true);
        return affected.size();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ItemStack renameAndSendMessage(ServerPlayer player, CommandSourceStack commandSourceStack, String newName, HelpfulCommandsStyle.TextStyles textStyles, boolean commandFeedback, boolean isSource, boolean feedbackSource) {
        String oldItemName;
        ItemStack itemStack = player.getMainHandItem();
        if (itemStack.isEmpty()) return ItemStack.EMPTY;
        Component oldCustomName = itemStack.getCustomName();
        String string = oldItemName = oldCustomName != null ? oldCustomName.getString() : itemStack.getItemName().getString();
        if (oldItemName.equals(newName)) {
            return ItemStack.EMPTY;
        }
        MutableComponent oldItemNameComponent = Component.literal((String)oldItemName).setStyle(textStyles.getPrimary());
        MutableComponent newItemNameComponent = Component.literal((String)newName).setStyle(textStyles.getPrimary());
        boolean remove = newName.isEmpty();
        if (remove) {
            if (itemStack.get(DataComponents.CUSTOM_NAME) == null) return ItemStack.EMPTY;
            itemStack.remove(DataComponents.CUSTOM_NAME);
        } else {
            itemStack.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)newName));
        }
        if (!commandFeedback) return itemStack;
        if (isSource) {
            if (!feedbackSource) return itemStack;
            TranslationManager.DeprecatedTextBuilder textBuilder = new TranslationManager.DeprecatedTextBuilder(player);
            textBuilder.setStyle(textStyles.getAffectedPositive());
            if (remove) {
                textBuilder.appendTranslatable("commands.helpful_commands.rename.remove.output.success.self").appendWhitespace().appendComponent((Component)oldItemNameComponent);
            } else {
                textBuilder.appendTranslatable("commands.helpful_commands.rename.output.success.self.part1").appendWhitespace().appendComponent((Component)oldItemNameComponent).appendWhitespace().appendTranslatable("commands.helpful_commands.rename.output.success.self.part2").appendWhitespace().appendComponent((Component)newItemNameComponent);
            }
            commandSourceStack.sendSuccess(textBuilder::getComponent, true);
            return itemStack;
        } else {
            TranslationManager.DeprecatedTextBuilder textBuilder = new TranslationManager.DeprecatedTextBuilder(player);
            textBuilder.setStyle(textStyles.getAffectedNeutral());
            if (remove) {
                textBuilder.appendTranslatable("commands.helpful_commands.rename.remove.output.success.affected.part1").appendWhitespace().appendComponent((Component)oldItemNameComponent).appendTranslatable("commands.helpful_commands.rename.remove.output.success.affected.part2");
            } else {
                textBuilder.appendTranslatable("commands.helpful_commands.rename.output.success.affected.part1").appendWhitespace().appendComponent((Component)oldItemNameComponent).appendWhitespace().appendTranslatable("commands.helpful_commands.rename.output.success.affected.part2").appendWhitespace().appendComponent((Component)newItemNameComponent);
            }
            player.sendSystemMessage((Component)textBuilder.getComponent());
        }
        return itemStack;
    }
}

