/*
 * Decompiled with CFR 0.152.
 */
package com.expecticament.helpfulcommands.command.itemsAndInventory;

import com.expecticament.helpfulcommands.command.HelpfulCommandsCommand;
import com.expecticament.helpfulcommands.helper.StylingHelper;
import com.expecticament.helpfulcommands.manager.ModCommandManager;
import com.expecticament.helpfulcommands.manager.StylingManager;
import com.expecticament.helpfulcommands.manager.TranslationManager;
import com.expecticament.helpfulcommands.style.HelpfulCommandsStyle;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandExceptionType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;

public class CMD_smelt
extends HelpfulCommandsCommand {
    public CMD_smelt(ModCommandManager.CommandData commandData) {
        super(commandData);
    }

    @Override
    public void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext buildContext, Commands.CommandSelection commandSelection) {
        ModCommandManager.CommandData commandData = this.getCommandData();
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)commandData.getName()).requires(this::canExecuteBaseCommand)).then(((RequiredArgumentBuilder)Commands.argument((String)"players", (ArgumentType)EntityArgument.players()).requires(src -> this.canExecute((CommandSourceStack)src, "other"))).executes(ctx -> this.execute((CommandContext<CommandSourceStack>)ctx, EntityArgument.getPlayers((CommandContext)ctx, (String)"players"))))).executes(this::execute));
    }

    @Override
    public boolean canExecuteBaseCommand(CommandSourceStack source) {
        return this.canExecute(source) || this.canExecute(source, "other");
    }

    private int execute(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        return this.execute(ctx, null);
    }

    private int execute(CommandContext<CommandSourceStack> ctx, Collection<ServerPlayer> players) throws CommandSyntaxException {
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        ServerPlayer sourcePlayer = this.validateAnySource(src);
        ArrayList targets = new ArrayList(Objects.requireNonNullElse(players, List.of()));
        HelpfulCommandsStyle.TextStyles textStyles = StylingManager.getCurrentStyle().getTextStyles();
        boolean commandFeedback = src.getLevel().getGameRules().getBoolean(GameRules.RULE_SENDCOMMANDFEEDBACK);
        if (targets.isEmpty() || targets.size() == 1 && sourcePlayer != null && targets.contains(sourcePlayer)) {
            if (sourcePlayer == null) {
                throw new CommandSyntaxException((CommandExceptionType)SELECTOR_REQUIRED, (Message)Component.literal((String)TranslationManager.translate(src, "error.helpful_commands.selectorRequired")));
            }
            this.smeltAndSendMessage(sourcePlayer, src, textStyles, commandFeedback, true, true);
            return 1;
        }
        HashMap<ServerPlayer, String> affected = new HashMap<ServerPlayer, String>();
        Iterator iterator = targets.iterator();
        while (iterator.hasNext()) {
            ServerPlayer player;
            ItemStack itemStack = this.smeltAndSendMessage(player, src, textStyles, commandFeedback, (player = (ServerPlayer)iterator.next()) == sourcePlayer, false);
            if (itemStack.isEmpty()) continue;
            affected.put(player, itemStack.getItemName().getString());
        }
        if (affected.isEmpty()) {
            throw EntityArgument.NO_PLAYERS_FOUND.create();
        }
        TranslationManager.DeprecatedTextBuilder textBuilder = new TranslationManager.DeprecatedTextBuilder(src);
        textBuilder.setStyle(textStyles.getSuccess());
        textBuilder.appendTranslatable("commands.helpful_commands.smelt.output.success.other.part1").appendWhitespace();
        if (affected.size() == 1) {
            Component affectedPlayerNameText = StylingHelper.getAffectedEntityNameText((Entity)affected.keySet().iterator().next());
            MutableComponent itemNameText = Component.literal((String)((String)affected.values().iterator().next())).setStyle(textStyles.getPrimary());
            textBuilder.appendComponent(affectedPlayerNameText).appendTranslatable("commands.helpful_commands.smelt.output.success.other.part2.single").appendWhitespace().appendComponent((Component)itemNameText);
        } else {
            textBuilder.appendComponent(StylingHelper.getAffectedEntitiesNumberText(affected)).appendWhitespace().appendTranslatable("commands.helpful_commands.smelt.output.success.other.part2.multiple");
        }
        src.sendSuccess(textBuilder::getComponent, true);
        return affected.size();
    }

    private ItemStack smeltAndSendMessage(ServerPlayer player, CommandSourceStack commandSourceStack, HelpfulCommandsStyle.TextStyles textStyles, boolean commandFeedback, boolean isSource, boolean feedbackSource) {
        ItemStack itemStack = player.getMainHandItem();
        if (!itemStack.isEmpty()) {
            ServerLevel level = player.level();
            SingleRecipeInput input = new SingleRecipeInput(itemStack.copy());
            RecipeManager recipeManager = level.recipeAccess();
            RegistryAccess registryAccess = level.registryAccess();
            Optional optionalRecipe = recipeManager.getRecipeFor(RecipeType.SMELTING, (RecipeInput)input, (Level)level);
            ItemStack output = optionalRecipe.map(holder -> ((SmeltingRecipe)holder.value()).assemble(input, (HolderLookup.Provider)registryAccess)).orElse(ItemStack.EMPTY);
            if (output.isEmpty()) {
                return ItemStack.EMPTY;
            }
            output.setCount(itemStack.getCount());
            player.setItemInHand(InteractionHand.MAIN_HAND, output);
            String itemName = itemStack.getItemName().getString();
            MutableComponent itemNameComponent = Component.literal((String)itemName).setStyle(textStyles.getPrimary());
            if (commandFeedback) {
                if (isSource) {
                    if (feedbackSource) {
                        TranslationManager.DeprecatedTextBuilder textBuilder = new TranslationManager.DeprecatedTextBuilder(player);
                        textBuilder.setStyle(textStyles.getAffectedPositive());
                        textBuilder.appendTranslatable("commands.helpful_commands.smelt.output.success.self").appendWhitespace().appendComponent((Component)itemNameComponent);
                        commandSourceStack.sendSuccess(textBuilder::getComponent, true);
                    }
                } else {
                    TranslationManager.DeprecatedTextBuilder textBuilder = new TranslationManager.DeprecatedTextBuilder(player);
                    textBuilder.setStyle(textStyles.getAffectedPositive());
                    textBuilder.appendTranslatable("commands.helpful_commands.smelt.output.success.affected.part1").appendWhitespace().appendComponent((Component)itemNameComponent).appendWhitespace().appendTranslatable("commands.helpful_commands.smelt.output.success.affected.part2");
                    player.sendSystemMessage((Component)textBuilder.getComponent());
                }
            }
            return itemStack;
        }
        return ItemStack.EMPTY;
    }
}

