/*
 * Decompiled with CFR 0.152.
 */
package com.expecticament.helpfulcommands.command.main;

import com.expecticament.helpfulcommands.HelpfulCommands;
import com.expecticament.helpfulcommands.command.HelpfulCommandsCommand;
import com.expecticament.helpfulcommands.helper.PermissionHelper;
import com.expecticament.helpfulcommands.helper.StylingHelper;
import com.expecticament.helpfulcommands.manager.ConfigManager;
import com.expecticament.helpfulcommands.manager.ModCommandManager;
import com.expecticament.helpfulcommands.manager.StylingManager;
import com.expecticament.helpfulcommands.manager.TranslationManager;
import com.expecticament.helpfulcommands.style.HelpfulCommandsStyle;
import com.expecticament.helpfulcommands.suggestionProvider.HelpfulCommandsCommandSuggestionProvider;
import com.expecticament.helpfulcommands.suggestionProvider.StyleSuggestionProvider;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandExceptionType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.tree.CommandNode;
import java.net.URI;
import java.util.List;
import java.util.Map;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;

public class CMD_hc
extends HelpfulCommandsCommand {
    protected static final SimpleCommandExceptionType INVALID_HC_COMMAND = new SimpleCommandExceptionType((Message)Component.empty());
    protected static final SimpleCommandExceptionType STYLE_DOESNT_EXIST = new SimpleCommandExceptionType((Message)Component.empty());
    protected static final SimpleCommandExceptionType STYLE_ALREADY_IN_USE = new SimpleCommandExceptionType((Message)Component.empty());
    protected static final SimpleCommandExceptionType COMMAND_NOT_CONFIGURABLE = new SimpleCommandExceptionType((Message)Component.empty());

    public CMD_hc(ModCommandManager.CommandData commandData) {
        super(commandData);
    }

    @Override
    public void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext buildContext, Commands.CommandSelection commandSelection) {
        ModCommandManager.CommandData commandData = this.getCommandData();
        LiteralArgumentBuilder configField = Commands.literal((String)"field");
        configField.requires(src -> PermissionHelper.canConfigure(src, "field"));
        for (Map.Entry<String, ConfigManager.ConfigFieldProperties> entry : ConfigManager.DEFAULT_FIELDS.entrySet()) {
            String name = entry.getKey();
            ConfigManager.ConfigFieldProperties properties = entry.getValue();
            LiteralArgumentBuilder field = Commands.literal((String)entry.getKey());
            LiteralArgumentBuilder setArgument = Commands.literal((String)"set");
            switch (properties.valueType) {
                case Double: {
                    setArgument.then(Commands.argument((String)"value", (ArgumentType)DoubleArgumentType.doubleArg((double)properties.min, (double)properties.max)).executes(ctx -> this.setConfigField((CommandContext<CommandSourceStack>)ctx, name, DoubleArgumentType.getDouble((CommandContext)ctx, (String)"value"))));
                    break;
                }
                case Integer: {
                    setArgument.then(Commands.argument((String)"value", (ArgumentType)IntegerArgumentType.integer((int)properties.min.intValue(), (int)properties.max.intValue())).executes(ctx -> this.setConfigField((CommandContext<CommandSourceStack>)ctx, name, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"value"))));
                    break;
                }
                case Boolean: {
                    setArgument.then(Commands.argument((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> this.setConfigField((CommandContext<CommandSourceStack>)ctx, name, BoolArgumentType.getBool((CommandContext)ctx, (String)"value"))));
                }
            }
            ((LiteralArgumentBuilder)((LiteralArgumentBuilder)field.then((ArgumentBuilder)setArgument)).then(Commands.literal((String)"reset").executes(ctx -> this.setConfigField((CommandContext<CommandSourceStack>)ctx, name, properties.defaultValue)))).then(Commands.literal((String)"query").executes(ctx -> this.queryConfigField((CommandContext<CommandSourceStack>)ctx, name)));
            configField.then((ArgumentBuilder)field);
        }
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)commandData.getName()).then(Commands.literal((String)"about").executes(this::about))).then(Commands.literal((String)"commandList").executes(ctx -> this.commandList((CommandContext<CommandSourceStack>)ctx, dispatcher)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"config").requires(PermissionHelper::canConfigure)).executes(this::config)).then((ArgumentBuilder)configField)).then(((LiteralArgumentBuilder)Commands.literal((String)"command").requires(src -> PermissionHelper.canConfigure(src, "command") || PermissionHelper.canConfigure(src, "command.state"))).then(Commands.literal((String)"state").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"command", (ArgumentType)StringArgumentType.word()).requires(src -> PermissionHelper.canConfigure(src, "command.state"))).suggests((SuggestionProvider)new HelpfulCommandsCommandSuggestionProvider()).then(Commands.argument((String)"new_state", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> this.setCommandState((CommandContext<CommandSourceStack>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"command"), BoolArgumentType.getBool((CommandContext)ctx, (String)"new_state"))))).executes(ctx -> this.queryCommandState((CommandContext<CommandSourceStack>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"command"))))))).then(((LiteralArgumentBuilder)Commands.literal((String)"styling").requires(src -> PermissionHelper.canConfigure(src, "styling"))).then(((LiteralArgumentBuilder)Commands.literal((String)"style").then(Commands.literal((String)"set").then(Commands.argument((String)"style_name", (ArgumentType)StringArgumentType.word()).suggests((SuggestionProvider)new StyleSuggestionProvider()).executes(ctx -> this.setStyle((CommandContext<CommandSourceStack>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"style_name")))))).then(Commands.literal((String)"query").executes(this::queryStyle)))))).executes(this::about));
    }

    @Override
    public boolean canExecuteBaseCommand(CommandSourceStack source) {
        return true;
    }

    private int about(CommandContext<CommandSourceStack> ctx) {
        MutableComponent modrinthComponent;
        MutableComponent curseForgeComponent;
        MutableComponent gitHubComponent;
        MutableComponent docsComponent;
        MutableComponent authorComponent;
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        boolean isPlayer = src.isPlayer();
        HelpfulCommandsStyle hcStyle = StylingManager.getCurrentStyle();
        HelpfulCommandsStyle.TextStyles textStyles = hcStyle.getTextStyles();
        HelpfulCommandsStyle.TextDecorators textDecorators = hcStyle.getTextDecorators();
        HoverEvent.ShowText linkHoverEvent = new HoverEvent.ShowText((Component)Component.literal((String)TranslationManager.translate(src, "hover.helpful_commands.clickToOpenTheLink")));
        Component quickActionCommandListBtn = StylingHelper.getButton("\ud83d\udcc3", (Component)Component.literal((String)TranslationManager.translate(src, "commands.helpful_commands.hc.about.actions.commandList")), (HoverEvent)new HoverEvent.ShowText((Component)Component.literal((String)TranslationManager.translate(src, "commands.helpful_commands.hc.about.hover.commandList"))), (ClickEvent)new ClickEvent.RunCommand("/hc commandList"));
        Component quickActionConfigureBtn = StylingHelper.getButton("\ud83d\udd27", (Component)Component.literal((String)TranslationManager.translate(src, "commands.helpful_commands.hc.about.actions.config")), (HoverEvent)new HoverEvent.ShowText((Component)Component.literal((String)TranslationManager.translate(src, "commands.helpful_commands.hc.about.hover.config"))), (ClickEvent)new ClickEvent.RunCommand("/hc config"));
        String linkSeparator = isPlayer ? " " + textDecorators.getBulletPoint() : "\n";
        String authorLink = "https://expecticament.com";
        String docsLink = "https://helpfulcommands.expecticament.com";
        String gitHubLink = "https://github.com/Expecticament/helpful-commands";
        String curseForgeLink = "https://www.curseforge.com/minecraft/mc-mods/helpful-commands";
        String modrinthLink = "https://modrinth.com/mod/helpful-commands";
        if (isPlayer) {
            authorComponent = Component.literal((String)"Expecticament").setStyle(textStyles.getSecondary().withUnderlined(Boolean.valueOf(true)).withHoverEvent((HoverEvent)linkHoverEvent).withClickEvent((ClickEvent)new ClickEvent.OpenUrl(URI.create(authorLink))));
            docsComponent = Component.literal((String)TranslationManager.translate(src, "commands.helpful_commands.hc.about.docs")).setStyle(textStyles.getSecondary().withUnderlined(Boolean.valueOf(true)).withHoverEvent((HoverEvent)linkHoverEvent).withClickEvent((ClickEvent)new ClickEvent.OpenUrl(URI.create(docsLink))));
            gitHubComponent = Component.literal((String)"GitHub").setStyle(textStyles.getSecondary().withUnderlined(Boolean.valueOf(true)).withHoverEvent((HoverEvent)linkHoverEvent).withClickEvent((ClickEvent)new ClickEvent.OpenUrl(URI.create(gitHubLink))));
            curseForgeComponent = Component.literal((String)"CurseForge").setStyle(textStyles.getSecondary().withUnderlined(Boolean.valueOf(true)).withHoverEvent((HoverEvent)linkHoverEvent).withClickEvent((ClickEvent)new ClickEvent.OpenUrl(URI.create(curseForgeLink))));
            modrinthComponent = Component.literal((String)"Modrinth").setStyle(textStyles.getSecondary().withUnderlined(Boolean.valueOf(true)).withHoverEvent((HoverEvent)linkHoverEvent).withClickEvent((ClickEvent)new ClickEvent.OpenUrl(URI.create(modrinthLink))));
        } else {
            authorComponent = Component.literal((String)"Expecticament (%s)".formatted(authorLink));
            docsComponent = Component.literal((String)("\n" + TranslationManager.translate(src, "commands.helpful_commands.hc.about.docs"))).append(": %s".formatted(docsLink));
            gitHubComponent = Component.literal((String)"GitHub: %s".formatted(gitHubLink));
            curseForgeComponent = Component.literal((String)"CurseForge: %s".formatted(curseForgeLink));
            modrinthComponent = Component.literal((String)"Modrinth: %s".formatted(modrinthLink));
        }
        TranslationManager.DeprecatedTextBuilder textBuilder = new TranslationManager.DeprecatedTextBuilder(src);
        textBuilder.appendComponent(StylingHelper.getTitle((Component)Component.literal((String)"Helpful Commands"), (Component)Component.literal((String)TranslationManager.translate(src, "commands.helpful_commands.hc.about.title")))).appendNewline().appendWhitespace().appendTranslatable("modmenu.descriptionTranslation.helpful_commands").appendNewline().appendNewline().appendLiteral(textDecorators.getBulletPoint(), textStyles.getTertiary()).appendTranslatable("commands.helpful_commands.hc.about.version", textStyles.getTertiary()).appendWhitespace().appendLiteral(HelpfulCommands.getModVersion(), textStyles.getSecondary()).appendNewline().appendLiteral(textDecorators.getBulletPoint(), textStyles.getTertiary()).appendTranslatable("commands.helpful_commands.hc.about.author", textStyles.getTertiary()).appendWhitespace().appendComponent((Component)authorComponent).appendNewline().appendNewline().appendLiteral(textDecorators.getBulletPoint(), textStyles.getTertiary()).appendTranslatable("commands.helpful_commands.hc.about.links", textStyles.getTertiary()).appendWhitespace().appendComponent((Component)docsComponent).appendLiteral(linkSeparator).appendComponent((Component)gitHubComponent).appendLiteral(linkSeparator).appendComponent((Component)curseForgeComponent).appendLiteral(linkSeparator).appendComponent((Component)modrinthComponent).appendNewline().appendNewline().appendLiteral(textDecorators.getBulletPoint(), textStyles.getTertiary()).appendTranslatable("commands.helpful_commands.hc.about.actions", textStyles.getTertiary());
        if (isPlayer) {
            textBuilder.appendWhitespace().appendComponent(quickActionCommandListBtn);
            if (PermissionHelper.canConfigure(src)) {
                textBuilder.appendWhitespace().appendComponent(quickActionConfigureBtn);
            }
        } else {
            textBuilder.appendNewline().appendTranslatable("commands.helpful_commands.hc.about.actions.commandList").appendLiteral(": /hc commandList").appendNewline().appendTranslatable("commands.helpful_commands.hc.about.actions.config").appendLiteral(": /hc config");
        }
        src.sendSystemMessage((Component)textBuilder.getComponent());
        return 1;
    }

    private int commandList(CommandContext<CommandSourceStack> ctx, CommandDispatcher<CommandSourceStack> dispatcher) {
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        HelpfulCommandsStyle hcStyle = StylingManager.getCurrentStyle();
        HelpfulCommandsStyle.TextStyles textStyles = hcStyle.getTextStyles();
        HelpfulCommandsStyle.TextDecorators textDecorators = hcStyle.getTextDecorators();
        Style categoryStyle = textStyles.getTertiary();
        boolean toggleStateCommandPermission = PermissionHelper.canConfigure(src, "command.state");
        TranslationManager.DeprecatedTextBuilder textBuilder = new TranslationManager.DeprecatedTextBuilder(src);
        textBuilder.appendComponent(StylingHelper.getTitle((Component)Component.literal((String)"Helpful Commands"), (Component)Component.literal((String)TranslationManager.translate(src, "commands.helpful_commands.hc.commandList.title"))));
        ConfigManager.HelpfulCommandsConfig config = ConfigManager.readConfig();
        for (Map.Entry<ModCommandManager.CommandCategory, List<HelpfulCommandsCommand>> entry : ModCommandManager.getCommandListByCategory().entrySet()) {
            if (entry.getKey().equals((Object)ModCommandManager.CommandCategory.MAIN)) continue;
            textBuilder.appendNewline().appendLiteral(textDecorators.getCategoryStartingChar(), categoryStyle).appendTranslatable("command.category.helpful_commands." + entry.getKey().toString().toLowerCase(), categoryStyle);
            HelpfulCommandsCommand lastCommand = entry.getValue().getLast();
            for (HelpfulCommandsCommand command : entry.getValue()) {
                ModCommandManager.CommandData cmdData = command.getCommandData();
                boolean enabled = config.getCommandState(cmdData.getName());
                boolean hasPerms = command.canExecuteBaseCommand(src);
                boolean canUse = enabled && hasPerms;
                textBuilder.appendNewline().appendLiteral(command.equals(lastCommand) ? textDecorators.getCategoryEndingChar() : textDecorators.getCategoryTrailingChar(), categoryStyle);
                if (toggleStateCommandPermission) {
                    HoverEvent cmdStateHoverEvent = this.getCommandStateHoverEvent(src, textStyles, cmdData.getName(), enabled);
                    ClickEvent.RunCommand cmdStateClickEvent = new ClickEvent.RunCommand("/hc config command state " + cmdData.getName() + " " + String.valueOf(!enabled).toLowerCase());
                    Style cmdStateStyle = (enabled ? textStyles.getEnabled() : textStyles.getDisabled()).withHoverEvent(cmdStateHoverEvent).withClickEvent((ClickEvent)cmdStateClickEvent);
                    textBuilder.appendComponent(StylingHelper.getButton((Component)Component.literal((String)(enabled ? textDecorators.getEnabled() : textDecorators.getDisabled())), cmdStateStyle)).appendWhitespace();
                }
                HoverEvent cmdNameHoverEvent = this.getCommandHoverEvent(src, dispatcher, textStyles, command, hasPerms, enabled);
                ClickEvent.SuggestCommand cmdNameClickEvent = canUse ? new ClickEvent.SuggestCommand("/" + cmdData.getName() + " ") : null;
                Style cmdNameStyle = (canUse ? textStyles.getAvailable() : textStyles.getUnavailable()).withHoverEvent(cmdNameHoverEvent).withClickEvent((ClickEvent)cmdNameClickEvent);
                textBuilder.appendLiteral("/" + cmdData.getName(), cmdNameStyle);
            }
        }
        src.sendSystemMessage((Component)textBuilder.getComponent());
        return 1;
    }

    private HoverEvent getCommandHoverEvent(CommandSourceStack src, CommandDispatcher<CommandSourceStack> dispatcher, HelpfulCommandsStyle.TextStyles textStyles, HelpfulCommandsCommand command, boolean hasPerms, boolean enabled) {
        String commandName = command.getCommandData().getName();
        boolean canUse = enabled && hasPerms;
        TranslationManager.DeprecatedTextBuilder textBuilder = new TranslationManager.DeprecatedTextBuilder(src);
        textBuilder.appendLiteral("/" + commandName, canUse ? textStyles.getAvailable() : textStyles.getUnavailable()).appendNewline().appendTranslatable("commands.helpful_commands." + commandName + ".description");
        if (canUse) {
            Map usages;
            MutableComponent usagesText = Component.empty().setStyle(textStyles.getSubtle());
            CommandNode node = dispatcher.getRoot().getChild(commandName);
            if (node != null && !(usages = dispatcher.getSmartUsage(node, (Object)src)).isEmpty()) {
                usagesText.append("\n");
                for (String usage : usages.values()) {
                    usagesText.append((Component)Component.literal((String)("\n/" + commandName + " " + usage)));
                }
            }
            textBuilder.appendComponent((Component)usagesText);
        } else {
            textBuilder.appendNewline().appendNewline().appendTranslatable("commands.helpful_commands.hc.commandList.cantUse", textStyles.getUnavailable()).appendWhitespace().appendLiteral(TranslationManager.translate(src, !enabled ? "error.helpful_commands.commandDisabled" : "error.helpful_commands.notPermitted").toLowerCase(), textStyles.getUnavailable());
        }
        return new HoverEvent.ShowText((Component)textBuilder.getComponent());
    }

    private HoverEvent getCommandStateHoverEvent(CommandSourceStack source, HelpfulCommandsStyle.TextStyles textStyles, String commandName, boolean currentState) {
        TranslationManager.DeprecatedTextBuilder textBuilder = new TranslationManager.DeprecatedTextBuilder(source);
        textBuilder.appendTranslatable("helpful_commands.common." + (currentState ? "enabled" : "disabled"), currentState ? textStyles.getEnabled() : textStyles.getDisabled()).appendNewline().appendNewline().appendTranslatable("commands.helpful_commands.hc.commandList.clickToToggleCommand.part1").appendWhitespace().appendTranslatable("commands.helpful_commands.hc.commandList.clickToToggleCommand.part2." + String.valueOf(currentState).toLowerCase()).appendWhitespace().appendLiteral("/" + commandName, textStyles.getPrimary()).appendWhitespace().appendTranslatable("commands.helpful_commands.hc.commandList.clickToToggleCommand.part3");
        return new HoverEvent.ShowText((Component)textBuilder.getComponent());
    }

    private int config(CommandContext<CommandSourceStack> ctx) {
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        this.validateAnySource(src);
        boolean isPlayer = src.isPlayer();
        HelpfulCommandsStyle currentStyle = StylingManager.getCurrentStyle();
        HelpfulCommandsStyle.TextStyles textStyles = currentStyle.getTextStyles();
        HelpfulCommandsStyle.TextDecorators textDecorators = currentStyle.getTextDecorators();
        MutableComponent bulletPoint = Component.literal((String)textDecorators.getBulletPoint()).setStyle(textStyles.getTertiary());
        TranslationManager.TextBuilder textBuilder = new TranslationManager.TextBuilder(src);
        textBuilder.appendComponent(StylingHelper.getTitle((Component)Component.literal((String)"Helpful Commands"), (Component)Component.literal((String)TranslationManager.translate(src, "commands.helpful_commands.hc.config.title"))));
        if (PermissionHelper.canConfigure(src, "command") || PermissionHelper.canConfigure(src, "command.state")) {
            textBuilder.appendNewline().appendNewline().appendComponent((Component)bulletPoint).appendComponent((Component)Component.literal((String)TranslationManager.translate(src, "commands.helpful_commands.hc.config.command.title")).setStyle(textStyles.getTertiary())).appendNewline().appendWhitespace().appendTranslatable("commands.helpful_commands.hc.config.command.description", new Component[]{Component.literal((String)"/hc config command").setStyle(textStyles.getSecondary().withClickEvent((ClickEvent)new ClickEvent.SuggestCommand("/hc config command ")).withHoverEvent((HoverEvent)new HoverEvent.ShowText((Component)Component.literal((String)TranslationManager.translate(src, "hover.helpful_commands.clickToPasteCommand")))))});
            if (isPlayer) {
                Component commandListBtn = StylingHelper.getButton("\ud83d\udcc3", (Component)Component.literal((String)TranslationManager.translate(src, "commands.helpful_commands.hc.about.actions.commandList")), (HoverEvent)new HoverEvent.ShowText((Component)Component.literal((String)TranslationManager.translate(src, "commands.helpful_commands.hc.about.hover.commandList"))), (ClickEvent)new ClickEvent.RunCommand("/hc commandList"));
                textBuilder.appendNewline().appendWhitespace().appendTranslatable("Tip: Use %s for quick and easy command configuration", commandListBtn);
            }
        }
        if (PermissionHelper.canConfigure(src, "field")) {
            textBuilder.appendNewline().appendNewline().appendComponent((Component)bulletPoint).appendComponent((Component)Component.literal((String)TranslationManager.translate(src, "commands.helpful_commands.hc.config.field.title")).setStyle(textStyles.getTertiary())).appendNewline().appendWhitespace().appendTranslatable("commands.helpful_commands.hc.config.field.description", new Component[]{Component.literal((String)"/hc config field").setStyle(textStyles.getSecondary().withClickEvent((ClickEvent)new ClickEvent.SuggestCommand("/hc config field ")).withHoverEvent((HoverEvent)new HoverEvent.ShowText((Component)Component.literal((String)TranslationManager.translate(src, "hover.helpful_commands.clickToPasteCommand")))))});
        }
        if (PermissionHelper.canConfigure(src, "styling")) {
            textBuilder.appendNewline().appendNewline().appendComponent((Component)bulletPoint).appendComponent((Component)Component.literal((String)TranslationManager.translate(src, "commands.helpful_commands.hc.config.styling.title")).setStyle(textStyles.getTertiary())).appendNewline().appendWhitespace().appendTranslatable("commands.helpful_commands.hc.config.styling.description", new Component[]{Component.literal((String)"/hc config styling").setStyle(textStyles.getSecondary().withClickEvent((ClickEvent)new ClickEvent.SuggestCommand("/hc config styling ")).withHoverEvent((HoverEvent)new HoverEvent.ShowText((Component)Component.literal((String)TranslationManager.translate(src, "hover.helpful_commands.clickToPasteCommand")))))});
        }
        src.sendSystemMessage((Component)textBuilder.getComponent());
        return 1;
    }

    private int setStyle(CommandContext<CommandSourceStack> ctx, String styleName) throws CommandSyntaxException {
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        this.validateAnySource(src);
        HelpfulCommandsStyle currentStyle = StylingManager.getCurrentStyle();
        HelpfulCommandsStyle.TextStyles textStyles = currentStyle.getTextStyles();
        MutableComponent styleNameText = Component.literal((String)styleName).setStyle(textStyles.getPrimary());
        if (currentStyle.getDisplayName().equals(styleName)) {
            throw new CommandSyntaxException((CommandExceptionType)STYLE_ALREADY_IN_USE, (Message)new TranslationManager.TextBuilder(src).appendTranslatable("commands.helpful_commands.hc.config.styling.style.set.error.styleAlreadyInUse", new Component[]{styleNameText}).getComponent());
        }
        try {
            StylingManager.setCurrentStyle(styleName);
            currentStyle = StylingManager.getCurrentStyle();
            textStyles = currentStyle.getTextStyles();
            TranslationManager.TextBuilder textBuilder = new TranslationManager.TextBuilder(src);
            textBuilder.appendTranslatable("commands.helpful_commands.hc.config.styling.style.set", new Component[]{styleNameText}).setStyle(textStyles.getSuccess());
            src.sendSuccess(textBuilder::getComponent, true);
            return 1;
        }
        catch (StylingManager.StyleDoesntExistException e) {
            throw new CommandSyntaxException((CommandExceptionType)STYLE_DOESNT_EXIST, (Message)new TranslationManager.TextBuilder(src).appendTranslatable("commands.helpful_commands.hc.config.styling.style.set.error.styleDoesntExist", new Component[]{styleNameText}).getComponent());
        }
    }

    private int queryStyle(CommandContext<CommandSourceStack> ctx) {
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        this.validateAnySource(src);
        HelpfulCommandsStyle currentStyle = StylingManager.getCurrentStyle();
        HelpfulCommandsStyle.TextStyles textStyles = currentStyle.getTextStyles();
        TranslationManager.TextBuilder textBuilder = new TranslationManager.TextBuilder(src);
        textBuilder.appendTranslatable("commands.helpful_commands.hc.config.styling.style.query", new Component[]{Component.literal((String)currentStyle.getDisplayName()).setStyle(textStyles.getPrimary())}).setStyle(textStyles.getSuccess());
        src.sendSuccess(textBuilder::getComponent, true);
        return 1;
    }

    private int setCommandState(CommandContext<CommandSourceStack> ctx, String command, boolean newState) throws CommandSyntaxException {
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        this.validateAnySource(src);
        HelpfulCommandsStyle.TextStyles textStyles = StylingManager.getCurrentStyle().getTextStyles();
        boolean valid = false;
        for (HelpfulCommandsCommand hcCmd : ModCommandManager.getCommandList()) {
            ModCommandManager.CommandData data = hcCmd.getCommandData();
            if (!data.getName().equals(command)) continue;
            if (data.getCategory() == ModCommandManager.CommandCategory.MAIN) {
                TranslationManager.TextBuilder textBuilder = new TranslationManager.TextBuilder(src);
                textBuilder.appendTranslatable("commands.helpful_commands.hc.config.command.error.commandNotConfigurable", new Component[]{Component.literal((String)command).setStyle(textStyles.getPrimary())});
                throw new CommandSyntaxException((CommandExceptionType)COMMAND_NOT_CONFIGURABLE, (Message)textBuilder.getComponent());
            }
            valid = true;
            break;
        }
        if (!valid) {
            TranslationManager.TextBuilder textBuilder = new TranslationManager.TextBuilder(src);
            textBuilder.appendTranslatable("commands.helpful_commands.hc.config.command.error.invalidCommand", new Component[]{Component.literal((String)command).setStyle(textStyles.getPrimary())});
            throw new CommandSyntaxException((CommandExceptionType)INVALID_HC_COMMAND, (Message)textBuilder.getComponent());
        }
        ConfigManager.HelpfulCommandsConfig config = ConfigManager.readConfig();
        if (config.setCommandState(command, newState)) {
            TranslationManager.TextBuilder textBuilder = new TranslationManager.TextBuilder(src);
            textBuilder.appendTranslatable("commands.helpful_commands.hc.config.command.state.set", new Component[]{Component.literal((String)TranslationManager.translate(src, "commands.helpful_commands.hc.config.command.state." + String.valueOf(newState).toLowerCase())), Component.literal((String)("/" + command)).setStyle(textStyles.getPrimary())});
            textBuilder.setStyle(newState ? textStyles.getEnabled() : textStyles.getDisabled());
            ModCommandManager.sendCommandsToEveryone(src);
            src.sendSuccess(textBuilder::getComponent, true);
            return 1;
        }
        return 0;
    }

    private int queryCommandState(CommandContext<CommandSourceStack> ctx, String command) throws CommandSyntaxException {
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        this.validateAnySource(src);
        HelpfulCommandsStyle.TextStyles textStyles = StylingManager.getCurrentStyle().getTextStyles();
        boolean valid = false;
        for (HelpfulCommandsCommand hcCmd : ModCommandManager.getCommandList()) {
            ModCommandManager.CommandData data = hcCmd.getCommandData();
            if (!data.getName().equals(command)) continue;
            if (data.getCategory() == ModCommandManager.CommandCategory.MAIN) {
                TranslationManager.TextBuilder textBuilder = new TranslationManager.TextBuilder(src);
                textBuilder.appendTranslatable("commands.helpful_commands.hc.config.command.error.commandNotConfigurable", new Component[]{Component.literal((String)("/" + command)).setStyle(textStyles.getPrimary())});
                throw new CommandSyntaxException((CommandExceptionType)COMMAND_NOT_CONFIGURABLE, (Message)textBuilder.getComponent());
            }
            valid = true;
            break;
        }
        if (!valid) {
            TranslationManager.TextBuilder textBuilder = new TranslationManager.TextBuilder(src);
            textBuilder.appendTranslatable("commands.helpful_commands.hc.config.command.error.invalidCommand", new Component[]{Component.literal((String)("/" + command)).setStyle(textStyles.getPrimary())});
            throw new CommandSyntaxException((CommandExceptionType)INVALID_HC_COMMAND, (Message)textBuilder.getComponent());
        }
        ConfigManager.HelpfulCommandsConfig config = ConfigManager.readConfig();
        boolean state = config.getCommandState(command);
        TranslationManager.TextBuilder textBuilder = new TranslationManager.TextBuilder(src);
        textBuilder.appendTranslatable("commands.helpful_commands.hc.config.command.state.query", new Component[]{Component.literal((String)("/" + command)).setStyle(textStyles.getPrimary()), Component.literal((String)TranslationManager.translate(src, "commands.helpful_commands.hc.config.command.state." + String.valueOf(state).toLowerCase()).toLowerCase())});
        textBuilder.setStyle(state ? textStyles.getEnabled() : textStyles.getDisabled());
        src.sendSuccess(textBuilder::getComponent, true);
        return 1;
    }

    private int setConfigField(CommandContext<CommandSourceStack> ctx, String field, Object newValue) {
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        this.validateAnySource(src);
        HelpfulCommandsStyle.TextStyles textStyles = StylingManager.getCurrentStyle().getTextStyles();
        ConfigManager.HelpfulCommandsConfig config = ConfigManager.readConfig();
        config.writeField(field, newValue);
        TranslationManager.TextBuilder textBuilder = new TranslationManager.TextBuilder(src);
        textBuilder.appendTranslatable("commands.helpful_commands.hc.config.field.set", new Component[]{Component.literal((String)field).setStyle(textStyles.getPrimary()), Component.literal((String)String.valueOf(newValue)).setStyle(textStyles.getPrimary())});
        textBuilder.setStyle(textStyles.getSuccess());
        src.sendSuccess(textBuilder::getComponent, true);
        return 1;
    }

    private int queryConfigField(CommandContext<CommandSourceStack> ctx, String field) {
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        this.validateAnySource(src);
        HelpfulCommandsStyle.TextStyles textStyles = StylingManager.getCurrentStyle().getTextStyles();
        ConfigManager.HelpfulCommandsConfig config = ConfigManager.readConfig();
        Object value = config.readField(field);
        TranslationManager.TextBuilder textBuilder = new TranslationManager.TextBuilder(src);
        textBuilder.appendTranslatable("commands.helpful_commands.hc.config.field.query", new Component[]{Component.literal((String)field).setStyle(textStyles.getPrimary()), Component.literal((String)String.valueOf(value)).setStyle(textStyles.getPrimary())});
        textBuilder.setStyle(textStyles.getSuccess());
        src.sendSuccess(textBuilder::getComponent, true);
        return 1;
    }
}

