/*
 * Decompiled with CFR 0.152.
 */
package com.expecticament.helpfulcommands.command.movementAndTeleportation;

import com.expecticament.helpfulcommands.command.HelpfulCommandsCommand;
import com.expecticament.helpfulcommands.helper.ServerLevelHelper;
import com.expecticament.helpfulcommands.helper.StylingHelper;
import com.expecticament.helpfulcommands.manager.ModCommandManager;
import com.expecticament.helpfulcommands.manager.StylingManager;
import com.expecticament.helpfulcommands.manager.TranslationManager;
import com.expecticament.helpfulcommands.style.HelpfulCommandsStyle;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandExceptionType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Optional;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Relative;

public class CMD_deathpos
extends HelpfulCommandsCommand {
    protected static final SimpleCommandExceptionType NO_DEATH_POS = new SimpleCommandExceptionType((Message)Component.empty());

    public CMD_deathpos(ModCommandManager.CommandData commandData) {
        super(commandData);
    }

    @Override
    public void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext buildContext, Commands.CommandSelection commandSelection) {
        ModCommandManager.CommandData commandData = this.getCommandData();
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)commandData.getName()).requires(this::canExecuteBaseCommand)).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"tp").requires(ctx -> this.canExecute((CommandSourceStack)ctx, "tp") || this.canExecute((CommandSourceStack)ctx, "tp.other"))).then(((RequiredArgumentBuilder)Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).requires(src -> this.canExecute((CommandSourceStack)src, "tp.other"))).executes(ctx -> this.teleport((CommandContext<CommandSourceStack>)ctx, EntityArgument.getPlayer((CommandContext)ctx, (String)"player"))))).executes(this::teleport))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"query").requires(src -> this.canExecute((CommandSourceStack)src, "query") || this.canExecute((CommandSourceStack)src, "query.other"))).then(((RequiredArgumentBuilder)Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).requires(src -> this.canExecute((CommandSourceStack)src, "query.other"))).executes(ctx -> this.query((CommandContext<CommandSourceStack>)ctx, EntityArgument.getPlayer((CommandContext)ctx, (String)"player"))))).executes(this::query)));
    }

    @Override
    public boolean canExecuteBaseCommand(CommandSourceStack source) {
        return this.canExecute(source) || this.canExecute(source, "tp") || this.canExecute(source, "tp.other") || this.canExecute(source, "query") || this.canExecute(source, "query.other");
    }

    private int query(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        return this.query(ctx, null);
    }

    private int query(CommandContext<CommandSourceStack> ctx, ServerPlayer player) throws CommandSyntaxException {
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        ServerPlayer sourcePlayer = this.validateAnySource(src);
        if (player == null) {
            if (sourcePlayer == null) {
                throw new CommandSyntaxException((CommandExceptionType)SELECTOR_REQUIRED, (Message)Component.literal((String)TranslationManager.translate(src, "error.helpful_commands.selectorRequired")));
            }
            player = sourcePlayer;
        }
        boolean self = player == sourcePlayer;
        String trKeyEnd = self ? "self" : "other";
        Optional deathPos = player.getLastDeathLocation();
        if (deathPos.isEmpty()) {
            TranslationManager.DeprecatedTextBuilder textBuilder = new TranslationManager.DeprecatedTextBuilder(src);
            if (!self) {
                textBuilder.appendComponent(StylingHelper.getAffectedEntityNameText((Entity)player));
            }
            textBuilder.appendTranslatable("commands.helpful_commands.deathpos.output.error.noDeathPos." + trKeyEnd);
            throw new CommandSyntaxException((CommandExceptionType)NO_DEATH_POS, (Message)textBuilder.getComponent());
        }
        GlobalPos globalPos = (GlobalPos)deathPos.get();
        TranslationManager.DeprecatedTextBuilder textBuilder = new TranslationManager.DeprecatedTextBuilder(src);
        if (!self) {
            textBuilder.appendComponent(StylingHelper.getAffectedEntityNameText((Entity)player));
        }
        textBuilder.appendTranslatable("commands.helpful_commands.deathpos.query.output." + trKeyEnd).appendWhitespace().appendComponent(StylingHelper.getLocationText(globalPos));
        src.sendSuccess(textBuilder::getComponent, true);
        return 1;
    }

    private int teleport(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        return this.teleport(ctx, null);
    }

    private int teleport(CommandContext<CommandSourceStack> ctx, ServerPlayer player) throws CommandSyntaxException {
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        ServerPlayer sourcePlayer = this.validatePlayerOnly(src);
        if (player == null) {
            if (sourcePlayer == null) {
                throw new CommandSyntaxException((CommandExceptionType)SELECTOR_REQUIRED, (Message)Component.literal((String)TranslationManager.translate(src, "error.helpful_commands.selectorRequired")));
            }
            player = sourcePlayer;
        }
        boolean self = player == sourcePlayer;
        String trKeyEnd = self ? "self" : "other";
        Optional deathPos = player.getLastDeathLocation();
        if (deathPos.isEmpty()) {
            TranslationManager.DeprecatedTextBuilder textBuilder = new TranslationManager.DeprecatedTextBuilder(src);
            if (!self) {
                textBuilder.appendComponent(StylingHelper.getAffectedEntityNameText((Entity)player));
            }
            textBuilder.appendTranslatable("commands.helpful_commands.deathpos.output.error.noDeathPos." + trKeyEnd);
            throw new CommandSyntaxException((CommandExceptionType)NO_DEATH_POS, (Message)textBuilder.getComponent());
        }
        HelpfulCommandsStyle.TextStyles textStyles = StylingManager.getCurrentStyle().getTextStyles();
        GlobalPos globalPos = (GlobalPos)deathPos.get();
        String levelLocation = globalPos.dimension().location().toString();
        try {
            ServerLevel level = ServerLevelHelper.getLevel(levelLocation);
            BlockPos blockPos = globalPos.pos();
            sourcePlayer.teleportTo(level, (double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ(), Relative.DELTA, sourcePlayer.getYRot(), sourcePlayer.getXRot(), false);
            TranslationManager.DeprecatedTextBuilder textBuilder = new TranslationManager.DeprecatedTextBuilder(src);
            textBuilder.appendTranslatable("commands.helpful_commands.deathpos.teleport.output.success.part1").appendWhitespace();
            if (self) {
                textBuilder.appendTranslatable("commands.helpful_commands.deathpos.teleport.output.success.part2.self");
            } else {
                textBuilder.appendComponent(StylingHelper.getAffectedEntityNameText((Entity)player)).appendTranslatable("commands.helpful_commands.deathpos.teleport.output.success.part2.other");
            }
            textBuilder.appendWhitespace().appendTranslatable("commands.helpful_commands.deathpos.teleport.output.success.part3");
            textBuilder.setStyle(textStyles.getSuccess());
            src.sendSuccess(textBuilder::getComponent, true);
            return 1;
        }
        catch (ServerLevelHelper.UnknownServerLevelException e) {
            TranslationManager.TextBuilder textBuilder = new TranslationManager.TextBuilder(src);
            textBuilder.appendTranslatable("error.helpful_commands.unknownDimension", new Component[]{Component.literal((String)levelLocation).setStyle(textStyles.getPrimary())});
            throw new CommandSyntaxException((CommandExceptionType)UNKNOWN_DIMENSION, (Message)textBuilder.getComponent());
        }
    }
}

