/*
 * Decompiled with CFR 0.152.
 */
package com.expecticament.helpfulcommands.command.movementAndTeleportation;

import com.expecticament.helpfulcommands.command.HelpfulCommandsCommand;
import com.expecticament.helpfulcommands.helper.ServerLevelHelper;
import com.expecticament.helpfulcommands.helper.StylingHelper;
import com.expecticament.helpfulcommands.manager.ModCommandManager;
import com.expecticament.helpfulcommands.manager.StylingManager;
import com.expecticament.helpfulcommands.manager.TranslationManager;
import com.expecticament.helpfulcommands.style.HelpfulCommandsStyle;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandExceptionType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.phys.Vec3;

public class CMD_dimension
extends HelpfulCommandsCommand {
    protected static final SimpleCommandExceptionType FAILED_TO_TELEPORT = new SimpleCommandExceptionType((Message)Component.empty());
    protected static final SimpleCommandExceptionType ALREADY_IN_DIMENSION = new SimpleCommandExceptionType((Message)Component.empty());

    public CMD_dimension(ModCommandManager.CommandData commandData) {
        super(commandData);
    }

    @Override
    public void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext buildContext, Commands.CommandSelection commandSelection) {
        ModCommandManager.CommandData commandData = this.getCommandData();
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)commandData.getName()).requires(this::canExecuteBaseCommand)).then(((RequiredArgumentBuilder)Commands.argument((String)"dimension", (ArgumentType)DimensionArgument.dimension()).then(((RequiredArgumentBuilder)Commands.argument((String)"entities", (ArgumentType)EntityArgument.entities()).requires(src -> this.canExecute((CommandSourceStack)src, "other"))).executes(ctx -> this.executeOther((CommandContext<CommandSourceStack>)ctx, DimensionArgument.getDimension((CommandContext)ctx, (String)"dimension"), EntityArgument.getEntities((CommandContext)ctx, (String)"entities"))))).executes(ctx -> this.executeSelf((CommandContext<CommandSourceStack>)ctx, DimensionArgument.getDimension((CommandContext)ctx, (String)"dimension")))));
    }

    @Override
    public boolean canExecuteBaseCommand(CommandSourceStack source) {
        return this.canExecute(source) || this.canExecute(source, "other");
    }

    private int executeSelf(CommandContext<CommandSourceStack> ctx, ServerLevel serverLevel) throws CommandSyntaxException {
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        ServerPlayer sourcePlayer = this.validatePlayerOnly(src);
        HelpfulCommandsStyle.TextStyles textStyles = StylingManager.getCurrentStyle().getTextStyles();
        int result = this.switchDimension((Entity)sourcePlayer, serverLevel);
        Component dimensionText = this.getDimensionText(serverLevel, textStyles);
        TranslationManager.TextBuilder textBuilder = new TranslationManager.TextBuilder(src);
        if (result == 1) {
            textBuilder.appendTranslatable("commands.helpful_commands.dimension.error.alreadyInDimension", dimensionText);
            throw new CommandSyntaxException((CommandExceptionType)ALREADY_IN_DIMENSION, (Message)textBuilder.getComponent());
        }
        if (result == 2) {
            textBuilder.appendTranslatable("commands.helpful_commands.dimension.error.failedToTeleport", dimensionText);
            throw new CommandSyntaxException((CommandExceptionType)FAILED_TO_TELEPORT, (Message)textBuilder.getComponent());
        }
        textBuilder.appendTranslatable("commands.helpful_commands.dimension.success.self", dimensionText);
        textBuilder.setStyle(textStyles.getSuccess());
        src.sendSuccess(textBuilder::getComponent, true);
        return 1;
    }

    private int executeOther(CommandContext<CommandSourceStack> ctx, ServerLevel serverLevel, Collection<? extends Entity> entities) throws CommandSyntaxException {
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        ServerPlayer sourcePlayer = this.validateAnySource(src);
        if (sourcePlayer != null && entities.size() == 1 && entities.contains(sourcePlayer)) {
            return this.executeSelf(ctx, serverLevel);
        }
        HelpfulCommandsStyle.TextStyles textStyles = StylingManager.getCurrentStyle().getTextStyles();
        boolean commandFeedback = src.getLevel().getGameRules().getBoolean(GameRules.RULE_SENDCOMMANDFEEDBACK);
        Component dimensionText = this.getDimensionText(serverLevel, textStyles);
        List<Entity> affected = entities.stream().filter(entity -> this.switchDimension((Entity)entity, serverLevel) == 0).peek(entity -> {
            ServerPlayer player;
            if (entity.isAlwaysTicking() && commandFeedback && (player = (ServerPlayer)entity) != sourcePlayer) {
                TranslationManager.TextBuilder textBuilder = new TranslationManager.TextBuilder(player);
                textBuilder.appendTranslatable("commands.helpful_commands.dimension.success.affected", dimensionText).setStyle(textStyles.getAffectedNeutral());
                player.sendSystemMessage((Component)textBuilder.getComponent());
            }
        }).toList();
        if (affected.isEmpty()) {
            throw EntityArgument.NO_ENTITIES_FOUND.create();
        }
        MutableComponent affectedText = Component.empty();
        if (affected.size() == 1) {
            affectedText.append(StylingHelper.getAffectedEntityNameText(affected.getFirst()));
        } else {
            affectedText.append(StylingHelper.getAffectedEntitiesNumberText(affected)).append(" ").append(TranslationManager.translate(src, "commands.helpful_commands.dimension.success.other.multiple"));
        }
        TranslationManager.TextBuilder textBuilder = new TranslationManager.TextBuilder(src);
        textBuilder.appendTranslatable("commands.helpful_commands.dimension.success.other", new Component[]{affectedText, dimensionText}).setStyle(textStyles.getSuccess());
        src.sendSuccess(textBuilder::getComponent, true);
        return affected.size();
    }

    private int switchDimension(Entity entity, ServerLevel serverLevel) {
        if (entity.level() == serverLevel) {
            return 1;
        }
        Vec3 pos = entity.position();
        return entity.teleportTo(serverLevel, pos.x(), pos.y(), pos.z(), new HashSet(), entity.getYRot(), entity.getXRot(), false) ? 0 : 2;
    }

    private Component getDimensionText(ServerLevel serverLevel, HelpfulCommandsStyle.TextStyles textStyles) {
        return Component.literal((String)ServerLevelHelper.getLevelLocation(serverLevel)).setStyle(textStyles.getPrimary());
    }
}

