/*
 * Decompiled with CFR 0.152.
 */
package com.expecticament.helpfulcommands.command.movementAndTeleportation;

import com.expecticament.helpfulcommands.command.HelpfulCommandsCommand;
import com.expecticament.helpfulcommands.helper.ServerLevelHelper;
import com.expecticament.helpfulcommands.helper.StylingHelper;
import com.expecticament.helpfulcommands.manager.HomeManager;
import com.expecticament.helpfulcommands.manager.ModCommandManager;
import com.expecticament.helpfulcommands.manager.StylingManager;
import com.expecticament.helpfulcommands.manager.TranslationManager;
import com.expecticament.helpfulcommands.style.HelpfulCommandsStyle;
import com.expecticament.helpfulcommands.suggestionProvider.HomeNameSuggestionProvider;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandExceptionType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.Position;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Relative;

public class CMD_home
extends HelpfulCommandsCommand {
    protected static final SimpleCommandExceptionType HOME_DOESNT_EXIST = new SimpleCommandExceptionType((Message)Component.empty());
    protected static final SimpleCommandExceptionType HOME_ALREADY_EXISTS = new SimpleCommandExceptionType((Message)Component.empty());
    protected static final SimpleCommandExceptionType HOME_LIMIT_EXCEEDED = new SimpleCommandExceptionType((Message)Component.empty());
    protected static final SimpleCommandExceptionType SAME_NAME_PROVIDED = new SimpleCommandExceptionType((Message)Component.empty());

    public CMD_home(ModCommandManager.CommandData commandData) {
        super(commandData);
    }

    @Override
    public void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext buildContext, Commands.CommandSelection commandSelection) {
        ModCommandManager.CommandData commandData = this.getCommandData();
        HomeNameSuggestionProvider homeNameSuggestionProvider = new HomeNameSuggestionProvider();
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)commandData.getName()).requires(this::canExecuteBaseCommand)).then(((LiteralArgumentBuilder)Commands.literal((String)"tp").requires(ctx -> this.canExecute((CommandSourceStack)ctx, "tp"))).then(Commands.argument((String)"home_name", (ArgumentType)StringArgumentType.word()).suggests((SuggestionProvider)homeNameSuggestionProvider).executes(ctx -> this.teleport((CommandContext<CommandSourceStack>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"home_name")))))).then(Commands.literal((String)"add").then(Commands.argument((String)"home_name", (ArgumentType)StringArgumentType.word()).executes(ctx -> this.addHome((CommandContext<CommandSourceStack>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"home_name")))))).then(Commands.literal((String)"remove").then(Commands.argument((String)"home_name", (ArgumentType)StringArgumentType.word()).suggests((SuggestionProvider)homeNameSuggestionProvider).executes(ctx -> this.removeHome((CommandContext<CommandSourceStack>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"home_name")))))).then(Commands.literal((String)"edit").then(((RequiredArgumentBuilder)Commands.argument((String)"home_name", (ArgumentType)StringArgumentType.word()).suggests((SuggestionProvider)homeNameSuggestionProvider).then(Commands.literal((String)"name").then(Commands.argument((String)"new_name", (ArgumentType)StringArgumentType.word()).executes(ctx -> this.editHomeName((CommandContext<CommandSourceStack>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"home_name"), StringArgumentType.getString((CommandContext)ctx, (String)"new_name")))))).then(Commands.literal((String)"location").executes(ctx -> this.editHomeLocation((CommandContext<CommandSourceStack>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"home_name"))))))).then(Commands.literal((String)"info").then(Commands.argument((String)"home_name", (ArgumentType)StringArgumentType.word()).suggests((SuggestionProvider)homeNameSuggestionProvider).executes(ctx -> this.homeInfo((CommandContext<CommandSourceStack>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"home_name"))))));
    }

    @Override
    public boolean canExecuteBaseCommand(CommandSourceStack source) {
        return this.canExecute(source) || this.canExecute(source, "tp");
    }

    private int teleport(CommandContext<CommandSourceStack> ctx, String homeName) throws CommandSyntaxException {
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        ServerPlayer sourcePlayer = this.validatePlayerOnly(src);
        HelpfulCommandsStyle.TextStyles textStyles = StylingManager.getCurrentStyle().getTextStyles();
        try {
            HomeManager.Home home = HomeManager.getHome(sourcePlayer, homeName);
            try {
                ServerLevel level = ServerLevelHelper.getLevel(home.dimension);
                sourcePlayer.teleportTo(level, home.x, home.y, home.z, Relative.DELTA, sourcePlayer.getYRot(), sourcePlayer.getXRot(), false);
                TranslationManager.DeprecatedTextBuilder textBuilder = new TranslationManager.DeprecatedTextBuilder(sourcePlayer);
                textBuilder.appendTranslatable("commands.helpful_commands.home.teleport.output.success.part1").appendWhitespace().appendLiteral(homeName, textStyles.getPrimary()).appendWhitespace().appendTranslatable("commands.helpful_commands.home.teleport.output.success.part2");
                textBuilder.setStyle(textStyles.getSuccess());
                src.sendSuccess(textBuilder::getComponent, true);
            }
            catch (ServerLevelHelper.UnknownServerLevelException e) {
                TranslationManager.TextBuilder textBuilder = new TranslationManager.TextBuilder(src);
                textBuilder.appendTranslatable("error.helpful_commands.unknownDimension", new Component[]{Component.literal((String)home.dimension).setStyle(textStyles.getPrimary())});
                throw new CommandSyntaxException((CommandExceptionType)UNKNOWN_DIMENSION, (Message)textBuilder.getComponent());
            }
        }
        catch (HomeManager.HomeDoesntExistException e) {
            TranslationManager.DeprecatedTextBuilder textBuilder = new TranslationManager.DeprecatedTextBuilder(sourcePlayer);
            textBuilder.appendLiteral(homeName, textStyles.getPrimary()).appendTranslatable("commands.helpful_commands.home.output.error.homeDoesntExist");
            throw new CommandSyntaxException((CommandExceptionType)HOME_DOESNT_EXIST, (Message)textBuilder.getComponent());
        }
        return 1;
    }

    private int addHome(CommandContext<CommandSourceStack> ctx, String homeName) throws CommandSyntaxException {
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        ServerPlayer sourcePlayer = this.validatePlayerOnly(src);
        HelpfulCommandsStyle.TextStyles textStyles = StylingManager.getCurrentStyle().getTextStyles();
        try {
            HomeManager.addHome(sourcePlayer, homeName);
            TranslationManager.DeprecatedTextBuilder textBuilder = new TranslationManager.DeprecatedTextBuilder(sourcePlayer);
            textBuilder.appendTranslatable("commands.helpful_commands.home.add.output.success").appendWhitespace().appendLiteral(homeName, textStyles.getPrimary());
            textBuilder.setStyle(textStyles.getSuccess());
            src.sendSuccess(textBuilder::getComponent, true);
        }
        catch (HomeManager.HomeAlreadyExistsException e) {
            TranslationManager.DeprecatedTextBuilder textBuilder = new TranslationManager.DeprecatedTextBuilder(sourcePlayer);
            textBuilder.appendLiteral(homeName, textStyles.getPrimary()).appendTranslatable("commands.helpful_commands.home.output.error.homeAlreadyExists");
            throw new CommandSyntaxException((CommandExceptionType)HOME_ALREADY_EXISTS, (Message)textBuilder.getComponent());
        }
        catch (HomeManager.HomeLimitExceededException e) {
            TranslationManager.DeprecatedTextBuilder textBuilder = new TranslationManager.DeprecatedTextBuilder(sourcePlayer);
            textBuilder.appendTranslatable("commands.helpful_commands.home.add.output.error.homeLimitExceeded");
            throw new CommandSyntaxException((CommandExceptionType)HOME_LIMIT_EXCEEDED, (Message)textBuilder.getComponent());
        }
        return 1;
    }

    private int removeHome(CommandContext<CommandSourceStack> ctx, String homeName) throws CommandSyntaxException {
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        ServerPlayer sourcePlayer = this.validatePlayerOnly(src);
        HelpfulCommandsStyle.TextStyles textStyles = StylingManager.getCurrentStyle().getTextStyles();
        try {
            HomeManager.removeHome(sourcePlayer, homeName);
            TranslationManager.DeprecatedTextBuilder textBuilder = new TranslationManager.DeprecatedTextBuilder(sourcePlayer);
            textBuilder.appendTranslatable("commands.helpful_commands.home.remove.output.success").appendWhitespace().appendLiteral(homeName, textStyles.getPrimary());
            textBuilder.setStyle(textStyles.getSuccess());
            src.sendSuccess(textBuilder::getComponent, true);
        }
        catch (HomeManager.HomeDoesntExistException e) {
            TranslationManager.DeprecatedTextBuilder textBuilder = new TranslationManager.DeprecatedTextBuilder(sourcePlayer);
            textBuilder.appendLiteral(homeName, textStyles.getPrimary()).appendTranslatable("commands.helpful_commands.home.output.error.homeDoesntExist");
            throw new CommandSyntaxException((CommandExceptionType)HOME_DOESNT_EXIST, (Message)textBuilder.getComponent());
        }
        return 1;
    }

    private int editHomeName(CommandContext<CommandSourceStack> ctx, String homeName, String newName) throws CommandSyntaxException {
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        ServerPlayer sourcePlayer = this.validatePlayerOnly(src);
        HelpfulCommandsStyle.TextStyles textStyles = StylingManager.getCurrentStyle().getTextStyles();
        try {
            HomeManager.editHomeName(sourcePlayer, homeName, newName);
            TranslationManager.DeprecatedTextBuilder textBuilder = new TranslationManager.DeprecatedTextBuilder(sourcePlayer);
            textBuilder.appendTranslatable("commands.helpful_commands.home.edit.name.output.success.part1").appendWhitespace().appendLiteral(homeName, textStyles.getPrimary()).appendWhitespace().appendTranslatable("commands.helpful_commands.home.edit.name.output.success.part2").appendWhitespace().appendLiteral(newName, textStyles.getPrimary());
            textBuilder.setStyle(textStyles.getSuccess());
            src.sendSuccess(textBuilder::getComponent, true);
        }
        catch (HomeManager.HomeDoesntExistException e) {
            TranslationManager.DeprecatedTextBuilder textBuilder = new TranslationManager.DeprecatedTextBuilder(sourcePlayer);
            textBuilder.appendLiteral(homeName, textStyles.getPrimary()).appendTranslatable("commands.helpful_commands.home.output.error.homeDoesntExist");
            throw new CommandSyntaxException((CommandExceptionType)HOME_DOESNT_EXIST, (Message)textBuilder.getComponent());
        }
        catch (HomeManager.SameHomeNameProvided e) {
            TranslationManager.DeprecatedTextBuilder textBuilder = new TranslationManager.DeprecatedTextBuilder(sourcePlayer);
            textBuilder.appendLiteral(homeName, textStyles.getPrimary()).appendTranslatable("commands.helpful_commands.home.edit.name.output.error.sameName");
            throw new CommandSyntaxException((CommandExceptionType)SAME_NAME_PROVIDED, (Message)textBuilder.getComponent());
        }
        catch (HomeManager.HomeAlreadyExistsException e) {
            TranslationManager.DeprecatedTextBuilder textBuilder = new TranslationManager.DeprecatedTextBuilder(sourcePlayer);
            textBuilder.appendLiteral(newName, textStyles.getPrimary()).appendTranslatable("commands.helpful_commands.home.output.error.homeAlreadyExists");
            throw new CommandSyntaxException((CommandExceptionType)HOME_ALREADY_EXISTS, (Message)textBuilder.getComponent());
        }
        return 1;
    }

    private int editHomeLocation(CommandContext<CommandSourceStack> ctx, String homeName) throws CommandSyntaxException {
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        ServerPlayer sourcePlayer = this.validatePlayerOnly(src);
        HelpfulCommandsStyle.TextStyles textStyles = StylingManager.getCurrentStyle().getTextStyles();
        try {
            HomeManager.editHomeLocation(sourcePlayer, homeName, (Position)sourcePlayer.position(), sourcePlayer.level());
            TranslationManager.DeprecatedTextBuilder textBuilder = new TranslationManager.DeprecatedTextBuilder(sourcePlayer);
            textBuilder.appendTranslatable("commands.helpful_commands.home.edit.location.output.success.part1").appendWhitespace().appendLiteral(homeName, textStyles.getPrimary()).appendWhitespace().appendTranslatable("commands.helpful_commands.home.edit.location.output.success.part2");
            textBuilder.setStyle(textStyles.getSuccess());
            src.sendSuccess(textBuilder::getComponent, true);
        }
        catch (HomeManager.HomeDoesntExistException e) {
            TranslationManager.DeprecatedTextBuilder textBuilder = new TranslationManager.DeprecatedTextBuilder(sourcePlayer);
            textBuilder.appendLiteral(homeName, textStyles.getPrimary()).appendTranslatable("commands.helpful_commands.home.output.error.homeDoesntExist");
            throw new CommandSyntaxException((CommandExceptionType)HOME_DOESNT_EXIST, (Message)textBuilder.getComponent());
        }
        return 1;
    }

    private int homeInfo(CommandContext<CommandSourceStack> ctx, String homeName) throws CommandSyntaxException {
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        ServerPlayer sourcePlayer = this.validatePlayerOnly(src);
        HelpfulCommandsStyle.TextStyles textStyles = StylingManager.getCurrentStyle().getTextStyles();
        HelpfulCommandsStyle.TextDecorators textDecorators = StylingManager.getCurrentStyle().getTextDecorators();
        try {
            HomeManager.Home home = HomeManager.getHome(sourcePlayer, homeName);
            TranslationManager.DeprecatedTextBuilder textBuilder = new TranslationManager.DeprecatedTextBuilder(sourcePlayer);
            HoverEvent.ShowText tpBtnHoverEvent = new HoverEvent.ShowText((Component)Component.literal((String)TranslationManager.translate(sourcePlayer, "hover.helpful_commands.clickToTeleport")));
            ClickEvent.RunCommand tpBtnClickEvent = new ClickEvent.RunCommand("/home tp " + homeName);
            Style tpBtnStyle = textStyles.getSecondary().withHoverEvent((HoverEvent)tpBtnHoverEvent).withClickEvent((ClickEvent)tpBtnClickEvent);
            HoverEvent.ShowText editBtnHoverEvent = new HoverEvent.ShowText((Component)Component.literal((String)TranslationManager.translate(sourcePlayer, "hover.helpful_commands.clickToEdit")));
            ClickEvent.SuggestCommand editBtnClickEvent = new ClickEvent.SuggestCommand("/home edit " + homeName + " ");
            Style editBtnStyle = textStyles.getTertiary().withHoverEvent((HoverEvent)editBtnHoverEvent).withClickEvent((ClickEvent)editBtnClickEvent);
            HoverEvent.ShowText removeBtnHoverEvent = new HoverEvent.ShowText((Component)Component.literal((String)TranslationManager.translate(sourcePlayer, "hover.helpful_commands.clickToRemove")));
            ClickEvent.RunCommand removeBtnClickEvent = new ClickEvent.RunCommand("/home remove " + homeName);
            Style removeBtnStyle = textStyles.getDangerousAction().withHoverEvent((HoverEvent)removeBtnHoverEvent).withClickEvent((ClickEvent)removeBtnClickEvent);
            textBuilder.appendComponent(StylingHelper.getTitle((Component)Component.literal((String)TranslationManager.translate(sourcePlayer, "commands.helpful_commands.home.info.title")), (Component)Component.literal((String)homeName))).appendNewline().appendLiteral(textDecorators.getBulletPoint(), textStyles.getTertiary()).appendTranslatable("helpful_commands.common.position", textStyles.getTertiary()).appendLiteral(": ", textStyles.getTertiary()).appendComponent(StylingHelper.getPositionText(home.x, home.y, home.z)).appendNewline().appendLiteral(textDecorators.getBulletPoint(), textStyles.getTertiary()).appendTranslatable("helpful_commands.common.dimension", textStyles.getTertiary()).appendLiteral(": ", textStyles.getTertiary()).appendLiteral(home.dimension, textStyles.getSecondary()).appendNewline().appendNewline();
            if (src.isPlayer() && this.canExecute(src, "tp")) {
                textBuilder.appendComponent(StylingHelper.getButton(textDecorators.getTeleport(), (Component)Component.literal((String)TranslationManager.translate(sourcePlayer, "helpful_commands.common.teleport")), tpBtnStyle)).appendWhitespace();
            }
            textBuilder.appendComponent(StylingHelper.getButton((Component)Component.literal((String)textDecorators.getEdit()), editBtnStyle)).appendWhitespace().appendComponent(StylingHelper.getButton((Component)Component.literal((String)textDecorators.getRemove()), removeBtnStyle));
            src.sendSystemMessage((Component)textBuilder.getComponent());
        }
        catch (HomeManager.HomeDoesntExistException e) {
            TranslationManager.DeprecatedTextBuilder textBuilder = new TranslationManager.DeprecatedTextBuilder(sourcePlayer);
            textBuilder.appendLiteral(homeName, textStyles.getPrimary()).appendTranslatable("commands.helpful_commands.home.output.error.homeDoesntExist");
            throw new CommandSyntaxException((CommandExceptionType)HOME_DOESNT_EXIST, (Message)textBuilder.getComponent());
        }
        return 1;
    }
}

