/*
 * Decompiled with CFR 0.152.
 */
package com.expecticament.helpfulcommands.command.movementAndTeleportation;

import com.expecticament.helpfulcommands.command.HelpfulCommandsCommand;
import com.expecticament.helpfulcommands.helper.ServerLevelHelper;
import com.expecticament.helpfulcommands.helper.StylingHelper;
import com.expecticament.helpfulcommands.manager.ModCommandManager;
import com.expecticament.helpfulcommands.manager.StylingManager;
import com.expecticament.helpfulcommands.manager.TranslationManager;
import com.expecticament.helpfulcommands.style.HelpfulCommandsStyle;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandExceptionType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.HashSet;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.storage.LevelData;
import net.minecraft.world.phys.Vec3;

public class CMD_spawn
extends HelpfulCommandsCommand {
    protected static final SimpleCommandExceptionType FAILED_TO_TELEPORT = new SimpleCommandExceptionType((Message)Component.empty());
    protected static final SimpleCommandExceptionType PLAYER_SPAWN_NOT_SET = new SimpleCommandExceptionType((Message)Component.empty());

    public CMD_spawn(ModCommandManager.CommandData commandData) {
        super(commandData);
    }

    @Override
    public void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext buildContext, Commands.CommandSelection commandSelection) {
        ModCommandManager.CommandData commandData = this.getCommandData();
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)commandData.getName()).requires(this::canExecuteBaseCommand)).then(((LiteralArgumentBuilder)Commands.literal((String)"player").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"tp").requires(src -> this.canExecute((CommandSourceStack)src, "player.tp"))).then(((RequiredArgumentBuilder)Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).requires(src -> this.canExecute((CommandSourceStack)src, "player.tp.other"))).executes(ctx -> this.executePlayerTp((CommandContext<CommandSourceStack>)ctx, EntityArgument.getPlayer((CommandContext)ctx, (String)"player"))))).executes(ctx -> this.executePlayerTp((CommandContext<CommandSourceStack>)ctx, null)))).then(((LiteralArgumentBuilder)Commands.literal((String)"query").then(((RequiredArgumentBuilder)Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).requires(src -> this.canExecute((CommandSourceStack)src, "player.query.other"))).executes(ctx -> this.executePlayerQuery((CommandContext<CommandSourceStack>)ctx, EntityArgument.getPlayer((CommandContext)ctx, (String)"player"))))).executes(ctx -> this.executePlayerQuery((CommandContext<CommandSourceStack>)ctx, null))))).then(((LiteralArgumentBuilder)Commands.literal((String)"world").then(((LiteralArgumentBuilder)Commands.literal((String)"tp").requires(src -> this.canExecute((CommandSourceStack)src, "world.tp"))).executes(this::executeWorldTp))).then(Commands.literal((String)"query").executes(this::executeWorldQuery))));
    }

    @Override
    public boolean canExecuteBaseCommand(CommandSourceStack source) {
        return this.canExecute(source) || this.canExecute(source, "player.tp") || this.canExecute(source, "player.tp.other") || this.canExecute(source, "player.query.other") || this.canExecute(source, "world.tp");
    }

    private int executePlayerTp(CommandContext<CommandSourceStack> ctx, ServerPlayer otherPlayer) throws CommandSyntaxException {
        int result;
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        ServerPlayer sourcePlayer = this.validatePlayerOnly(src);
        HelpfulCommandsStyle.TextStyles textStyles = StylingManager.getCurrentStyle().getTextStyles();
        TranslationManager.TextBuilder textBuilder = new TranslationManager.TextBuilder(src);
        boolean self = false;
        if (otherPlayer == null || otherPlayer == sourcePlayer) {
            otherPlayer = sourcePlayer;
            self = true;
        }
        if ((result = this.teleportToPlayerSpawn(sourcePlayer, otherPlayer)) == 1) {
            if (self) {
                textBuilder.appendTranslatable("commands.helpful_commands.spawn.error.playerSpawnNotSet.self", new Component[0]);
            } else {
                textBuilder.appendTranslatable("commands.helpful_commands.spawn.error.playerSpawnNotSet.other", StylingHelper.getAffectedEntityNameText((Entity)otherPlayer));
            }
            throw new CommandSyntaxException((CommandExceptionType)PLAYER_SPAWN_NOT_SET, (Message)textBuilder.getComponent());
        }
        if (result == 2) {
            textBuilder.appendTranslatable("commands.helpful_commands.spawn.error.failedToTeleport", new Component[0]);
            throw new CommandSyntaxException((CommandExceptionType)FAILED_TO_TELEPORT, (Message)textBuilder.getComponent());
        }
        if (self) {
            textBuilder.appendTranslatable("commands.helpful_commands.spawn.player.tp.self.own", new Component[0]);
        } else {
            textBuilder.appendTranslatable("commands.helpful_commands.spawn.player.tp.self.other", StylingHelper.getAffectedEntityNameText((Entity)otherPlayer));
        }
        textBuilder.setStyle(textStyles.getSuccess());
        src.sendSuccess(textBuilder::getComponent, true);
        return 1;
    }

    private int executeWorldTp(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        ServerPlayer sourcePlayer = this.validatePlayerOnly(src);
        HelpfulCommandsStyle.TextStyles textStyles = StylingManager.getCurrentStyle().getTextStyles();
        TranslationManager.TextBuilder textBuilder = new TranslationManager.TextBuilder(src);
        if (!this.teleportToWorldSpawn(sourcePlayer, sourcePlayer.level())) {
            textBuilder.appendTranslatable("commands.helpful_commands.spawn.error.failedToTeleport", new Component[0]);
            throw new CommandSyntaxException((CommandExceptionType)FAILED_TO_TELEPORT, (Message)textBuilder.getComponent());
        }
        textBuilder.appendTranslatable("commands.helpful_commands.spawn.world.tp", new Component[0]).setStyle(textStyles.getSuccess());
        src.sendSuccess(textBuilder::getComponent, true);
        return 1;
    }

    private int executePlayerQuery(CommandContext<CommandSourceStack> ctx, ServerPlayer otherPlayer) throws CommandSyntaxException {
        ServerPlayer.RespawnConfig respawnConfig;
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        ServerPlayer sourcePlayer = this.validateAnySource(src);
        TranslationManager.TextBuilder textBuilder = new TranslationManager.TextBuilder(src);
        if (otherPlayer == null && sourcePlayer == null) {
            throw CommandSourceStack.ERROR_NOT_PLAYER.create();
        }
        boolean self = false;
        if (otherPlayer == null || otherPlayer == sourcePlayer) {
            otherPlayer = sourcePlayer;
            self = true;
        }
        if ((respawnConfig = otherPlayer.getRespawnConfig()) == null) {
            if (self) {
                textBuilder.appendTranslatable("commands.helpful_commands.spawn.error.playerSpawnNotSet.self", new Component[0]);
            } else {
                textBuilder.appendTranslatable("commands.helpful_commands.spawn.error.playerSpawnNotSet.other", StylingHelper.getAffectedEntityNameText((Entity)otherPlayer));
            }
            throw new CommandSyntaxException((CommandExceptionType)PLAYER_SPAWN_NOT_SET, (Message)textBuilder.getComponent());
        }
        src.sendSystemMessage(this.buildInfoComponent(respawnConfig.respawnData(), src, otherPlayer.getName().getString(), self));
        return 1;
    }

    private int executeWorldQuery(CommandContext<CommandSourceStack> ctx) {
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        this.validateAnySource(src);
        src.sendSystemMessage(this.buildInfoComponent(src.getLevel().getRespawnData(), src, "", false));
        return 1;
    }

    private Component buildInfoComponent(LevelData.RespawnData respawnData, CommandSourceStack src, String playerName, boolean isOwnSpawn) {
        HelpfulCommandsStyle currentStyle = StylingManager.getCurrentStyle();
        HelpfulCommandsStyle.TextStyles textStyles = currentStyle.getTextStyles();
        HelpfulCommandsStyle.TextDecorators textDecorators = currentStyle.getTextDecorators();
        boolean isPlayer = !playerName.isEmpty();
        HoverEvent.ShowText tpBtnHoverEvent = new HoverEvent.ShowText((Component)Component.literal((String)TranslationManager.translate(src, "hover.helpful_commands.clickToTeleport")));
        ClickEvent.RunCommand tpBtnClickEvent = new ClickEvent.RunCommand("/spawn " + (String)(isPlayer ? "player tp" + (String)(isOwnSpawn ? "" : " " + playerName) : "world tp"));
        Style tpBtnStyle = textStyles.getSecondary().withHoverEvent((HoverEvent)tpBtnHoverEvent).withClickEvent((ClickEvent)tpBtnClickEvent);
        Vec3 pos = respawnData.pos().getCenter();
        String dimensionLocation = respawnData.dimension().location().toString();
        TranslationManager.TextBuilder textBuilder = new TranslationManager.TextBuilder(src);
        textBuilder.appendComponent(StylingHelper.getTitle((Component)Component.literal((String)TranslationManager.translate(src, "commands.helpful_commands.spawn.info.title")), (Component)Component.literal((String)(isPlayer ? playerName : TranslationManager.translate(src, "commands.helpful_commands.spawn.info.title.world"))))).appendNewline().appendLiteral(textDecorators.getBulletPoint()).appendTranslatable("helpful_commands.common.position", new Component[0]).appendLiteral(": ").appendComponent(StylingHelper.getPositionText(pos.x(), pos.y(), pos.z())).appendNewline().appendLiteral(textDecorators.getBulletPoint()).appendTranslatable("helpful_commands.common.dimension", new Component[0]).appendLiteral(": ").appendComponent((Component)Component.literal((String)dimensionLocation).setStyle(textStyles.getSecondary()));
        if (src.isPlayer()) {
            String string = isPlayer ? (isOwnSpawn ? "player.tp" : "player.tp.other") : "world.tp";
            if (this.canExecute(src, string)) {
                textBuilder.appendNewline().appendNewline().appendComponent(StylingHelper.getButton(textDecorators.getTeleport(), (Component)Component.literal((String)TranslationManager.translate(src, "helpful_commands.common.teleport")), tpBtnStyle));
            }
        }
        textBuilder.setStyle(textStyles.getTertiary());
        return textBuilder.getComponent();
    }

    private int teleportToPlayerSpawn(ServerPlayer teleportedPlayer, ServerPlayer otherPlayer) throws CommandSyntaxException {
        ServerLevel serverLevel;
        ServerPlayer.RespawnConfig respawnConfig = otherPlayer.getRespawnConfig();
        if (respawnConfig == null) {
            return 1;
        }
        LevelData.RespawnData respawnData = respawnConfig.respawnData();
        String dimensionLocation = respawnData.dimension().location().toString();
        try {
            serverLevel = ServerLevelHelper.getLevel(dimensionLocation);
        }
        catch (ServerLevelHelper.UnknownServerLevelException e) {
            HelpfulCommandsStyle.TextStyles textStyles = StylingManager.getCurrentStyle().getTextStyles();
            TranslationManager.TextBuilder eTextBuilder = new TranslationManager.TextBuilder(teleportedPlayer);
            eTextBuilder.appendTranslatable("error.helpful_commands.unknownDimension", new Component[]{Component.literal((String)dimensionLocation).setStyle(textStyles.getPrimary())});
            throw new CommandSyntaxException((CommandExceptionType)UNKNOWN_DIMENSION, (Message)eTextBuilder.getComponent());
        }
        Vec3 pos = respawnData.pos().getCenter();
        return teleportedPlayer.teleportTo(serverLevel, pos.x(), pos.y(), pos.z(), new HashSet(), respawnData.yaw(), respawnData.pitch(), false) ? 0 : 2;
    }

    private boolean teleportToWorldSpawn(ServerPlayer teleportedPlayer, ServerLevel serverLevel) throws CommandSyntaxException {
        LevelData.RespawnData respawnData = serverLevel.getRespawnData();
        String dimensionLocation = respawnData.dimension().location().toString();
        try {
            serverLevel = ServerLevelHelper.getLevel(dimensionLocation);
        }
        catch (ServerLevelHelper.UnknownServerLevelException e) {
            HelpfulCommandsStyle.TextStyles textStyles = StylingManager.getCurrentStyle().getTextStyles();
            TranslationManager.TextBuilder eTextBuilder = new TranslationManager.TextBuilder(teleportedPlayer);
            eTextBuilder.appendTranslatable("error.helpful_commands.unknownDimension", new Component[]{Component.literal((String)dimensionLocation).setStyle(textStyles.getPrimary())});
            throw new CommandSyntaxException((CommandExceptionType)UNKNOWN_DIMENSION, (Message)eTextBuilder.getComponent());
        }
        Vec3 pos = respawnData.pos().getCenter();
        return teleportedPlayer.teleportTo(serverLevel, pos.x(), pos.y(), pos.z(), new HashSet(), respawnData.yaw(), respawnData.pitch(), false);
    }
}

