/*
 * Decompiled with CFR 0.152.
 */
package com.expecticament.helpfulcommands.command.movementAndTeleportation;

import com.expecticament.helpfulcommands.command.HelpfulCommandsCommand;
import com.expecticament.helpfulcommands.helper.ServerLevelHelper;
import com.expecticament.helpfulcommands.helper.StylingHelper;
import com.expecticament.helpfulcommands.manager.ModCommandManager;
import com.expecticament.helpfulcommands.manager.StylingManager;
import com.expecticament.helpfulcommands.manager.TranslationManager;
import com.expecticament.helpfulcommands.manager.WarpManager;
import com.expecticament.helpfulcommands.style.HelpfulCommandsStyle;
import com.expecticament.helpfulcommands.suggestionProvider.WarpDescriptionSuggestionProvider;
import com.expecticament.helpfulcommands.suggestionProvider.WarpNameSuggestionProvider;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandExceptionType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.core.Position;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Relative;
import net.minecraft.world.level.GameRules;

public class CMD_warp
extends HelpfulCommandsCommand {
    protected static final SimpleCommandExceptionType WARP_DOESNT_EXIST = new SimpleCommandExceptionType((Message)Component.empty());
    protected static final SimpleCommandExceptionType WARP_ALREADY_EXISTS = new SimpleCommandExceptionType((Message)Component.empty());
    protected static final SimpleCommandExceptionType SAME_NAME_PROVIDED = new SimpleCommandExceptionType((Message)Component.empty());
    protected static final SimpleCommandExceptionType NO_POSITION_PROVIDED = new SimpleCommandExceptionType((Message)Component.empty());
    protected static final SimpleCommandExceptionType NO_DIMENSION_PROVIDED = new SimpleCommandExceptionType((Message)Component.empty());

    public CMD_warp(ModCommandManager.CommandData commandData) {
        super(commandData);
    }

    @Override
    public void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext buildContext, Commands.CommandSelection commandSelection) {
        ModCommandManager.CommandData commandData = this.getCommandData();
        WarpNameSuggestionProvider warpNameSuggestionProvider = new WarpNameSuggestionProvider();
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)commandData.getName()).requires(this::canExecuteBaseCommand)).then(((LiteralArgumentBuilder)Commands.literal((String)"tp").requires(src -> this.canExecute((CommandSourceStack)src, "tp"))).then((ArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"warp_name", (ArgumentType)StringArgumentType.word()).then(((RequiredArgumentBuilder)Commands.argument((String)"entities", (ArgumentType)EntityArgument.entities()).requires(src -> this.canExecute((CommandSourceStack)src, "tp.other", 2))).executes(ctx -> this.teleport((CommandContext<CommandSourceStack>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"warp_name"), EntityArgument.getEntities((CommandContext)ctx, (String)"entities"))))).executes(ctx -> this.teleport((CommandContext<CommandSourceStack>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"warp_name")))).suggests((SuggestionProvider)warpNameSuggestionProvider)))).then(((LiteralArgumentBuilder)Commands.literal((String)"add").requires(src -> this.canExecute((CommandSourceStack)src, "manage", 3))).then(((RequiredArgumentBuilder)Commands.argument((String)"warp_name", (ArgumentType)StringArgumentType.word()).then(((RequiredArgumentBuilder)Commands.argument((String)"description", (ArgumentType)StringArgumentType.string()).executes(ctx -> this.addWarp((CommandContext<CommandSourceStack>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"warp_name"), StringArgumentType.getString((CommandContext)ctx, (String)"description")))).then(((RequiredArgumentBuilder)Commands.argument((String)"position", (ArgumentType)Vec3Argument.vec3()).executes(ctx -> this.addWarp((CommandContext<CommandSourceStack>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"warp_name"), StringArgumentType.getString((CommandContext)ctx, (String)"description"), (Position)Vec3Argument.getVec3((CommandContext)ctx, (String)"position")))).then(Commands.argument((String)"dimension", (ArgumentType)DimensionArgument.dimension()).executes(ctx -> this.addWarp((CommandContext<CommandSourceStack>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"warp_name"), StringArgumentType.getString((CommandContext)ctx, (String)"description"), (Position)Vec3Argument.getVec3((CommandContext)ctx, (String)"position"), DimensionArgument.getDimension((CommandContext)ctx, (String)"dimension"))))))).executes(ctx -> this.addWarp((CommandContext<CommandSourceStack>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"warp_name")))))).then(((LiteralArgumentBuilder)Commands.literal((String)"remove").requires(src -> this.canExecute((CommandSourceStack)src, "manage", 3))).then((ArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"warp_name", (ArgumentType)StringArgumentType.word()).executes(ctx -> this.removeWarp((CommandContext<CommandSourceStack>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"warp_name")))).suggests((SuggestionProvider)warpNameSuggestionProvider)))).then(((LiteralArgumentBuilder)Commands.literal((String)"edit").requires(src -> this.canExecute((CommandSourceStack)src, "manage", 3))).then((ArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"warp_name", (ArgumentType)StringArgumentType.word()).then(Commands.literal((String)"name").then(Commands.argument((String)"new_name", (ArgumentType)StringArgumentType.word()).executes(ctx -> this.editWarpName((CommandContext<CommandSourceStack>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"warp_name"), StringArgumentType.getString((CommandContext)ctx, (String)"new_name")))))).then(Commands.literal((String)"description").then((ArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"new_description", (ArgumentType)StringArgumentType.string()).executes(ctx -> this.editWarpDescription((CommandContext<CommandSourceStack>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"warp_name"), StringArgumentType.getString((CommandContext)ctx, (String)"new_description")))).suggests((SuggestionProvider)new WarpDescriptionSuggestionProvider())))).then(((LiteralArgumentBuilder)Commands.literal((String)"location").then(((RequiredArgumentBuilder)Commands.argument((String)"new_position", (ArgumentType)Vec3Argument.vec3()).then(Commands.argument((String)"new_dimension", (ArgumentType)DimensionArgument.dimension()).executes(ctx -> this.editWarpLocation((CommandContext<CommandSourceStack>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"warp_name"), (Position)Vec3Argument.getVec3((CommandContext)ctx, (String)"new_position"), DimensionArgument.getDimension((CommandContext)ctx, (String)"new_dimension"))))).executes(ctx -> this.editWarpLocation((CommandContext<CommandSourceStack>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"warp_name"), (Position)Vec3Argument.getVec3((CommandContext)ctx, (String)"new_position"))))).executes(ctx -> this.editWarpLocation((CommandContext<CommandSourceStack>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"warp_name"))))).suggests((SuggestionProvider)warpNameSuggestionProvider)))).then(Commands.literal((String)"info").then(Commands.argument((String)"warp_name", (ArgumentType)StringArgumentType.word()).suggests((SuggestionProvider)warpNameSuggestionProvider).executes(ctx -> this.warpInfo((CommandContext<CommandSourceStack>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"warp_name"))))));
    }

    @Override
    public boolean canExecuteBaseCommand(CommandSourceStack source) {
        return this.canExecute(source) || this.canExecute(source, "tp") || this.canExecute(source, "tp.other") || this.canExecute(source, "manage");
    }

    private int teleport(CommandContext<CommandSourceStack> ctx, String warpName) throws CommandSyntaxException {
        return this.teleport(ctx, warpName, null);
    }

    private int teleport(CommandContext<CommandSourceStack> ctx, String warpName, Collection<? extends Entity> entities) throws CommandSyntaxException {
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        ServerPlayer sourcePlayer = this.validateAnySource(src);
        ArrayList<ServerPlayer> targets = new ArrayList<ServerPlayer>(Objects.requireNonNullElse(entities, List.of()));
        if (targets.isEmpty() && sourcePlayer == null) {
            throw new CommandSyntaxException((CommandExceptionType)SELECTOR_REQUIRED, (Message)Component.literal((String)TranslationManager.translate(src, "error.helpful_commands.selectorRequired")));
        }
        if (entities == null) {
            targets.add(sourcePlayer);
        }
        HelpfulCommandsStyle.TextStyles textStyles = StylingManager.getCurrentStyle().getTextStyles();
        try {
            WarpManager.Warp warp = WarpManager.getWarp(warpName);
            try {
                ServerLevel dimension = ServerLevelHelper.getLevel(warp.dimension);
                boolean commandFeedback = src.getLevel().getGameRules().getBoolean(GameRules.RULE_SENDCOMMANDFEEDBACK);
                List<Entity> affected = targets.stream().filter(e -> e.teleportTo(dimension, warp.x, warp.y, warp.z, Relative.DELTA, e.getYRot(), e.getXRot(), false)).peek(e -> {
                    if (e.isAlwaysTicking() && e != sourcePlayer && commandFeedback) {
                        ServerPlayer plr = (ServerPlayer)e;
                        TranslationManager.TextBuilder affectedMsgTextBuilder = new TranslationManager.TextBuilder(src);
                        affectedMsgTextBuilder.appendTranslatable("commands.helpful_commands.warp.teleport.output.success.affected", new Component[]{Component.literal((String)warpName).setStyle(textStyles.getPrimary())}).setStyle(textStyles.getAffectedNeutral());
                        plr.sendSystemMessage((Component)affectedMsgTextBuilder.getComponent());
                    }
                }).toList();
                if (affected.isEmpty()) {
                    throw EntityArgument.NO_ENTITIES_FOUND.create();
                }
                boolean multiple = affected.size() > 1;
                boolean self = affected.contains(sourcePlayer);
                src.sendSuccess(() -> this.buildTeleportFeedbackMessage(src, multiple, self, warpName, affected), true);
                return affected.size();
            }
            catch (ServerLevelHelper.UnknownServerLevelException e2) {
                TranslationManager.TextBuilder textBuilder = new TranslationManager.TextBuilder(src);
                textBuilder.appendTranslatable("error.helpful_commands.unknownDimension", new Component[]{Component.literal((String)warp.dimension).setStyle(textStyles.getPrimary())});
                throw new CommandSyntaxException((CommandExceptionType)UNKNOWN_DIMENSION, (Message)textBuilder.getComponent());
            }
        }
        catch (WarpManager.WarpDoesntExistException e3) {
            TranslationManager.TextBuilder textBuilder = new TranslationManager.TextBuilder(src);
            textBuilder.appendTranslatable("commands.helpful_commands.warp.output.error.warpDoesntExist", new Component[]{Component.literal((String)warpName).setStyle(textStyles.getPrimary())});
            throw new CommandSyntaxException((CommandExceptionType)WARP_DOESNT_EXIST, (Message)textBuilder.getComponent());
        }
    }

    private Component buildTeleportFeedbackMessage(CommandSourceStack src, boolean multiple, boolean self, String warpName, List<Entity> affected) {
        HelpfulCommandsStyle.TextStyles textStyles = StylingManager.getCurrentStyle().getTextStyles();
        MutableComponent warpNameText = Component.literal((String)warpName).setStyle(textStyles.getPrimary());
        TranslationManager.TextBuilder textBuilder = new TranslationManager.TextBuilder(src);
        if (multiple) {
            textBuilder.appendTranslatable("commands.helpful_commands.warp.teleport.output.success.others", new Component[]{StylingHelper.getAffectedEntitiesNumberText(affected), warpNameText});
        } else if (self) {
            textBuilder.appendTranslatable("commands.helpful_commands.warp.teleport.output.success.self", new Component[]{warpNameText});
        } else {
            textBuilder.appendTranslatable("commands.helpful_commands.warp.teleport.output.success.others", new Component[]{StylingHelper.getAffectedEntityNameText(affected.getFirst()), warpNameText});
        }
        textBuilder.setStyle(textStyles.getSuccess());
        return textBuilder.getComponent();
    }

    private int addWarp(CommandContext<CommandSourceStack> ctx, String warpName) throws CommandSyntaxException {
        return this.addWarp(ctx, warpName, "", null, null);
    }

    private int addWarp(CommandContext<CommandSourceStack> ctx, String warpName, String warpDescription) throws CommandSyntaxException {
        return this.addWarp(ctx, warpName, warpDescription, null, null);
    }

    private int addWarp(CommandContext<CommandSourceStack> ctx, String warpName, String warpDescription, Position position) throws CommandSyntaxException {
        return this.addWarp(ctx, warpName, warpDescription, position, null);
    }

    private int addWarp(CommandContext<CommandSourceStack> ctx, String warpName, String warpDescription, Position position, ServerLevel serverLevel) throws CommandSyntaxException {
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        ServerPlayer sourcePlayer = this.validateAnySource(src);
        if (position == null) {
            if (sourcePlayer == null) {
                TranslationManager.TextBuilder textBuilder = new TranslationManager.TextBuilder(src);
                textBuilder.appendTranslatable("commands.helpful_commands.warp.output.error.specifyPosition", new Component[0]);
                throw new CommandSyntaxException((CommandExceptionType)NO_POSITION_PROVIDED, (Message)textBuilder.getComponent());
            }
            position = sourcePlayer.position();
        }
        if (serverLevel == null) {
            if (sourcePlayer == null) {
                TranslationManager.TextBuilder textBuilder = new TranslationManager.TextBuilder(src);
                textBuilder.appendTranslatable("commands.helpful_commands.warp.output.error.specifyDimension", new Component[0]);
                throw new CommandSyntaxException((CommandExceptionType)NO_DIMENSION_PROVIDED, (Message)textBuilder.getComponent());
            }
            serverLevel = sourcePlayer.level();
        }
        HelpfulCommandsStyle.TextStyles textStyles = StylingManager.getCurrentStyle().getTextStyles();
        try {
            WarpManager.addWarp(warpName, warpDescription, position, serverLevel);
            TranslationManager.TextBuilder textBuilder = new TranslationManager.TextBuilder(src);
            textBuilder.appendTranslatable("commands.helpful_commands.warp.add.output.success", new Component[]{Component.literal((String)warpName).setStyle(textStyles.getPrimary())}).setStyle(textStyles.getSuccess());
            src.sendSuccess(textBuilder::getComponent, true);
        }
        catch (WarpManager.WarpAlreadyExistsException e) {
            TranslationManager.TextBuilder textBuilder = new TranslationManager.TextBuilder(src);
            textBuilder.appendTranslatable("commands.helpful_commands.warp.output.error.warpAlreadyExists", new Component[]{Component.literal((String)warpName).setStyle(textStyles.getPrimary())});
            throw new CommandSyntaxException((CommandExceptionType)WARP_ALREADY_EXISTS, (Message)textBuilder.getComponent());
        }
        return 1;
    }

    private int removeWarp(CommandContext<CommandSourceStack> ctx, String warpName) throws CommandSyntaxException {
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        this.validateAnySource(src);
        HelpfulCommandsStyle.TextStyles textStyles = StylingManager.getCurrentStyle().getTextStyles();
        try {
            WarpManager.removeWarp(warpName);
            TranslationManager.TextBuilder textBuilder = new TranslationManager.TextBuilder(src);
            textBuilder.appendTranslatable("commands.helpful_commands.warp.remove.output.success", new Component[]{Component.literal((String)warpName).setStyle(textStyles.getPrimary())}).setStyle(textStyles.getSuccess());
            src.sendSuccess(textBuilder::getComponent, true);
        }
        catch (WarpManager.WarpDoesntExistException e) {
            TranslationManager.TextBuilder textBuilder = new TranslationManager.TextBuilder(src);
            textBuilder.appendTranslatable("commands.helpful_commands.warp.output.error.warpDoesntExist", new Component[]{Component.literal((String)warpName).setStyle(textStyles.getPrimary())});
            throw new CommandSyntaxException((CommandExceptionType)WARP_DOESNT_EXIST, (Message)textBuilder.getComponent());
        }
        return 1;
    }

    private int editWarpName(CommandContext<CommandSourceStack> ctx, String warpName, String newName) throws CommandSyntaxException {
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        this.validateAnySource(src);
        HelpfulCommandsStyle.TextStyles textStyles = StylingManager.getCurrentStyle().getTextStyles();
        try {
            WarpManager.editWarpName(warpName, newName);
            TranslationManager.TextBuilder textBuilder = new TranslationManager.TextBuilder(src);
            textBuilder.appendTranslatable("commands.helpful_commands.warp.edit.name.output.success", new Component[]{Component.literal((String)warpName).setStyle(textStyles.getPrimary()), Component.literal((String)newName).setStyle(textStyles.getPrimary())}).setStyle(textStyles.getSuccess());
            src.sendSuccess(textBuilder::getComponent, true);
        }
        catch (WarpManager.WarpDoesntExistException e) {
            TranslationManager.TextBuilder textBuilder = new TranslationManager.TextBuilder(src);
            textBuilder.appendTranslatable("commands.helpful_commands.warp.output.error.warpDoesntExist", new Component[]{Component.literal((String)warpName).setStyle(textStyles.getPrimary())});
            throw new CommandSyntaxException((CommandExceptionType)WARP_DOESNT_EXIST, (Message)textBuilder.getComponent());
        }
        catch (WarpManager.SameWarpNameProvided e) {
            TranslationManager.TextBuilder textBuilder = new TranslationManager.TextBuilder(src);
            textBuilder.appendTranslatable("commands.helpful_commands.warp.edit.name.output.error.sameName", new Component[]{Component.literal((String)warpName).setStyle(textStyles.getPrimary())});
            throw new CommandSyntaxException((CommandExceptionType)SAME_NAME_PROVIDED, (Message)textBuilder.getComponent());
        }
        catch (WarpManager.WarpAlreadyExistsException e) {
            TranslationManager.TextBuilder textBuilder = new TranslationManager.TextBuilder(src);
            textBuilder.appendTranslatable("commands.helpful_commands.warp.output.error.warpAlreadyExists", new Component[]{Component.literal((String)warpName).setStyle(textStyles.getPrimary())});
            throw new CommandSyntaxException((CommandExceptionType)WARP_ALREADY_EXISTS, (Message)textBuilder.getComponent());
        }
        return 1;
    }

    private int editWarpDescription(CommandContext<CommandSourceStack> ctx, String warpName, String newDescription) throws CommandSyntaxException {
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        this.validateAnySource(src);
        HelpfulCommandsStyle.TextStyles textStyles = StylingManager.getCurrentStyle().getTextStyles();
        try {
            WarpManager.editWarpDescription(warpName, newDescription);
            TranslationManager.TextBuilder textBuilder = new TranslationManager.TextBuilder(src);
            textBuilder.appendTranslatable("commands.helpful_commands.warp.edit.description.output.success", new Component[]{Component.literal((String)warpName).setStyle(textStyles.getPrimary())}).setStyle(textStyles.getSuccess());
            src.sendSuccess(textBuilder::getComponent, true);
        }
        catch (WarpManager.WarpDoesntExistException e) {
            TranslationManager.TextBuilder textBuilder = new TranslationManager.TextBuilder(src);
            textBuilder.appendTranslatable("commands.helpful_commands.warp.output.error.warpDoesntExist", new Component[]{Component.literal((String)warpName).setStyle(textStyles.getPrimary())});
            throw new CommandSyntaxException((CommandExceptionType)WARP_DOESNT_EXIST, (Message)textBuilder.getComponent());
        }
        return 1;
    }

    private int editWarpLocation(CommandContext<CommandSourceStack> ctx, String warpName) throws CommandSyntaxException {
        return this.editWarpLocation(ctx, warpName, null, null);
    }

    private int editWarpLocation(CommandContext<CommandSourceStack> ctx, String warpName, Position newPosition) throws CommandSyntaxException {
        return this.editWarpLocation(ctx, warpName, newPosition, null);
    }

    private int editWarpLocation(CommandContext<CommandSourceStack> ctx, String warpName, Position newPosition, ServerLevel newServerLevel) throws CommandSyntaxException {
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        ServerPlayer sourcePlayer = this.validateAnySource(src);
        if (newPosition == null) {
            if (sourcePlayer == null) {
                TranslationManager.TextBuilder textBuilder = new TranslationManager.TextBuilder(src);
                textBuilder.appendTranslatable("commands.helpful_commands.warp.output.error.specifyPosition", new Component[0]);
                throw new CommandSyntaxException((CommandExceptionType)NO_POSITION_PROVIDED, (Message)textBuilder.getComponent());
            }
            newPosition = sourcePlayer.position();
        }
        if (newServerLevel == null) {
            if (sourcePlayer == null) {
                TranslationManager.TextBuilder textBuilder = new TranslationManager.TextBuilder(src);
                textBuilder.appendTranslatable("commands.helpful_commands.warp.output.error.specifyDimension", new Component[0]);
                throw new CommandSyntaxException((CommandExceptionType)NO_DIMENSION_PROVIDED, (Message)textBuilder.getComponent());
            }
            newServerLevel = sourcePlayer.level();
        }
        HelpfulCommandsStyle.TextStyles textStyles = StylingManager.getCurrentStyle().getTextStyles();
        try {
            WarpManager.editWarpLocation(warpName, newPosition, newServerLevel);
            TranslationManager.TextBuilder textBuilder = new TranslationManager.TextBuilder(src);
            textBuilder.appendTranslatable("commands.helpful_commands.warp.edit.location.output.success", new Component[]{Component.literal((String)warpName).setStyle(textStyles.getPrimary())}).setStyle(textStyles.getSuccess());
            src.sendSuccess(textBuilder::getComponent, true);
        }
        catch (WarpManager.WarpDoesntExistException e) {
            TranslationManager.TextBuilder textBuilder = new TranslationManager.TextBuilder(src);
            textBuilder.appendTranslatable("commands.helpful_commands.warp.output.error.warpDoesntExist", new Component[]{Component.literal((String)warpName).setStyle(textStyles.getPrimary())});
            throw new CommandSyntaxException((CommandExceptionType)WARP_DOESNT_EXIST, (Message)textBuilder.getComponent());
        }
        return 1;
    }

    private int warpInfo(CommandContext<CommandSourceStack> ctx, String warpName) throws CommandSyntaxException {
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        this.validateAnySource(src);
        HelpfulCommandsStyle.TextStyles textStyles = StylingManager.getCurrentStyle().getTextStyles();
        HelpfulCommandsStyle.TextDecorators textDecorators = StylingManager.getCurrentStyle().getTextDecorators();
        try {
            WarpManager.Warp warp = WarpManager.getWarp(warpName);
            TranslationManager.TextBuilder textBuilder = new TranslationManager.TextBuilder(src);
            HoverEvent.ShowText tpBtnHoverEvent = new HoverEvent.ShowText((Component)Component.literal((String)TranslationManager.translate(src, "hover.helpful_commands.clickToTeleport")));
            ClickEvent.RunCommand tpBtnClickEvent = new ClickEvent.RunCommand("/warp tp " + warpName);
            Style tpBtnStyle = textStyles.getSecondary().withHoverEvent((HoverEvent)tpBtnHoverEvent).withClickEvent((ClickEvent)tpBtnClickEvent);
            HoverEvent.ShowText editBtnHoverEvent = new HoverEvent.ShowText((Component)Component.literal((String)TranslationManager.translate(src, "hover.helpful_commands.clickToEdit")));
            ClickEvent.SuggestCommand editBtnClickEvent = new ClickEvent.SuggestCommand("/warp edit " + warpName + " ");
            Style editBtnStyle = textStyles.getTertiary().withHoverEvent((HoverEvent)editBtnHoverEvent).withClickEvent((ClickEvent)editBtnClickEvent);
            HoverEvent.ShowText removeBtnHoverEvent = new HoverEvent.ShowText((Component)Component.literal((String)TranslationManager.translate(src, "hover.helpful_commands.clickToRemove")));
            ClickEvent.RunCommand removeBtnClickEvent = new ClickEvent.RunCommand("/warp remove " + warpName);
            Style removeBtnStyle = textStyles.getDangerousAction().withHoverEvent((HoverEvent)removeBtnHoverEvent).withClickEvent((ClickEvent)removeBtnClickEvent);
            MutableComponent bulletPointComponent = Component.literal((String)textDecorators.getBulletPoint()).setStyle(textStyles.getTertiary());
            MutableComponent colonComponent = Component.literal((String)": ").setStyle(textStyles.getTertiary());
            textBuilder.appendComponent(StylingHelper.getTitle((Component)Component.literal((String)TranslationManager.translate(src, "commands.helpful_commands.warp.info.title")), (Component)Component.literal((String)warpName)));
            if (!warp.description.isEmpty() && !warp.description.equals(" ")) {
                textBuilder.appendNewline().appendComponent((Component)bulletPointComponent).appendComponent((Component)Component.literal((String)TranslationManager.translate(src, "helpful_commands.common.description")).setStyle(textStyles.getTertiary())).appendComponent((Component)colonComponent).appendLiteral(warp.description);
            }
            textBuilder.appendNewline().appendComponent((Component)bulletPointComponent).appendComponent((Component)Component.literal((String)TranslationManager.translate(src, "helpful_commands.common.position")).setStyle(textStyles.getTertiary())).appendComponent((Component)colonComponent).appendComponent(StylingHelper.getPositionText(warp.x, warp.y, warp.z)).appendNewline().appendComponent((Component)bulletPointComponent).appendComponent((Component)Component.literal((String)TranslationManager.translate(src, "helpful_commands.common.dimension")).setStyle(textStyles.getTertiary())).appendComponent((Component)colonComponent).appendComponent((Component)Component.literal((String)warp.dimension).setStyle(textStyles.getSecondary()));
            if (!src.isPlayer()) {
                textBuilder.appendNewline().appendNewline().appendLiteral(TranslationManager.translate(src, "helpful_commands.common.teleport") + ": /warp tp %s <entities>".formatted(warpName)).appendNewline().appendLiteral(TranslationManager.translate(src, "helpful_commands.common.edit") + ": /warp edit %s ...".formatted(warpName)).appendNewline().appendLiteral(TranslationManager.translate(src, "helpful_commands.common.remove") + ": /warp remove %s".formatted(warpName));
            } else {
                boolean canTp = this.canExecute(src, "tp");
                boolean canManage = this.canExecute(src, "manage", 3);
                if (canTp || canManage) {
                    textBuilder.appendNewline().appendNewline();
                    if (canTp) {
                        textBuilder.appendComponent(StylingHelper.getButton(textDecorators.getTeleport(), (Component)Component.literal((String)TranslationManager.translate(src, "helpful_commands.common.teleport")), tpBtnStyle)).appendWhitespace();
                    }
                    if (canManage) {
                        textBuilder.appendComponent(StylingHelper.getButton((Component)Component.literal((String)textDecorators.getEdit()), editBtnStyle)).appendWhitespace().appendComponent(StylingHelper.getButton((Component)Component.literal((String)textDecorators.getRemove()), removeBtnStyle));
                    }
                }
            }
            src.sendSystemMessage((Component)textBuilder.getComponent());
        }
        catch (WarpManager.WarpDoesntExistException e) {
            TranslationManager.TextBuilder textBuilder = new TranslationManager.TextBuilder(src);
            textBuilder.appendTranslatable("commands.helpful_commands.warp.output.error.warpDoesntExist", new Component[]{Component.literal((String)warpName).setStyle(textStyles.getPrimary())});
            throw new CommandSyntaxException((CommandExceptionType)WARP_DOESNT_EXIST, (Message)textBuilder.getComponent());
        }
        return 1;
    }
}

