/*
 * Decompiled with CFR 0.152.
 */
package com.expecticament.helpfulcommands.command.playersAndEntities;

import com.expecticament.helpfulcommands.command.HelpfulCommandsCommand;
import com.expecticament.helpfulcommands.helper.ServerLevelHelper;
import com.expecticament.helpfulcommands.helper.StylingHelper;
import com.expecticament.helpfulcommands.manager.ModCommandManager;
import com.expecticament.helpfulcommands.manager.StylingManager;
import com.expecticament.helpfulcommands.manager.TranslationManager;
import com.expecticament.helpfulcommands.style.HelpfulCommandsStyle;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandExceptionType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;

public class CMD_coords
extends HelpfulCommandsCommand {
    public CMD_coords(ModCommandManager.CommandData commandData) {
        super(commandData);
    }

    @Override
    public void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext buildContext, Commands.CommandSelection commandSelection) {
        ModCommandManager.CommandData commandData = this.getCommandData();
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)commandData.getName()).requires(this::canExecuteBaseCommand)).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"broadcast").requires(src -> this.canExecute((CommandSourceStack)src, "broadcast", 2) || this.canExecute((CommandSourceStack)src, "broadcast.other", 2))).then(((RequiredArgumentBuilder)Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).requires(src -> this.canExecute((CommandSourceStack)src, "broadcast.other", 2))).executes(ctx -> this.broadcast((CommandContext<CommandSourceStack>)ctx, EntityArgument.getPlayer((CommandContext)ctx, (String)"player"))))).executes(this::broadcast))).then(((LiteralArgumentBuilder)Commands.literal((String)"share").requires(src -> this.canExecute((CommandSourceStack)src, "share"))).then(Commands.argument((String)"players", (ArgumentType)EntityArgument.players()).executes(ctx -> this.share((CommandContext<CommandSourceStack>)ctx, EntityArgument.getPlayers((CommandContext)ctx, (String)"players")))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"query").requires(src -> this.canExecute((CommandSourceStack)src, "query", 2) || this.canExecute((CommandSourceStack)src, "query.other", 2))).then(((RequiredArgumentBuilder)Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).requires(src -> this.canExecute((CommandSourceStack)src, "query.other", 2))).executes(ctx -> this.query((CommandContext<CommandSourceStack>)ctx, EntityArgument.getPlayer((CommandContext)ctx, (String)"player"))))).executes(this::execute))).executes(this::execute));
    }

    @Override
    public boolean canExecuteBaseCommand(CommandSourceStack source) {
        return this.canExecute(source) || this.canExecute(source, "broadcast", 2) || this.canExecute(source, "broadcast.other", 2) || this.canExecute(source, "share") || this.canExecute(source, "query", 2) || this.canExecute(source, "query.other", 2);
    }

    private int execute(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        ServerPlayer sourcePlayer = this.validatePlayerOnly(src);
        String dimensionKey = ServerLevelHelper.getLevelLocation(sourcePlayer.level());
        TranslationManager.TextBuilder textBuilder = new TranslationManager.TextBuilder(src);
        textBuilder.appendTranslatable("commands.helpful_commands.coords.output.success.self", StylingHelper.getLocationText(sourcePlayer.position(), dimensionKey));
        src.sendSuccess(textBuilder::getComponent, true);
        return 1;
    }

    private int broadcast(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        return this.broadcast(ctx, null);
    }

    private int broadcast(CommandContext<CommandSourceStack> ctx, ServerPlayer player) throws CommandSyntaxException {
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        ServerPlayer sourcePlayer = this.validateAnySource(src);
        if (player == null && sourcePlayer == null) {
            throw new CommandSyntaxException((CommandExceptionType)SELECTOR_REQUIRED, (Message)Component.literal((String)TranslationManager.translate(src, "error.helpful_commands.selectorRequired")));
        }
        if (player == null) {
            player = sourcePlayer;
        }
        String dimensionKey = ServerLevelHelper.getLevelLocation(player.level());
        ArrayList playerList = new ArrayList(player.level().getServer().getPlayerList().getPlayers());
        if (playerList.isEmpty()) {
            throw EntityArgument.NO_PLAYERS_FOUND.create();
        }
        for (ServerPlayer plr : playerList) {
            TranslationManager.TextBuilder textBuilder = new TranslationManager.TextBuilder(plr);
            textBuilder.appendTranslatable("commands.helpful_commands.coords.output.success.other", StylingHelper.getAffectedEntityNameText((Entity)player), StylingHelper.getLocationText(player.position(), dimensionKey));
            plr.sendSystemMessage((Component)textBuilder.getComponent());
        }
        if (sourcePlayer == null) {
            TranslationManager.TextBuilder textBuilder = new TranslationManager.TextBuilder(src);
            textBuilder.appendTranslatable("commands.helpful_commands.coords.output.success.other", StylingHelper.getAffectedEntityNameText((Entity)player), StylingHelper.getLocationText(player.position(), dimensionKey));
            src.sendSystemMessage((Component)textBuilder.getComponent());
        }
        return 1;
    }

    private int share(CommandContext<CommandSourceStack> ctx, Collection<ServerPlayer> players) throws CommandSyntaxException {
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        ServerPlayer sourcePlayer = this.validatePlayerOnly(src);
        ArrayList<ServerPlayer> playerList = new ArrayList<ServerPlayer>(players);
        playerList.remove(sourcePlayer);
        if (playerList.isEmpty()) {
            throw EntityArgument.NO_PLAYERS_FOUND.create();
        }
        HelpfulCommandsStyle.TextStyles textStyles = StylingManager.getCurrentStyle().getTextStyles();
        String dimensionKey = ServerLevelHelper.getLevelLocation(sourcePlayer.level());
        for (ServerPlayer player : playerList) {
            TranslationManager.TextBuilder textBuilder = new TranslationManager.TextBuilder(player);
            textBuilder.appendTranslatable("commands.helpful_commands.coords.share.output.success.affected", StylingHelper.getAffectedEntityNameText((Entity)sourcePlayer), StylingHelper.getLocationText(sourcePlayer.position(), dimensionKey));
            player.sendSystemMessage((Component)textBuilder.getComponent());
        }
        TranslationManager.TextBuilder textBuilder = new TranslationManager.TextBuilder(sourcePlayer);
        textBuilder.setStyle(textStyles.getSuccess());
        MutableComponent affected = Component.empty();
        if (playerList.size() == 1) {
            affected.append(StylingHelper.getAffectedEntityNameText((Entity)playerList.getFirst()));
        } else {
            affected.append(StylingHelper.getAffectedEntitiesNumberText(playerList)).append(TranslationManager.translate(src, "commands.helpful_commands.coords.share.output.success.multiple"));
        }
        textBuilder.appendTranslatable("commands.helpful_commands.coords.share.output.success.other", new Component[]{affected});
        src.sendSuccess(textBuilder::getComponent, true);
        return playerList.size();
    }

    private int query(CommandContext<CommandSourceStack> ctx, ServerPlayer player) throws CommandSyntaxException {
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        ServerPlayer sourcePlayer = this.validateAnySource(src);
        if (player == sourcePlayer) {
            return this.execute(ctx);
        }
        String dimensionKey = ServerLevelHelper.getLevelLocation(player.level());
        TranslationManager.TextBuilder textBuilder = new TranslationManager.TextBuilder(src);
        textBuilder.appendTranslatable("commands.helpful_commands.coords.output.success.other", StylingHelper.getAffectedEntityNameText((Entity)player), StylingHelper.getLocationText(player.position(), dimensionKey));
        src.sendSuccess(textBuilder::getComponent, true);
        return 1;
    }
}

