/*
 * Decompiled with CFR 0.152.
 */
package com.expecticament.helpfulcommands.command.playersAndEntities;

import com.expecticament.helpfulcommands.command.HelpfulCommandsCommand;
import com.expecticament.helpfulcommands.helper.StylingHelper;
import com.expecticament.helpfulcommands.manager.ModCommandManager;
import com.expecticament.helpfulcommands.manager.StylingManager;
import com.expecticament.helpfulcommands.manager.TranslationManager;
import com.expecticament.helpfulcommands.style.HelpfulCommandsStyle;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandExceptionType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GameType;

public class CMD_gm
extends HelpfulCommandsCommand {
    public CMD_gm(ModCommandManager.CommandData commandData) {
        super(commandData);
    }

    @Override
    public void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext buildContext, Commands.CommandSelection commandSelection) {
        ModCommandManager.CommandData commandData = this.getCommandData();
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)commandData.getName()).requires(this::canExecuteBaseCommand)).then(((LiteralArgumentBuilder)Commands.literal((String)"a").then(((RequiredArgumentBuilder)Commands.argument((String)"players", (ArgumentType)EntityArgument.players()).requires(src -> this.canExecute((CommandSourceStack)src, "other"))).executes(ctx -> this.execute((CommandContext<CommandSourceStack>)ctx, GameType.ADVENTURE, EntityArgument.getPlayers((CommandContext)ctx, (String)"players"))))).executes(ctx -> this.execute((CommandContext<CommandSourceStack>)ctx, GameType.ADVENTURE)))).then(((LiteralArgumentBuilder)Commands.literal((String)"c").then(((RequiredArgumentBuilder)Commands.argument((String)"players", (ArgumentType)EntityArgument.players()).requires(src -> this.canExecute((CommandSourceStack)src, "other"))).executes(ctx -> this.execute((CommandContext<CommandSourceStack>)ctx, GameType.CREATIVE, EntityArgument.getPlayers((CommandContext)ctx, (String)"players"))))).executes(ctx -> this.execute((CommandContext<CommandSourceStack>)ctx, GameType.CREATIVE)))).then(((LiteralArgumentBuilder)Commands.literal((String)"s").then(((RequiredArgumentBuilder)Commands.argument((String)"players", (ArgumentType)EntityArgument.players()).requires(src -> this.canExecute((CommandSourceStack)src, "other"))).executes(ctx -> this.execute((CommandContext<CommandSourceStack>)ctx, GameType.SURVIVAL, EntityArgument.getPlayers((CommandContext)ctx, (String)"players"))))).executes(ctx -> this.execute((CommandContext<CommandSourceStack>)ctx, GameType.SURVIVAL)))).then(((LiteralArgumentBuilder)Commands.literal((String)"sp").then(((RequiredArgumentBuilder)Commands.argument((String)"players", (ArgumentType)EntityArgument.players()).requires(src -> this.canExecute((CommandSourceStack)src, "other"))).executes(ctx -> this.execute((CommandContext<CommandSourceStack>)ctx, GameType.SPECTATOR, EntityArgument.getPlayers((CommandContext)ctx, (String)"players"))))).executes(ctx -> this.execute((CommandContext<CommandSourceStack>)ctx, GameType.SPECTATOR))));
    }

    @Override
    public boolean canExecuteBaseCommand(CommandSourceStack source) {
        return this.canExecute(source) || this.canExecute(source, "other");
    }

    private int execute(CommandContext<CommandSourceStack> ctx, GameType gameType) throws CommandSyntaxException {
        return this.execute(ctx, gameType, null);
    }

    private int execute(CommandContext<CommandSourceStack> ctx, GameType gameType, Collection<ServerPlayer> players) throws CommandSyntaxException {
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        ServerPlayer sourcePlayer = this.validateAnySource(src);
        ArrayList targets = new ArrayList(Objects.requireNonNullElse(players, List.of()));
        HelpfulCommandsStyle.TextStyles textStyles = StylingManager.getCurrentStyle().getTextStyles();
        boolean commandFeedback = src.getLevel().getGameRules().getBoolean(GameRules.RULE_SENDCOMMANDFEEDBACK);
        if (targets.isEmpty() || targets.size() == 1 && sourcePlayer != null && targets.contains(sourcePlayer)) {
            if (sourcePlayer == null) {
                throw new CommandSyntaxException((CommandExceptionType)SELECTOR_REQUIRED, (Message)Component.literal((String)TranslationManager.translate(src, "error.helpful_commands.selectorRequired")));
            }
            this.changeGameModeAndSendMessage(sourcePlayer, src, gameType, textStyles, commandFeedback, true, true);
            return 1;
        }
        List<ServerPlayer> affected = targets.stream().filter(p -> this.changeGameModeAndSendMessage((ServerPlayer)p, src, gameType, textStyles, commandFeedback, p == sourcePlayer, false)).toList();
        if (affected.isEmpty()) {
            throw EntityArgument.NO_PLAYERS_FOUND.create();
        }
        String gameModeTrKey = "gameMode." + gameType.getName();
        MutableComponent gameModeComponent = Component.translatable((String)gameModeTrKey).setStyle(textStyles.getPrimary());
        TranslationManager.DeprecatedTextBuilder textBuilder = new TranslationManager.DeprecatedTextBuilder(src);
        if (affected.size() == 1) {
            textBuilder.setStyle(textStyles.getSuccess());
            textBuilder.appendTranslatable("commands.helpful_commands.gm.output.success.other.part1").appendWhitespace().appendComponent(StylingHelper.getAffectedEntityNameText((Entity)affected.getFirst())).appendTranslatable("commands.helpful_commands.gm.output.success.other.part2").appendWhitespace().appendComponent((Component)gameModeComponent);
        } else {
            textBuilder.setStyle(textStyles.getSuccess());
            textBuilder.appendTranslatable("commands.helpful_commands.gm.output.success.others.part1").appendWhitespace().appendComponent((Component)gameModeComponent).appendWhitespace().appendTranslatable("commands.helpful_commands.gm.output.success.others.part2").appendWhitespace().appendComponent(StylingHelper.getAffectedEntitiesNumberText(affected)).appendWhitespace().appendTranslatable("commands.helpful_commands.gm.output.success.others.part3");
        }
        src.sendSuccess(textBuilder::getComponent, true);
        return affected.size();
    }

    private boolean changeGameModeAndSendMessage(ServerPlayer player, CommandSourceStack commandSourceStack, GameType gameType, HelpfulCommandsStyle.TextStyles textStyles, boolean commandFeedback, boolean isSource, boolean feedbackSource) {
        if (player.setGameMode(gameType)) {
            if (commandFeedback) {
                String gameModeTrKey = "gameMode." + gameType.getName();
                MutableComponent gameModeComponent = Component.translatable((String)gameModeTrKey).setStyle(textStyles.getPrimary());
                if (isSource) {
                    if (feedbackSource) {
                        TranslationManager.DeprecatedTextBuilder textBuilder = new TranslationManager.DeprecatedTextBuilder(player);
                        textBuilder.setStyle(textStyles.getAffectedPositive());
                        textBuilder.appendTranslatable("commands.helpful_commands.gm.output.success.self").appendWhitespace().appendComponent((Component)gameModeComponent);
                        commandSourceStack.sendSuccess(textBuilder::getComponent, true);
                    }
                } else {
                    TranslationManager.DeprecatedTextBuilder textBuilder = new TranslationManager.DeprecatedTextBuilder(player);
                    textBuilder.setStyle(textStyles.getAffectedNeutral());
                    textBuilder.appendTranslatable("commands.helpful_commands.gm.output.success.affected").appendWhitespace().appendComponent((Component)gameModeComponent);
                    player.sendSystemMessage((Component)textBuilder.getComponent());
                }
            }
            return true;
        }
        return false;
    }
}

