/*
 * Decompiled with CFR 0.152.
 */
package com.expecticament.helpfulcommands.command.playersAndEntities;

import com.expecticament.helpfulcommands.command.HelpfulCommandsCommand;
import com.expecticament.helpfulcommands.helper.StylingHelper;
import com.expecticament.helpfulcommands.manager.ModCommandManager;
import com.expecticament.helpfulcommands.manager.StylingManager;
import com.expecticament.helpfulcommands.manager.TranslationManager;
import com.expecticament.helpfulcommands.style.HelpfulCommandsStyle;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.item.ItemArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;

public class CMD_hat
extends HelpfulCommandsCommand {
    public CMD_hat(ModCommandManager.CommandData commandData) {
        super(commandData);
    }

    @Override
    public void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext buildContext, Commands.CommandSelection commandSelection) {
        ModCommandManager.CommandData commandData = this.getCommandData();
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)commandData.getName()).requires(this::canExecuteBaseCommand)).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"players", (ArgumentType)EntityArgument.players()).requires(src -> this.canExecute((CommandSourceStack)src, "other", 2))).executes(ctx -> this.executeOther((CommandContext<CommandSourceStack>)ctx, EntityArgument.getPlayers((CommandContext)ctx, (String)"players"), null))).then(((RequiredArgumentBuilder)Commands.argument((String)"item", (ArgumentType)ItemArgument.item((CommandBuildContext)buildContext)).requires(src -> this.canExecute((CommandSourceStack)src, "item", 2))).executes(ctx -> this.executeOther((CommandContext<CommandSourceStack>)ctx, EntityArgument.getPlayers((CommandContext)ctx, (String)"players"), ItemArgument.getItem((CommandContext)ctx, (String)"item").createItemStack(1, false)))))).executes(this::executeSelf));
    }

    @Override
    public boolean canExecuteBaseCommand(CommandSourceStack source) {
        return this.canExecute(source) || this.canExecute(source, "other", 2) || this.canExecute(source, "item", 2);
    }

    private int executeSelf(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        ServerPlayer sourcePlayer = this.validatePlayerOnly(src);
        return this.executeSelf(ctx, sourcePlayer.getMainHandItem().copy(), true);
    }

    private int executeSelf(CommandContext<CommandSourceStack> ctx, ItemStack itemStack, boolean itemFromMainhand) throws CommandSyntaxException {
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        ServerPlayer sourcePlayer = this.validatePlayerOnly(src);
        TranslationManager.TextBuilder textBuilder = new TranslationManager.TextBuilder(src);
        if (itemFromMainhand) {
            Inventory inventory = sourcePlayer.getInventory();
            inventory.setItem(inventory.getSelectedSlot(), inventory.getItem(39));
        }
        if (!this.put(sourcePlayer, itemStack)) {
            return 0;
        }
        HelpfulCommandsStyle.TextStyles textStyles = StylingManager.getCurrentStyle().getTextStyles();
        if (itemStack.getItem() != Items.AIR) {
            textBuilder.appendTranslatable("commands.helpful_commands.hat.self", this.getItemName(itemStack));
        } else {
            textBuilder.appendTranslatable("commands.helpful_commands.hat.remove.self", new Component[0]);
        }
        textBuilder.setStyle(textStyles.getSuccess());
        src.sendSuccess(textBuilder::getComponent, true);
        return 1;
    }

    private int executeOther(CommandContext<CommandSourceStack> ctx, Collection<ServerPlayer> players, ItemStack itemStack) throws CommandSyntaxException {
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        ServerPlayer sourcePlayer = this.validateAnySource(src);
        if (sourcePlayer != null && players.size() == 1 && players.contains(sourcePlayer)) {
            if (itemStack == null) {
                return this.executeSelf(ctx);
            }
            return this.executeSelf(ctx, itemStack, false);
        }
        if (itemStack == null) {
            if (sourcePlayer == null) {
                throw CommandSourceStack.ERROR_NOT_PLAYER.create();
            }
            itemStack = sourcePlayer.getMainHandItem().copy();
        }
        HelpfulCommandsStyle.TextStyles textStyles = StylingManager.getCurrentStyle().getTextStyles();
        boolean commandFeedback = src.getLevel().getGameRules().getBoolean(GameRules.RULE_SENDCOMMANDFEEDBACK);
        boolean isAir = itemStack.getItem() == Items.AIR;
        Component itemNameComponent = this.getItemName(itemStack);
        ArrayList<ServerPlayer> affected = new ArrayList<ServerPlayer>();
        for (ServerPlayer player : players) {
            if (!this.put(player, itemStack)) continue;
            if (commandFeedback && player != sourcePlayer) {
                TranslationManager.TextBuilder textBuilder = new TranslationManager.TextBuilder(player);
                if (isAir) {
                    textBuilder.appendTranslatable("commands.helpful_commands.hat.remove.affected", new Component[0]);
                } else {
                    textBuilder.appendTranslatable("commands.helpful_commands.hat.affected", itemNameComponent);
                }
                textBuilder.setStyle(textStyles.getAffectedNeutral());
                player.sendSystemMessage((Component)textBuilder.getComponent());
            }
            affected.add(player);
        }
        if (affected.isEmpty()) {
            throw EntityArgument.NO_PLAYERS_FOUND.create();
        }
        TranslationManager.TextBuilder textBuilder = new TranslationManager.TextBuilder(src);
        if (affected.size() == 1) {
            if (isAir) {
                textBuilder.appendTranslatable("commands.helpful_commands.hat.remove.other", StylingHelper.getAffectedEntityNameText((Entity)affected.getFirst()));
            } else {
                textBuilder.appendTranslatable("commands.helpful_commands.hat.other", itemNameComponent, StylingHelper.getAffectedEntityNameText((Entity)affected.getFirst()));
            }
        } else if (isAir) {
            textBuilder.appendTranslatable("commands.helpful_commands.hat.remove.others", StylingHelper.getAffectedEntitiesNumberText(affected));
        } else {
            textBuilder.appendTranslatable("commands.helpful_commands.hat.others", itemNameComponent, StylingHelper.getAffectedEntitiesNumberText(affected));
        }
        textBuilder.setStyle(textStyles.getSuccess());
        src.sendSuccess(textBuilder::getComponent, true);
        return players.size();
    }

    private Component getItemName(ItemStack itemStack) {
        return Component.literal((String)itemStack.getItemName().getString()).setStyle(StylingManager.getCurrentStyle().getTextStyles().getPrimary());
    }

    private boolean put(ServerPlayer player, ItemStack itemStack) {
        Inventory inventory = player.getInventory();
        if (itemStack.getItem() == Items.AIR && inventory.getItem(39).getItem() == itemStack.getItem()) {
            return false;
        }
        inventory.setItem(39, itemStack.copy());
        player.playNotifySound((SoundEvent)SoundEvents.ARMOR_EQUIP_GENERIC.value(), SoundSource.PLAYERS, 1.0f, 1.0f);
        return true;
    }
}

