/*
 * Decompiled with CFR 0.152.
 */
package com.expecticament.helpfulcommands.command.playersAndEntities;

import com.expecticament.helpfulcommands.command.HelpfulCommandsCommand;
import com.expecticament.helpfulcommands.helper.StylingHelper;
import com.expecticament.helpfulcommands.manager.ModCommandManager;
import com.expecticament.helpfulcommands.manager.StylingManager;
import com.expecticament.helpfulcommands.manager.TranslationManager;
import com.expecticament.helpfulcommands.style.HelpfulCommandsStyle;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandExceptionType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.GameRules;

public class CMD_ignite
extends HelpfulCommandsCommand {
    public CMD_ignite(ModCommandManager.CommandData commandData) {
        super(commandData);
    }

    @Override
    public void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext buildContext, Commands.CommandSelection commandSelection) {
        ModCommandManager.CommandData commandData = this.getCommandData();
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)commandData.getName()).requires(this::canExecuteBaseCommand)).then(((RequiredArgumentBuilder)Commands.argument((String)"duration_seconds", (ArgumentType)FloatArgumentType.floatArg((float)1.0f)).then(((RequiredArgumentBuilder)Commands.argument((String)"entities", (ArgumentType)EntityArgument.entities()).requires(src -> this.canExecute((CommandSourceStack)src, "other"))).executes(ctx -> this.execute((CommandContext<CommandSourceStack>)ctx, FloatArgumentType.getFloat((CommandContext)ctx, (String)"duration_seconds"), EntityArgument.getEntities((CommandContext)ctx, (String)"entities"))))).executes(ctx -> this.execute((CommandContext<CommandSourceStack>)ctx, FloatArgumentType.getFloat((CommandContext)ctx, (String)"duration_seconds")))));
    }

    @Override
    public boolean canExecuteBaseCommand(CommandSourceStack source) {
        return this.canExecute(source) || this.canExecute(source, "other");
    }

    private int execute(CommandContext<CommandSourceStack> ctx, float duration) throws CommandSyntaxException {
        return this.execute(ctx, duration, null);
    }

    private int execute(CommandContext<CommandSourceStack> ctx, float duration, Collection<? extends Entity> entities) throws CommandSyntaxException {
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        ServerPlayer sourcePlayer = this.validateAnySource(src);
        ArrayList targets = new ArrayList(Objects.requireNonNullElse(entities, List.of()));
        HelpfulCommandsStyle.TextStyles textStyles = StylingManager.getCurrentStyle().getTextStyles();
        boolean commandFeedback = src.getLevel().getGameRules().getBoolean(GameRules.RULE_SENDCOMMANDFEEDBACK);
        if (targets.isEmpty() || targets.size() == 1 && sourcePlayer != null && targets.contains(sourcePlayer)) {
            if (sourcePlayer == null) {
                throw new CommandSyntaxException((CommandExceptionType)SELECTOR_REQUIRED, (Message)Component.literal((String)TranslationManager.translate(src, "error.helpful_commands.selectorRequired")));
            }
            this.igniteAndSendMessage((Entity)sourcePlayer, src, duration, textStyles, commandFeedback, true, true);
            return 1;
        }
        List<Entity> affected = targets.stream().filter(p -> this.igniteAndSendMessage((Entity)p, src, duration, textStyles, commandFeedback, p == sourcePlayer, false)).toList();
        if (affected.isEmpty()) {
            throw EntityArgument.NO_ENTITIES_FOUND.create();
        }
        TranslationManager.DeprecatedTextBuilder textBuilder = new TranslationManager.DeprecatedTextBuilder(src);
        textBuilder.setStyle(textStyles.getSuccess());
        textBuilder.appendTranslatable("commands.helpful_commands.ignite.output.success.other.part1").appendWhitespace();
        if (affected.size() == 1) {
            textBuilder.appendComponent(StylingHelper.getAffectedEntityNameText(affected.getFirst()));
        } else {
            textBuilder.appendComponent(StylingHelper.getAffectedEntitiesNumberText(affected)).appendWhitespace().appendTranslatable("commands.helpful_commands.ignite.output.success.other.part2.multiple");
        }
        MutableComponent durationText = Component.literal((String)String.valueOf(duration)).setStyle(textStyles.getPrimary());
        String durationTrKey = "commands.helpful_commands.ignite.output.success.duration.part2." + (duration == 1.0f ? "singular" : "plural");
        textBuilder.appendWhitespace().appendTranslatable("commands.helpful_commands.ignite.output.success.other.part3").appendWhitespace().appendTranslatable("commands.helpful_commands.ignite.output.success.duration.part1").appendWhitespace().appendComponent((Component)durationText).appendWhitespace().appendTranslatable(durationTrKey);
        src.sendSuccess(textBuilder::getComponent, true);
        return affected.size();
    }

    private boolean igniteAndSendMessage(Entity entity, CommandSourceStack commandSourceStack, float duration, HelpfulCommandsStyle.TextStyles textStyles, boolean commandFeedback, boolean isSource, boolean feedbackSource) {
        if (entity.isAlive() && !entity.fireImmune()) {
            ServerPlayer player = null;
            if (entity.isAlwaysTicking()) {
                player = (ServerPlayer)entity;
            }
            if (player != null && player.getAbilities().invulnerable) {
                return false;
            }
            entity.igniteForSeconds(duration);
            if (commandFeedback && player != null) {
                if (isSource) {
                    if (feedbackSource) {
                        MutableComponent durationText = Component.literal((String)String.valueOf(duration)).setStyle(textStyles.getPrimary());
                        String durationTrKey = "commands.helpful_commands.ignite.output.success.duration.part2." + (duration == 1.0f ? "singular" : "plural");
                        TranslationManager.DeprecatedTextBuilder textBuilder = new TranslationManager.DeprecatedTextBuilder(player);
                        textBuilder.setStyle(textStyles.getAffectedNeutral());
                        textBuilder.appendTranslatable("commands.helpful_commands.ignite.output.success.self").appendWhitespace().appendTranslatable("commands.helpful_commands.ignite.output.success.duration.part1").appendWhitespace().appendComponent((Component)durationText).appendWhitespace().appendTranslatable(durationTrKey);
                        commandSourceStack.sendSuccess(textBuilder::getComponent, true);
                    }
                } else {
                    TranslationManager.DeprecatedTextBuilder textBuilder = new TranslationManager.DeprecatedTextBuilder(player);
                    textBuilder.setStyle(textStyles.getAffectedNeutral());
                    textBuilder.appendTranslatable("commands.helpful_commands.ignite.output.success.affected");
                    player.sendSystemMessage((Component)textBuilder.getComponent());
                }
            }
            return true;
        }
        return false;
    }
}

