/*
 * Decompiled with CFR 0.152.
 */
package com.expecticament.helpfulcommands.command.social;

import com.expecticament.helpfulcommands.command.HelpfulCommandsCommand;
import com.expecticament.helpfulcommands.helper.StylingHelper;
import com.expecticament.helpfulcommands.manager.ModCommandManager;
import com.expecticament.helpfulcommands.manager.StylingManager;
import com.expecticament.helpfulcommands.manager.TranslationManager;
import com.expecticament.helpfulcommands.style.HelpfulCommandsStyle;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;

public class CMD_coinflip
extends HelpfulCommandsCommand {
    public CMD_coinflip(ModCommandManager.CommandData commandData) {
        super(commandData);
    }

    @Override
    public void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext buildContext, Commands.CommandSelection commandSelection) {
        ModCommandManager.CommandData commandData = this.getCommandData();
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)commandData.getName()).requires(this::canExecuteBaseCommand)).then(Commands.literal((String)"heads").executes(ctx -> this.execute((CommandContext<CommandSourceStack>)ctx, CoinSide.HEADS)))).then(Commands.literal((String)"tails").executes(ctx -> this.execute((CommandContext<CommandSourceStack>)ctx, CoinSide.TAILS))));
    }

    @Override
    public boolean canExecuteBaseCommand(CommandSourceStack source) {
        return this.canExecute(source);
    }

    private int execute(CommandContext<CommandSourceStack> ctx, CoinSide guessedCoinSide) throws CommandSyntaxException {
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        ServerPlayer sourcePlayer = this.validatePlayerOnly(src);
        HelpfulCommandsStyle.TextStyles textStyles = StylingManager.getCurrentStyle().getTextStyles();
        CoinSide landedCoinSide = CoinSide.randomSide(sourcePlayer.level().getRandom());
        boolean won = guessedCoinSide == landedCoinSide;
        ArrayList playerList = new ArrayList(sourcePlayer.level().getServer().getPlayerList().getPlayers());
        if (playerList.isEmpty()) {
            throw EntityArgument.NO_PLAYERS_FOUND.create();
        }
        Component affectedPlayerText = StylingHelper.getAffectedEntityNameText((Entity)sourcePlayer);
        for (ServerPlayer player : playerList) {
            MutableComponent guessedCoinSideText = Component.literal((String)TranslationManager.translate(player, "commands.helpful_commands.coinflip." + guessedCoinSide.toString().toLowerCase())).setStyle(textStyles.getPrimary());
            MutableComponent landedCoinSideText = Component.literal((String)TranslationManager.translate(player, "commands.helpful_commands.coinflip." + landedCoinSide.toString().toLowerCase())).setStyle(textStyles.getPrimary());
            MutableComponent resultText = Component.literal((String)TranslationManager.translate(player, "commands.helpful_commands.coinflip." + (won ? "won" : "lost"))).setStyle(won ? textStyles.getAffectedPositive() : textStyles.getAffectedNegative());
            TranslationManager.DeprecatedTextBuilder textBuilder = new TranslationManager.DeprecatedTextBuilder(player);
            textBuilder.appendComponent(affectedPlayerText).appendWhitespace().appendTranslatable("commands.helpful_commands.coinflip.output.success.part1").appendWhitespace().appendComponent((Component)guessedCoinSideText).appendLiteral(". ").appendTranslatable("commands.helpful_commands.coinflip.output.success.part2").appendWhitespace().appendComponent((Component)landedCoinSideText).appendLiteral(" - ").appendTranslatable("commands.helpful_commands.coinflip.output.success.part3").appendWhitespace().appendComponent((Component)resultText);
            if (won) {
                textBuilder.appendLiteral("!");
            }
            player.sendSystemMessage((Component)textBuilder.getComponent());
        }
        sourcePlayer.playNotifySound(won ? SoundEvents.PLAYER_LEVELUP : SoundEvents.WANDERING_TRADER_NO, SoundSource.PLAYERS, 0.5f, 1.0f);
        return 1;
    }

    private static enum CoinSide {
        HEADS,
        TAILS;


        public static CoinSide randomSide(RandomSource random) {
            return CoinSide.values()[random.nextInt(CoinSide.values().length)];
        }
    }
}

