/*
 * Decompiled with CFR 0.152.
 */
package com.expecticament.helpfulcommands.command.world;

import com.expecticament.helpfulcommands.command.HelpfulCommandsCommand;
import com.expecticament.helpfulcommands.helper.StylingHelper;
import com.expecticament.helpfulcommands.manager.ConfigManager;
import com.expecticament.helpfulcommands.manager.ModCommandManager;
import com.expecticament.helpfulcommands.manager.StylingManager;
import com.expecticament.helpfulcommands.manager.TranslationManager;
import com.expecticament.helpfulcommands.style.HelpfulCommandsStyle;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandExceptionType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.item.ItemPredicateArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class CMD_killitems
extends HelpfulCommandsCommand {
    protected static final SimpleCommandExceptionType RANGE_CONFIG_VALUE_EXCEEDED = new SimpleCommandExceptionType((Message)Component.empty());

    public CMD_killitems(ModCommandManager.CommandData commandData) {
        super(commandData);
    }

    @Override
    public void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext buildContext, Commands.CommandSelection commandSelection) {
        ModCommandManager.CommandData commandData = this.getCommandData();
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)commandData.getName()).requires(this::canExecuteBaseCommand)).then(((RequiredArgumentBuilder)Commands.argument((String)"range_cubic", (ArgumentType)IntegerArgumentType.integer((int)1)).then(Commands.argument((String)"filter", (ArgumentType)ItemPredicateArgument.itemPredicate((CommandBuildContext)buildContext)).executes(ctx -> this.execute((CommandContext<CommandSourceStack>)ctx, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"range_cubic"), (Predicate<ItemStack>)ItemPredicateArgument.getItemPredicate((CommandContext)ctx, (String)"filter"))))).executes(ctx -> this.execute((CommandContext<CommandSourceStack>)ctx, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"range_cubic"))))).executes(this::execute));
    }

    @Override
    public boolean canExecuteBaseCommand(CommandSourceStack source) {
        return this.canExecute(source);
    }

    private int execute(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        return this.execute(ctx, 0, null);
    }

    private int execute(CommandContext<CommandSourceStack> ctx, int range) throws CommandSyntaxException {
        return this.execute(ctx, range, null);
    }

    private int execute(CommandContext<CommandSourceStack> ctx, int range, Predicate<ItemStack> itemPredicate) throws CommandSyntaxException {
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        ServerPlayer sourcePlayer = this.validateAnySource(src);
        HelpfulCommandsStyle.TextStyles textStyles = StylingManager.getCurrentStyle().getTextStyles();
        ConfigManager.HelpfulCommandsConfig config = ConfigManager.readConfig();
        int maxRange = (Integer)config.readField("killitemsMaxRange");
        if (range < 1) {
            range = Math.clamp(64L, 1, maxRange);
        } else if (range > maxRange) {
            TranslationManager.TextBuilder textBuilder = new TranslationManager.TextBuilder(src);
            textBuilder.appendTranslatable("commands.helpful_commands.killitems.configValueExceeded", new Component[]{Component.literal((String)String.valueOf(maxRange)).setStyle(textStyles.getPrimary())});
            throw new CommandSyntaxException((CommandExceptionType)RANGE_CONFIG_VALUE_EXCEEDED, (Message)textBuilder.getComponent());
        }
        ServerLevel level = src.getLevel();
        Vec3 center = sourcePlayer != null ? sourcePlayer.position() : src.getLevel().getRespawnData().pos().getCenter();
        AABB aabb = new AABB(center.x - (double)range, center.y - (double)range, center.z - (double)range, center.x + (double)range, center.y + (double)range, center.z + (double)range);
        List itemEntities = level.getEntitiesOfClass(ItemEntity.class, aabb, itemEntity -> itemPredicate == null || itemPredicate.test(itemEntity.getItem()));
        boolean multiple = false;
        for (ItemEntity itemEntity2 : itemEntities) {
            if (!multiple && itemEntity2.getItem().getCount() > 1) {
                multiple = true;
            }
            itemEntity2.discard();
        }
        if (itemEntities.isEmpty()) {
            throw new CommandSyntaxException((CommandExceptionType)NO_ITEMS_FOUND, (Message)Component.literal((String)TranslationManager.translate(src, "error.helpful_commands.noItemsFound")));
        }
        TranslationManager.TextBuilder textBuilder = new TranslationManager.TextBuilder(src);
        textBuilder.appendTranslatable("commands.helpful_commands.killitems", new Component[]{StylingHelper.getAffectedEntitiesNumberText(itemEntities), Component.literal((String)TranslationManager.translate(src, "commands.helpful_commands.killitems." + (itemEntities.size() == 1 && !multiple ? "single" : "multiple")))});
        textBuilder.setStyle(textStyles.getSuccess());
        src.sendSuccess(textBuilder::getComponent, true);
        return itemEntities.size();
    }
}

