/*
 * Decompiled with CFR 0.152.
 */
package com.expecticament.helpfulcommands.command.world;

import com.expecticament.helpfulcommands.command.HelpfulCommandsCommand;
import com.expecticament.helpfulcommands.manager.ModCommandManager;
import com.expecticament.helpfulcommands.manager.StylingManager;
import com.expecticament.helpfulcommands.manager.TranslationManager;
import com.expecticament.helpfulcommands.style.HelpfulCommandsStyle;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;

public class TimeCommand
extends HelpfulCommandsCommand {
    private final int time;

    public TimeCommand(ModCommandManager.CommandData commandData, int time) {
        super(commandData);
        this.time = time;
    }

    @Override
    public void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext buildContext, Commands.CommandSelection commandSelection) {
        ModCommandManager.CommandData commandData = this.getCommandData();
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)commandData.getName()).requires(this::canExecuteBaseCommand)).executes(this::execute));
    }

    @Override
    public boolean canExecuteBaseCommand(CommandSourceStack source) {
        return this.canExecute(source);
    }

    private int execute(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        this.validateAnySource(src);
        MinecraftServer server = src.getServer();
        for (ServerLevel serverLevel : server.getAllLevels()) {
            serverLevel.setDayTime((long)this.time);
        }
        server.forceTimeSynchronization();
        HelpfulCommandsStyle.TextStyles textStyles = StylingManager.getCurrentStyle().getTextStyles();
        TranslationManager.TextBuilder hoverTextBuilder = new TranslationManager.TextBuilder(src);
        hoverTextBuilder.appendTranslatable("commands.helpful_commands.time." + this.time, new Component[0]);
        MutableComponent timeValueText = Component.literal((String)String.valueOf(this.time)).setStyle(textStyles.getPrimary().withHoverEvent((HoverEvent)new HoverEvent.ShowText((Component)hoverTextBuilder.getComponent())));
        TranslationManager.TextBuilder messageTextBuilder = new TranslationManager.TextBuilder(src);
        messageTextBuilder.appendTranslatable("commands.helpful_commands.time.output.success", new Component[]{timeValueText}).setStyle(textStyles.getSuccess());
        src.sendSuccess(messageTextBuilder::getComponent, true);
        return 1;
    }
}

