/*
 * Decompiled with CFR 0.152.
 */
package com.expecticament.helpfulcommands.helper;

import net.luckperms.api.LuckPermsProvider;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.NameAndId;

public class PermissionHelper {
    public static boolean hasPermission(CommandSourceStack source, String permission, int defaultOpLevel) {
        try {
            ServerPlayer player = source.getPlayer();
            if (player == null) {
                return source.hasPermission(defaultOpLevel);
            }
            return LuckPermsProvider.get().getPlayerAdapter(ServerPlayer.class).getPermissionData((Object)player).checkPermission(permission).asBoolean();
        }
        catch (IllegalStateException | NoClassDefFoundError e) {
            return source.hasPermission(defaultOpLevel);
        }
    }

    public static boolean canConfigure(CommandSourceStack source) {
        return PermissionHelper.canConfigure(source, "");
    }

    public static boolean canConfigure(CommandSourceStack source, String configPermission) {
        int configOpLevel = 3;
        ServerPlayer player = source.getPlayer();
        if (!source.getServer().isDedicatedServer() && player != null) {
            return source.hasPermission(configOpLevel) && source.getServer().isSingleplayerOwner(new NameAndId(player.getGameProfile()));
        }
        if (configPermission.isEmpty()) {
            return PermissionHelper.hasPermission(source, "helpful_commands.config", configOpLevel) || PermissionHelper.hasPermission(source, "helpful_commands.config.command", configOpLevel) || PermissionHelper.hasPermission(source, "helpful_commands.config.command.state", configOpLevel) || PermissionHelper.hasPermission(source, "helpful_commands.config.field", configOpLevel) || PermissionHelper.hasPermission(source, "helpful_commands.config.styling", configOpLevel);
        }
        return PermissionHelper.hasPermission(source, "helpful_commands.config." + configPermission, configOpLevel);
    }
}

